/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.MacroHelper;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.EVAL;
import io.warp10.script.functions.LOAD;
import io.warp10.script.functions.NOOP;
import io.warp10.script.functions.PUSHR;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DEREF
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final NOOP NOOP = new NOOP("NOOP");
    private static final EVAL EVAL = new EVAL("EVAL");

    public DEREF(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a map of variable names or register id to values on top of the stack.");
        }
        Map values = (Map)top;
        top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a Macro.");
        }
        ArrayList<WarpScriptStack.Macro> allmacros = new ArrayList<WarpScriptStack.Macro>();
        allmacros.add((WarpScriptStack.Macro)top);
        while (!allmacros.isEmpty()) {
            WarpScriptStack.Macro m = (WarpScriptStack.Macro)allmacros.remove(0);
            if (m.isSecure()) {
                throw new WarpScriptException(this.getName() + " cannot operate on a secure Macro.");
            }
            ArrayList<Object> statements = new ArrayList<Object>(m.statements());
            for (int i = 0; i < statements.size(); ++i) {
                long register;
                if (statements.get(i) instanceof WarpScriptStack.Macro) {
                    allmacros.add((WarpScriptStack.Macro)statements.get(i));
                    continue;
                }
                if (i > 0 && statements.get(i) instanceof LOAD) {
                    Object symbol = statements.get(i - 1);
                    if (!(symbol instanceof String) || !values.containsKey(symbol)) continue;
                    Object value = values.get(symbol);
                    if (value instanceof WarpScriptStack.Macro) {
                        if (1 == ((WarpScriptStack.Macro)value).size()) {
                            statements.set(i - 1, NOOP);
                            statements.set(i, ((WarpScriptStack.Macro)value).get(0));
                            continue;
                        }
                        statements.set(i - 1, value);
                        statements.set(i, EVAL);
                        continue;
                    }
                    statements.set(i - 1, NOOP);
                    statements.set(i, value);
                    continue;
                }
                if (!(statements.get(i) instanceof PUSHR) || !values.containsKey(register = (long)((PUSHR)statements.get(i)).getRegister())) continue;
                Object value = values.get(register);
                if (value instanceof WarpScriptStack.Macro) {
                    statements.set(i, MacroHelper.wrap((WarpScriptStack.Macro)value));
                    continue;
                }
                statements.set(i, value);
            }
            List<Object> macstmt = m.statements();
            int noops = 0;
            for (int i = 0; i < statements.size(); ++i) {
                if (statements.get(i) instanceof NOOP) {
                    ++noops;
                    continue;
                }
                macstmt.set(i - noops, statements.get(i));
            }
            m.setSize(statements.size() - noops);
        }
        stack.push(top);
        return stack;
    }
}

