/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.fastdtw;

import io.warp10.script.fastdtw.ColMajorCell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class SearchWindow {
    private final int[] minValues;
    private final int[] maxValues;
    private final int maxJ;
    private int size;
    private int modCount;

    public SearchWindow(int tsIsize, int tsJsize) {
        this.minValues = new int[tsIsize];
        this.maxValues = new int[tsIsize];
        Arrays.fill(this.minValues, -1);
        this.maxJ = tsJsize - 1;
        this.size = 0;
        this.modCount = 0;
    }

    public final boolean isInWindow(int i, int j) {
        return i >= this.minI() && i <= this.maxI() && this.minValues[i] <= j && this.maxValues[i] >= j;
    }

    public final int minI() {
        return 0;
    }

    public final int maxI() {
        return this.minValues.length - 1;
    }

    public final int minJ() {
        return 0;
    }

    public final int maxJ() {
        return this.maxJ;
    }

    public final int minJforI(int i) {
        return this.minValues[i];
    }

    public final int maxJforI(int i) {
        return this.maxValues[i];
    }

    public final int size() {
        return this.size;
    }

    public final Iterator iterator() {
        return new SearchWindowIterator(this);
    }

    public final String toString() {
        StringBuffer outStr = new StringBuffer();
        for (int i = this.minI(); i <= this.maxI(); ++i) {
            outStr.append("i=" + i + ", j=" + this.minValues[i] + "..." + this.maxValues[i]);
            if (i == this.maxI()) continue;
            outStr.append("\n");
        }
        return outStr.toString();
    }

    protected int getModCount() {
        return this.modCount;
    }

    protected final void expandWindow(int radius) {
        if (radius > 0) {
            this.expandSearchWindow(1);
            this.expandSearchWindow(radius - 1);
        }
    }

    private final void expandSearchWindow(int radius) {
        if (radius > 0) {
            ArrayList windowCells = new ArrayList(this.size());
            Iterator cellIter = this.iterator();
            while (cellIter.hasNext()) {
                windowCells.add(cellIter.next());
            }
            for (int cell = 0; cell < windowCells.size(); ++cell) {
                int cellsPastEdge;
                int targetRow;
                int targetCol;
                ColMajorCell currentCell = (ColMajorCell)windowCells.get(cell);
                if (currentCell.getCol() != this.minI() && currentCell.getRow() != this.maxJ()) {
                    targetCol = currentCell.getCol() - radius;
                    targetRow = currentCell.getRow() + radius;
                    if (targetCol >= this.minI() && targetRow <= this.maxJ()) {
                        this.markVisited(targetCol, targetRow);
                    } else {
                        cellsPastEdge = Math.max(this.minI() - targetCol, targetRow - this.maxJ());
                        this.markVisited(targetCol + cellsPastEdge, targetRow - cellsPastEdge);
                    }
                }
                if (currentCell.getRow() != this.maxJ()) {
                    targetCol = currentCell.getCol();
                    targetRow = currentCell.getRow() + radius;
                    if (targetRow <= this.maxJ()) {
                        this.markVisited(targetCol, targetRow);
                    } else {
                        cellsPastEdge = targetRow - this.maxJ();
                        this.markVisited(targetCol, targetRow - cellsPastEdge);
                    }
                }
                if (currentCell.getCol() != this.maxI() && currentCell.getRow() != this.maxJ()) {
                    targetCol = currentCell.getCol() + radius;
                    targetRow = currentCell.getRow() + radius;
                    if (targetCol <= this.maxI() && targetRow <= this.maxJ()) {
                        this.markVisited(targetCol, targetRow);
                    } else {
                        cellsPastEdge = Math.max(targetCol - this.maxI(), targetRow - this.maxJ());
                        this.markVisited(targetCol - cellsPastEdge, targetRow - cellsPastEdge);
                    }
                }
                if (currentCell.getCol() != this.minI()) {
                    targetCol = currentCell.getCol() - radius;
                    targetRow = currentCell.getRow();
                    if (targetCol >= this.minI()) {
                        this.markVisited(targetCol, targetRow);
                    } else {
                        cellsPastEdge = this.minI() - targetCol;
                        this.markVisited(targetCol + cellsPastEdge, targetRow);
                    }
                }
                if (currentCell.getCol() != this.maxI()) {
                    targetCol = currentCell.getCol() + radius;
                    targetRow = currentCell.getRow();
                    if (targetCol <= this.maxI()) {
                        this.markVisited(targetCol, targetRow);
                    } else {
                        cellsPastEdge = targetCol - this.maxI();
                        this.markVisited(targetCol - cellsPastEdge, targetRow);
                    }
                }
                if (currentCell.getCol() != this.minI() && currentCell.getRow() != this.minJ()) {
                    targetCol = currentCell.getCol() - radius;
                    targetRow = currentCell.getRow() - radius;
                    if (targetCol >= this.minI() && targetRow >= this.minJ()) {
                        this.markVisited(targetCol, targetRow);
                    } else {
                        cellsPastEdge = Math.max(this.minI() - targetCol, this.minJ() - targetRow);
                        this.markVisited(targetCol + cellsPastEdge, targetRow + cellsPastEdge);
                    }
                }
                if (currentCell.getRow() != this.minJ()) {
                    targetCol = currentCell.getCol();
                    targetRow = currentCell.getRow() - radius;
                    if (targetRow >= this.minJ()) {
                        this.markVisited(targetCol, targetRow);
                    } else {
                        cellsPastEdge = this.minJ() - targetRow;
                        this.markVisited(targetCol, targetRow + cellsPastEdge);
                    }
                }
                if (currentCell.getCol() == this.maxI() || currentCell.getRow() == this.minJ()) continue;
                targetCol = currentCell.getCol() + radius;
                targetRow = currentCell.getRow() - radius;
                if (targetCol <= this.maxI() && targetRow >= this.minJ()) {
                    this.markVisited(targetCol, targetRow);
                    continue;
                }
                cellsPastEdge = Math.max(targetCol - this.maxI(), this.minJ() - targetRow);
                this.markVisited(targetCol - cellsPastEdge, targetRow + cellsPastEdge);
            }
        }
    }

    protected final void markVisited(int col, int row) {
        if (this.minValues[col] == -1) {
            this.minValues[col] = row;
            this.maxValues[col] = row;
            ++this.size;
            ++this.modCount;
        } else if (this.minValues[col] > row) {
            this.size += this.minValues[col] - row;
            this.minValues[col] = row;
            ++this.modCount;
        } else if (this.maxValues[col] < row) {
            this.size += row - this.maxValues[col];
            this.maxValues[col] = row;
            ++this.modCount;
        }
    }

    private final class SearchWindowIterator
    implements Iterator {
        private int currentI;
        private int currentJ;
        private final SearchWindow window;
        private boolean hasMoreElements;
        private final int expectedModCount;

        private SearchWindowIterator(SearchWindow w) {
            this.window = w;
            this.hasMoreElements = this.window.size() > 0;
            this.currentI = this.window.minI();
            this.currentJ = this.window.minJ();
            this.expectedModCount = w.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements;
        }

        public Object next() {
            if (SearchWindow.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasMoreElements) {
                throw new NoSuchElementException();
            }
            ColMajorCell cell = new ColMajorCell(this.currentI, this.currentJ);
            if (++this.currentJ > this.window.maxJforI(this.currentI)) {
                if (++this.currentI <= this.window.maxI()) {
                    this.currentJ = this.window.minJforI(this.currentI);
                } else {
                    this.hasMoreElements = false;
                }
            }
            return cell;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

