/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.warprun;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.ext.warprun.STDIN;
import io.warp10.script.functions.FOREACH;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;

public class FREAD
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final FOREACH FOREACH = new FOREACH("FOREACH");

    public FREAD(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a file path.");
        }
        Path path = new Path((String)top);
        top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects a MACRO.");
        }
        WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        Configuration conf = new Configuration();
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        FSDataInputStream in = null;
        try {
            FileSystem fs = path.getFileSystem(conf);
            in = fs.open(path);
            STDIN.InputStreamIterator iter = new STDIN.InputStreamIterator((InputStream)in);
            stack.push(iter);
            stack.push(macro);
            stack.push(false);
            FOREACH.apply(stack);
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " error processing '" + path + "'.", ioe);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    throw new WarpScriptException(this.getName() + " error closing '" + path + "'.", e);
                }
            }
        }
        return stack;
    }
}

