/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.hadoop;

import com.google.common.util.concurrent.RateLimiter;
import io.warp10.ThriftUtils;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.crypto.OrderPreservingBase64;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class Warp10RecordWriter
extends RecordWriter<Writable, Writable> {
    public static final String WARP10_GZIP = "warp10.gzip";
    public static final String WARP10_ENDPOINT = "warp10.endpoint";
    public static final String WARP10_TOKEN = "warp10.token";
    public static final String WARP10_MAXRATE = "warp10.maxrate";
    private final Properties props;
    private volatile boolean init = false;
    private HttpURLConnection conn = null;
    private PrintWriter pw = null;
    private RateLimiter limiter = null;

    public Warp10RecordWriter(Properties props) {
        this.props = props;
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            if (null != this.pw) {
                this.pw.flush();
                this.pw.close();
                int respcode = this.conn.getResponseCode();
                if (200 != respcode) {
                    throw new IOException("HTTP code: " + respcode + " - " + this.conn.getResponseMessage());
                }
            }
        }
        finally {
            if (null != this.pw) {
                try {
                    this.pw.close();
                }
                catch (Exception exception) {}
            }
            if (null != this.conn) {
                try {
                    this.conn.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writable key, Writable value) throws IOException, InterruptedException {
        GTSWrapper gtsWrapper;
        block13: {
            if (!this.init) {
                Properties properties = this.props;
                synchronized (properties) {
                    if (!this.init) {
                        this.init();
                    }
                }
            }
            TDeserializer deserializer = ThriftUtils.getTDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
            gtsWrapper = new GTSWrapper();
            try {
                if (value instanceof BytesWritable) {
                    deserializer.deserialize((TBase)gtsWrapper, ((BytesWritable)value).copyBytes());
                    break block13;
                }
                if (value instanceof Text) {
                    deserializer.deserialize((TBase)gtsWrapper, OrderPreservingBase64.decode(((Text)value).copyBytes()));
                    break block13;
                }
                throw new IOException("Invalid value class, expecting BytesWritable or Text, was " + value.getClass());
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }
        Metadata metadataChunk = gtsWrapper.isSetMetadata() ? new Metadata(gtsWrapper.getMetadata()) : new Metadata();
        GTSDecoder decoder = GTSWrapperHelper.fromGTSWrapperToGTSDecoder(gtsWrapper);
        StringBuilder metasb = new StringBuilder();
        GTSHelper.metadataToString(metasb, metadataChunk.getName(), metadataChunk.getLabels(), false);
        if (null == metadataChunk.getAttributes()) {
            metadataChunk.setAttributes(new HashMap<String, String>());
        }
        GTSHelper.metadataToString(metasb, "", metadataChunk.getAttributes(), true);
        boolean first = true;
        while (decoder.next()) {
            if (null != this.limiter) {
                this.limiter.acquire(1);
            }
            if (!first) {
                this.pw.print("=");
                this.pw.println(GTSHelper.tickToString(null, decoder.getTimestamp(), decoder.getLocation(), decoder.getElevation(), decoder.getBinaryValue()));
                continue;
            }
            this.pw.println(GTSHelper.tickToString(metasb, decoder.getTimestamp(), decoder.getLocation(), decoder.getElevation(), decoder.getBinaryValue()));
            first = false;
        }
    }

    private void init() throws IOException {
        boolean gzip = "true".equals(this.props.getProperty(WARP10_GZIP));
        String endpoint = this.props.getProperty(WARP10_ENDPOINT);
        String token = this.props.getProperty(WARP10_TOKEN);
        String maxrate = this.props.getProperty(WARP10_MAXRATE);
        if (null != maxrate) {
            this.limiter = RateLimiter.create((double)Double.parseDouble(maxrate));
        }
        this.conn = (HttpURLConnection)new URL(endpoint).openConnection();
        this.conn.setRequestMethod("POST");
        this.conn.setDoOutput(true);
        this.conn.setDoInput(true);
        this.conn.setRequestProperty("X-Warp10-Token", token);
        this.conn.setChunkedStreamingMode(65536);
        if (gzip) {
            this.conn.setRequestProperty("Content-Type", "application/gzip");
        }
        this.conn.connect();
        OutputStream out = this.conn.getOutputStream();
        if (gzip) {
            out = new GZIPOutputStream(out);
        }
        this.pw = new PrintWriter(out);
        this.init = true;
    }
}

