/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.hadoop;

import io.warp10.hadoop.Warp10InputFormat;
import io.warp10.hadoop.Warp10RecordWriter;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class Warp10OutputFormat
extends OutputFormat<Writable, Writable> {
    private final String suffix;

    public Warp10OutputFormat() {
        this(null);
    }

    public Warp10OutputFormat(String suffix) {
        this.suffix = null != suffix ? "." + suffix : "";
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new OutputCommitter(){

            public void setupTask(TaskAttemptContext taskContext) throws IOException {
            }

            public void setupJob(JobContext jobContext) throws IOException {
            }

            public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
                return false;
            }

            public void commitTask(TaskAttemptContext taskContext) throws IOException {
            }

            public void abortTask(TaskAttemptContext taskContext) throws IOException {
            }
        };
    }

    public RecordWriter<Writable, Writable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Properties props = new Properties();
        Configuration conf = context.getConfiguration();
        props.setProperty("warp10.gzip", Warp10InputFormat.getProperty(conf, this.suffix, "warp10.gzip", "false"));
        props.setProperty("warp10.endpoint", Warp10InputFormat.getProperty(conf, this.suffix, "warp10.endpoint", ""));
        props.setProperty("warp10.token", Warp10InputFormat.getProperty(conf, this.suffix, "warp10.token", ""));
        props.setProperty("warp10.maxrate", Warp10InputFormat.getProperty(conf, this.suffix, "warp10.maxrate", Long.toString(Long.MAX_VALUE)));
        return new Warp10RecordWriter(props);
    }
}

