//
//   Copyright 2018  SenX S.A.S.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//

package io.warp10.script.fwt.wavelets;

import io.warp10.script.fwt.Wavelet;

public class Wavelet_db18 extends Wavelet {

  private static final int transformWavelength = 2;

  private static final double[] scalingDeComposition = new double[] { -2.507934454941929e-09, 3.06883586303703e-08, -1.1760987670250871e-07, -7.691632689865049e-08, 1.768712983622886e-06, -3.3326344788769603e-06, -8.520602537423464e-06, 3.741237880730847e-05, -1.535917123021341e-07, -0.00019864855231101547, 0.0002135815619103188, 0.0006284656829644715, -0.0013405962983313922, -0.0011187326669886426, 0.004943343605456594, 0.00011863003387493042, -0.013051480946517112, 0.006262167954438661, 0.026670705926689853, -0.023733210395336858, -0.04452614190225633, 0.05705124773905827, 0.0648872162123582, -0.10675224665906288, -0.09233188415030412, 0.16708131276294505, 0.14953397556500755, -0.21648093400458224, -0.2936540407357981, 0.14722311196952223, 0.571801654887122, 0.5718268077650818, 0.31467894133619284, 0.10358846582214751, 0.01928853172409497, 0.0015763102184365595,  };
  private static final double[] waveletDeComposition = new double[] { -0.0015763102184365595, 0.01928853172409497, -0.10358846582214751, 0.31467894133619284, -0.5718268077650818, 0.571801654887122, -0.14722311196952223, -0.2936540407357981, 0.21648093400458224, 0.14953397556500755, -0.16708131276294505, -0.09233188415030412, 0.10675224665906288, 0.0648872162123582, -0.05705124773905827, -0.04452614190225633, 0.023733210395336858, 0.026670705926689853, -0.006262167954438661, -0.013051480946517112, -0.00011863003387493042, 0.004943343605456594, 0.0011187326669886426, -0.0013405962983313922, -0.0006284656829644715, 0.0002135815619103188, 0.00019864855231101547, -1.535917123021341e-07, -3.741237880730847e-05, -8.520602537423464e-06, 3.3326344788769603e-06, 1.768712983622886e-06, 7.691632689865049e-08, -1.1760987670250871e-07, -3.06883586303703e-08, -2.507934454941929e-09,  };

  private static final double[] scalingReConstruction = new double[] { 0.0015763102184365595, 0.01928853172409497, 0.10358846582214751, 0.31467894133619284, 0.5718268077650818, 0.571801654887122, 0.14722311196952223, -0.2936540407357981, -0.21648093400458224, 0.14953397556500755, 0.16708131276294505, -0.09233188415030412, -0.10675224665906288, 0.0648872162123582, 0.05705124773905827, -0.04452614190225633, -0.023733210395336858, 0.026670705926689853, 0.006262167954438661, -0.013051480946517112, 0.00011863003387493042, 0.004943343605456594, -0.0011187326669886426, -0.0013405962983313922, 0.0006284656829644715, 0.0002135815619103188, -0.00019864855231101547, -1.535917123021341e-07, 3.741237880730847e-05, -8.520602537423464e-06, -3.3326344788769603e-06, 1.768712983622886e-06, -7.691632689865049e-08, -1.1760987670250871e-07, 3.06883586303703e-08, -2.507934454941929e-09,  };
  private static final double[] waveletReConstruction = new double[] { -2.507934454941929e-09, -3.06883586303703e-08, -1.1760987670250871e-07, 7.691632689865049e-08, 1.768712983622886e-06, 3.3326344788769603e-06, -8.520602537423464e-06, -3.741237880730847e-05, -1.535917123021341e-07, 0.00019864855231101547, 0.0002135815619103188, -0.0006284656829644715, -0.0013405962983313922, 0.0011187326669886426, 0.004943343605456594, -0.00011863003387493042, -0.013051480946517112, -0.006262167954438661, 0.026670705926689853, 0.023733210395336858, -0.04452614190225633, -0.05705124773905827, 0.0648872162123582, 0.10675224665906288, -0.09233188415030412, -0.16708131276294505, 0.14953397556500755, 0.21648093400458224, -0.2936540407357981, -0.14722311196952223, 0.571801654887122, -0.5718268077650818, 0.31467894133619284, -0.10358846582214751, 0.01928853172409497, -0.0015763102184365595,  };

  static {
    //
    // Reverse the arrays as we do convolutions
    //
    reverse(scalingDeComposition);
    reverse(waveletDeComposition);
  }

  private static final void reverse(double[] array) {
    int i = 0;
    int j = array.length - 1;
    
    while (i < j) {
      double tmp = array[i];
      array[i] = array[j];
      array[j] = tmp;
      i++;
      j--;
    }
  }

  public int getTransformWavelength() {
    return transformWavelength;
  }

  public int getMotherWavelength() {
    return waveletReConstruction.length;
  }

  public double[] getScalingDeComposition() {
    return scalingDeComposition;
  }

  public double[] getWaveletDeComposition() {
    return waveletDeComposition;
  }

  public double[] getScalingReConstruction() {
    return scalingReConstruction;
  }

  public double[] getWaveletReConstruction() {
    return waveletReConstruction;
  }
}

