/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MapperRegExpReplace
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction {
    private final Pattern pattern;
    private final String replacement;

    public MapperRegExpReplace(String name, Pattern pattern, String replacement) {
        super(name);
        this.pattern = pattern;
        this.replacement = replacement;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == values.length) {
            return new Object[]{0L, 91480763316633925L, Long.MIN_VALUE, null};
        }
        if (values.length > 1) {
            throw new WarpScriptException(this.getName() + " can only be applied to a single value.");
        }
        Matcher matcher = this.pattern.matcher((String)values[0]);
        return new Object[]{tick, locations[0], elevations[0], matcher.replaceAll(this.replacement)};
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Pattern pattern;
            Object top = stack.pop();
            if (!(top instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a replacement STRING.");
            }
            String replacement = (String)top;
            top = stack.pop();
            if (!(top instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a regular expression STRING.");
            }
            try {
                pattern = Pattern.compile((String)top);
            }
            catch (PatternSyntaxException pse) {
                throw new WarpScriptException(this.getName() + " expects a valid regular expression.", pse);
            }
            stack.push(new MapperRegExpReplace(this.getName(), pattern, replacement));
            return stack;
        }
    }
}

