/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.fwt;

import com.google.common.base.Preconditions;
import io.warp10.script.fwt.Wavelet;
import java.util.Arrays;

public class FWT {
    public static double[] forward(Wavelet wavelet, double[] timeBased) {
        Preconditions.checkArgument((0 == (timeBased.length & timeBased.length - 1) ? 1 : 0) != 0, (Object)"Can only perform FWT on data whose cardinality is a power of 2.");
        double[] hilbert = Arrays.copyOf(timeBased, timeBased.length);
        int transformWavelength = wavelet.getTransformWavelength();
        for (int h = hilbert.length; h >= transformWavelength; h >>= 1) {
            double[] temp = wavelet.forward(hilbert, h);
            System.arraycopy(temp, 0, hilbert, 0, h);
        }
        return hilbert;
    }

    public static double[] reverse(Wavelet wavelet, double[] arrHilb) {
        int transformWavelength;
        Preconditions.checkArgument((0 == (arrHilb.length & arrHilb.length - 1) ? 1 : 0) != 0, (Object)"Can only perform FWT on data whose cardinality is a power of 2.");
        double[] arrTime = Arrays.copyOf(arrHilb, arrHilb.length);
        for (int h = transformWavelength = wavelet.getTransformWavelength(); h <= arrTime.length && h >= transformWavelength; h <<= 1) {
            double[] arrTempPart = wavelet.reverse(arrTime, h);
            System.arraycopy(arrTempPart, 0, arrTime, 0, h);
        }
        return arrTime;
    }
}

