/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class TOQUATERNION
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOQUATERNION(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object zo = stack.pop();
        if (!(zo instanceof Double)) {
            throw new WarpScriptException(this.getName() + " expects the quaternion components w x y z as doubles on the stack (z on top).");
        }
        Object yo = stack.pop();
        if (!(yo instanceof Double)) {
            throw new WarpScriptException(this.getName() + " expects the quaternion components w x y z as doubles on the stack (z on top).");
        }
        Object xo = stack.pop();
        if (!(xo instanceof Double)) {
            throw new WarpScriptException(this.getName() + " expects the quaternion components w x y z as doubles on the stack (z on top).");
        }
        Object wo = stack.pop();
        if (!(wo instanceof Double)) {
            throw new WarpScriptException(this.getName() + " expects the quaternion components w x y z as doubles on the stack (z on top).");
        }
        double w = ((Number)wo).doubleValue();
        double x = ((Number)xo).doubleValue();
        double y = ((Number)yo).doubleValue();
        double z = ((Number)zo).doubleValue();
        if (!(Double.isFinite(w) && Double.isFinite(x) && Double.isFinite(y) && Double.isFinite(z))) {
            throw new WarpScriptException(this.getName() + " expects finite arguments.");
        }
        long q = TOQUATERNION.toQuaternion(w, x, y, z);
        stack.push(q);
        return stack;
    }

    public static long toQuaternion(double w, double x, double y, double z) {
        double norm = Math.sqrt(w * w + x * x + y * y + z * z);
        if (0.0 != norm) {
            w /= norm;
            x /= norm;
            y /= norm;
            z /= norm;
        }
        int iw = (int)Math.floor((w + 1.0) / 2.0 * 65535.0);
        int ix = (int)Math.floor((x + 1.0) / 2.0 * 65535.0);
        int iy = (int)Math.floor((y + 1.0) / 2.0 * 65535.0);
        int iz = (int)Math.floor((z + 1.0) / 2.0 * 65535.0);
        long q = iw & 0xFFFF;
        q <<= 16;
        q |= (long)(ix & 0xFFFF);
        q <<= 16;
        q |= (long)(iy & 0xFFFF);
        q <<= 16;
        return q |= (long)(iz & 0xFFFF);
    }
}

