/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.io.gml2.GMLWriter;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.TOGEOJSON;
import java.io.IOException;
import java.io.Writer;

public class TOKML
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final TOGEOJSON togeojson;

    public TOKML(String name) {
        super(name);
        this.togeojson = new TOGEOJSON(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object peeked = stack.peek();
        if (peeked instanceof GeoXPLib.GeoXPShape || peeked instanceof Boolean) {
            this.togeojson.apply(stack);
        }
        Object geomObject = stack.pop();
        try {
            Geometry geometry = TOGEOJSON.toGeometry(geomObject);
            stack.push(TOKML.GeometryToKML(geometry));
        }
        catch (WarpScriptException wse) {
            throw new WarpScriptException(this.getName() + " expects a GEOSHAPE, a WKT STRING, a GeoJSON STRING, a KML STRING or a GeoJSON STRING.", wse);
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " was given invalid input.", e);
        }
        return stack;
    }

    public static String GeometryToKML(Geometry geometry) {
        KMLWriter writer = new KMLWriter();
        String kml = writer.write(geometry);
        return kml.replaceAll("\\n\\s*", "");
    }

    protected static class KMLWriter
    extends GMLWriter {
        public KMLWriter() {
            this.setPrefix(null);
        }

        public void write(Geometry geometry, Writer writer) throws IOException {
            if (geometry instanceof MultiPoint || geometry instanceof MultiLineString || geometry instanceof MultiPolygon) {
                writer.write("<MultiGeometry>");
                for (int t = 0; t < geometry.getNumGeometries(); ++t) {
                    this.write(geometry.getGeometryN(t), writer);
                }
                writer.write("</MultiGeometry>");
            } else {
                super.write(geometry, writer);
            }
        }
    }
}

