/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.geoxp.geo.Coverage;
import com.geoxp.geo.CoverageHelper;
import com.geoxp.geo.HHCodeHelper;
import com.vividsolutions.jts.io.ParseException;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.GeoGML;
import io.warp10.script.functions.GeoJSON;
import io.warp10.script.functions.GeoKML;
import io.warp10.script.functions.GeoWKB;
import io.warp10.script.functions.GeoWKT;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.wololo.geojson.Geometry;
import org.wololo.jts2geojson.GeoJSONWriter;
import org.xml.sax.SAXException;

public class TOGEOJSON
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOGEOJSON(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        boolean allCells = false;
        Object top = stack.pop();
        if (top instanceof Boolean) {
            allCells = (Boolean)top;
            top = stack.pop();
            if (!(top instanceof GeoXPLib.GeoXPShape)) {
                throw new WarpScriptException(this.getName() + " operates on a GEOSHAPE when first given a BOOLEAN.");
            }
        }
        if (top instanceof GeoXPLib.GeoXPShape) {
            GeoXPLib.GeoXPShape shape = (GeoXPLib.GeoXPShape)top;
            if (allCells) {
                long[] cells = GeoXPLib.getCells((GeoXPLib.GeoXPShape)shape);
                StringBuilder sb = new StringBuilder();
                sb.append("{\"type\":\"MultiPolygon\",\"coordinates\":[");
                String prefix = "";
                for (long cell : cells) {
                    int cellRes = (int)(cell >>> 60) << 1;
                    long hh = cell << 4;
                    double[] bbox = HHCodeHelper.getHHCodeBBox((long)hh, (int)cellRes);
                    sb.append(prefix);
                    prefix = ",";
                    sb.append("[[[").append(bbox[1]).append(",").append(bbox[0]).append("],");
                    sb.append("[").append(bbox[3]).append(",").append(bbox[0]).append("],");
                    sb.append("[").append(bbox[3]).append(",").append(bbox[2]).append("],");
                    sb.append("[").append(bbox[1]).append(",").append(bbox[2]).append("],");
                    sb.append("[").append(bbox[1]).append(",").append(bbox[0]).append("]]]");
                }
                sb.append("]}");
                stack.push(sb.toString());
            } else {
                long[] cells = GeoXPLib.getCells((GeoXPLib.GeoXPShape)shape);
                Coverage coverage = new Coverage(cells);
                stack.push(CoverageHelper.toGeoJSON((Coverage)coverage));
            }
        } else {
            try {
                com.vividsolutions.jts.geom.Geometry geometry = TOGEOJSON.toGeometry(top);
                GeoJSONWriter writer = new GeoJSONWriter();
                Geometry json = writer.write(geometry);
                stack.push(json.toString());
            }
            catch (WarpScriptException wse) {
                throw new WarpScriptException(this.getName() + " expects a GEOSHAPE, a WKT STRING, a GML STRING, a KML STRING or WKB BYTES.", wse);
            }
            catch (Exception e) {
                throw new WarpScriptException(this.getName() + " was given invalid input.", e);
            }
        }
        return stack;
    }

    public static com.vividsolutions.jts.geom.Geometry toGeometry(Object geomObject) throws WarpScriptException, ParseException, IOException, ParserConfigurationException, SAXException {
        com.vividsolutions.jts.geom.Geometry geometry;
        if (geomObject instanceof byte[]) {
            geometry = GeoWKB.wkbToGeometry((byte[])geomObject);
        } else if (geomObject instanceof String) {
            String geomString = ((String)geomObject).trim();
            geometry = geomString.startsWith("{") ? GeoJSON.geoJSONToGeometry(geomString) : (geomString.startsWith("<gml") ? GeoGML.GMLToGeometry(geomString) : (geomString.startsWith("<") ? GeoKML.KMLToGeometry(geomString) : GeoWKT.wktToGeometry(geomString)));
        } else {
            throw new WarpScriptException("Unknown geometry format.");
        }
        return geometry;
    }
}

