/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public class TOBIN
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String[] NIBBLES = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};

    public TOBIN(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        StringBuilder sb = new StringBuilder();
        if (o instanceof String || o instanceof byte[]) {
            byte[] data = o instanceof String ? ((String)o).getBytes(StandardCharsets.UTF_8) : (byte[])o;
            for (byte datum : data) {
                int nibble = datum >>> 4 & 0xF;
                sb.append(NIBBLES[nibble]);
                nibble = datum & 0xF;
                sb.append(NIBBLES[nibble]);
            }
            stack.push(sb.toString());
        } else if (o instanceof Long) {
            sb.append("0000000000000000000000000000000000000000000000000000000000000000");
            sb.append(Long.toBinaryString(((Number)o).longValue()));
            stack.push(sb.substring(sb.length() - 64));
        } else if (o instanceof BitSet) {
            BitSet bitset = (BitSet)o;
            for (int i = 0; i < bitset.length(); ++i) {
                sb.append(bitset.get(i) ? (char)'1' : '0');
            }
            stack.push(sb.toString());
        } else {
            throw new WarpScriptException(this.getName() + " operates on a STRING, BYTES, LONG or BITSET.");
        }
        return stack;
    }
}

