/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.google.common.primitives.Bytes;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.digests.SHA256Digest;

public class TOB58
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    public static final BigInteger FIFTY_EIGHT = new BigInteger("58");
    private final boolean check;

    public TOB58(String name, boolean check) {
        super(name);
        this.check = check;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        byte[] payload = null;
        byte[] prefix = null;
        if (this.check) {
            if (!(top instanceof byte[])) {
                throw new WarpScriptException(this.getName() + " expects a byte array prefix.");
            }
            prefix = (byte[])top;
            top = stack.pop();
        }
        if (top instanceof byte[]) {
            payload = (byte[])top;
        } else if (top instanceof String) {
            payload = ((String)top).getBytes(StandardCharsets.UTF_8);
        } else {
            throw new WarpScriptException(this.getName() + " operates on STRING or a byte array.");
        }
        if (this.check) {
            SHA256Digest digest = new SHA256Digest();
            digest.update(prefix, 0, prefix.length);
            digest.update(payload, 0, payload.length);
            byte[] hash = new byte[digest.getDigestSize()];
            digest.doFinal(hash, 0);
            digest.reset();
            digest.update(hash, 0, hash.length);
            digest.doFinal(hash, 0);
            byte[] data = new byte[prefix.length + payload.length + 4];
            System.arraycopy(prefix, 0, data, 0, prefix.length);
            System.arraycopy(payload, 0, data, prefix.length, payload.length);
            System.arraycopy(hash, 0, data, prefix.length + payload.length, 4);
            payload = data;
        }
        stack.push(TOB58.encode(payload));
        return stack;
    }

    public static String encode(byte[] data) {
        int zero_counter;
        StringBuilder b58_encoding = new StringBuilder();
        for (zero_counter = 0; zero_counter < data.length && 0 == data[zero_counter]; ++zero_counter) {
            b58_encoding.append("1");
        }
        if (0 != (data[0] & 0x80)) {
            data = Bytes.concat((byte[][])new byte[][]{{0}, data});
        }
        BigInteger n = new BigInteger(data);
        while (!BigInteger.ZERO.equals(n)) {
            int r = n.mod(FIFTY_EIGHT).intValue();
            n = n.divide(FIFTY_EIGHT);
            b58_encoding.insert(zero_counter, ALPHABET.charAt(r));
        }
        return b58_encoding.toString();
    }
}

