/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.QUATERNIONTO;

public class QROTATION
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public QROTATION(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " can only operate on a quaternion.");
        }
        double[] q = QUATERNIONTO.fromQuaternion(((Number)top).longValue());
        double angle = Math.acos(q[0]);
        double sin = Math.sin(angle);
        if (0.0 != sin) {
            q[1] = q[1] / sin;
            q[2] = q[2] / sin;
            q[3] = q[3] / sin;
        }
        stack.push(q[1]);
        stack.push(q[2]);
        stack.push(q[3]);
        stack.push(Math.toDegrees(angle * 2.0));
        return stack;
    }
}

