/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.QUATERNIONTO;
import io.warp10.script.functions.TOQUATERNION;

public class QDIVIDE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public QDIVIDE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object ro = stack.pop();
        if (!(ro instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a quaternion on top of the stack.");
        }
        double[] r = QUATERNIONTO.fromQuaternion(((Number)ro).longValue());
        Object qo = stack.pop();
        if (!(qo instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects another quaternion below the quaternion on top of the stack.");
        }
        double[] q = QUATERNIONTO.fromQuaternion(((Number)qo).longValue());
        double n = r[0] * r[0] + r[1] * r[1] + r[2] * r[2] + r[3] * r[3];
        double w = r[0] * q[0] + r[1] * q[1] + r[2] * q[2] + r[3] * q[3];
        double x = r[0] * q[1] - r[1] * q[0] - r[2] * q[3] + r[3] * q[2];
        double y = r[0] * q[2] + r[1] * q[3] - r[2] * q[0] - r[3] * q[1];
        double z = r[0] * q[3] - r[1] * q[2] + r[2] * q[1] - r[3] * q[0];
        stack.push(TOQUATERNION.toQuaternion(w / n, x / n, y / n, z / n));
        return stack;
    }
}

