/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.encoders.Hex;

public class PGPENCRYPT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String KEY_RECIPIENT = "recipient";

    public PGPENCRYPT(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expected a parameter MAP.");
        }
        Map params = (Map)top;
        boolean throwKeyId = Boolean.TRUE.equals(params.getOrDefault("throw_keyid", true));
        boolean armor = Boolean.TRUE.equals(params.getOrDefault("armor", true));
        PGPPublicKey pubkey = null;
        if (params.get(KEY_RECIPIENT) instanceof PGPPublicKey) {
            pubkey = (PGPPublicKey)params.get(KEY_RECIPIENT);
        } else if (params.get(KEY_RECIPIENT) instanceof Long || params.get(KEY_RECIPIENT) instanceof String) {
            Object k = params.get(KEY_RECIPIENT);
            long keyid = 0L;
            if (k instanceof Long) {
                keyid = (Long)k;
            } else if (k instanceof String) {
                byte[] decoded = Hex.decode((String)((String)k));
                for (int i = 8; i >= 1; --i) {
                    if (decoded.length - i < 0) continue;
                    keyid <<= 8;
                    keyid |= (long)decoded[decoded.length - i] & 0xFFL;
                }
            } else {
                throw new WarpScriptException(this.getName() + " missing PGP secret key id.");
            }
            if (params.get("keyring") instanceof PGPSecretKeyRing) {
                pubkey = ((PGPSecretKeyRing)params.get("keyring")).getPublicKey(keyid);
            } else if (params.get("keyring") instanceof PGPPublicKeyRing) {
                pubkey = ((PGPPublicKeyRing)params.get("keyring")).getPublicKey(keyid);
            } else {
                throw new WarpScriptException(this.getName() + " missing PGP secret key ring.");
            }
            if (null == pubkey) {
                throw new WarpScriptException(this.getName() + " key with id 0x" + Long.toHexString(keyid) + " not found.");
            }
        } else {
            throw new WarpScriptException(this.getName() + " missing recipient PGP public key or key ring and key id.");
        }
        top = stack.pop();
        byte[] data = null;
        if (top instanceof byte[]) {
            data = (byte[])top;
        } else if (top instanceof String) {
            data = ((String)top).getBytes(StandardCharsets.UTF_8);
        } else {
            throw new WarpScriptException(this.getName() + " expects data to encrypt to be either STRING or BYTES.");
        }
        try {
            PGPEncryptedDataGenerator edg = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new BcPGPDataEncryptorBuilder(PGPENCRYPT.getEncryptionAlgorithm(String.valueOf(params.getOrDefault("algorithm", "AES_256")))).setWithIntegrityPacket(true).setSecureRandom(new SecureRandom()));
            if (throwKeyId) {
                edg.addMethod((PGPKeyEncryptionMethodGenerator)new AnonymousBcPublicKeyKeyEncryptionMethodGenerator(pubkey).setSecureRandom(new SecureRandom()).setSessionKeyObfuscation(true));
            } else {
                edg.addMethod((PGPKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(pubkey).setSecureRandom(new SecureRandom()).setSessionKeyObfuscation(true));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ArmoredOutputStream armored = armor ? new ArmoredOutputStream((OutputStream)out, new Hashtable()) : null;
            OutputStream cOut = edg.open((OutputStream)(armor ? armored : out), new byte[1024]);
            PGPLiteralDataGenerator ldata = new PGPLiteralDataGenerator();
            Date date = PGPLiteralData.NOW;
            if (params.get("date") instanceof Long) {
                date = new Date((Long)params.get("date") / Constants.TIME_UNITS_PER_MS);
            }
            OutputStream pOut = ldata.open(cOut, 'b', "_CONSOLE", (long)data.length, date);
            pOut.write(data);
            pOut.close();
            cOut.close();
            if (armor) {
                armored.close();
                stack.push(new String(out.toByteArray(), StandardCharsets.UTF_8));
            } else {
                stack.push(out.toByteArray());
            }
        }
        catch (Exception e) {
            throw new WarpScriptException(this.getName() + " error while encrypting data.", e);
        }
        return stack;
    }

    public static int getEncryptionAlgorithm(String name) throws WarpScriptException {
        switch (name) {
            case "AES_128": {
                return 7;
            }
            case "AES_192": {
                return 8;
            }
            case "AES_256": {
                return 9;
            }
            case "BLOWFISH": {
                return 4;
            }
            case "CAMELLIA_128": {
                return 11;
            }
            case "CAMELLIA_192": {
                return 12;
            }
            case "CAMELLIA_256": {
                return 13;
            }
            case "CAST5": {
                return 3;
            }
            case "DES": {
                return 6;
            }
            case "IDEA": {
                return 1;
            }
            case "SAFER": {
                return 5;
            }
            case "TRIPLE_DES": 
            case "3DES": {
                return 2;
            }
            case "TWOFISH": {
                return 10;
            }
        }
        throw new WarpScriptException("Invalid encryption algorithm '" + name + "'.");
    }

    private static class AnonymousBcPublicKeyKeyEncryptionMethodGenerator
    extends BcPublicKeyKeyEncryptionMethodGenerator {
        private final PGPPublicKey pubKey;

        public AnonymousBcPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey key) {
            super(key);
            this.pubKey = key;
        }

        public ContainedPacket generate(int encAlgorithm, byte[] sessionInfo) throws PGPException {
            return new PublicKeyEncSessionPacket(0L, this.pubKey.getAlgorithm(), this.processSessionInfo(this.encryptSessionInfo(this.pubKey, sessionInfo)));
        }
    }
}

