/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;

public class PGPDECRYPT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public PGPDECRYPT(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " missing passphrase.");
        }
        String passphrase = (String)top;
        top = stack.pop();
        long keyid = 0L;
        if (top instanceof Long) {
            keyid = (Long)top;
        } else if (top instanceof String) {
            byte[] decoded = Hex.decode((String)((String)top));
            for (int i = 8; i >= 1; --i) {
                if (decoded.length - i < 0) continue;
                keyid <<= 8;
                keyid |= (long)decoded[decoded.length - i] & 0xFFL;
            }
        } else {
            throw new WarpScriptException(this.getName() + " missing PGP secret key id.");
        }
        top = stack.pop();
        if (!(top instanceof PGPSecretKeyRing)) {
            throw new WarpScriptException(this.getName() + " missing PGP secret key ring.");
        }
        PGPSecretKeyRing keyring = (PGPSecretKeyRing)top;
        PGPSecretKey key = keyring.getSecretKey(keyid);
        if (null == key) {
            throw new WarpScriptException(this.getName() + " key with id 0x" + Long.toHexString(keyid) + " not found.");
        }
        PBESecretKeyDecryptor decryptorFactory = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passphrase.toCharArray());
        PGPPrivateKey privateKey = null;
        try {
            privateKey = key.extractPrivateKey(decryptorFactory);
        }
        catch (PGPException pgpe) {
            throw new WarpScriptException(this.getName() + " unable to extract private key.", pgpe);
        }
        top = stack.pop();
        byte[] data = null;
        if (top instanceof byte[]) {
            data = (byte[])top;
        } else if (top instanceof String) {
            try {
                ArmoredInputStream ais = new ArmoredInputStream((InputStream)new ByteArrayInputStream(((String)top).getBytes(StandardCharsets.UTF_8)));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copyLarge((InputStream)ais, (OutputStream)out);
                data = out.toByteArray();
            }
            catch (IOException ioe) {
                throw new WarpScriptException(this.getName() + " error while extracting PGP message.", ioe);
            }
        } else {
            throw new WarpScriptException(this.getName() + " expected encrypted content as STRING or BYTES.");
        }
        BcPGPObjectFactory pgpFact = new BcPGPObjectFactory(data);
        try {
            PGPEncryptedDataList encList = (PGPEncryptedDataList)pgpFact.nextObject();
            PGPPublicKeyEncryptedData encData = (PGPPublicKeyEncryptedData)encList.get(0);
            BcPublicKeyDataDecryptorFactory dataDecryptorFactory = new BcPublicKeyDataDecryptorFactory(privateKey);
            InputStream clear = encData.getDataStream((PublicKeyDataDecryptorFactory)dataDecryptorFactory);
            byte[] literalData = Streams.readAll((InputStream)clear);
            BcPGPObjectFactory litFact = new BcPGPObjectFactory(literalData);
            Object next = litFact.nextObject();
            if (next instanceof PGPCompressedData) {
                PGPCompressedData cData = (PGPCompressedData)next;
                pgpFact = new BcPGPObjectFactory(cData.getDataStream());
                next = pgpFact.nextObject();
            }
            if (!(next instanceof PGPLiteralData)) {
                throw new IllegalStateException("no encrypted content found");
            }
            PGPLiteralData litData = (PGPLiteralData)next;
            byte[] cleartext = Streams.readAll((InputStream)litData.getInputStream());
            stack.push(cleartext);
        }
        catch (IOException | IllegalStateException | NullPointerException | PGPException e) {
            throw new WarpScriptException(this.getName() + " error during decryption.", e);
        }
        return stack;
    }
}

