/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSOpsHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.ListRecursiveStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.math.BigDecimal;
import java.util.function.DoubleUnaryOperator;
import java.util.function.LongUnaryOperator;

public class NumericalUnaryFunction
extends ListRecursiveStackFunction {
    final ListRecursiveStackFunction.ElementStackFunction func;

    public NumericalUnaryFunction(String name, final LongUnaryOperator opL, final DoubleUnaryOperator opD) {
        super(name);
        this.func = new ListRecursiveStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                if (element instanceof Number) {
                    if (null != opD && (null == opL || element instanceof Double || element instanceof BigDecimal)) {
                        return opD.applyAsDouble(((Number)element).doubleValue());
                    }
                    return opL.applyAsLong(((Number)element).longValue());
                }
                if (element instanceof GeoTimeSerie) {
                    GeoTimeSerie gts = (GeoTimeSerie)element;
                    GeoTimeSerie.TYPE type = gts.getType();
                    if (GeoTimeSerie.TYPE.LONG != type && GeoTimeSerie.TYPE.DOUBLE != type && GeoTimeSerie.TYPE.UNDEFINED != type) {
                        throw new WarpScriptException(NumericalUnaryFunction.this.getName() + " can only operate on LONG, DOUBLE or empty GTSs.");
                    }
                    GeoTimeSerie result = gts.cloneEmpty(gts.size());
                    GTSOpsHelper.GTSUnaryOp op = null != opD && (null == opL || gts.getType() == GeoTimeSerie.TYPE.DOUBLE) ? new GTSOpsHelper.GTSUnaryOp(){

                        @Override
                        public Object op(GeoTimeSerie gts, int idx) {
                            return opD.applyAsDouble(((Number)GTSHelper.valueAtIndex(gts, idx)).doubleValue());
                        }
                    } : new GTSOpsHelper.GTSUnaryOp(){

                        @Override
                        public Object op(GeoTimeSerie gts, int idx) {
                            return opL.applyAsLong(((Number)GTSHelper.valueAtIndex(gts, idx)).longValue());
                        }
                    };
                    GTSOpsHelper.applyUnaryOp(result, gts, op);
                    return result;
                }
                return ListRecursiveStackFunction.UNHANDLED;
            }
        };
    }

    @Override
    public ListRecursiveStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        return this.func;
    }

    @Override
    public String getUnhandledErrorMessage() {
        return this.getName() + " can only operate on numerical values, list of numerical values or numerical GTSs.";
    }
}

