/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.MSIG;
import java.util.LinkedHashMap;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public class MSIGINFO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String KEY_SIG = "sig";
    private static final String KEY_KEY = "key";

    public MSIGINFO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects a macro.");
        }
        WarpScriptStack.Macro macro = MSIG.getSignature((WarpScriptStack.Macro)top);
        int size = macro.size();
        LinkedHashMap<String, Object> siginfo = new LinkedHashMap<String, Object>();
        if (4 != size) {
            stack.push(false);
            return stack;
        }
        final ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)((String)macro.get(0)));
        ECCurve curve = spec.getCurve();
        final byte[] encoded = Hex.decode((String)((String)macro.get(1)));
        final ECPoint q = curve.decodePoint(encoded);
        ECPublicKey pubkey = new ECPublicKey(){

            public String getFormat() {
                return "PKCS#8";
            }

            public byte[] getEncoded() {
                return encoded;
            }

            public String getAlgorithm() {
                return "EC";
            }

            public ECParameterSpec getParameters() {
                return spec;
            }

            public ECPoint getQ() {
                return q;
            }
        };
        byte[] sig = Hex.decode((String)((String)macro.get(2)));
        siginfo.put(KEY_SIG, sig);
        siginfo.put(KEY_KEY, pubkey);
        stack.push(top);
        stack.push(siginfo);
        return stack;
    }
}

