/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MOTIONSPLIT
extends ElementOrListStackFunction {
    public static final String PARAM_TIMESPLIT = "timesplit";
    public static final String PARAM_SPLIT_NUMBER_LABEL = "label.split.number";
    public static final String PARAM_PROXIMITY_IN_ZONE_TIME_LABEL = "label.stopped.time";
    public static final String PARAM_SPLIT_TYPE_LABEL = "label.split.type";
    public static final String PARAM_DISTANCETHRESHOLD = "distance.split";
    public static final String PARAM_PROXIMITY_ZONE_TIME = "stopped.min.time";
    public static final String PARAM_PROXIMITY_ZONE_SPEED = "stopped.max.speed";
    public static final String PARAM_PROXIMITY_ZONE_RADIUS = "stopped.max.radius";
    public static final String PARAM_PROXIMITY_IN_ZONE_MAX_SPEED = "stopped.max.mean.speed";
    public static final String PARAM_PROXIMITY_SPLIT_STOPPED = "stopped.split";
    public static final String SPLIT_TYPE_TIME = "timesplit";
    public static final String SPLIT_TYPE_DISTANCE = "distancesplit";
    public static final String SPLIT_TYPE_END = "end";
    public static final String SPLIT_TYPE_STOPPED = "stopped";
    public static final String SPLIT_TYPE_MOVING = "moving";

    public MOTIONSPLIT(String name) {
        super(name);
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        Map params = null;
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a parameter MAP on top of the stack.");
        }
        params = (Map)top;
        long timeThreshold = Long.MAX_VALUE;
        if (params.containsKey("timesplit")) {
            Object o = params.get("timesplit");
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " " + "timesplit" + " must be a number.");
            }
            timeThreshold = ((Number)o).longValue();
        }
        String splitNumberLabel = null;
        if (params.containsKey(PARAM_SPLIT_NUMBER_LABEL)) {
            Object o = params.get(PARAM_SPLIT_NUMBER_LABEL);
            if (!(o instanceof String)) {
                throw new WarpScriptException(this.getName() + " " + PARAM_SPLIT_NUMBER_LABEL + " must be a string.");
            }
            splitNumberLabel = o.toString();
        }
        String splitTypeLabel = null;
        if (params.containsKey(PARAM_SPLIT_TYPE_LABEL)) {
            Object o = params.get(PARAM_SPLIT_TYPE_LABEL);
            if (!(o instanceof String)) {
                throw new WarpScriptException(this.getName() + " " + PARAM_SPLIT_TYPE_LABEL + " must be a string.");
            }
            splitTypeLabel = o.toString();
        }
        String stoppedTimeLabel = null;
        if (params.containsKey(PARAM_PROXIMITY_IN_ZONE_TIME_LABEL)) {
            Object o = params.get(PARAM_PROXIMITY_IN_ZONE_TIME_LABEL);
            if (!(o instanceof String)) {
                throw new WarpScriptException(this.getName() + " " + PARAM_PROXIMITY_IN_ZONE_TIME_LABEL + " must be a string.");
            }
            stoppedTimeLabel = o.toString();
        }
        double distanceThreshold = Double.MAX_VALUE;
        if (params.containsKey(PARAM_DISTANCETHRESHOLD)) {
            Object o = params.get(PARAM_DISTANCETHRESHOLD);
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " " + PARAM_DISTANCETHRESHOLD + " must be a number.");
            }
            distanceThreshold = ((Number)o).doubleValue();
        }
        double proximityZoneMaxSpeed = Double.MAX_VALUE;
        if (params.containsKey(PARAM_PROXIMITY_ZONE_SPEED)) {
            Object o = params.get(PARAM_PROXIMITY_ZONE_SPEED);
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " " + PARAM_PROXIMITY_ZONE_SPEED + " must be a number: speed in m/s.");
            }
            proximityZoneMaxSpeed = ((Number)o).doubleValue();
        }
        double proximityInZoneMaxMeanSpeed = Double.MAX_VALUE;
        if (params.containsKey(PARAM_PROXIMITY_IN_ZONE_MAX_SPEED)) {
            Object o = params.get(PARAM_PROXIMITY_IN_ZONE_MAX_SPEED);
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " " + PARAM_PROXIMITY_IN_ZONE_MAX_SPEED + " must be a number: speed in m/s.");
            }
            proximityInZoneMaxMeanSpeed = ((Number)o).doubleValue();
        }
        long proximityZoneTime = Long.MAX_VALUE;
        if (params.containsKey(PARAM_PROXIMITY_ZONE_TIME)) {
            Object o = params.get(PARAM_PROXIMITY_ZONE_TIME);
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " " + PARAM_PROXIMITY_ZONE_TIME + " must be a number: time in platform time unit");
            }
            proximityZoneTime = ((Number)o).longValue();
        }
        double proximityZoneRadius = Double.MAX_VALUE;
        if (params.containsKey(PARAM_PROXIMITY_ZONE_RADIUS)) {
            Object o = params.get(PARAM_PROXIMITY_ZONE_RADIUS);
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " " + PARAM_PROXIMITY_ZONE_RADIUS + " must be a number: radius in meters.");
            }
            proximityZoneRadius = ((Number)o).doubleValue();
        }
        boolean proximityZoneSplit = false;
        if (params.containsKey(PARAM_PROXIMITY_SPLIT_STOPPED)) {
            Object o = params.get(PARAM_PROXIMITY_SPLIT_STOPPED);
            if (!(o instanceof Boolean)) {
                throw new WarpScriptException(this.getName() + " " + PARAM_PROXIMITY_SPLIT_STOPPED + " must be a boolean.");
            }
            proximityZoneSplit = (Boolean)o;
        }
        final String fsplitNumberLabel = splitNumberLabel;
        final long ftimeThreshold = timeThreshold;
        final double fdistanceThreshold = distanceThreshold;
        final double fproximityZoneRadius = proximityZoneRadius;
        final double fproximityZoneMaxSpeed = proximityZoneMaxSpeed;
        final long fproximityZoneTime = proximityZoneTime;
        final double fproximityInZoneMaxMeanSpeed = proximityInZoneMaxMeanSpeed;
        final String fsplitTypeLabel = splitTypeLabel;
        final String fstoppedTimeLabel = stoppedTimeLabel;
        final boolean fproximityZoneSplit = proximityZoneSplit;
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                if (!(element instanceof GeoTimeSerie)) {
                    throw new WarpScriptException(MOTIONSPLIT.this.getName() + " can only be applied on Geo Time Series.");
                }
                GeoTimeSerie gts = (GeoTimeSerie)element;
                return MOTIONSPLIT.motionSplit(gts, fsplitNumberLabel, ftimeThreshold, fdistanceThreshold, fproximityZoneRadius, fproximityZoneMaxSpeed, fproximityZoneTime, fproximityInZoneMaxMeanSpeed, fsplitTypeLabel, fstoppedTimeLabel, fproximityZoneSplit);
            }
        };
    }

    private static List<GeoTimeSerie> motionSplit(GeoTimeSerie gts, String splitNumberLabel, long timeThreshold, double distanceThreshold, double proximityZoneRadius, double proximityZoneMaxSpeed, long proximityZoneTime, double proximityInZoneMaxMeanSpeed, String splitTypeLabel, String stoppedTimeLabel, boolean proximityZoneSplit) throws WarpScriptException {
        GTSHelper.sort(gts, false);
        GeoTimeSerie split = null;
        ArrayList<GeoTimeSerie> splits = new ArrayList<GeoTimeSerie>();
        int gtsid = 1;
        int n = GTSHelper.nvalues(gts);
        boolean mustSplit = true;
        long refLocation = 91480763316633925L;
        long refTimestamp = Long.MIN_VALUE;
        long previousTimestamp = Long.MIN_VALUE;
        long previousTimestampWithLocation = Long.MIN_VALUE;
        long previousValidLocation = 91480763316633925L;
        double proximityZoneTraveledDistance = 0.0;
        String splitReason = SPLIT_TYPE_END;
        if (n <= 1) {
            GeoTimeSerie result = gts.clone();
            if (null != splitTypeLabel) {
                result.getMetadata().putToLabels(splitTypeLabel, SPLIT_TYPE_END);
            }
            if (null != splitNumberLabel) {
                result.getMetadata().putToLabels(splitNumberLabel, "1");
            }
            splits.add(result);
            return splits;
        }
        for (int idx = 0; idx < n; ++idx) {
            GeoTimeSerie stopped;
            long timestamp = GTSHelper.tickAtIndex(gts, idx);
            long location = GTSHelper.locationAtIndex(gts, idx);
            long elevation = GTSHelper.elevationAtIndex(gts, idx);
            Object value = GTSHelper.valueAtIndex(gts, idx);
            if (91480763316633925L == refLocation && 91480763316633925L != location) {
                refLocation = location;
                refTimestamp = timestamp;
            }
            long timeStopped = previousTimestampWithLocation - refTimestamp;
            if (proximityZoneRadius < Double.MAX_VALUE && proximityZoneTime < Long.MAX_VALUE && 91480763316633925L != refLocation && 91480763316633925L != location) {
                double currentSpeed = 0.0;
                if (91480763316633925L != previousValidLocation && timestamp != previousTimestampWithLocation) {
                    currentSpeed = GeoXPLib.orthodromicDistance((long)previousValidLocation, (long)location) / ((double)(timestamp - previousTimestampWithLocation) / (double)Constants.TIME_UNITS_PER_S);
                }
                if (GeoXPLib.orthodromicDistance((long)refLocation, (long)location) > proximityZoneRadius || currentSpeed > proximityZoneMaxSpeed) {
                    double zoneMeanSpeed = 0.0;
                    if (previousTimestampWithLocation != refTimestamp) {
                        zoneMeanSpeed = proximityZoneTraveledDistance / ((double)(previousTimestampWithLocation - refTimestamp) / (double)Constants.TIME_UNITS_PER_S);
                    }
                    if (timeStopped > proximityZoneTime && zoneMeanSpeed < proximityInZoneMaxMeanSpeed) {
                        splitReason = SPLIT_TYPE_STOPPED;
                        mustSplit = true;
                        if (null != stoppedTimeLabel && null != split) {
                            split.getMetadata().putToLabels(stoppedTimeLabel, Long.toString(timeStopped));
                        }
                    }
                    refLocation = location;
                    refTimestamp = timestamp;
                    proximityZoneTraveledDistance = 0.0;
                } else if (91480763316633925L != previousValidLocation) {
                    proximityZoneTraveledDistance += GeoXPLib.orthodromicDistance((long)previousValidLocation, (long)location);
                }
            }
            if (!mustSplit) {
                if (91480763316633925L != previousValidLocation && 91480763316633925L != location && GeoXPLib.orthodromicDistance((long)location, (long)previousValidLocation) > distanceThreshold) {
                    splitReason = SPLIT_TYPE_DISTANCE;
                    mustSplit = true;
                } else if (timestamp - previousTimestamp > timeThreshold) {
                    splitReason = "timesplit";
                    mustSplit = true;
                }
            }
            if (mustSplit) {
                long stopTimestamp;
                if (null != splitTypeLabel && null != split) {
                    split.getMetadata().putToLabels(splitTypeLabel, splitReason);
                }
                if (proximityZoneSplit && null != split && SPLIT_TYPE_STOPPED.equals(splitReason) && (stopTimestamp = GTSHelper.lasttick(split) - timeStopped) != GTSHelper.firsttick(split)) {
                    GeoTimeSerie moving = GTSHelper.timeclip(split, Long.MIN_VALUE, stopTimestamp);
                    stopped = GTSHelper.timeclip(split, stopTimestamp + 1L, Long.MAX_VALUE);
                    if (null != splitTypeLabel) {
                        moving.getMetadata().putToLabels(splitTypeLabel, SPLIT_TYPE_MOVING);
                    }
                    if (null != splitNumberLabel) {
                        stopped.getMetadata().putToLabels(splitNumberLabel, Long.toString(gtsid));
                        ++gtsid;
                    }
                    splits.remove(splits.size() - 1);
                    splits.add(moving);
                    splits.add(stopped);
                }
                split = gts.cloneEmpty();
                if (null != splitNumberLabel) {
                    split.getMetadata().putToLabels(splitNumberLabel, Long.toString(gtsid));
                    ++gtsid;
                }
                splits.add(split);
                mustSplit = false;
                refLocation = location;
                refTimestamp = timestamp;
                proximityZoneTraveledDistance = 0.0;
            }
            GTSHelper.setValue(split, timestamp, location, elevation, value, false);
            if (idx == n - 1) {
                if (previousTimestampWithLocation - refTimestamp > proximityZoneTime) {
                    splitReason = SPLIT_TYPE_STOPPED;
                    if (null != stoppedTimeLabel) {
                        split.getMetadata().putToLabels(stoppedTimeLabel, Long.toString(timeStopped));
                    }
                    if (null != splitTypeLabel) {
                        split.getMetadata().putToLabels(splitTypeLabel, splitReason);
                    }
                    if (proximityZoneSplit) {
                        long stopTimestamp = GTSHelper.lasttick(split) - timeStopped;
                        GeoTimeSerie moving = GTSHelper.timeclip(split, Long.MIN_VALUE, stopTimestamp);
                        stopped = GTSHelper.timeclip(split, stopTimestamp + 1L, Long.MAX_VALUE);
                        if (null != splitTypeLabel) {
                            moving.getMetadata().putToLabels(splitTypeLabel, SPLIT_TYPE_MOVING);
                        }
                        if (null != splitNumberLabel) {
                            stopped.getMetadata().putToLabels(splitNumberLabel, Long.toString(gtsid));
                        }
                        splits.remove(splits.size() - 1);
                        splits.add(moving);
                        splits.add(stopped);
                    }
                } else if (null != splitTypeLabel) {
                    if (proximityZoneSplit) {
                        split.getMetadata().putToLabels(splitTypeLabel, SPLIT_TYPE_MOVING);
                    } else {
                        split.getMetadata().putToLabels(splitTypeLabel, SPLIT_TYPE_END);
                    }
                }
            }
            previousTimestamp = timestamp;
            if (91480763316633925L == location) continue;
            previousTimestampWithLocation = timestamp;
            previousValidLocation = location;
        }
        return splits;
    }
}

