/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.gts.MetadataTextComparator;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class METASORT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final Comparator<GeoTimeSerie> META_COMPARATOR = new Comparator<GeoTimeSerie>(){
        private final Comparator<Metadata> INNER_COMP = new MetadataTextComparator(null);

        @Override
        public int compare(GeoTimeSerie o1, GeoTimeSerie o2) {
            return this.INNER_COMP.compare(o1.getMetadata(), o2.getMetadata());
        }
    };

    public METASORT(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        boolean considerAttributes = false;
        if (top instanceof Boolean) {
            considerAttributes = (Boolean)top;
            top = stack.pop();
        }
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of fields to consider for sorting on top of the stack.");
        }
        final ArrayList<String> fields = new ArrayList<String>();
        for (Object o : (List)top) {
            if (null != o && !(o instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a list of fields (strings).");
            }
            if (null == o) {
                fields.add(null);
                continue;
            }
            fields.add(o.toString());
        }
        top = stack.peek();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " operates on a list of Geo Time Series.");
        }
        for (Object o : (List)top) {
            if (o instanceof GeoTimeSerie) continue;
            throw new WarpScriptException(this.getName() + " operates on a list of Geo Time Series.");
        }
        if (fields.isEmpty()) {
            ((List)top).sort(META_COMPARATOR);
        } else {
            final boolean finalConsiderAttributes = considerAttributes;
            ((List)top).sort(new Comparator<GeoTimeSerie>(){
                private final Comparator<Metadata> INNER_COMP;
                {
                    this.INNER_COMP = new MetadataTextComparator(fields, finalConsiderAttributes);
                }

                @Override
                public int compare(GeoTimeSerie o1, GeoTimeSerie o2) {
                    return this.INNER_COMP.compare(o1.getMetadata(), o2.getMetadata());
                }
            });
        }
        return stack;
    }
}

