/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MERGE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public MERGE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        Boolean reversed = null;
        if (top instanceof Boolean) {
            reversed = (Boolean)top;
            top = stack.pop();
        }
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " operates on a LIST containing GTS or ENCODERs.");
        }
        List params = (List)top;
        if (null != reversed) {
            try {
                stack.push(GTSHelper.sortedMerge(params, reversed));
            }
            catch (WarpScriptException wse) {
                throw new WarpScriptException(this.getName() + " encountered an error while merging.", wse);
            }
        }
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        ArrayList<GTSEncoder> encoders = new ArrayList<GTSEncoder>();
        for (int i = 0; i < params.size(); ++i) {
            if (params.get(i) instanceof GeoTimeSerie) {
                series.add((GeoTimeSerie)params.get(i));
                continue;
            }
            if (params.get(i) instanceof GTSEncoder) {
                encoders.add((GTSEncoder)params.get(i));
                continue;
            }
            if (!(params.get(i) instanceof List)) continue;
            for (Object o : (List)params.get(i)) {
                if (o instanceof GeoTimeSerie) {
                    series.add((GeoTimeSerie)o);
                    continue;
                }
                if (o instanceof GTSEncoder) {
                    encoders.add((GTSEncoder)o);
                    continue;
                }
                throw new WarpScriptException(this.getName() + " expects a list of Geo Time Series or encoders as first parameter.");
            }
        }
        if (!encoders.isEmpty() && !series.isEmpty()) {
            throw new WarpScriptException(this.getName() + " can only operate on homogeneous lists of Geo Time Series or encoders.");
        }
        try {
            if (encoders.isEmpty()) {
                GeoTimeSerie merged = GTSHelper.mergeViaEncoders(series);
                stack.push(merged);
            } else {
                GTSEncoder encoder = new GTSEncoder(0L);
                encoder.setMetadata(((GTSEncoder)encoders.get(0)).getMetadata());
                for (GTSEncoder enc : encoders) {
                    encoder.merge(enc);
                }
                stack.push(encoder);
            }
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " failed.", ioe);
        }
        return stack;
    }
}

