/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class LR
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public LR(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        BigDecimal zero;
        Object o = stack.pop();
        if (!(o instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " expects a Geo Time Series instance on top of the stack.");
        }
        GeoTimeSerie gts = (GeoTimeSerie)o;
        int n = GTSHelper.nvalues(gts);
        if (GeoTimeSerie.TYPE.DOUBLE != gts.getType() && GeoTimeSerie.TYPE.LONG != gts.getType()) {
            throw new WarpScriptException(this.getName() + " can only compute simple linear regression parameters for numerical series.");
        }
        BigDecimal sumx = zero = new BigDecimal(0.0, MathContext.UNLIMITED).setScale(16);
        BigDecimal sumy = zero;
        BigDecimal sumxx = zero;
        BigDecimal sumxy = zero;
        for (int i = 0; i < n; ++i) {
            BigDecimal bd = GeoTimeSerie.TYPE.DOUBLE == gts.getType() ? BigDecimal.valueOf(((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue()) : BigDecimal.valueOf(((Number)GTSHelper.valueAtIndex(gts, i)).longValue());
            BigDecimal tick = BigDecimal.valueOf(GTSHelper.tickAtIndex(gts, i));
            sumx = sumx.add(tick);
            sumy = sumy.add(bd);
            sumxx = sumxx.add(tick.multiply(tick));
            sumxy = sumxy.add(bd.multiply(tick));
        }
        BigDecimal N = BigDecimal.valueOf((double)GTSHelper.nvalues(gts));
        BigDecimal xybar = sumxy.divide(N, RoundingMode.HALF_UP);
        BigDecimal xbar = sumx.divide(N, RoundingMode.HALF_UP);
        BigDecimal ybar = sumy.divide(N, RoundingMode.HALF_UP);
        BigDecimal xxbar = sumxx.divide(N, RoundingMode.HALF_UP);
        BigDecimal betaHat = xybar.subtract(xbar.multiply(ybar)).divide(xxbar.subtract(xbar.multiply(xbar)), RoundingMode.HALF_UP);
        BigDecimal alphaHat = ybar.subtract(betaHat.multiply(xbar));
        stack.push(alphaHat.doubleValue());
        stack.push(betaHat.doubleValue());
        return stack;
    }
}

