/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public class INFLATE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public INFLATE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a byte array.");
        }
        byte[] data = (byte[])o;
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        ByteArrayOutputStream decompressed = new ByteArrayOutputStream(data.length);
        byte[] buf = new byte[1024];
        try {
            int len;
            InflaterInputStream in = new InflaterInputStream(bin);
            while ((len = in.read(buf)) >= 0) {
                decompressed.write(buf, 0, len);
            }
            in.close();
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " encountered an error while decompressing.", ioe);
        }
        stack.push(decompressed.toByteArray());
        return stack;
    }
}

