/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class HAVERSINE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final double EARTH_RADIUS = 6371000.0;

    public HAVERSINE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object lon2 = stack.pop();
        Object lat2 = stack.pop();
        Object lon1 = stack.pop();
        Object lat1 = stack.pop();
        if (!(lat1 instanceof Number && lat2 instanceof Number && lon1 instanceof Number && lon2 instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects two sets of lat/lon coordinates.");
        }
        double rlat1 = Math.toRadians(((Number)lat1).doubleValue());
        double rlon1 = Math.toRadians(((Number)lon1).doubleValue());
        double rlat2 = Math.toRadians(((Number)lat2).doubleValue());
        double rlon2 = Math.toRadians(((Number)lon2).doubleValue());
        double sinphi2 = Math.sin((rlat2 - rlat1) / 2.0);
        sinphi2 *= sinphi2;
        double sinlambda2 = Math.sin((rlon2 - rlon1) / 2.0);
        sinlambda2 *= sinlambda2;
        double d = 1.2742E7 * Math.asin(Math.sqrt(sinphi2 + Math.cos(rlat1) * Math.cos(rlat2) * sinlambda2));
        stack.push(d);
        return stack;
    }
}

