/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;

public class GZIP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GZIP(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof byte[]) && !(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " operates on a byte array or a String.");
        }
        if (o instanceof String) {
            o = o.toString().getBytes(StandardCharsets.UTF_8);
        }
        byte[] data = (byte[])o;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream out = new GZIPOutputStream(baos);
            out.write(data);
            out.close();
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " encountered an error while compressing.", ioe);
        }
        stack.push(baos.toByteArray());
        return stack;
    }
}

