/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLoopBreakException;
import io.warp10.script.WarpScriptLoopContinueException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class FOR
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final long maxtime;

    public FOR(String name) {
        super(name);
        this.maxtime = -1L;
    }

    public FOR(String name, long maxtime) {
        super(name);
        this.maxtime = maxtime;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long maxtime;
        Object top = stack.pop();
        boolean pushCounter = true;
        if (top instanceof Boolean) {
            pushCounter = (Boolean)top;
            top = stack.pop();
        }
        Object macro = top;
        Object to = stack.pop();
        Object from = stack.pop();
        if (!(macro instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects a macro on top of the stack.");
        }
        if (!(to instanceof Number) || !(from instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects numbers as its range.");
        }
        double dfrom = 0.0;
        double dto = 0.0;
        double dcounter = 0.0;
        long lfrom = 0L;
        long lto = 0L;
        long lcounter = 0L;
        boolean useDouble = false;
        if (from instanceof Double || to instanceof Double) {
            dfrom = ((Number)from).doubleValue();
            dto = ((Number)to).doubleValue();
            dcounter = dfrom;
            useDouble = true;
        } else {
            lfrom = ((Number)from).longValue();
            lto = ((Number)to).longValue();
            lcounter = lfrom;
        }
        long now = System.currentTimeMillis();
        long l = maxtime = this.maxtime > 0L ? this.maxtime : (Long)stack.getAttribute("loop.maxduration");
        while (true) {
            if (maxtime > 0L && System.currentTimeMillis() - now > maxtime) {
                throw new WarpScriptException(this.getName() + " executed for too long (> " + maxtime + " ms). Consider raising the limit or using capabilities.");
            }
            if (!useDouble ? lcounter > lto : dcounter > dto) break;
            if (pushCounter) {
                if (useDouble) {
                    stack.push(dcounter);
                } else {
                    stack.push(lcounter);
                }
            }
            try {
                stack.exec((WarpScriptStack.Macro)macro);
            }
            catch (WarpScriptLoopBreakException elbe) {
                break;
            }
            catch (WarpScriptLoopContinueException warpScriptLoopContinueException) {
                // empty catch block
            }
            if (useDouble) {
                dcounter += 1.0;
                continue;
            }
            ++lcounter;
        }
        return stack;
    }
}

