/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.fwt.FWT;
import io.warp10.script.fwt.Wavelet;
import io.warp10.script.fwt.wavelets.WaveletRegistry;
import java.util.HashMap;
import java.util.Map;

public class FDWT
extends GTSStackFunction {
    private static final String WAVELET = "wavelet";

    public FDWT(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a wavelet name on top of the stack.");
        }
        Wavelet wavelet = WaveletRegistry.find(top.toString());
        if (null == wavelet) {
            throw new WarpScriptException(this.getName() + " could not find wavelet '" + top.toString() + "'.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(WAVELET, wavelet);
        return params;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        Wavelet wavelet = (Wavelet)params.get(WAVELET);
        if (GeoTimeSerie.TYPE.DOUBLE != gts.getType() && GeoTimeSerie.TYPE.LONG != gts.getType()) {
            throw new WarpScriptException(this.getName() + " can only be applied to numeric Geo Time Series.");
        }
        int len = gts.size();
        if (0 != (len & len - 1)) {
            throw new WarpScriptException(this.getName() + " can only operate on Geo Time Series whose length is a power of 2.");
        }
        GTSHelper.sort(gts);
        double[] values = GTSHelper.getValuesAsDouble(gts);
        double[] hilbert = FWT.forward(wavelet, values);
        GeoTimeSerie transformed = gts.cloneEmpty();
        for (int i = 0; i < len; ++i) {
            GTSHelper.setValue(transformed, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), hilbert[i], false);
        }
        return transformed;
    }
}

