/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.ECGEN;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.math.ec.ECCurve;

public class ECVERIFY
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public ECVERIFY(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof ECPublicKey)) {
            throw new WarpScriptException(this.getName() + " expects an ECC public key.");
        }
        final byte[] encoded = ((ECPublicKey)top).getQ().getEncoded(false);
        org.bouncycastle.math.ec.ECPoint q = ((ECPublicKey)top).getQ();
        final ECPoint w = new ECPoint(q.getXCoord().toBigInteger(), q.getYCoord().toBigInteger());
        org.bouncycastle.jce.spec.ECParameterSpec curve = ((ECPublicKey)top).getParameters();
        EllipticCurve ec = EC5Util.convertCurve((ECCurve)curve.getCurve(), (byte[])curve.getSeed());
        final ECParameterSpec spec = new ECParameterSpec(ec, new ECPoint(curve.getG().getXCoord().toBigInteger(), curve.getG().getYCoord().toBigInteger()), curve.getN(), curve.getH().intValue());
        java.security.interfaces.ECPublicKey key = new java.security.interfaces.ECPublicKey(){

            @Override
            public String getFormat() {
                return "PKCS#8";
            }

            @Override
            public byte[] getEncoded() {
                return encoded;
            }

            @Override
            public String getAlgorithm() {
                return "EC";
            }

            @Override
            public ECPoint getW() {
                return w;
            }

            @Override
            public ECParameterSpec getParams() {
                return spec;
            }
        };
        top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects an algorithm name.");
        }
        String alg = top.toString();
        top = stack.pop();
        if (!(top instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " expects a signature.");
        }
        byte[] sig = (byte[])top;
        top = stack.pop();
        if (!(top instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a byte array.");
        }
        byte[] data = (byte[])top;
        try {
            Signature signature = Signature.getInstance(alg, (Provider)ECGEN.BCProvider);
            signature.initVerify(key);
            signature.update(data);
            stack.push(signature.verify(sig));
        }
        catch (SignatureException se) {
            throw new WarpScriptException(this.getName() + " error while verifying signature.", se);
        }
        catch (InvalidKeyException ike) {
            throw new WarpScriptException(this.getName() + " error while verifying signature.", ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new WarpScriptException(this.getName() + " error while verifying signature.", nsae);
        }
        return stack;
    }
}

