/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.ECGEN;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class ECPRIVATE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public ECPRIVATE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (top instanceof ECPrivateKey) {
            ECPrivateKey priv = (ECPrivateKey)top;
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            ECNamedCurveParameterSpec curve = (ECNamedCurveParameterSpec)priv.getParameters();
            params.put("curve", curve.getName());
            params.put("d", priv.getD().toString());
            stack.push(params);
            return stack;
        }
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a parameter map or an ECC private key instance.");
        }
        Map params = (Map)top;
        String name = String.valueOf(params.get("curve"));
        final ECNamedCurveParameterSpec curve = ECNamedCurveTable.getParameterSpec((String)name);
        if (null == curve) {
            throw new WarpScriptException(this.getName() + " curve name not in " + ECGEN.getCurves() + ".");
        }
        if (!(params.get("d") instanceof String)) {
            throw new WarpScriptException(this.getName() + " missing or non-String parameter '" + "d" + "'.");
        }
        String dstr = (String)params.get("d");
        final BigInteger d = dstr.startsWith("0x") || dstr.startsWith("0X") ? new BigInteger(dstr.substring(2), 16) : new BigInteger(dstr);
        ECPrivateKey privateKey = new ECPrivateKey(){

            public String getFormat() {
                return "PKCS#8";
            }

            public byte[] getEncoded() {
                return null;
            }

            public String getAlgorithm() {
                return "EC";
            }

            public ECParameterSpec getParameters() {
                return curve;
            }

            public BigInteger getD() {
                return d;
            }
        };
        stack.push(privateKey);
        return stack;
    }
}

