/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.CHRONOSTATS;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class CHRONOEND
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public CHRONOEND(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        AtomicLong[] alias_stats;
        long endNanos = System.nanoTime();
        Object o1 = stack.pop();
        if (!(o1 instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a STRING alias.");
        }
        String alias = (String)o1;
        String keyStart = CHRONOSTATS.getStartKey(alias, stack);
        String keyActiveCount = CHRONOSTATS.getActiveCountKey(alias, stack);
        String keyTotalCount = CHRONOSTATS.getTotalCountKey(alias, stack);
        AtomicLong activeCount = (AtomicLong)stack.getAttribute(keyActiveCount);
        if (null == activeCount) {
            throw new WarpScriptException(this.getName() + " called before " + "CHRONOSTART" + " for " + alias + ".");
        }
        activeCount.decrementAndGet();
        if (activeCount.intValue() > 0) {
            return stack;
        }
        if (activeCount.intValue() < 0) {
            throw new WarpScriptException(this.getName() + " called more times than " + "CHRONOSTART" + " for " + alias + ".");
        }
        AtomicLong startNanos = (AtomicLong)stack.getAttribute(keyStart);
        AtomicLong totalCount = (AtomicLong)stack.getAttribute(keyTotalCount);
        ConcurrentHashMap<String, AtomicLong[]> stats = (ConcurrentHashMap<String, AtomicLong[]>)stack.getAttribute("chronostats");
        if (null == stats) {
            stats = new ConcurrentHashMap<String, AtomicLong[]>();
            stack.setAttribute("chronostats", stats);
        }
        if (null == (alias_stats = (AtomicLong[])stats.get(alias))) {
            alias_stats = new AtomicLong[]{new AtomicLong(), new AtomicLong()};
            stats.put(alias, alias_stats);
        }
        alias_stats[0].addAndGet(endNanos - startNanos.longValue());
        alias_stats[1].addAndGet(totalCount.longValue());
        totalCount.set(0L);
        return stack;
    }
}

