/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.ThriftUtils;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ASENCODERS
extends ElementOrListStackFunction {
    private final ElementOrListStackFunction.ElementStackFunction gtstoFunction = new ElementOrListStackFunction.ElementStackFunction(){

        @Override
        public Object applyOnElement(Object element) throws WarpScriptException {
            if (element instanceof String) {
                element = OrderPreservingBase64.decode(element.toString().getBytes(StandardCharsets.US_ASCII));
            }
            if (element instanceof byte[]) {
                TDeserializer deser = ThriftUtils.getTDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
                try {
                    GTSWrapper wrapper = new GTSWrapper();
                    deser.deserialize((TBase)wrapper, (byte[])element);
                    return GTSWrapperHelper.fromGTSWrapperToGTSEncoder(wrapper);
                }
                catch (TException te) {
                    throw new WarpScriptException(ASENCODERS.this.getName() + " failed to unwrap encoder.", te);
                }
                catch (IOException ioe) {
                    throw new WarpScriptException(ASENCODERS.this.getName() + " failed to convert wrapper to encoder.", ioe);
                }
            }
            if (element instanceof GeoTimeSerie) {
                try {
                    GeoTimeSerie gts = (GeoTimeSerie)element;
                    GTSEncoder encoder = new GTSEncoder();
                    encoder.encodeOptimized(gts);
                    encoder.setMetadata(gts.getMetadata());
                    return encoder;
                }
                catch (IOException ioe) {
                    throw new WarpScriptException(ASENCODERS.this.getName() + " cannot convert Encoder to Geo Time Series.", ioe);
                }
            }
            if (element instanceof GTSEncoder) {
                return element;
            }
            throw new WarpScriptException(ASENCODERS.this.getName() + " expects a Geo Time Series or a list thereof on top on the stack.");
        }
    };

    public ASENCODERS(String name) {
        super(name);
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        return this.gtstoFunction;
    }
}

