/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.ThriftUtils;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.MACROMAPPER;
import java.io.IOException;
import java.util.List;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ADDVALUE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean overwrite;

    public ADDVALUE(String name, boolean overwrite) {
        super(name);
        this.overwrite = overwrite;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        TSerializer ser;
        Object value = null;
        long elevation = Long.MIN_VALUE;
        long location = 91480763316633925L;
        long timestamp = 0L;
        Object o = stack.pop();
        if (o instanceof List) {
            Object[] array = MACROMAPPER.listToObjects((List)o);
            timestamp = (Long)array[0];
            location = (Long)array[1];
            elevation = (Long)array[2];
            value = array[3];
        } else {
            double latitude;
            if (!(o instanceof Number || o instanceof String || o instanceof Boolean || o instanceof byte[] || o instanceof GeoTimeSerie || o instanceof GTSEncoder)) {
                throw new WarpScriptException(this.getName() + " expects a LONG, DOUBLE, STRING, byte array or BOOLEAN value or a Geo Time Series or ENCODER.");
            }
            value = o;
            o = stack.pop();
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " expects the elevation to be numeric or NaN.");
            }
            if (!(o instanceof Double) || !Double.isNaN((Double)o)) {
                elevation = ((Number)o).longValue();
            }
            if (!((o = stack.pop()) instanceof Number)) {
                throw new WarpScriptException(this.getName() + " expects the longitude to be numeric or NaN.");
            }
            double longitude = o instanceof Double ? ((Double)o).doubleValue() : ((Number)o).doubleValue();
            o = stack.pop();
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " expects the latitude to be numeric or NaN.");
            }
            double d = latitude = o instanceof Double ? ((Double)o).doubleValue() : ((Number)o).doubleValue();
            if (!Double.isNaN(latitude) && !Double.isNaN(longitude)) {
                location = GeoXPLib.toGeoXPPoint((double)latitude, (double)longitude);
            }
            if (!((o = stack.pop()) instanceof Number)) {
                throw new WarpScriptException(this.getName() + " expects the tick to be numeric.");
            }
            timestamp = ((Number)o).longValue();
        }
        o = stack.pop();
        if (!(o instanceof GeoTimeSerie) && !(o instanceof GTSEncoder)) {
            throw new WarpScriptException(this.getName() + " operates on a single Geo Time Series or GTS Encoder.");
        }
        if (value instanceof GeoTimeSerie) {
            ser = ThriftUtils.getTSerializer((TProtocolFactory)new TCompactProtocol.Factory());
            try {
                value = ser.serialize((TBase)GTSWrapperHelper.fromGTSToGTSWrapper((GeoTimeSerie)value, true, 100.0, Integer.MAX_VALUE, false, false));
            }
            catch (TException te) {
                throw new WarpScriptException(this.getName() + " encountered an error while serializing the Geo Time Series.", te);
            }
        }
        if (value instanceof GTSEncoder) {
            ser = ThriftUtils.getTSerializer((TProtocolFactory)new TCompactProtocol.Factory());
            try {
                value = ser.serialize((TBase)GTSWrapperHelper.fromGTSEncoderToGTSWrapper((GTSEncoder)value, true, 100.0, Integer.MAX_VALUE, false));
            }
            catch (TException te) {
                throw new WarpScriptException(this.getName() + " encountered an error while serializing the GTS Encoder.", te);
            }
        }
        if (o instanceof GeoTimeSerie) {
            GeoTimeSerie gts = (GeoTimeSerie)o;
            GTSHelper.setValue(gts, timestamp, location, elevation, value, this.overwrite);
            stack.push(gts);
        } else {
            GTSEncoder encoder = (GTSEncoder)o;
            try {
                encoder.addValue(timestamp, location, elevation, value);
            }
            catch (IOException ioe) {
                throw new WarpScriptException(this.getName() + " error adding datapoint to encoder.", ioe);
            }
            stack.push(encoder);
        }
        return stack;
    }
}

