/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.fastdtw;

import io.warp10.script.fastdtw.CostMatrix;
import io.warp10.script.fastdtw.SearchWindow;

class PartialWindowMatrix
implements CostMatrix {
    private static final double OUT_OF_WINDOW_VALUE = Double.POSITIVE_INFINITY;
    private double[] lastCol;
    private double[] currCol;
    private int currColIndex;
    private int minLastRow;
    private int minCurrRow;
    private final SearchWindow window;

    PartialWindowMatrix(SearchWindow searchWindow) {
        this.window = searchWindow;
        if (this.window.maxI() > 0) {
            this.currCol = new double[this.window.maxJforI(1) - this.window.minJforI(1) + 1];
            this.currColIndex = 1;
            this.minLastRow = this.window.minJforI(this.currColIndex - 1);
        } else {
            this.currColIndex = 0;
        }
        this.minCurrRow = this.window.minJforI(this.currColIndex);
        this.lastCol = new double[this.window.maxJforI(0) - this.window.minJforI(0) + 1];
    }

    @Override
    public void put(int col, int row, double value) {
        if (row < this.window.minJforI(col) || row > this.window.maxJforI(col)) {
            throw new RuntimeException("CostMatrix is filled in a cell (col=" + col + ", row=" + row + ") that is not in the search window");
        }
        if (col == this.currColIndex) {
            this.currCol[row - this.minCurrRow] = value;
        } else if (col == this.currColIndex - 1) {
            this.lastCol[row - this.minLastRow] = value;
        } else if (col == this.currColIndex + 1) {
            this.lastCol = this.currCol;
            this.minLastRow = this.minCurrRow;
            ++this.currColIndex;
            this.currCol = new double[this.window.maxJforI(col) - this.window.minJforI(col) + 1];
            this.minCurrRow = this.window.minJforI(col);
            this.currCol[row - this.minCurrRow] = value;
        } else {
            throw new RuntimeException("A PartialWindowMatrix can only fill in 2 adjacentcolumns at a time");
        }
    }

    @Override
    public double get(int col, int row) {
        if (row < this.window.minJforI(col) || row > this.window.maxJforI(col)) {
            return Double.POSITIVE_INFINITY;
        }
        if (col == this.currColIndex) {
            return this.currCol[row - this.minCurrRow];
        }
        if (col == this.currColIndex - 1) {
            return this.lastCol[row - this.minLastRow];
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public int size() {
        return this.lastCol.length + this.currCol.length;
    }

    public int windowSize() {
        return this.window.size();
    }
}

