/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.fastdtw;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.fastdtw.ColMajorCell;
import io.warp10.script.fastdtw.DistanceFunction;
import io.warp10.script.fastdtw.PartialWindowMatrix;
import io.warp10.script.fastdtw.SearchWindow;
import io.warp10.script.fastdtw.TimeWarpInfo;
import io.warp10.script.fastdtw.WarpPath;
import io.warp10.script.fastdtw.WindowMatrix;
import java.util.Iterator;

public class DTW {
    public static double calcWarpCost(WarpPath path, GeoTimeSerie tsI, GeoTimeSerie tsJ, DistanceFunction distFn) {
        double totalCost = 0.0;
        for (int p = 0; p < path.size(); ++p) {
            ColMajorCell currWarp = path.get(p);
            totalCost += distFn.calcDistance(tsI, currWarp.getCol(), tsJ, currWarp.getRow());
        }
        return totalCost;
    }

    public static double getWarpDistBetween(GeoTimeSerie tsI, GeoTimeSerie tsJ, DistanceFunction distFn) {
        if (tsI.size() < tsJ.size()) {
            return DTW.getWarpDistBetween(tsJ, tsI, distFn);
        }
        double[] lastCol = new double[tsJ.size()];
        double[] currCol = new double[tsJ.size()];
        int maxI = tsI.size() - 1;
        int maxJ = tsJ.size() - 1;
        currCol[0] = distFn.calcDistance(tsI, 0, tsJ, 0);
        for (int j = 1; j <= maxJ; ++j) {
            currCol[j] = currCol[j - 1] + distFn.calcDistance(tsI, 0, tsJ, j);
        }
        for (int i = 1; i <= maxI; ++i) {
            double[] temp = lastCol;
            lastCol = currCol;
            currCol = temp;
            currCol[0] = lastCol[0] + distFn.calcDistance(tsI, i, tsJ, 0);
            for (int j = 1; j <= maxJ; ++j) {
                double minGlobalCost = Math.min(lastCol[j], Math.min(lastCol[j - 1], currCol[j - 1]));
                currCol[j] = minGlobalCost + distFn.calcDistance(tsI, i, tsJ, j);
            }
        }
        return currCol[maxJ];
    }

    public static WarpPath getWarpPathBetween(GeoTimeSerie tsI, GeoTimeSerie tsJ, DistanceFunction distFn) {
        return DTW.DynamicTimeWarp(tsI, tsJ, distFn).getPath();
    }

    public static TimeWarpInfo getWarpInfoBetween(GeoTimeSerie tsI, GeoTimeSerie tsJ, DistanceFunction distFn) {
        return DTW.DynamicTimeWarp(tsI, tsJ, distFn);
    }

    private static TimeWarpInfo DynamicTimeWarp(GeoTimeSerie tsI, GeoTimeSerie tsJ, DistanceFunction distFn) {
        double[][] costMatrix = new double[tsI.size()][tsJ.size()];
        int maxI = tsI.size() - 1;
        int maxJ = tsJ.size() - 1;
        costMatrix[0][0] = distFn.calcDistance(tsI, 0, tsJ, 0);
        for (int j = 1; j <= maxJ; ++j) {
            costMatrix[0][j] = costMatrix[0][j - 1] + distFn.calcDistance(tsI, 0, tsJ, j);
        }
        for (int i = 1; i <= maxI; ++i) {
            costMatrix[i][0] = costMatrix[i - 1][0] + distFn.calcDistance(tsI, i, tsJ, 0);
            for (int j = 1; j <= maxJ; ++j) {
                double minGlobalCost = Math.min(costMatrix[i - 1][j], Math.min(costMatrix[i - 1][j - 1], costMatrix[i][j - 1]));
                costMatrix[i][j] = minGlobalCost + distFn.calcDistance(tsI, i, tsJ, j);
            }
        }
        double minimumCost = costMatrix[maxI][maxJ];
        WarpPath minCostPath = new WarpPath(maxI + maxJ - 1);
        int i = maxI;
        int j = maxJ;
        minCostPath.addFirst(i, j);
        while (i > 0 || j > 0) {
            double diagCost = i > 0 && j > 0 ? costMatrix[i - 1][j - 1] : Double.POSITIVE_INFINITY;
            double leftCost = i > 0 ? costMatrix[i - 1][j] : Double.POSITIVE_INFINITY;
            double downCost = j > 0 ? costMatrix[i][j - 1] : Double.POSITIVE_INFINITY;
            if (diagCost <= leftCost && diagCost <= downCost) {
                --i;
                --j;
            } else if (leftCost < diagCost && leftCost < downCost) {
                --i;
            } else if (downCost < diagCost && downCost < leftCost) {
                --j;
            } else if (i <= j) {
                --j;
            } else {
                --i;
            }
            minCostPath.addFirst(i, j);
        }
        return new TimeWarpInfo(minimumCost, minCostPath);
    }

    public static double getWarpDistBetween(GeoTimeSerie tsI, GeoTimeSerie tsJ, SearchWindow window, DistanceFunction distFn) {
        PartialWindowMatrix costMatrix = new PartialWindowMatrix(window);
        int maxI = tsI.size() - 1;
        int maxJ = tsJ.size() - 1;
        Iterator matrixIterator = window.iterator();
        while (matrixIterator.hasNext()) {
            ColMajorCell currentCell = (ColMajorCell)matrixIterator.next();
            int i = currentCell.getCol();
            int j = currentCell.getRow();
            if (i == 0 && j == 0) {
                costMatrix.put(i, j, distFn.calcDistance(tsI, 0, tsJ, 0));
                continue;
            }
            if (i == 0) {
                costMatrix.put(i, j, distFn.calcDistance(tsI, 0, tsJ, j) + costMatrix.get(i, j - 1));
                continue;
            }
            if (j == 0) {
                costMatrix.put(i, j, distFn.calcDistance(tsI, i, tsJ, 0) + costMatrix.get(i - 1, j));
                continue;
            }
            double minGlobalCost = Math.min(costMatrix.get(i - 1, j), Math.min(costMatrix.get(i - 1, j - 1), costMatrix.get(i, j - 1)));
            costMatrix.put(i, j, minGlobalCost + distFn.calcDistance(tsI, i, tsJ, j));
        }
        return costMatrix.get(maxI, maxJ);
    }

    public static WarpPath getWarpPathBetween(GeoTimeSerie tsI, GeoTimeSerie tsJ, SearchWindow window, DistanceFunction distFn) {
        return DTW.constrainedTimeWarp(tsI, tsJ, window, distFn).getPath();
    }

    public static TimeWarpInfo getWarpInfoBetween(GeoTimeSerie tsI, GeoTimeSerie tsJ, SearchWindow window, DistanceFunction distFn) {
        return DTW.constrainedTimeWarp(tsI, tsJ, window, distFn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimeWarpInfo constrainedTimeWarp(GeoTimeSerie tsI, GeoTimeSerie tsJ, SearchWindow window, DistanceFunction distFn) {
        WindowMatrix costMatrix = new WindowMatrix(window);
        try {
            int maxI = tsI.size() - 1;
            int maxJ = tsJ.size() - 1;
            Iterator matrixIterator = window.iterator();
            while (matrixIterator.hasNext()) {
                ColMajorCell currentCell = (ColMajorCell)matrixIterator.next();
                int i = currentCell.getCol();
                int j = currentCell.getRow();
                if (i == 0 && j == 0) {
                    costMatrix.put(i, j, distFn.calcDistance(tsI, 0, tsJ, 0));
                    continue;
                }
                if (i == 0) {
                    costMatrix.put(i, j, distFn.calcDistance(tsI, 0, tsJ, j) + costMatrix.get(i, j - 1));
                    continue;
                }
                if (j == 0) {
                    costMatrix.put(i, j, distFn.calcDistance(tsI, i, tsJ, 0) + costMatrix.get(i - 1, j));
                    continue;
                }
                double minGlobalCost = Math.min(costMatrix.get(i - 1, j), Math.min(costMatrix.get(i - 1, j - 1), costMatrix.get(i, j - 1)));
                costMatrix.put(i, j, minGlobalCost + distFn.calcDistance(tsI, i, tsJ, j));
            }
            double minimumCost = costMatrix.get(maxI, maxJ);
            WarpPath minCostPath = new WarpPath(maxI + maxJ - 1);
            int i = maxI;
            int j = maxJ;
            minCostPath.addFirst(i, j);
            while (i > 0 || j > 0) {
                double diagCost = i > 0 && j > 0 ? costMatrix.get(i - 1, j - 1) : Double.POSITIVE_INFINITY;
                double leftCost = i > 0 ? costMatrix.get(i - 1, j) : Double.POSITIVE_INFINITY;
                double downCost = j > 0 ? costMatrix.get(i, j - 1) : Double.POSITIVE_INFINITY;
                if (diagCost <= leftCost && diagCost <= downCost) {
                    --i;
                    --j;
                } else if (leftCost < diagCost && leftCost < downCost) {
                    --i;
                } else if (downCost < diagCost && downCost < leftCost) {
                    --j;
                } else if (i <= j) {
                    --j;
                } else {
                    --i;
                }
                minCostPath.addFirst(i, j);
            }
            TimeWarpInfo timeWarpInfo = new TimeWarpInfo(minimumCost, minCostPath);
            return timeWarpInfo;
        }
        finally {
            costMatrix.freeMem();
        }
    }
}

