/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.warprun;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class STDIN
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final Iterator<String> stdin = new InputStreamIterator(System.in);

    public STDIN(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        stack.push(stdin);
        return stack;
    }

    static final class InputStreamIterator
    implements Iterator<String> {
        private final BufferedReader br;
        private String line = null;
        private boolean done = false;

        public InputStreamIterator(InputStream in) {
            this.br = new BufferedReader(new InputStreamReader(in));
        }

        @Override
        public boolean hasNext() {
            if (this.done) {
                return false;
            }
            if (null == this.line) {
                try {
                    this.line = this.br.readLine();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            this.done = null == this.line;
            return !this.done;
        }

        @Override
        public String next() {
            if (null == this.line) {
                throw new IllegalStateException();
            }
            String result = this.line;
            this.line = null;
            return result;
        }
    }
}

