/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.shm;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.ext.shm.SharedMemoryWarpScriptExtension;
import io.warp10.warp.sdk.Capabilities;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public class MUTEX
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    static final String MUTEX_ATTRIBUTE = "ext.shm.mutex";

    public MUTEX(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top;
        String cap = Capabilities.get(stack, "mutex");
        if (null == cap) {
            throw new WarpScriptException(this.getName() + " expected capability '" + "mutex" + "' to be set to regular expression.");
        }
        long maxwait = SharedMemoryWarpScriptExtension.MUTEX_DEFAULT_MAXWAIT;
        if (null != Capabilities.get(stack, "mutex.maxwait")) {
            try {
                maxwait = Long.parseLong(Capabilities.get(stack, "mutex.maxwait"));
                if (maxwait < 0L) {
                    throw new NumberFormatException("expected value >= 0");
                }
            }
            catch (NumberFormatException nfe) {
                throw new WarpScriptException(this.getName() + " invalid '" + "mutex.maxwait" + "' capability value, expected a value >= 0.");
            }
        }
        if ((top = stack.pop()) instanceof Long) {
            long wait = (Long)top / Constants.TIME_UNITS_PER_MS;
            if (wait < 0L) {
                throw new WarpScriptException(this.getName() + " invalid timeout, MUST be >= 0.");
            }
            if (0L == maxwait) {
                maxwait = wait;
            } else if (wait <= maxwait && wait > 0L) {
                maxwait = wait;
            } else {
                throw new WarpScriptException(this.getName() + " invalid timeout, may not exceed " + maxwait + " ms.");
            }
            top = stack.pop();
        }
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects the mutex name.");
        }
        String mutex = String.valueOf(top);
        if (null != stack.getAttribute(MUTEX_ATTRIBUTE + stack.getUUID()) && !mutex.equals(stack.getAttribute(MUTEX_ATTRIBUTE + stack.getUUID()))) {
            throw new WarpScriptException(this.getName() + " calls can only be nested with the same mutex.");
        }
        top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " expects the macro to run below the mutex name.");
        }
        WarpScriptStack.Macro macro = (WarpScriptStack.Macro)top;
        if (!"".equals(cap) && !Pattern.matches(cap, mutex)) {
            throw new WarpScriptException(this.getName() + " capability does not grant access to mutex '" + mutex + "'.");
        }
        ReentrantLock lock = SharedMemoryWarpScriptExtension.getLock(mutex);
        boolean locked = false;
        boolean clearAttr = null == stack.getAttribute(MUTEX_ATTRIBUTE + stack.getUUID());
        try {
            if (0L == maxwait) {
                lock.lockInterruptibly();
                locked = true;
            } else {
                locked = lock.tryLock(maxwait, TimeUnit.MILLISECONDS);
                if (!locked) {
                    throw new WarpScriptException(this.getName() + " failed to acquire mutex within " + maxwait + " ms.");
                }
            }
            stack.setAttribute(MUTEX_ATTRIBUTE + stack.getUUID(), mutex);
            stack.exec(macro);
        }
        catch (WarpScriptException wse) {
            throw wse;
        }
        catch (Throwable t) {
            throw new WarpScriptException("Error while running mutex macro.", t);
        }
        finally {
            if (lock.isHeldByCurrentThread() && locked) {
                lock.unlock();
            }
            if (clearAttr) {
                stack.setAttribute(MUTEX_ATTRIBUTE + stack.getUUID(), null);
            }
        }
        return stack;
    }
}

