/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;

public class VarianceWelford
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptReducerFunction,
WarpScriptBucketizerFunction {
    private final boolean useBessel;
    private final boolean forbidNulls;

    public VarianceWelford(String name, boolean useBessel, boolean forbidNulls) {
        super(name);
        this.useBessel = useBessel;
        this.forbidNulls = forbidNulls;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == ticks.length) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        double m = 0.0;
        double s = 0.0;
        long location = 91480763316633925L;
        long elevation = Long.MIN_VALUE;
        long timestamp = Long.MIN_VALUE;
        int nticks = 0;
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (null == value) {
                if (!this.forbidNulls) continue;
                return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
            }
            ++nticks;
            if (ticks[i] > timestamp) {
                location = locations[i];
                elevation = elevations[i];
                timestamp = ticks[i];
            }
            if (value instanceof Number) {
                double x = ((Number)value).doubleValue();
                if (0 == i) {
                    m = x;
                    s = 0.0;
                    continue;
                }
                double mnew = m + (x - m) / (double)(i + 1);
                s += (x - m) * (x - mnew);
                m = mnew;
                continue;
            }
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        double variance = nticks > 1 && this.useBessel ? s / (double)(nticks - 1) : s / (double)nticks;
        return new Object[]{0L, location, elevation, variance};
    }

    @Override
    public String toString() {
        return Boolean.toString(this.useBessel) + " " + this.getName();
    }
}

