/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import com.geoxp.GeoXPLib;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;
import io.warp10.script.binary.EQ;
import java.util.Arrays;
import java.util.Comparator;

public class Median
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptBucketizerFunction,
WarpScriptReducerFunction {
    private final boolean forbidNulls;

    public Median(String name, boolean forbidNulls) {
        super(name);
        this.forbidNulls = forbidNulls;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        double median;
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        final Object[] values = (Object[])args[6];
        int nullCounter = 0;
        for (Object v : values) {
            if (null != v) continue;
            ++nullCounter;
        }
        if (0 != nullCounter && this.forbidNulls) {
            throw new WarpScriptException(this.getName() + " cannot compute median of null values.");
        }
        Integer[] indices = new Integer[values.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        final String functionName = this.getName();
        Arrays.sort(indices, new Comparator<Integer>(){

            @Override
            public int compare(Integer idx1, Integer idx2) {
                if (null == values[idx1] && null == values[idx2]) {
                    return 0;
                }
                if (null == values[idx1] || null == values[idx2]) {
                    return null == values[idx1] ? 1 : -1;
                }
                if (values[idx1] instanceof Number && values[idx2] instanceof Number) {
                    return EQ.compare((Number)values[idx1], (Number)values[idx2]);
                }
                throw new RuntimeException(functionName + " can only operate on numeric Geo Time Series.");
            }
        });
        long location = 91480763316633925L;
        long elevation = Long.MIN_VALUE;
        int nonNullLength = values.length - nullCounter;
        if (1 == nonNullLength) {
            return new Object[]{tick, locations[indices[0]], elevations[indices[0]], ((Number)values[indices[0]]).doubleValue()};
        }
        if (0 == nonNullLength % 2) {
            int low = indices[nonNullLength / 2 - 1];
            int high = indices[nonNullLength / 2];
            median = (((Number)values[low]).doubleValue() + ((Number)values[high]).doubleValue()) / 2.0;
            if (Long.MIN_VALUE != elevations[low] && Long.MIN_VALUE != elevations[high]) {
                elevation = (elevations[low] + elevations[high]) / 2L;
            } else if (Long.MIN_VALUE != elevations[low]) {
                elevation = elevations[low];
            } else if (Long.MIN_VALUE != elevations[high]) {
                elevation = elevations[high];
            }
            if (91480763316633925L != locations[low] && 91480763316633925L != locations[high]) {
                long[] xyLow = GeoXPLib.xyFromGeoXPPoint((long)locations[low]);
                long[] xyHigh = GeoXPLib.xyFromGeoXPPoint((long)locations[high]);
                location = GeoXPLib.toGeoXPPoint((long)((xyLow[0] + xyHigh[0]) / 2L), (long)((xyLow[1] + xyHigh[1]) / 2L));
            } else if (91480763316633925L != locations[low]) {
                location = locations[low];
            } else if (91480763316633925L != locations[high]) {
                location = locations[high];
            }
        } else {
            location = locations[indices[nonNullLength / 2]];
            elevation = elevations[indices[nonNullLength / 2]];
            median = ((Number)values[indices[nonNullLength / 2]]).doubleValue();
        }
        return new Object[]{tick, location, elevation, median};
    }
}

