/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import com.geoxp.GeoXPLib;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;
import java.util.function.BiFunction;

public class CompareTo
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptReducerFunction,
WarpScriptBucketizerFunction {
    private final BiFunction<Object[], Integer, Boolean> tester;
    private final Object reference;

    public CompareTo(String name, Object threshold, Compared compared, Comparison comparison) throws WarpScriptException {
        super(name);
        this.reference = threshold;
        if (threshold instanceof Boolean && comparison != Comparison.EQ && comparison != Comparison.NE) {
            throw new WarpScriptException(name + " cannot compare with a BOOLEAN.");
        }
        if (Compared.TICK == compared || Compared.HHCODE == compared || Compared.ELEV == compared) {
            if (!(threshold instanceof Long)) {
                throw new WarpScriptException(name + " can only compare with a LONG.");
            }
        } else if (Compared.LAT == compared || Compared.LON == compared) {
            if (!(threshold instanceof Double) && !(threshold instanceof Long)) {
                throw new WarpScriptException(name + " can only compare with a DOUBLE or a LONG.");
            }
        } else if (!(threshold instanceof String || threshold instanceof Long || threshold instanceof Double || threshold instanceof Boolean)) {
            throw new WarpScriptException(name + " can only compare with a STRING, a DOUBLE, a LONG or a BOOLEAN.");
        }
        this.tester = this.generateTester(compared, comparison);
    }

    private BiFunction<Object[], Integer, Boolean> generateTester(Compared compared, Comparison comparison) {
        boolean invertComparison;
        int compareEqualsTo;
        switch (comparison) {
            case GT: {
                compareEqualsTo = 1;
                invertComparison = false;
                break;
            }
            case GE: {
                compareEqualsTo = -1;
                invertComparison = true;
                break;
            }
            case EQ: {
                compareEqualsTo = 0;
                invertComparison = false;
                break;
            }
            case LE: {
                compareEqualsTo = 1;
                invertComparison = true;
                break;
            }
            case LT: {
                compareEqualsTo = -1;
                invertComparison = false;
                break;
            }
            case NE: {
                compareEqualsTo = 0;
                invertComparison = true;
                break;
            }
            default: {
                throw new RuntimeException(this.getName() + " was given an invalid comparison value.");
            }
        }
        switch (compared) {
            case TICK: {
                return new BiFunction<Object[], Integer, Boolean>(){

                    @Override
                    public Boolean apply(Object[] args, Integer index) {
                        return Integer.signum(Long.compare(((long[])args[3])[index], (Long)CompareTo.this.reference)) == compareEqualsTo ^ invertComparison;
                    }
                };
            }
            case HHCODE: {
                return new BiFunction<Object[], Integer, Boolean>(){

                    @Override
                    public Boolean apply(Object[] args, Integer index) {
                        return Integer.signum(Long.compare(((long[])args[4])[index], (Long)CompareTo.this.reference)) == compareEqualsTo ^ invertComparison;
                    }
                };
            }
            case ELEV: {
                return new BiFunction<Object[], Integer, Boolean>(){

                    @Override
                    public Boolean apply(Object[] args, Integer index) {
                        return Integer.signum(Long.compare(((long[])args[5])[index], (Long)CompareTo.this.reference)) == compareEqualsTo ^ invertComparison;
                    }
                };
            }
            case LAT: {
                return new BiFunction<Object[], Integer, Boolean>(){

                    @Override
                    public Boolean apply(Object[] args, Integer index) {
                        double[] latlon1 = GeoXPLib.fromGeoXPPoint((long)((long[])args[4])[index]);
                        return Integer.signum(Double.compare(latlon1[0], ((Number)CompareTo.this.reference).doubleValue())) == compareEqualsTo ^ invertComparison;
                    }
                };
            }
            case LON: {
                return new BiFunction<Object[], Integer, Boolean>(){

                    @Override
                    public Boolean apply(Object[] args, Integer index) {
                        double[] latlon1 = GeoXPLib.fromGeoXPPoint((long)((long[])args[4])[index]);
                        return Integer.signum(Double.compare(latlon1[1], ((Number)CompareTo.this.reference).doubleValue())) == compareEqualsTo ^ invertComparison;
                    }
                };
            }
            case VALUE: {
                if (this.reference instanceof Long) {
                    return new BiFunction<Object[], Integer, Boolean>(){

                        @Override
                        public Boolean apply(Object[] args, Integer index) {
                            Object value = ((Object[])args[6])[index];
                            if (value instanceof Number) {
                                return Integer.signum(Long.compare(((Number)value).longValue(), (Long)CompareTo.this.reference)) == compareEqualsTo ^ invertComparison;
                            }
                            return false;
                        }
                    };
                }
                if (this.reference instanceof Double) {
                    return new BiFunction<Object[], Integer, Boolean>(){

                        @Override
                        public Boolean apply(Object[] args, Integer index) {
                            Object value = ((Object[])args[6])[index];
                            if (value instanceof Number) {
                                return Integer.signum(Double.compare(((Number)value).doubleValue(), (Double)CompareTo.this.reference)) == compareEqualsTo ^ invertComparison;
                            }
                            return false;
                        }
                    };
                }
                if (this.reference instanceof String) {
                    return new BiFunction<Object[], Integer, Boolean>(){

                        @Override
                        public Boolean apply(Object[] args, Integer index) {
                            Object value = ((Object[])args[6])[index];
                            return Integer.signum(value.toString().compareTo((String)CompareTo.this.reference)) == compareEqualsTo ^ invertComparison;
                        }
                    };
                }
                if (this.reference instanceof Boolean) {
                    return new BiFunction<Object[], Integer, Boolean>(){

                        @Override
                        public Boolean apply(Object[] args, Integer index) {
                            Object value = ((Object[])args[6])[index];
                            if (value instanceof Boolean) {
                                return Integer.signum(Boolean.compare((Boolean)value, (Boolean)CompareTo.this.reference)) == compareEqualsTo ^ invertComparison;
                            }
                            return false;
                        }
                    };
                }
                throw new RuntimeException(this.getName() + " was given a threshold of invalid type.");
            }
        }
        throw new RuntimeException(this.getName() + " was given an invalid compared value.");
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = Long.MAX_VALUE;
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        int idx = -1;
        for (int i = 0; i < values.length; ++i) {
            if (-1 != idx && ticks[i] >= tick || !this.tester.apply(args, i).booleanValue()) continue;
            idx = i;
            tick = ticks[i];
        }
        if (-1 != idx) {
            return new Object[]{ticks[idx], locations[idx], elevations[idx], values[idx]};
        }
        return new Object[]{args[0], 91480763316633925L, Long.MIN_VALUE, null};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.reference));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static enum Compared {
        TICK,
        HHCODE,
        LAT,
        LON,
        ELEV,
        VALUE;

    }

    public static enum Comparison {
        GT,
        GE,
        EQ,
        LE,
        LT,
        NE;

    }
}

