/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import io.warp10.WarpURLEncoder;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Map;

public class Argminmax
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptBucketizerFunction,
WarpScriptReducerFunction {
    private final String label;
    private final int count;
    private final boolean isArgmin;

    public Argminmax(String name, String label, int count, boolean isArgmin) {
        super(name);
        this.label = label;
        this.count = count;
        this.isArgmin = isArgmin;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        Map[] labels = (Map[])args[2];
        long[] ticks = (long[])args[3];
        Object[] values = (Object[])args[6];
        BitSet bitset = new BitSet(ticks.length);
        GeoTimeSerie.TYPE type = GeoTimeSerie.TYPE.LONG;
        long lmax = this.isArgmin ? Long.MAX_VALUE : Long.MIN_VALUE;
        double dmax = this.isArgmin ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        block6: for (int i = 0; i < ticks.length; ++i) {
            if (null == values[i]) continue;
            if (!labels[i].containsKey(this.label)) {
                throw new WarpScriptException(this.getName() + " expects all labels to contain label '" + this.label + "'.");
            }
            if (!(values[i] instanceof Number)) {
                throw new WarpScriptException(this.getName() + " can only operate on numerical values.");
            }
            if (values[i] instanceof Long && GeoTimeSerie.TYPE.DOUBLE == type) {
                values[i] = ((Long)values[i]).doubleValue();
            } else if (values[i] instanceof Double && GeoTimeSerie.TYPE.LONG == type) {
                if (bitset.length() > 0) {
                    dmax = lmax;
                }
                type = GeoTimeSerie.TYPE.DOUBLE;
            }
            switch (type) {
                case LONG: {
                    if ((Long)values[i] == lmax) {
                        bitset.set(i);
                        continue block6;
                    }
                    if (!((Long)values[i] > lmax ^ this.isArgmin)) continue block6;
                    bitset.clear();
                    lmax = (Long)values[i];
                    bitset.set(i);
                    continue block6;
                }
                case DOUBLE: {
                    if ((Double)values[i] == dmax) {
                        bitset.set(i);
                        continue block6;
                    }
                    if (!((Double)values[i] > dmax ^ this.isArgmin)) continue block6;
                    bitset.clear();
                    dmax = (Double)values[i];
                    bitset.set(i);
                    continue block6;
                }
                default: {
                    throw new WarpScriptException(this.getName() + " encountered an incoherent case, call the coherency police!");
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        int rescount = 0;
        for (int i = 0; i < bitset.length(); ++i) {
            if (!bitset.get(i)) continue;
            ++rescount;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String lval = (String)labels[i].get(this.label);
            try {
                sb.append(WarpURLEncoder.encode(lval, StandardCharsets.UTF_8));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (this.count > 0 && rescount == this.count) break;
        }
        return new Object[]{tick, 91480763316633925L, Long.MIN_VALUE, sb.toString()};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.label));
        sb.append(" ");
        sb.append(StackUtils.toString(this.count));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        private final boolean isArgmin;

        public Builder(String name, boolean isArgmin) {
            super(name);
            this.isArgmin = isArgmin;
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object o = stack.pop();
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects an integer number of maxima to report (use 0 to report them all).");
            }
            int count = ((Number)o).intValue();
            o = stack.pop();
            if (!(o instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects the name of the label to report on the second level of the stack.");
            }
            String label = o.toString();
            stack.push(new Argminmax(this.getName(), label, count, this.isArgmin));
            return stack;
        }
    }
}

