/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.script.WarpScriptStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;

public class WarpScriptStackRegistry {
    private static final Map<String, WeakReference<WarpScriptStack>> stacks = new ConcurrentHashMap<String, WeakReference<WarpScriptStack>>();
    private static boolean enabled = false;

    public static void register(WarpScriptStack stack) {
        if (!enabled || null == stack) {
            return;
        }
        stacks.put(stack.getUUID(), new WeakReference<WarpScriptStack>(stack));
    }

    public static boolean unregister(WarpScriptStack stack) {
        if (!enabled || null == stack) {
            return false;
        }
        return null != stacks.remove(stack.getUUID());
    }

    public static boolean unregister(String uuid) {
        return null != stacks.remove(uuid);
    }

    public static boolean signalByUuid(String uuid, WarpScriptStack.Signal signal) {
        if (!enabled) {
            return false;
        }
        WeakReference<WarpScriptStack> stackref = stacks.get(uuid);
        if (null == stackref) {
            return false;
        }
        WarpScriptStack stack = (WarpScriptStack)stackref.get();
        if (null == stack) {
            return false;
        }
        stack.signal(signal);
        return true;
    }

    public static int signalBySession(String session, WarpScriptStack.Signal signal) {
        if (null == session) {
            return 0;
        }
        ArrayList<WeakReference<WarpScriptStack>> refs = new ArrayList<WeakReference<WarpScriptStack>>(stacks.values());
        int aborted = 0;
        for (WeakReference weakReference : refs) {
            WarpScriptStack stack = (WarpScriptStack)weakReference.get();
            if (null == stack || !session.equals(stack.getAttribute("stackps.session"))) continue;
            stack.signal(signal);
            ++aborted;
        }
        return aborted;
    }

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        stacks.clear();
        enabled = false;
    }

    public static List<WarpScriptStack> stacks() {
        ArrayList<WarpScriptStack> stacks = new ArrayList<WarpScriptStack>(WarpScriptStackRegistry.stacks.size());
        for (WeakReference<WarpScriptStack> ref : WarpScriptStackRegistry.stacks.values()) {
            WarpScriptStack stack = (WarpScriptStack)ref.get();
            if (null == stack) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    static {
        Thread janitor = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block4: while (true) {
                    try {
                        HashSet uuids = new HashSet(stacks.keySet());
                        Iterator iterator = uuids.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block4;
                            String uuid = (String)iterator.next();
                            WeakReference ref = (WeakReference)stacks.get(uuid);
                            if (null == ref || null != ref.get()) continue;
                            stacks.remove(uuid);
                        }
                    }
                    catch (Throwable throwable) {}
                    continue;
                    finally {
                        LockSupport.parkNanos(1000000000L);
                        continue;
                    }
                    break;
                }
            }
        });
        janitor.setName("[WarpScriptStackRegistry janitor]");
        janitor.setDaemon(true);
        janitor.start();
    }
}

