/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.crypto.OrderPreservingBase64;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SAXUtils {
    public static final int SAX_MAX_LEVELS = 16;
    private static final double[][] INVNORM_BOUNDS = new double[16][];
    private static final double P_LOW = 0.02425;
    private static final double P_HIGH = 0.97575;
    private static final double[] ICDF_A = new double[]{-39.69683028665376, 220.9460984245205, -275.9285104469687, 138.357751867269, -30.66479806614716, 2.506628277459239};
    private static final double[] ICDF_B = new double[]{-54.47609879822406, 161.5858368580409, -155.6989798598866, 66.80131188771972, -13.28068155288572};
    private static final double[] ICDF_C = new double[]{-0.007784894002430293, -0.3223964580411365, -2.400758277161838, -2.549732539343734, 4.374664141464968, 2.938163982698783};
    private static final double[] ICDF_D = new double[]{0.007784695709041462, 0.3224671290700398, 2.445134137142996, 3.754408661907416};
    private static final double[] ERF_A = new double[]{3.1611237438705655, 113.86415415105016, 377.485237685302, 3209.3775891384694, 0.18577770618460315};
    private static final double[] ERF_B = new double[]{23.601290952344122, 244.02463793444417, 1282.6165260773723, 2844.236833439171};
    private static final double[] ERF_C = new double[]{0.5641884969886701, 8.883149794388377, 66.11919063714163, 298.6351381974001, 881.952221241769, 1712.0476126340707, 2051.0783778260716, 1230.3393547979972, 2.1531153547440383E-8};
    private static final double[] ERF_D = new double[]{15.744926110709835, 117.6939508913125, 537.1811018620099, 1621.3895745666903, 3290.7992357334597, 4362.619090143247, 3439.3676741437216, 1230.3393548037495};
    private static final double[] ERF_P = new double[]{0.30532663496123236, 0.36034489994980445, 0.12578172611122926, 0.016083785148742275, 6.587491615298378E-4, 0.016315387137302097};
    private static final double[] ERF_Q = new double[]{2.568520192289822, 1.8729528499234604, 0.5279051029514285, 0.06051834131244132, 0.0023352049762686918};
    private static final double PI_SQRT = Math.sqrt(Math.PI);
    private static final double THRESHOLD = 0.46875;
    private static final double X_MIN = Double.MIN_VALUE;
    private static final double X_INF = Double.MAX_VALUE;
    private static final double X_NEG = -9.38241396824444;
    private static final double X_SMALL = (double)1.110223E-16f;
    private static final double X_BIG = 9.194;
    private static final double X_HUGE = 1.0 / (2.0 * Math.sqrt(1.110223E-16f));
    private static final double X_MAX = Math.min(Double.MAX_VALUE, 1.0 / (Math.sqrt(Math.PI) * Double.MIN_VALUE));

    public static double getInvCDF(double d, boolean highPrecision) {
        double z = 0.0;
        if (d == 0.0) {
            z = Double.NEGATIVE_INFINITY;
        } else if (d == 1.0) {
            z = Double.POSITIVE_INFINITY;
        } else if (Double.isNaN(d) || d < 0.0 || d > 1.0) {
            z = Double.NaN;
        } else if (d < 0.02425) {
            double q = Math.sqrt(-2.0 * Math.log(d));
            z = (((((ICDF_C[0] * q + ICDF_C[1]) * q + ICDF_C[2]) * q + ICDF_C[3]) * q + ICDF_C[4]) * q + ICDF_C[5]) / ((((ICDF_D[0] * q + ICDF_D[1]) * q + ICDF_D[2]) * q + ICDF_D[3]) * q + 1.0);
        } else if (0.97575 < d) {
            double q = Math.sqrt(-2.0 * Math.log(1.0 - d));
            z = -(((((ICDF_C[0] * q + ICDF_C[1]) * q + ICDF_C[2]) * q + ICDF_C[3]) * q + ICDF_C[4]) * q + ICDF_C[5]) / ((((ICDF_D[0] * q + ICDF_D[1]) * q + ICDF_D[2]) * q + ICDF_D[3]) * q + 1.0);
        } else {
            double q = d - 0.5;
            double r = q * q;
            z = (((((ICDF_A[0] * r + ICDF_A[1]) * r + ICDF_A[2]) * r + ICDF_A[3]) * r + ICDF_A[4]) * r + ICDF_A[5]) * q / (((((ICDF_B[0] * r + ICDF_B[1]) * r + ICDF_B[2]) * r + ICDF_B[3]) * r + ICDF_B[4]) * r + 1.0);
        }
        if (highPrecision) {
            z = SAXUtils.refine(z, d);
        }
        return z;
    }

    private static double calerf(double X, int jint) {
        double Y_SQ;
        double result = 0.0;
        double Y = Math.abs(X);
        if (Y <= 0.46875) {
            double Y_SQ2 = 0.0;
            if (Y > (double)1.110223E-16f) {
                Y_SQ2 = Y * Y;
            }
            double X_NUM = ERF_A[4] * Y_SQ2;
            double X_DEN = Y_SQ2;
            for (int i = 0; i < 3; ++i) {
                X_NUM = (X_NUM + ERF_A[i]) * Y_SQ2;
                X_DEN = (X_DEN + ERF_B[i]) * Y_SQ2;
            }
            result = X * (X_NUM + ERF_A[3]) / (X_DEN + ERF_B[3]);
            if (jint != 0) {
                result = 1.0 - result;
            }
            if (jint == 2) {
                result = Math.exp(Y_SQ2) * result;
            }
            return result;
        }
        if (Y <= 4.0) {
            double X_NUM = ERF_C[8] * Y;
            double X_DEN = Y;
            for (int i = 0; i < 7; ++i) {
                X_NUM = (X_NUM + ERF_C[i]) * Y;
                X_DEN = (X_DEN + ERF_D[i]) * Y;
            }
            result = (X_NUM + ERF_C[7]) / (X_DEN + ERF_D[7]);
            if (jint != 2) {
                Y_SQ = (double)Math.round(Y * 16.0) / 16.0;
                double del = (Y - Y_SQ) * (Y + Y_SQ);
                result = Math.exp(-Y_SQ * Y_SQ) * Math.exp(-del) * result;
            }
        } else {
            result = 0.0;
            if (!(Y >= 9.194) || jint == 2 && !(Y >= X_MAX)) {
                if (Y >= 9.194 && Y >= X_HUGE) {
                    result = PI_SQRT / Y;
                } else {
                    Y_SQ = 1.0 / (Y * Y);
                    double X_NUM = ERF_P[5] * Y_SQ;
                    double X_DEN = Y_SQ;
                    for (int i = 0; i < 4; ++i) {
                        X_NUM = (X_NUM + ERF_P[i]) * Y_SQ;
                        X_DEN = (X_DEN + ERF_Q[i]) * Y_SQ;
                    }
                    result = Y_SQ * (X_NUM + ERF_P[4]) / (X_DEN + ERF_Q[4]);
                    result = (PI_SQRT - result) / Y;
                    if (jint != 2) {
                        Y_SQ = (double)Math.round(Y * 16.0) / 16.0;
                        double del = (Y - Y_SQ) * (Y + Y_SQ);
                        result = Math.exp(-Y_SQ * Y_SQ) * Math.exp(-del) * result;
                    }
                }
            }
        }
        if (jint == 0) {
            result = 0.5 - result + 0.5;
            if (X < 0.0) {
                result = -result;
            }
        } else if (jint == 1) {
            if (X < 0.0) {
                result = 2.0 - result;
            }
        } else if (X < 0.0) {
            if (X < -9.38241396824444) {
                result = Double.MAX_VALUE;
            } else {
                Y_SQ = (double)Math.round(X * 16.0) / 16.0;
                double del = (X - Y_SQ) * (X + Y_SQ);
                Y = Math.exp(Y_SQ * Y_SQ) * Math.exp(del);
                result = Y + Y - result;
            }
        }
        return result;
    }

    public static double erf(double d) {
        return SAXUtils.calerf(d, 0);
    }

    public static double erfc(double d) {
        return SAXUtils.calerf(d, 1);
    }

    public static double erfcx(double d) {
        return SAXUtils.calerf(d, 2);
    }

    public static double refine(double x, double d) {
        if (d > 0.0 && d < 1.0) {
            double e = 0.5 * SAXUtils.erfc(-x / Math.sqrt(2.0)) - d;
            double u = e * Math.sqrt(Math.PI * 2) * Math.exp(x * x / 2.0);
            x -= u / (1.0 + x * u / 2.0);
        }
        return x;
    }

    public static double[] getBounds(int n) {
        double area = 1.0 / (double)n;
        double[] bounds = new double[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            bounds[i] = SAXUtils.getInvCDF((double)(i + 1) * area, true);
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static int SAX(int levels, double value) {
        int idx;
        if (levels > 16) throw new RuntimeException();
        if (levels < 1) {
            throw new RuntimeException();
        }
        if (null == INVNORM_BOUNDS[levels - 1]) {
            double[][] dArray = INVNORM_BOUNDS;
            // MONITORENTER : INVNORM_BOUNDS
            if (null == INVNORM_BOUNDS[levels - 1]) {
                SAXUtils.INVNORM_BOUNDS[levels - 1] = SAXUtils.getBounds(1 << levels);
            }
            // MONITOREXIT : dArray
        }
        if ((idx = Arrays.binarySearch(INVNORM_BOUNDS[levels - 1], value)) < 0) return -idx - 1;
        return idx;
    }

    public static double fromSAX(int levels, int sax, boolean random) {
        SAXUtils.SAX(levels, 0.0);
        double[] bounds = INVNORM_BOUNDS[levels - 1];
        if (sax < 0 || sax > bounds.length) {
            throw new RuntimeException("Invalid quantification symbol.");
        }
        if (sax > 0 && sax < bounds.length) {
            if (!random) {
                return 0.5 * (bounds[sax] + bounds[sax - 1]);
            }
            double x = Math.random();
            return x * bounds[sax - 1] + (1.0 - x) * bounds[sax];
        }
        if (0 == sax) {
            if (!random) {
                return bounds[0] - 2.0 * (bounds[1] - bounds[0]);
            }
            return bounds[0] - Math.exp(1.0 / Math.random());
        }
        if (!random) {
            return bounds[bounds.length - 1] + 2.0 * (bounds[bounds.length - 1] - bounds[bounds.length - 2]);
        }
        return bounds[bounds.length - 1] + Math.exp(1.0 / Math.random());
    }

    public static String[] indexable(int wordlen, int levels, byte[] bSAX) {
        String[] strings = new String[levels];
        for (int i = 1; i <= levels; ++i) {
            int nbits = wordlen * i;
            int len = nbits / 8 + (0 == nbits % 8 ? 0 : 1);
            if (0 != nbits % 8) {
                byte tmp = bSAX[len - 1];
                bSAX[len - 1] = (byte)(bSAX[len - 1] & (byte)(0xFF ^ 1 << 8 - nbits % 8 - 1));
                strings[i - 1] = new String(OrderPreservingBase64.encode(bSAX, 0, len), StandardCharsets.US_ASCII);
                bSAX[len - 1] = tmp;
                continue;
            }
            strings[i - 1] = new String(OrderPreservingBase64.encode(bSAX, 0, len), StandardCharsets.US_ASCII);
        }
        return strings;
    }

    public static byte[] bSAX(int levels, int[] symbols) {
        int bitlen = levels * symbols.length;
        byte[] binary = 0 == bitlen % 8 ? new byte[bitlen >>> 3] : new byte[1 + (bitlen >>> 3)];
        int idx = 0;
        int bits = 0;
        int bitcount = 0;
        for (int bit = 0; bit < levels; ++bit) {
            for (int w = 0; w < symbols.length; ++w) {
                bits <<= 1;
                bits |= symbols[w] >>> levels - bit - 1 & 1;
                if (0 != ++bitcount % 8) continue;
                binary[idx++] = (byte)(bits & 0xFF);
                bitcount = 0;
            }
        }
        if (idx < binary.length) {
            binary[idx] = (byte)((bits <<= 8 - bitcount) & 0xFF);
        }
        return binary;
    }

    public static int[] fromBSAX(int levels, int wordlen, byte[] bsax) {
        int[] symbols = new int[wordlen];
        int idx = 0;
        int bitidx = 7;
        int symbolidx = 0;
        for (int bits = 0; bits < levels * wordlen; ++bits) {
            int bit = bsax[idx] >> bitidx & 1;
            symbols[symbolidx] = symbols[symbolidx] << 1;
            int n = symbolidx++;
            symbols[n] = symbols[n] | bit;
            --bitidx;
            if (wordlen == symbolidx) {
                symbolidx = 0;
            }
            if (bitidx >= 0) continue;
            bitidx = 7;
            ++idx;
        }
        return symbols;
    }
}

