/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.json;

import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import io.warp10.json.BoundedWriter;
import io.warp10.json.BytesSerializer;
import io.warp10.json.COWListSerializer;
import io.warp10.json.GTSEncoderSerializer;
import io.warp10.json.GeoTimeSerieSerializer;
import io.warp10.json.MacroSerializer;
import io.warp10.json.MetadataSerializer;
import io.warp10.json.NamedWarpScriptFunctionSerializer;
import io.warp10.json.RealMatrixSerializer;
import io.warp10.json.RealVectorSerializer;
import io.warp10.json.WarpScriptAuditStatementSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JsonUtils {
    private static final NullKeySerializer NULL_KEY_SERIALIZER = new NullKeySerializer();
    private static final CustomSerializer CUSTOM_SERIALIZER = new CustomSerializer();
    private static final ObjectMapper STRICT_MAPPER;
    private static final ObjectMapper STRICT_MAPPER_PRETTY;
    private static final ObjectMapper LOOSE_MAPPER;
    private static final ObjectMapper LOOSE_MAPPER_PRETTY;
    private static List<JsonTransformer> transformers;

    public static Object jsonToObject(String json) throws JsonProcessingException {
        return STRICT_MAPPER.readValue(json, Object.class);
    }

    public static String objectToJson(Object o) throws IOException {
        return JsonUtils.objectToJson(o, Long.MAX_VALUE);
    }

    public static String objectToJson(Object o, long maxJsonSize) throws IOException {
        return JsonUtils.objectToJson(o, false, false, maxJsonSize);
    }

    public static String objectToJson(Object o, boolean isStrict) throws IOException {
        return JsonUtils.objectToJson(o, isStrict, false, Long.MAX_VALUE);
    }

    public static String objectToJson(Object o, boolean isStrict, boolean isPretty) throws IOException {
        return JsonUtils.objectToJson(o, isStrict, isPretty, Long.MAX_VALUE);
    }

    public static String objectToJson(Object o, boolean isStrict, long maxJsonSize) throws IOException {
        return JsonUtils.objectToJson(o, isStrict, false, maxJsonSize);
    }

    public static String objectToJson(Object o, boolean isStrict, boolean isPretty, long maxJsonSize) throws IOException {
        StringWriter writer = new StringWriter();
        JsonUtils.objectToJson(writer, o, isStrict, isPretty, maxJsonSize);
        return writer.toString();
    }

    public static void objectToJson(Writer writer, Object o, boolean isStrict) throws IOException {
        JsonUtils.objectToJson(writer, o, isStrict, false, Long.MAX_VALUE);
    }

    public static void objectToJson(Writer writer, Object o, boolean isStrict, boolean isPretty) throws IOException {
        JsonUtils.objectToJson(writer, o, isStrict, isPretty, Long.MAX_VALUE);
    }

    public static void objectToJson(Writer writer, Object o, boolean isStrict, long maxJsonSize) throws IOException {
        JsonUtils.objectToJson(writer, o, isStrict, false, maxJsonSize);
    }

    public static void objectToJson(Writer writer, Object o, boolean isStrict, boolean isPretty, long maxJsonSize) throws IOException {
        if (Long.MAX_VALUE != maxJsonSize) {
            writer = new BoundedWriter(writer, maxJsonSize);
        }
        try {
            if (isStrict) {
                if (isPretty) {
                    STRICT_MAPPER_PRETTY.writeValue(writer, o);
                } else {
                    STRICT_MAPPER.writeValue(writer, o);
                }
            } else if (isPretty) {
                LOOSE_MAPPER_PRETTY.writeValue(writer, o);
            } else {
                LOOSE_MAPPER.writeValue(writer, o);
            }
        }
        catch (BoundedWriter.WriterBoundReachedException wbre) {
            throw new IOException("Resulting JSON is too big.", wbre);
        }
    }

    public static synchronized void addTransformer(JsonTransformer transformer) {
        if (null == transformers) {
            transformers = new ArrayList<JsonTransformer>();
        }
        transformers.add(transformer);
    }

    static {
        SimpleModule module = new SimpleModule();
        module.setSerializerModifier((BeanSerializerModifier)new NotSerializedToCustomSerializedModifier());
        module.addSerializer((JsonSerializer)new GeoTimeSerieSerializer());
        module.addSerializer((JsonSerializer)new GTSEncoderSerializer());
        module.addSerializer((JsonSerializer)new MetadataSerializer());
        module.addSerializer((JsonSerializer)new NamedWarpScriptFunctionSerializer());
        module.addSerializer((JsonSerializer)new MacroSerializer());
        module.addSerializer((JsonSerializer)new BytesSerializer());
        module.addSerializer((JsonSerializer)new RealVectorSerializer());
        module.addSerializer((JsonSerializer)new RealMatrixSerializer());
        module.addSerializer((JsonSerializer)new COWListSerializer());
        module.addSerializer((JsonSerializer)new WarpScriptAuditStatementSerializer());
        JsonFactoryBuilder builder = new JsonFactoryBuilder();
        builder.enable(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS);
        builder.enable(JsonReadFeature.ALLOW_MISSING_VALUES);
        builder.enable(JsonWriteFeature.ESCAPE_NON_ASCII);
        builder.disable(JsonWriteFeature.WRITE_NUMBERS_AS_STRINGS);
        builder.disable(StreamWriteFeature.AUTO_CLOSE_TARGET);
        builder.enable(JsonWriteFeature.WRITE_NAN_AS_STRINGS);
        STRICT_MAPPER = new ObjectMapper(builder.build());
        STRICT_MAPPER.getSerializerProvider().setNullKeySerializer((JsonSerializer)NULL_KEY_SERIALIZER);
        STRICT_MAPPER.registerModule((Module)module);
        STRICT_MAPPER_PRETTY = new ObjectMapper(builder.build());
        STRICT_MAPPER_PRETTY.enable(SerializationFeature.INDENT_OUTPUT);
        STRICT_MAPPER_PRETTY.getSerializerProvider().setNullKeySerializer((JsonSerializer)NULL_KEY_SERIALIZER);
        STRICT_MAPPER_PRETTY.registerModule((Module)module);
        builder.disable(JsonWriteFeature.WRITE_NAN_AS_STRINGS);
        LOOSE_MAPPER = new ObjectMapper(builder.build());
        LOOSE_MAPPER.getSerializerProvider().setNullKeySerializer((JsonSerializer)NULL_KEY_SERIALIZER);
        LOOSE_MAPPER.registerModule((Module)module);
        LOOSE_MAPPER_PRETTY = new ObjectMapper(builder.build());
        LOOSE_MAPPER_PRETTY.enable(SerializationFeature.INDENT_OUTPUT);
        LOOSE_MAPPER_PRETTY.getSerializerProvider().setNullKeySerializer((JsonSerializer)NULL_KEY_SERIALIZER);
        LOOSE_MAPPER_PRETTY.registerModule((Module)module);
    }

    public static interface JsonTransformer {
        public TransformationResult transform(Object var1);

        public static class TransformationResult {
            private final boolean transformed;
            private final Object result;
            private final boolean raw;

            public TransformationResult(boolean transformed, Object result, boolean raw) {
                this.transformed = transformed;
                this.result = result;
                this.raw = raw;
            }
        }
    }

    public static class CustomSerializer
    extends JsonSerializer<Object> {
        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (null != transformers && !transformers.isEmpty()) {
                JsonTransformer transformer;
                JsonTransformer.TransformationResult transfRes = null;
                Iterator iterator = transformers.iterator();
                while (iterator.hasNext() && (null == (transfRes = (transformer = (JsonTransformer)iterator.next()).transform(value)) || !transfRes.transformed)) {
                }
                if (null != transfRes && transfRes.transformed) {
                    if (transfRes.raw && transfRes.result instanceof String) {
                        gen.writeRawValue((String)transfRes.result);
                    } else {
                        gen.writeObject(transfRes.result);
                    }
                } else {
                    gen.writeNull();
                }
            } else {
                gen.writeNull();
            }
        }
    }

    public static class NotSerializedToCustomSerializedModifier
    extends BeanSerializerModifier {
        public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            if (serializer instanceof UnknownSerializer || serializer instanceof BeanSerializer) {
                return CUSTOM_SERIALIZER;
            }
            return serializer;
        }
    }

    private static class NullKeySerializer
    extends JsonSerializer<Object> {
        private NullKeySerializer() {
        }

        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeFieldName("null");
        }
    }
}

