/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.hadoop;

import io.warp10.WarpConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.GenericWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.SortedMapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;

public class WritableUtils {
    private static final boolean strictWritables = "true".equals(WarpConfig.getProperty("warpscript.hadoop.strictwritables"));
    private static final boolean rawWritables = "true".equals(WarpConfig.getProperty("warpscript.hadoop.rawwritables"));

    public static Object fromWritable(Object w) throws IOException {
        if (!(w instanceof Writable) || rawWritables) {
            return w;
        }
        if (w instanceof Text) {
            return ((Text)w).toString();
        }
        if (w instanceof BytesWritable) {
            return ((BytesWritable)w).copyBytes();
        }
        if (w instanceof NullWritable) {
            return null;
        }
        if (w instanceof LongWritable) {
            return ((LongWritable)w).get();
        }
        if (w instanceof IntWritable) {
            return (long)((IntWritable)w).get();
        }
        if (w instanceof ByteWritable) {
            return (long)((ByteWritable)w).get();
        }
        if (w instanceof ShortWritable) {
            return (long)((ShortWritable)w).get();
        }
        if (w instanceof ArrayWritable) {
            Writable[] a = ((ArrayWritable)w).get();
            ArrayList<Object> l = new ArrayList<Object>();
            for (Writable ww : a) {
                l.add(WritableUtils.fromWritable(ww));
            }
            return l;
        }
        if (w instanceof BooleanWritable) {
            return ((BooleanWritable)w).get();
        }
        if (w instanceof DoubleWritable) {
            return ((DoubleWritable)w).get();
        }
        if (w instanceof FloatWritable) {
            return Float.valueOf(((FloatWritable)w).get());
        }
        if (w instanceof MapWritable) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Map.Entry entry : ((MapWritable)w).entrySet()) {
                map.put(WritableUtils.fromWritable(entry.getKey()), WritableUtils.fromWritable(entry.getValue()));
            }
            return map;
        }
        if (w instanceof ObjectWritable) {
            return ((ObjectWritable)w).get();
        }
        if (w instanceof GenericWritable) {
            return WritableUtils.fromWritable(((GenericWritable)w).get());
        }
        if (w instanceof SortedMapWritable) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : ((SortedMapWritable)w).entrySet()) {
                map.put(WritableUtils.fromWritable(entry.getKey()), WritableUtils.fromWritable(entry.getValue()));
            }
            return map;
        }
        if (w instanceof VIntWritable) {
            return (long)((VIntWritable)w).get();
        }
        if (w instanceof VLongWritable) {
            return ((VLongWritable)w).get();
        }
        if (strictWritables) {
            throw new IOException("Unsupported Writable implementation " + w.getClass());
        }
        return w;
    }

    public static Writable toWritable(Object o) throws IOException {
        if (o instanceof Long) {
            return new LongWritable(((Long)o).longValue());
        }
        if (o instanceof String) {
            return new Text(o.toString());
        }
        if (o instanceof byte[]) {
            return new BytesWritable((byte[])o);
        }
        if (o instanceof Integer) {
            return new IntWritable(((Integer)o).intValue());
        }
        if (o instanceof Short) {
            return new ShortWritable(((Short)o).shortValue());
        }
        if (o instanceof Byte) {
            return new ByteWritable(((Byte)o).byteValue());
        }
        if (o instanceof Double) {
            return new DoubleWritable(((Double)o).doubleValue());
        }
        if (o instanceof Float) {
            return new FloatWritable(((Float)o).floatValue());
        }
        if (o instanceof Boolean) {
            return new BooleanWritable(((Boolean)o).booleanValue());
        }
        if (o instanceof List) {
            Writable[] a = new Writable[((List)o).size()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = new ObjectWritable((Object)WritableUtils.toWritable(((List)o).get(i)));
            }
            return new ArrayWritable(ObjectWritable.class, a);
        }
        if (o instanceof Map) {
            MapWritable map = new MapWritable();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                map.put(WritableUtils.toWritable(entry.getKey()), WritableUtils.toWritable(entry.getValue()));
            }
            return map;
        }
        if (null == o) {
            return NullWritable.get();
        }
        ObjectWritable ow = new ObjectWritable();
        ow.set(o);
        return ow;
    }
}

