/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.crypto;

import com.geoxp.oss.CryptoHelper;
import com.geoxp.oss.OSSException;
import com.geoxp.oss.client.OSSClient;
import io.warp10.crypto.KeyStore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class OSSKeyStore
implements KeyStore {
    private byte[] masterKey;
    private final Map<String, byte[]> keys = new HashMap<String, byte[]>();

    private OSSKeyStore() {
    }

    public OSSKeyStore(String masterKeySpec) throws OSSException {
        this.masterKey = null;
        if (null != masterKeySpec) {
            try {
                this.masterKey = this.decodeKey(masterKeySpec);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == this.masterKey) {
                this.masterKey = OSSClient.getSecret((String)System.getProperty("oss.url"), (String)masterKeySpec, (String)System.getProperty("oss.sshkey"));
            }
        }
    }

    @Override
    public void setKey(String name, byte[] key) {
        if (null != key) {
            this.keys.put(name, Arrays.copyOf(key, key.length));
        }
    }

    @Override
    public byte[] getKey(String name) {
        return this.keys.get(name);
    }

    @Override
    public byte[] decodeKey(String encoded) {
        if (null == encoded) {
            return null;
        }
        if (encoded.startsWith("hex:")) {
            return Hex.decode((String)encoded.substring(4));
        }
        if (encoded.startsWith("base64:")) {
            return Base64.decode((String)encoded.substring(7));
        }
        if (encoded.startsWith("wrapped:")) {
            if (null == this.masterKey) {
                throw new RuntimeException("Master Key not retrieved from OSS, aborting.");
            }
            return CryptoHelper.unwrapBlob((byte[])this.masterKey, (byte[])this.decodeKey(encoded.substring(8)));
        }
        return null;
    }

    @Override
    public KeyStore clone() {
        OSSKeyStore keystore = new OSSKeyStore();
        if (null != this.masterKey) {
            keystore.masterKey = Arrays.copyOf(this.masterKey, this.masterKey.length);
        }
        for (Map.Entry<String, byte[]> entry : this.keys.entrySet()) {
            keystore.setKey(entry.getKey(), Arrays.copyOf(entry.getValue(), entry.getValue().length));
        }
        return keystore;
    }

    @Override
    public void forget() {
        Arrays.fill(this.masterKey, (byte)0);
    }
}

