/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.continuum.gts;

import com.geoxp.GeoXPLib;
import io.warp10.CapacityExtractorOutputStream;
import io.warp10.WarpHexDecoder;
import io.warp10.WarpURLDecoder;
import io.warp10.WarpURLEncoder;
import io.warp10.continuum.MetadataUtils;
import io.warp10.continuum.TimeSource;
import io.warp10.continuum.gts.COWList;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSIdComparator;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.gts.UnsafeString;
import io.warp10.continuum.gts.ValueEncoder;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.crypto.SipHashInline;
import io.warp10.json.JsonUtils;
import io.warp10.script.SAXUtils;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptAggregatorOnListsFunction;
import io.warp10.script.WarpScriptBinaryOp;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFillerFunction;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptLib;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptNAryFunction;
import io.warp10.script.WarpScriptReducerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.functions.MACROMAPPER;
import io.warp10.script.functions.TOQUATERNION;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoint;
import org.apache.thrift.TBase;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTSHelper {
    private static final Logger LOG = LoggerFactory.getLogger(GTSHelper.class);
    private static final Pattern MEASUREMENT_RE = Pattern.compile("^([0-9]+)?/(([0-9.-]+):([0-9.-]+))?/([0-9-]+)? +([^ ]+)\\{([^\\}]*)\\} +(.+)$");
    private static final Pattern STRING_VALUE_RE = Pattern.compile("^['\"].*['\"]$");
    private static final Pattern BOOLEAN_VALUE_RE = Pattern.compile("^(T|F|true|false)$", 2);
    private static final Pattern LONG_VALUE_RE = Pattern.compile("^[+-]?[0-9]+$");
    private static final Pattern DOUBLE_VALUE_RE = Pattern.compile("^[+-]?([0-9]+)\\.([0-9]+)$");

    public static final GeoTimeSerie sort(GeoTimeSerie gts, boolean reversed) {
        if (gts.sorted && gts.reversed != reversed) {
            long tmp;
            int j;
            int i;
            if (null != gts.ticks) {
                i = 0;
                for (j = gts.values - 1; i < j; ++i, --j) {
                    tmp = gts.ticks[i];
                    gts.ticks[i] = gts.ticks[j];
                    gts.ticks[j] = tmp;
                }
            }
            if (null != gts.locations) {
                i = 0;
                for (j = gts.values - 1; i < j; ++i, --j) {
                    tmp = gts.locations[i];
                    gts.locations[i] = gts.locations[j];
                    gts.locations[j] = tmp;
                }
            }
            if (null != gts.elevations) {
                i = 0;
                for (j = gts.values - 1; i < j; ++i, --j) {
                    tmp = gts.elevations[i];
                    gts.elevations[i] = gts.elevations[j];
                    gts.elevations[j] = tmp;
                }
            }
            switch (gts.type) {
                case LONG: {
                    if (null == gts.longValues) break;
                    i = 0;
                    for (j = gts.values - 1; i < j; ++i, --j) {
                        tmp = gts.longValues[i];
                        gts.longValues[i] = gts.longValues[j];
                        gts.longValues[j] = tmp;
                    }
                    break;
                }
                case DOUBLE: {
                    if (null == gts.doubleValues) break;
                    i = 0;
                    for (j = gts.values - 1; i < j; ++i, --j) {
                        double tmp2 = gts.doubleValues[i];
                        gts.doubleValues[i] = gts.doubleValues[j];
                        gts.doubleValues[j] = tmp2;
                    }
                    break;
                }
                case STRING: {
                    if (null == gts.stringValues) break;
                    i = 0;
                    for (j = gts.values - 1; i < j; ++i, --j) {
                        String tmp3 = gts.stringValues[i];
                        gts.stringValues[i] = gts.stringValues[j];
                        gts.stringValues[j] = tmp3;
                    }
                    break;
                }
                case BOOLEAN: {
                    if (null == gts.booleanValues) break;
                    i = 0;
                    for (j = gts.values - 1; i < j; ++i, --j) {
                        boolean tmp4 = gts.booleanValues.get(i);
                        gts.booleanValues.set(i, gts.booleanValues.get(j));
                        gts.booleanValues.set(j, tmp4);
                    }
                    break;
                }
            }
            gts.reversed = reversed;
            return gts;
        }
        if (gts.sorted) {
            return gts;
        }
        GTSHelper.quicksort(gts, 0, gts.values - 1, reversed);
        gts.sorted = true;
        gts.reversed = reversed;
        return gts;
    }

    public static final GeoTimeSerie sort(GeoTimeSerie gts) {
        return GTSHelper.sort(gts, false);
    }

    public static final GeoTimeSerie fullsort(GeoTimeSerie gts) {
        return GTSHelper.fullsort(gts, false);
    }

    public static final GeoTimeSerie fullsort(GeoTimeSerie gts, boolean reversed) {
        if (gts.sorted) {
            if (gts.reversed != reversed) {
                GTSHelper.sort(gts, reversed);
            }
            ArrayList<int[]> ranges = new ArrayList<int[]>();
            int startIndex = 0;
            for (int i = 1; i < gts.values; ++i) {
                if (gts.ticks[i] == gts.ticks[startIndex]) continue;
                if (i - 1 - startIndex > 0) {
                    ranges.add(new int[]{startIndex, i - 1});
                }
                startIndex = i;
            }
            if (startIndex < gts.values - 1) {
                ranges.add(new int[]{startIndex, gts.values - 1});
            }
            GTSHelper.fullquicksort(gts, ranges, reversed);
        } else {
            GTSHelper.fullquicksort(gts, 0, gts.values - 1, reversed);
        }
        gts.sorted = true;
        gts.reversed = reversed;
        return gts;
    }

    public static GTSEncoder fullsort(GTSEncoder encoder, boolean reversed) throws IOException {
        return GTSHelper.fullsort(encoder, reversed, encoder.getBaseTimestamp());
    }

    public static GTSEncoder fullsort(GTSEncoder encoder, boolean reversed, long baseTimestamp) throws IOException {
        GTSEncoder enc = null;
        GeoTimeSerie[] gts = new GeoTimeSerie[5];
        for (int i = 0; i < gts.length; ++i) {
            gts[i] = new GeoTimeSerie();
        }
        GTSDecoder decoder = encoder.getDecoder();
        while (decoder.next()) {
            long ts = decoder.getTimestamp();
            long location = decoder.getLocation();
            long elevation = decoder.getElevation();
            Object value = decoder.getBinaryValue();
            if (value instanceof Long) {
                GTSHelper.setValue(gts[0], ts, location, elevation, value, false);
                continue;
            }
            if (value instanceof Double || value instanceof BigDecimal) {
                GTSHelper.setValue(gts[1], ts, location, elevation, value, false);
                continue;
            }
            if (value instanceof Boolean) {
                GTSHelper.setValue(gts[2], ts, location, elevation, value, false);
                continue;
            }
            if (value instanceof String) {
                GTSHelper.setValue(gts[3], ts, location, elevation, value, false);
                continue;
            }
            if (!(value instanceof byte[])) continue;
            GTSHelper.setValue(gts[4], ts, location, elevation, value, false);
        }
        for (int i = 0; i < gts.length; ++i) {
            GTSHelper.fullsort(gts[i], reversed);
        }
        enc = new GTSEncoder(baseTimestamp);
        enc.setMetadata(encoder.getMetadata());
        int[] idx = new int[gts.length];
        while (true) {
            int gtsidx = -1;
            long ts = Long.MAX_VALUE;
            for (int i = 0; i < gts.length; ++i) {
                if (idx[i] >= GTSHelper.nvalues(gts[i])) continue;
                long tick = GTSHelper.tickAtIndex(gts[i], idx[i]);
                if (-1 != gtsidx && tick >= ts) continue;
                gtsidx = i;
                ts = tick;
            }
            if (-1 == gtsidx) break;
            do {
                long location = GTSHelper.locationAtIndex(gts[gtsidx], idx[gtsidx]);
                long elevation = GTSHelper.elevationAtIndex(gts[gtsidx], idx[gtsidx]);
                Object value = GTSHelper.valueAtIndex(gts[gtsidx], idx[gtsidx]);
                if (4 == gtsidx) {
                    value = value.toString().getBytes(StandardCharsets.ISO_8859_1);
                } else if (1 == gtsidx) {
                    value = GTSEncoder.optimizeValue(value);
                }
                enc.addValue(ts, location, elevation, value);
                int n = gtsidx;
                idx[n] = idx[n] + 1;
            } while (idx[gtsidx] < GTSHelper.nvalues(gts[gtsidx]) && GTSHelper.tickAtIndex(gts[gtsidx], idx[gtsidx]) == ts);
        }
        return enc;
    }

    public static final int binarySearchTick(GeoTimeSerie gts, long timestamp, BinarySearchTickChoice tickChoice) {
        return GTSHelper.binarySearchTick(gts, 0, gts.values, timestamp, tickChoice);
    }

    public static final int binarySearchTick(GeoTimeSerie gts, int fromIndex, int toIndex, long timestamp, BinarySearchTickChoice tickChoice) {
        int compFactor;
        if (null == gts.ticks) {
            return -1;
        }
        GTSHelper.sort(gts, gts.reversed);
        int low = fromIndex;
        int high = toIndex - 1;
        int resIndex = -1;
        int n = compFactor = gts.reversed ? -1 : 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = gts.ticks[mid];
            int comp = Long.compare(midVal, timestamp) * compFactor;
            if (0 > comp) {
                low = mid + 1;
                continue;
            }
            if (0 < comp) {
                high = mid - 1;
                continue;
            }
            if (BinarySearchTickChoice.ARBITRARY == tickChoice) {
                return mid;
            }
            resIndex = mid;
            if (BinarySearchTickChoice.FIRST == tickChoice) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        if (0 <= resIndex) {
            return resIndex;
        }
        if (gts.reversed) {
            return -(high + 1);
        }
        return -(low + 1);
    }

    public static final GeoTimeSerie valueSort(GeoTimeSerie gts, boolean reversed) {
        gts.sorted = false;
        GTSHelper.quicksortByValue(gts, 0, gts.values - 1, reversed);
        return gts;
    }

    public static final GeoTimeSerie valueSort(GeoTimeSerie gts) {
        return GTSHelper.valueSort(gts, false);
    }

    public static final Iterator<Long> tickIterator(GeoTimeSerie gts, final boolean reversed) {
        final GeoTimeSerie itergts = gts;
        if (!GTSHelper.isBucketized(gts)) {
            GTSHelper.sort(gts, false);
            return new Iterator<Long>(){
                int idx;
                {
                    this.idx = reversed ? itergts.values - 1 : 0;
                }

                @Override
                public boolean hasNext() {
                    return reversed ? this.idx > 0 : this.idx < itergts.values;
                }

                @Override
                public Long next() {
                    int n;
                    long[] lArray = itergts.ticks;
                    if (reversed) {
                        int n2 = this.idx;
                        n = n2;
                        this.idx = n2 - 1;
                    } else {
                        int n3 = this.idx;
                        n = n3;
                        this.idx = n3 + 1;
                    }
                    return lArray[n];
                }

                @Override
                public void remove() {
                }
            };
        }
        return new Iterator<Long>(){
            long bucket;
            {
                this.bucket = reversed ? 0L : (long)(itergts.bucketcount - 1);
            }

            @Override
            public boolean hasNext() {
                return reversed ? this.bucket < (long)itergts.bucketcount : this.bucket >= 0L;
            }

            @Override
            public Long next() {
                long ts = itergts.lastbucket - this.bucket * itergts.bucketspan;
                this.bucket = reversed ? ++this.bucket : --this.bucket;
                return ts;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static final void quicksort(GeoTimeSerie gts, int low, int high, boolean reversed) {
        if (0 == gts.values) {
            return;
        }
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        ranges.add(new int[]{low, high});
        while (!ranges.isEmpty()) {
            int[] range = (int[])ranges.remove(0);
            low = range[0];
            high = range[1];
            int i = low;
            int j = high;
            long pivot = gts.ticks[low + (high - low) / 2];
            while (i <= j) {
                while (!reversed && gts.ticks[i] < pivot || reversed && gts.ticks[i] > pivot) {
                    ++i;
                }
                while (!reversed && gts.ticks[j] > pivot || reversed && gts.ticks[j] < pivot) {
                    --j;
                }
                if (i > j) continue;
                if (i != j) {
                    long tmplong = gts.ticks[i];
                    gts.ticks[i] = gts.ticks[j];
                    gts.ticks[j] = tmplong;
                    if (null != gts.locations) {
                        tmplong = gts.locations[i];
                        gts.locations[i] = gts.locations[j];
                        gts.locations[j] = tmplong;
                    }
                    if (null != gts.elevations) {
                        tmplong = gts.elevations[i];
                        gts.elevations[i] = gts.elevations[j];
                        gts.elevations[j] = tmplong;
                    }
                    if (GeoTimeSerie.TYPE.LONG == gts.type) {
                        tmplong = gts.longValues[i];
                        gts.longValues[i] = gts.longValues[j];
                        gts.longValues[j] = tmplong;
                    } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                        double tmpdouble = gts.doubleValues[i];
                        gts.doubleValues[i] = gts.doubleValues[j];
                        gts.doubleValues[j] = tmpdouble;
                    } else if (GeoTimeSerie.TYPE.STRING == gts.type) {
                        String tmpstring = gts.stringValues[i];
                        gts.stringValues[i] = gts.stringValues[j];
                        gts.stringValues[j] = tmpstring;
                    } else if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
                        boolean tmpboolean = gts.booleanValues.get(i);
                        gts.booleanValues.set(i, gts.booleanValues.get(j));
                        gts.booleanValues.set(j, tmpboolean);
                    }
                }
                ++i;
                --j;
            }
            if (low < j) {
                ranges.add(new int[]{low, j});
            }
            if (i >= high) continue;
            ranges.add(new int[]{i, high});
        }
    }

    private static final void quicksortByValue(GeoTimeSerie gts, int low, int high, boolean reversed) {
        if (0 == gts.values) {
            return;
        }
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        ranges.add(new int[]{low, high});
        while (!ranges.isEmpty()) {
            int[] range = (int[])ranges.remove(0);
            low = range[0];
            high = range[1];
            int i = low;
            int j = high;
            long lpivot = 0L;
            double dpivot = 0.0;
            String spivot = null;
            GeoTimeSerie.TYPE type = gts.getType();
            if (GeoTimeSerie.TYPE.LONG == type) {
                lpivot = gts.longValues[low + (high - low) / 2];
            } else if (GeoTimeSerie.TYPE.DOUBLE == type) {
                dpivot = gts.doubleValues[low + (high - low) / 2];
            } else if (GeoTimeSerie.TYPE.STRING == type) {
                spivot = gts.stringValues[low + (high - low) / 2];
            } else if (GeoTimeSerie.TYPE.BOOLEAN == type) {
                return;
            }
            long pivotTick = gts.ticks[low + (high - low) / 2];
            while (i <= j) {
                long tmplong;
                if (GeoTimeSerie.TYPE.LONG == type) {
                    if (!reversed) {
                        while (gts.longValues[i] < lpivot || gts.longValues[i] == lpivot && gts.ticks[i] < pivotTick) {
                            ++i;
                        }
                        while (gts.longValues[j] > lpivot || gts.longValues[j] == lpivot && gts.ticks[j] > pivotTick) {
                            --j;
                        }
                    } else {
                        while (gts.longValues[i] > lpivot || gts.longValues[i] == lpivot && gts.ticks[i] > pivotTick) {
                            ++i;
                        }
                        while (gts.longValues[j] < lpivot || gts.longValues[j] == lpivot && gts.ticks[j] < pivotTick) {
                            --j;
                        }
                    }
                } else if (GeoTimeSerie.TYPE.DOUBLE == type) {
                    if (!reversed) {
                        while (gts.doubleValues[i] < dpivot || gts.doubleValues[i] == dpivot && gts.ticks[i] < pivotTick) {
                            ++i;
                        }
                        while (gts.doubleValues[j] > dpivot || gts.doubleValues[j] == dpivot && gts.ticks[j] > pivotTick) {
                            --j;
                        }
                    } else {
                        while (gts.doubleValues[i] > dpivot || gts.doubleValues[i] == dpivot && gts.ticks[i] > pivotTick) {
                            ++i;
                        }
                        while (gts.doubleValues[j] < dpivot || gts.doubleValues[j] == dpivot && gts.ticks[j] < pivotTick) {
                            --j;
                        }
                    }
                } else if (GeoTimeSerie.TYPE.STRING == type) {
                    if (!reversed) {
                        while (gts.stringValues[i].compareTo(spivot) < 0 || 0 == gts.stringValues[i].compareTo(spivot) && gts.ticks[i] < pivotTick) {
                            ++i;
                        }
                        while (gts.stringValues[j].compareTo(spivot) > 0 || 0 == gts.stringValues[j].compareTo(spivot) && gts.ticks[j] > pivotTick) {
                            --j;
                        }
                    } else {
                        while (gts.stringValues[i].compareTo(spivot) > 0 || 0 == gts.stringValues[i].compareTo(spivot) && gts.ticks[i] > pivotTick) {
                            ++i;
                        }
                        while (gts.stringValues[j].compareTo(spivot) < 0 || 0 == gts.stringValues[j].compareTo(spivot) && gts.ticks[j] < pivotTick) {
                            --j;
                        }
                    }
                }
                if (i > j) continue;
                if (GeoTimeSerie.TYPE.LONG == gts.type) {
                    tmplong = gts.longValues[i];
                    gts.longValues[i] = gts.longValues[j];
                    gts.longValues[j] = tmplong;
                } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                    double tmpdouble = gts.doubleValues[i];
                    gts.doubleValues[i] = gts.doubleValues[j];
                    gts.doubleValues[j] = tmpdouble;
                } else if (GeoTimeSerie.TYPE.STRING == gts.type) {
                    String tmpstring = gts.stringValues[i];
                    gts.stringValues[i] = gts.stringValues[j];
                    gts.stringValues[j] = tmpstring;
                } else if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
                    boolean tmpboolean = gts.booleanValues.get(i);
                    gts.booleanValues.set(i, gts.booleanValues.get(j));
                    gts.booleanValues.set(j, tmpboolean);
                }
                tmplong = gts.ticks[i];
                gts.ticks[i] = gts.ticks[j];
                gts.ticks[j] = tmplong;
                if (null != gts.locations) {
                    tmplong = gts.locations[i];
                    gts.locations[i] = gts.locations[j];
                    gts.locations[j] = tmplong;
                }
                if (null != gts.elevations) {
                    tmplong = gts.elevations[i];
                    gts.elevations[i] = gts.elevations[j];
                    gts.elevations[j] = tmplong;
                }
                ++i;
                --j;
            }
            if (low < j) {
                ranges.add(new int[]{low, j});
            }
            if (i >= high) continue;
            ranges.add(new int[]{i, high});
        }
    }

    private static final void quicksortByLocation(GeoTimeSerie gts, int low, int high, boolean reversed) {
        if (0 == gts.values) {
            return;
        }
        if (null == gts.locations) {
            return;
        }
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        ranges.add(new int[]{low, high});
        while (!ranges.isEmpty()) {
            int[] range = (int[])ranges.remove(0);
            low = range[0];
            high = range[1];
            int i = low;
            int j = high;
            long pivot = gts.locations[low + (high - low) / 2];
            long pivotTick = gts.ticks[low + (high - low) / 2];
            while (i <= j) {
                long tmplong;
                if (!reversed) {
                    while (pivot != 91480763316633925L && (gts.locations[i] == 91480763316633925L || gts.locations[i] < pivot) || gts.locations[i] == pivot && gts.ticks[i] < pivotTick) {
                        ++i;
                    }
                    while (gts.locations[j] != 91480763316633925L && (pivot == 91480763316633925L || gts.locations[j] > pivot) || gts.locations[j] == pivot && gts.ticks[j] > pivotTick) {
                        --j;
                    }
                } else {
                    while (gts.locations[i] != 91480763316633925L && (pivot == 91480763316633925L || gts.locations[i] > pivot) || gts.locations[i] == pivot && gts.ticks[i] > pivotTick) {
                        ++i;
                    }
                    while (pivot != 91480763316633925L && (gts.locations[j] == 91480763316633925L || gts.locations[j] < pivot) || gts.locations[j] == pivot && gts.ticks[j] < pivotTick) {
                        --j;
                    }
                }
                if (i > j) continue;
                if (GeoTimeSerie.TYPE.LONG == gts.type) {
                    tmplong = gts.longValues[i];
                    gts.longValues[i] = gts.longValues[j];
                    gts.longValues[j] = tmplong;
                } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                    double tmpdouble = gts.doubleValues[i];
                    gts.doubleValues[i] = gts.doubleValues[j];
                    gts.doubleValues[j] = tmpdouble;
                } else if (GeoTimeSerie.TYPE.STRING == gts.type) {
                    String tmpstring = gts.stringValues[i];
                    gts.stringValues[i] = gts.stringValues[j];
                    gts.stringValues[j] = tmpstring;
                } else if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
                    boolean tmpboolean = gts.booleanValues.get(i);
                    gts.booleanValues.set(i, gts.booleanValues.get(j));
                    gts.booleanValues.set(j, tmpboolean);
                }
                tmplong = gts.ticks[i];
                gts.ticks[i] = gts.ticks[j];
                gts.ticks[j] = tmplong;
                if (null != gts.locations) {
                    tmplong = gts.locations[i];
                    gts.locations[i] = gts.locations[j];
                    gts.locations[j] = tmplong;
                }
                if (null != gts.elevations) {
                    tmplong = gts.elevations[i];
                    gts.elevations[i] = gts.elevations[j];
                    gts.elevations[j] = tmplong;
                }
                ++i;
                --j;
            }
            if (low < j) {
                ranges.add(new int[]{low, j});
            }
            if (i >= high) continue;
            ranges.add(new int[]{i, high});
        }
    }

    public static GeoTimeSerie locationSort(GeoTimeSerie gts) {
        gts.sorted = false;
        GTSHelper.quicksortByLocation(gts, 0, gts.values - 1, false);
        return gts;
    }

    public static int compareAllAtTick(GeoTimeSerie gts, int index1, int index2) {
        if (gts.ticks[index1] < gts.ticks[index2]) {
            return -1;
        }
        if (gts.ticks[index1] > gts.ticks[index2]) {
            return 1;
        }
        if (GeoTimeSerie.TYPE.LONG == gts.type) {
            if (gts.longValues[index1] < gts.longValues[index2]) {
                return -1;
            }
            if (gts.longValues[index1] > gts.longValues[index2]) {
                return 1;
            }
        } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
            if (gts.doubleValues[index1] < gts.doubleValues[index2]) {
                return -1;
            }
            if (gts.doubleValues[index1] > gts.doubleValues[index2]) {
                return 1;
            }
        } else {
            if (GeoTimeSerie.TYPE.STRING == gts.type) {
                return gts.stringValues[index1].compareTo(gts.stringValues[index2]);
            }
            if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
                if (!gts.booleanValues.get(index1) && gts.booleanValues.get(index2)) {
                    return -1;
                }
                if (gts.booleanValues.get(index1) && !gts.booleanValues.get(index2)) {
                    return 1;
                }
            }
        }
        if (null != gts.locations) {
            if (gts.locations[index1] < gts.locations[index2]) {
                if (91480763316633925L == gts.locations[index2]) {
                    return 1;
                }
                return -1;
            }
            if (gts.locations[index1] > gts.locations[index2]) {
                if (91480763316633925L == gts.locations[index1]) {
                    return -1;
                }
                return 1;
            }
        }
        if (null != gts.elevations) {
            if (gts.elevations[index1] < gts.elevations[index2]) {
                if (Long.MIN_VALUE == gts.elevations[index2]) {
                    return 1;
                }
                return -1;
            }
            if (gts.elevations[index1] > gts.elevations[index2]) {
                if (Long.MIN_VALUE == gts.elevations[index1]) {
                    return -1;
                }
                return 1;
            }
        }
        return 0;
    }

    private static void fullquicksort(GeoTimeSerie gts, int low, int high, boolean reversed) {
        if (0 == gts.values) {
            return;
        }
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        ranges.add(new int[]{low, high});
        GTSHelper.fullquicksort(gts, ranges, reversed);
    }

    private static void fullquicksort(GeoTimeSerie gts, List<int[]> ranges, boolean reversed) {
        if (0 == gts.values) {
            return;
        }
        while (!ranges.isEmpty()) {
            int reverseComp;
            int[] range = ranges.remove(0);
            int low = range[0];
            int high = range[1];
            int i = low;
            int j = high;
            int pivotIndex = low + (high - low) / 2;
            int n = reverseComp = reversed ? -1 : 1;
            while (i <= j) {
                while (reverseComp * GTSHelper.compareAllAtTick(gts, i, pivotIndex) < 0) {
                    ++i;
                }
                while (reverseComp * GTSHelper.compareAllAtTick(gts, j, pivotIndex) > 0) {
                    --j;
                }
                if (i > j) continue;
                if (i != j) {
                    long tmplong = gts.ticks[i];
                    gts.ticks[i] = gts.ticks[j];
                    gts.ticks[j] = tmplong;
                    if (null != gts.locations) {
                        tmplong = gts.locations[i];
                        gts.locations[i] = gts.locations[j];
                        gts.locations[j] = tmplong;
                    }
                    if (null != gts.elevations) {
                        tmplong = gts.elevations[i];
                        gts.elevations[i] = gts.elevations[j];
                        gts.elevations[j] = tmplong;
                    }
                    if (GeoTimeSerie.TYPE.LONG == gts.type) {
                        tmplong = gts.longValues[i];
                        gts.longValues[i] = gts.longValues[j];
                        gts.longValues[j] = tmplong;
                    } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                        double tmpdouble = gts.doubleValues[i];
                        gts.doubleValues[i] = gts.doubleValues[j];
                        gts.doubleValues[j] = tmpdouble;
                    } else if (GeoTimeSerie.TYPE.STRING == gts.type) {
                        String tmpstring = gts.stringValues[i];
                        gts.stringValues[i] = gts.stringValues[j];
                        gts.stringValues[j] = tmpstring;
                    } else if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
                        boolean tmpboolean = gts.booleanValues.get(i);
                        gts.booleanValues.set(i, gts.booleanValues.get(j));
                        gts.booleanValues.set(j, tmpboolean);
                    }
                    if (pivotIndex == i) {
                        pivotIndex = j;
                    } else if (pivotIndex == j) {
                        pivotIndex = i;
                    }
                }
                ++i;
                --j;
            }
            if (low < j) {
                ranges.add(new int[]{low, j});
            }
            if (i >= high) continue;
            ranges.add(new int[]{i, high});
        }
    }

    public static long tickAtIndex(GeoTimeSerie gts, int idx) {
        if (0 > idx || idx >= gts.values) {
            return Long.MIN_VALUE;
        }
        return gts.ticks[idx];
    }

    public static List<Long> tickList(GeoTimeSerie gts) {
        ArrayList<Long> ticks = new ArrayList<Long>(gts.values);
        if (gts.values > 0) {
            ticks.addAll(Arrays.asList(ArrayUtils.toObject((long[])Arrays.copyOf(gts.ticks, gts.values))));
        }
        return ticks;
    }

    public static int indexAtTick(GeoTimeSerie gts, long tick) {
        if (0 == gts.values) {
            return -1;
        }
        GTSHelper.sort(gts, false);
        int idx = Arrays.binarySearch(gts.ticks, 0, gts.values, tick);
        if (idx < 0) {
            return -1;
        }
        return idx;
    }

    public static Object valueAtTick(GeoTimeSerie gts, long tick) {
        if (0 == gts.values) {
            return null;
        }
        GTSHelper.sort(gts, false);
        int idx = Arrays.binarySearch(gts.ticks, 0, gts.values, tick);
        if (idx < 0) {
            return null;
        }
        if (GeoTimeSerie.TYPE.LONG == gts.type) {
            return gts.longValues[idx];
        }
        if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
            return gts.doubleValues[idx];
        }
        if (GeoTimeSerie.TYPE.STRING == gts.type) {
            return gts.stringValues[idx];
        }
        if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
            return gts.booleanValues.get(idx);
        }
        return null;
    }

    public static Object valueAtIndex(GeoTimeSerie gts, int idx) {
        if (idx >= gts.values) {
            return null;
        }
        if (GeoTimeSerie.TYPE.LONG == gts.type) {
            return gts.longValues[idx];
        }
        if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
            return gts.doubleValues[idx];
        }
        if (GeoTimeSerie.TYPE.STRING == gts.type) {
            return gts.stringValues[idx];
        }
        if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
            return gts.booleanValues.get(idx);
        }
        return null;
    }

    public static long locationAtTick(GeoTimeSerie gts, long tick) {
        if (null == gts.locations) {
            return 91480763316633925L;
        }
        GTSHelper.sort(gts, false);
        int idx = Arrays.binarySearch(gts.ticks, 0, gts.values, tick);
        if (idx < 0) {
            return 91480763316633925L;
        }
        return gts.locations[idx];
    }

    public static long locationAtIndex(GeoTimeSerie gts, int idx) {
        if (null == gts.locations || 0 > idx || idx >= gts.values) {
            return 91480763316633925L;
        }
        return gts.locations[idx];
    }

    public static void setLocationAtIndex(GeoTimeSerie gts, int idx, long location) {
        if (idx >= gts.values) {
            return;
        }
        if (null != gts.locations) {
            gts.locations[idx] = location;
        } else if (91480763316633925L != location) {
            gts.locations = new long[gts.values];
            Arrays.fill(gts.locations, 91480763316633925L);
            gts.locations[idx] = location;
        }
    }

    public static long elevationAtTick(GeoTimeSerie gts, long tick) {
        if (null == gts.elevations) {
            return Long.MIN_VALUE;
        }
        GTSHelper.sort(gts, false);
        int idx = Arrays.binarySearch(gts.ticks, 0, gts.values, tick);
        if (idx < 0) {
            return Long.MIN_VALUE;
        }
        return gts.elevations[idx];
    }

    public static void setElevationAtIndex(GeoTimeSerie gts, int idx, long elevation) {
        if (idx >= gts.values) {
            return;
        }
        if (null != gts.elevations) {
            gts.elevations[idx] = elevation;
        } else if (Long.MIN_VALUE != elevation) {
            gts.elevations = new long[gts.values];
            Arrays.fill(gts.elevations, Long.MIN_VALUE);
            gts.elevations[idx] = elevation;
        }
    }

    public static long elevationAtIndex(GeoTimeSerie gts, int idx) {
        if (null == gts.elevations || 0 > idx || idx >= gts.values) {
            return Long.MIN_VALUE;
        }
        return gts.elevations[idx];
    }

    public static void removeValue(GeoTimeSerie gts, long timestamp, boolean all) {
        GeoTimeSerie altered = gts.cloneEmpty(gts.values);
        int todelete = Integer.MAX_VALUE;
        if (all) {
            todelete = 1;
        }
        for (int i = 0; i < gts.values; ++i) {
            if (todelete > 1 && timestamp == gts.ticks[i]) {
                --todelete;
                continue;
            }
            GTSHelper.setValue(altered, gts.ticks[i], GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), GTSHelper.valueAtIndex(gts, i), false);
        }
    }

    public static final int setValue(GeoTimeSerie gts, long timestamp, long geoxppoint, long elevation, Object value, boolean overwrite) {
        int idx;
        block62: {
            block63: {
                if (null == value) {
                    return gts.values;
                }
                if (value instanceof byte[]) {
                    value = new String((byte[])value, StandardCharsets.ISO_8859_1);
                }
                idx = gts.values;
                if (!overwrite) break block62;
                if (!gts.sorted) break block63;
                int possibleIndex = GTSHelper.binarySearchTick(gts, timestamp, BinarySearchTickChoice.FIRST);
                if (0 > possibleIndex) break block62;
                idx = possibleIndex;
                break block62;
            }
            for (int i = 0; i < gts.values; ++i) {
                if (timestamp != gts.ticks[i]) continue;
                idx = i;
                break;
            }
        }
        if (gts.values == idx) {
            if (2 > gts.values) {
                if (0 == gts.values) {
                    gts.sorted = true;
                    gts.reversed = false;
                } else {
                    gts.sorted = true;
                    gts.reversed = gts.ticks[0] > timestamp;
                }
            } else if (gts.sorted) {
                if (gts.reversed) {
                    gts.sorted = gts.ticks[gts.values - 1] >= timestamp;
                } else {
                    boolean bl = gts.sorted = gts.ticks[gts.values - 1] <= timestamp;
                }
            }
            if (GeoTimeSerie.TYPE.UNDEFINED == gts.type || null == gts.ticks || gts.values >= gts.ticks.length || null == gts.locations && 91480763316633925L != geoxppoint || null == gts.elevations && Long.MIN_VALUE != elevation) {
                GTSHelper.provision(gts, value, geoxppoint, elevation);
            }
        } else if (null == gts.locations && 91480763316633925L != geoxppoint || null == gts.elevations && Long.MIN_VALUE != elevation) {
            GTSHelper.provision(gts, value, geoxppoint, elevation);
        }
        gts.ticks[idx] = timestamp;
        if (null != gts.locations) {
            gts.locations[idx] = geoxppoint;
        }
        if (null != gts.elevations) {
            gts.elevations[idx] = elevation;
        }
        if (value instanceof Boolean) {
            if (GeoTimeSerie.TYPE.LONG == gts.type) {
                gts.longValues[idx] = (Boolean)value != false ? 1L : 0L;
            } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                gts.doubleValues[idx] = (Boolean)value != false ? 1.0 : 0.0;
            } else if (GeoTimeSerie.TYPE.STRING == gts.type) {
                gts.stringValues[idx] = (Boolean)value != false ? "T" : "F";
            } else if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
                gts.booleanValues.set(idx, (Boolean)value);
            }
        } else if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof BigInteger) {
            if (GeoTimeSerie.TYPE.LONG == gts.type) {
                gts.longValues[idx] = ((Number)value).longValue();
            } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                gts.doubleValues[idx] = ((Number)value).doubleValue();
            } else if (GeoTimeSerie.TYPE.STRING == gts.type) {
                gts.stringValues[idx] = ((Number)value).toString();
            } else if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
                gts.booleanValues.set(idx, 0L != ((Number)value).longValue());
            }
        } else if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
            if (GeoTimeSerie.TYPE.LONG == gts.type) {
                gts.longValues[idx] = ((Number)value).longValue();
            } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                gts.doubleValues[idx] = ((Number)value).doubleValue();
            } else if (GeoTimeSerie.TYPE.STRING == gts.type) {
                gts.stringValues[idx] = value.toString();
            } else if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
                gts.booleanValues.set(idx, 0.0 != ((Number)value).doubleValue());
            }
        } else if (value instanceof String) {
            if (GeoTimeSerie.TYPE.LONG == gts.type) {
                try {
                    gts.longValues[idx] = Long.parseLong((String)value);
                }
                catch (NumberFormatException nfe) {
                    try {
                        gts.longValues[idx] = (long)Double.parseDouble((String)value);
                    }
                    catch (NumberFormatException nfe2) {
                        gts.longValues[idx] = 0L;
                    }
                }
            } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                try {
                    gts.doubleValues[idx] = Double.parseDouble((String)value);
                }
                catch (NumberFormatException nfe) {
                    try {
                        gts.doubleValues[idx] = Long.parseLong((String)value);
                    }
                    catch (NumberFormatException nfe2) {
                        gts.doubleValues[idx] = 0.0;
                    }
                }
            } else if (GeoTimeSerie.TYPE.STRING == gts.type) {
                gts.stringValues[idx] = (String)value;
            } else if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
                gts.booleanValues.set(idx, !"".equals(value));
            }
        } else {
            return gts.values;
        }
        if (gts.values == idx) {
            ++gts.values;
        }
        return gts.values;
    }

    public static final int setValue(GeoTimeSerie gts, long timestamp, long geoxppoint, Object value) {
        return GTSHelper.setValue(gts, timestamp, geoxppoint, Long.MIN_VALUE, value, false);
    }

    public static final int setValue(GeoTimeSerie gts, long timestamp, Object value) {
        return GTSHelper.setValue(gts, timestamp, 91480763316633925L, Long.MIN_VALUE, value, false);
    }

    private static final void provision(GeoTimeSerie gts, Object value, long location, long elevation) {
        if (GeoTimeSerie.TYPE.UNDEFINED != gts.type && gts.values < gts.ticks.length) {
            if (91480763316633925L == location && Long.MIN_VALUE == elevation) {
                return;
            }
            if (null == gts.locations && 91480763316633925L != location) {
                gts.locations = new long[gts.ticks.length];
                Arrays.fill(gts.locations, 91480763316633925L);
            }
            if (null == gts.elevations && Long.MIN_VALUE != elevation) {
                gts.elevations = new long[gts.ticks.length];
                Arrays.fill(gts.elevations, Long.MIN_VALUE);
            }
        } else if (GeoTimeSerie.TYPE.UNDEFINED != gts.type) {
            int newlen = gts.ticks.length + (int)Math.min(32768.0f, Math.max(64.0f, (float)gts.ticks.length * 0.2f));
            if (newlen < gts.sizehint) {
                newlen = gts.sizehint;
            }
            gts.ticks = Arrays.copyOf(gts.ticks, newlen);
            if (null != gts.locations || 91480763316633925L != location) {
                if (null == gts.locations) {
                    gts.locations = new long[gts.ticks.length];
                    Arrays.fill(gts.locations, 91480763316633925L);
                } else {
                    gts.locations = Arrays.copyOf(gts.locations, gts.ticks.length);
                }
            }
            if (null != gts.elevations || Long.MIN_VALUE != elevation) {
                if (null == gts.elevations) {
                    gts.elevations = new long[gts.ticks.length];
                    Arrays.fill(gts.elevations, Long.MIN_VALUE);
                } else {
                    gts.elevations = Arrays.copyOf(gts.elevations, gts.ticks.length);
                }
            }
            if (GeoTimeSerie.TYPE.LONG == gts.type) {
                gts.longValues = Arrays.copyOf(gts.longValues, gts.ticks.length);
            } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                gts.doubleValues = Arrays.copyOf(gts.doubleValues, gts.ticks.length);
            } else if (GeoTimeSerie.TYPE.STRING == gts.type) {
                gts.stringValues = Arrays.copyOf(gts.stringValues, gts.ticks.length);
            }
        } else {
            if (null == gts.ticks) {
                gts.ticks = new long[gts.sizehint > 0 ? gts.sizehint : 64];
            }
            if (91480763316633925L == location) {
                gts.locations = null;
            } else if (null == gts.locations || gts.locations.length < gts.ticks.length) {
                gts.locations = new long[gts.ticks.length];
            }
            if (Long.MIN_VALUE == elevation) {
                gts.elevations = null;
            } else if (null == gts.elevations || gts.elevations.length < gts.ticks.length) {
                gts.elevations = new long[gts.ticks.length];
            }
            if (value instanceof Boolean) {
                gts.type = GeoTimeSerie.TYPE.BOOLEAN;
                if (null == gts.booleanValues) {
                    gts.booleanValues = new BitSet(gts.ticks.length);
                }
            } else if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof BigInteger) {
                gts.type = GeoTimeSerie.TYPE.LONG;
                if (null == gts.longValues || gts.longValues.length < gts.ticks.length) {
                    gts.longValues = new long[gts.ticks.length];
                }
            } else if (value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
                gts.type = GeoTimeSerie.TYPE.DOUBLE;
                if (null == gts.doubleValues || gts.doubleValues.length < gts.ticks.length) {
                    gts.doubleValues = new double[gts.ticks.length];
                }
            } else if (value instanceof String) {
                gts.type = GeoTimeSerie.TYPE.STRING;
                if (null == gts.stringValues || gts.stringValues.length < gts.ticks.length) {
                    gts.stringValues = new String[gts.ticks.length];
                }
            } else {
                gts.type = GeoTimeSerie.TYPE.BOOLEAN;
                gts.booleanValues = new BitSet(gts.ticks.length);
            }
        }
    }

    public static final void multiProvision(GeoTimeSerie gts, GeoTimeSerie.TYPE fallbackType, int numberOfValuesToAdd, int provisionSize) {
        if (0 < numberOfValuesToAdd) {
            int newSize = gts.values + provisionSize;
            if (null == gts.ticks) {
                gts.ticks = new long[newSize];
                if (GeoTimeSerie.TYPE.UNDEFINED != gts.type) {
                    if (GeoTimeSerie.TYPE.LONG == gts.type) {
                        gts.longValues = new long[newSize];
                    } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                        gts.doubleValues = new double[newSize];
                    } else if (GeoTimeSerie.TYPE.STRING == gts.type) {
                        gts.stringValues = new String[newSize];
                    } else if (GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
                        gts.booleanValues = new BitSet();
                    }
                } else if (GeoTimeSerie.TYPE.LONG == fallbackType) {
                    gts.longValues = new long[newSize];
                } else if (GeoTimeSerie.TYPE.DOUBLE == fallbackType) {
                    gts.doubleValues = new double[newSize];
                } else if (GeoTimeSerie.TYPE.STRING == fallbackType) {
                    gts.stringValues = new String[newSize];
                } else {
                    gts.booleanValues = new BitSet();
                }
            } else if (gts.ticks.length < gts.size() + numberOfValuesToAdd) {
                gts.ticks = Arrays.copyOf(gts.ticks, newSize);
                if (GeoTimeSerie.TYPE.LONG == gts.type) {
                    gts.longValues = Arrays.copyOf(gts.longValues, newSize);
                } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
                    gts.doubleValues = Arrays.copyOf(gts.doubleValues, newSize);
                } else if (GeoTimeSerie.TYPE.STRING == gts.type) {
                    gts.stringValues = Arrays.copyOf(gts.stringValues, newSize);
                }
                if (null != gts.locations) {
                    gts.locations = Arrays.copyOf(gts.locations, newSize);
                }
                if (null != gts.elevations) {
                    gts.elevations = Arrays.copyOf(gts.elevations, newSize);
                }
            }
        }
    }

    public static final GeoTimeSerie subSerie(GeoTimeSerie gts, long starttimestamp, long stoptimestamp, boolean overwrite, boolean copyLabels, GeoTimeSerie subgts) {
        if (null == subgts) {
            subgts = new GeoTimeSerie(gts.sizehint);
            subgts.setName(gts.getName());
            if (copyLabels) {
                subgts.setLabels(gts.getLabels());
                subgts.getMetadata().setAttributes(new HashMap<String, String>(gts.getMetadata().getAttributes()));
            }
        } else {
            GTSHelper.reset(subgts);
        }
        if (null == gts.ticks || 0 == gts.values) {
            return subgts;
        }
        if (starttimestamp > stoptimestamp) {
            return subgts;
        }
        GTSHelper.sort(gts);
        int lastidx = Arrays.binarySearch(gts.ticks, 0, gts.values, stoptimestamp);
        if (-1 == lastidx) {
            return subgts;
        }
        if (lastidx < 0) {
            lastidx = -lastidx - 1 - 1;
        } else if (lastidx < gts.values - 1) {
            int lastlastidx;
            for (lastlastidx = lastidx + 1; lastlastidx < gts.values && stoptimestamp == gts.ticks[lastlastidx]; ++lastlastidx) {
            }
            lastidx = lastlastidx - 1;
        }
        int firstidx = Arrays.binarySearch(gts.ticks, 0, lastidx + 1, starttimestamp);
        if (-gts.values - 1 == firstidx) {
            return subgts;
        }
        if (firstidx < 0) {
            firstidx = -firstidx - 1;
        } else if (firstidx > 0) {
            int firstfirstidx;
            for (firstfirstidx = firstidx - 1; firstfirstidx >= 0 && starttimestamp == gts.ticks[firstfirstidx]; --firstfirstidx) {
            }
            firstidx = firstfirstidx + 1;
        }
        int count = lastidx - firstidx + 1;
        GTSHelper.multiProvision(subgts, gts.type, count, count);
        if (!overwrite) {
            if (count > 0) {
                if (null != gts.locations) {
                    if (null != subgts.locations && subgts.locations.length >= count) {
                        System.arraycopy(gts.locations, firstidx, subgts.locations, 0, count);
                    } else {
                        subgts.locations = new long[count];
                        System.arraycopy(gts.locations, firstidx, subgts.locations, 0, count);
                    }
                } else {
                    subgts.locations = null;
                }
                if (null != gts.elevations) {
                    if (null != subgts.elevations && subgts.elevations.length >= count) {
                        System.arraycopy(gts.elevations, firstidx, subgts.elevations, 0, count);
                    } else {
                        subgts.elevations = new long[count];
                        System.arraycopy(gts.elevations, firstidx, subgts.elevations, 0, count);
                    }
                } else {
                    subgts.elevations = null;
                }
                if (null != subgts.ticks) {
                    System.arraycopy(gts.ticks, firstidx, subgts.ticks, 0, count);
                }
                switch (gts.type) {
                    case LONG: {
                        subgts.type = GeoTimeSerie.TYPE.LONG;
                        if (null == subgts.longValues || subgts.longValues.length < count) {
                            subgts.longValues = new long[count];
                        }
                        System.arraycopy(gts.longValues, firstidx, subgts.longValues, 0, count);
                        break;
                    }
                    case DOUBLE: {
                        subgts.type = GeoTimeSerie.TYPE.DOUBLE;
                        if (null == subgts.doubleValues || subgts.doubleValues.length < count) {
                            subgts.doubleValues = new double[count];
                        }
                        System.arraycopy(gts.doubleValues, firstidx, subgts.doubleValues, 0, count);
                        break;
                    }
                    case BOOLEAN: {
                        subgts.type = GeoTimeSerie.TYPE.BOOLEAN;
                        if (null == subgts.booleanValues) {
                            subgts.booleanValues = new BitSet(count);
                        }
                        subgts.booleanValues = gts.booleanValues.get(firstidx, lastidx + 1);
                        break;
                    }
                    case STRING: {
                        subgts.type = GeoTimeSerie.TYPE.STRING;
                        if (null == subgts.stringValues || subgts.stringValues.length < count) {
                            subgts.stringValues = new String[count];
                        }
                        System.arraycopy(gts.stringValues, firstidx, subgts.stringValues, 0, count);
                    }
                }
            }
            subgts.values = count;
            subgts.sorted = gts.sorted;
            subgts.reversed = gts.reversed;
        } else {
            for (int i = firstidx; i <= lastidx; ++i) {
                GTSHelper.setValue(subgts, gts.ticks[i], null != gts.locations ? gts.locations[i] : 91480763316633925L, null != gts.elevations ? gts.elevations[i] : Long.MIN_VALUE, GTSHelper.valueAtIndex(gts, i), overwrite);
            }
        }
        return subgts;
    }

    public static final GeoTimeSerie subSerie(GeoTimeSerie gts, long starttimestamp, long stoptimestamp, boolean overwrite) {
        return GTSHelper.subSerie(gts, starttimestamp, stoptimestamp, overwrite, true, null);
    }

    public static final GeoTimeSerie subCycleSerie(GeoTimeSerie gts, long lastbucket, int buckets_per_period, boolean overwrite, GeoTimeSerie subgts) throws WarpScriptException {
        if (!GTSHelper.isBucketized(gts)) {
            throw new WarpScriptException("GTS must be bucketized");
        }
        if (0L != (gts.lastbucket - lastbucket) % gts.bucketspan) {
            throw new WarpScriptException("lasbucket parameter of subCycleSerie method must fall on an actual bucket of the gts input");
        }
        if (null == subgts) {
            subgts = new GeoTimeSerie(lastbucket, (gts.bucketcount - (int)((gts.lastbucket - lastbucket) / gts.bucketspan) - 1) / buckets_per_period + 1, gts.bucketspan * (long)buckets_per_period, (int)Math.max(1.4 * (double)gts.bucketcount, (double)gts.sizehint) / buckets_per_period);
        } else {
            subgts.values = 0;
            subgts.type = GeoTimeSerie.TYPE.UNDEFINED;
            subgts.lastbucket = lastbucket;
            subgts.bucketcount = (gts.bucketcount - (int)((gts.lastbucket - lastbucket) / gts.bucketspan) - 1) / buckets_per_period + 1;
            subgts.bucketspan = gts.bucketspan * (long)buckets_per_period;
        }
        if (null == gts.ticks || 0 == gts.values) {
            return subgts;
        }
        Iterator<Long> iter = GTSHelper.tickIterator(subgts, true);
        GTSHelper.sort(gts);
        int i = gts.values;
        while (iter.hasNext()) {
            long tick = iter.next();
            int j = Arrays.binarySearch(gts.ticks, 0, i, tick);
            if (j < 0) continue;
            GTSHelper.setValue(subgts, tick, null != gts.locations ? gts.locations[j] : 91480763316633925L, null != gts.elevations ? gts.elevations[j] : Long.MIN_VALUE, GTSHelper.valueAtIndex(gts, j), overwrite);
            i = j;
        }
        return subgts;
    }

    public static final GeoTimeSerie subCycleSerie(GeoTimeSerie gts, long lastbucket, int buckets_per_period, boolean overwrite) throws WarpScriptException {
        return GTSHelper.subCycleSerie(gts, lastbucket, buckets_per_period, overwrite, null);
    }

    private static final void copyToSubGts(GeoTimeSerie srcGts, int srcPos, GeoTimeSerie subGts, int length) {
        if (srcGts.type != subGts.type) {
            throw new RuntimeException("Cannot copy data, both gts do not have the same type.");
        }
        if (null == subGts.ticks || subGts.ticks.length < length) {
            subGts.ticks = new long[length];
        }
        System.arraycopy(srcGts.ticks, srcPos, subGts.ticks, 0, length);
        if (null != srcGts.locations) {
            if (null == subGts.locations || subGts.locations.length < length) {
                subGts.locations = new long[length];
            }
            System.arraycopy(srcGts.locations, srcPos, subGts.locations, 0, length);
        }
        if (null != srcGts.elevations) {
            if (null == subGts.elevations || subGts.elevations.length < length) {
                subGts.elevations = new long[length];
            }
            System.arraycopy(srcGts.elevations, srcPos, subGts.elevations, 0, length);
        }
        switch (srcGts.type) {
            case LONG: {
                if (null == subGts.longValues || subGts.longValues.length < length) {
                    subGts.longValues = new long[length];
                }
                System.arraycopy(srcGts.longValues, srcPos, subGts.longValues, 0, length);
                break;
            }
            case DOUBLE: {
                if (null == subGts.doubleValues || subGts.doubleValues.length < length) {
                    subGts.doubleValues = new double[length];
                }
                System.arraycopy(srcGts.doubleValues, srcPos, subGts.doubleValues, 0, length);
                break;
            }
            case STRING: {
                if (null == subGts.stringValues || subGts.stringValues.length < length) {
                    subGts.stringValues = new String[length];
                }
                System.arraycopy(srcGts.stringValues, srcPos, subGts.stringValues, 0, length);
                break;
            }
            case BOOLEAN: {
                subGts.booleanValues = srcGts.booleanValues.get(srcPos, srcPos + length);
            }
        }
        subGts.values = length;
    }

    public static final GeoTimeSerie bucketize(GeoTimeSerie gts, long bucketspan, int bucketcount, long lastbucket, WarpScriptBucketizerFunction aggregator, long maxbuckets) throws WarpScriptException {
        return GTSHelper.bucketize(gts, bucketspan, bucketcount, lastbucket, aggregator, maxbuckets, null);
    }

    public static final GeoTimeSerie bucketize(GeoTimeSerie gts, long bucketspan, int bucketcount, long lastbucket, Object aggregator, long maxbuckets, WarpScriptStack stack) throws WarpScriptException {
        int i;
        long delta;
        boolean zeroBucketcount;
        long lasttick = GTSHelper.lasttick(gts);
        long firsttick = GTSHelper.firsttick(gts);
        boolean zeroLastBucket = 0L == lastbucket;
        boolean bl = zeroBucketcount = 0 == bucketcount;
        if (0L == lastbucket) {
            lastbucket = lasttick;
        }
        if (0L == bucketspan || -1L == bucketspan) {
            if (0 == bucketcount) {
                throw new WarpScriptException("One of bucketspan or bucketcount must be different from zero.");
            }
            if (lastbucket >= firsttick) {
                if (0L == bucketspan) {
                    delta = lastbucket - firsttick + 1L;
                    bucketspan = delta / (long)bucketcount;
                } else {
                    delta = lastbucket - firsttick;
                    bucketspan = 1 == bucketcount ? delta : delta / (long)(bucketcount - 1);
                }
                if (0L == bucketspan || delta % bucketspan != 0L) {
                    ++bucketspan;
                }
            }
        }
        if (bucketspan < 0L) {
            bucketspan = 0L;
        }
        if (0 == bucketcount && lastbucket >= firsttick) {
            delta = lastbucket - firsttick;
            bucketcount = delta < bucketspan ? 1 : 1 + (int)(delta / bucketspan);
        }
        if (zeroLastBucket && zeroBucketcount && 0L != lastbucket % bucketspan && (lastbucket = lastbucket - lastbucket % bucketspan + bucketspan) - (long)bucketcount * bucketspan >= firsttick) {
            ++bucketcount;
        }
        if (bucketcount < 0 || (long)bucketcount > maxbuckets) {
            throw new WarpScriptException("Bucket count (" + bucketcount + ") would exceed maximum value of " + maxbuckets + ". Consider raising the limit or using capabilities.");
        }
        if (0L == bucketspan) {
            throw new WarpScriptException("Undefined bucket span, check your GTS timestamps.");
        }
        if (null == aggregator) {
            gts.lastbucket = lastbucket;
            gts.bucketcount = bucketcount;
            gts.bucketspan = bucketspan;
            return gts;
        }
        int hint = Math.min(gts.values, (int)((lasttick - firsttick) / bucketspan));
        GeoTimeSerie bucketized = new GeoTimeSerie(lastbucket, bucketcount, bucketspan, hint);
        bucketized.setMetadata(new Metadata(gts.getMetadata()));
        Map<String, String> labels = gts.getLabels();
        if (gts.values == 0 || firsttick > lastbucket || lasttick < lastbucket - bucketspan * (long)bucketcount + 1L) {
            return bucketized;
        }
        GTSHelper.sort(gts);
        if (lastbucket > lasttick) {
            i = gts.size() - 1;
        } else {
            i = Arrays.binarySearch(gts.ticks, 0, gts.values, lastbucket);
            if (-1 == i) {
                return bucketized;
            }
            if (i < 0) {
                i = -i - 1 - 1;
            }
        }
        if (null != stack) {
            if (!(aggregator instanceof WarpScriptStack.Macro)) {
                throw new WarpScriptException("Expected a macro as bucketizer.");
            }
            GeoTimeSerie subgts = new GeoTimeSerie(1);
            subgts.safeSetMetadata(bucketized.getMetadata());
            subgts.type = gts.type;
            subgts.sorted = true;
            subgts.reversed = false;
            Object[] aggregated = null;
            while (i >= 0 && gts.ticks[i] > lastbucket - bucketspan * (long)bucketcount) {
                int currentBucketEndPosition = i;
                long currentBucketEnd = gts.ticks[i] + (lastbucket - gts.ticks[i]) % bucketspan;
                while (i >= 0 && gts.ticks[i] > currentBucketEnd - bucketspan) {
                    --i;
                }
                int currentBucketStartPosition = i + 1;
                int count = currentBucketEndPosition - currentBucketStartPosition + 1;
                GTSHelper.copyToSubGts(gts, currentBucketStartPosition, subgts, count);
                stack.push(subgts);
                stack.exec((WarpScriptStack.Macro)aggregator);
                Object res = stack.peek();
                if (res instanceof List) {
                    if (null == ((List)res).get(((List)res).size() - 1)) continue;
                    aggregated = MACROMAPPER.listToObjects((List)stack.pop());
                    GTSHelper.setValue(bucketized, currentBucketEnd, (Long)aggregated[1], (Long)aggregated[2], aggregated[3], false);
                    continue;
                }
                if (null == res) continue;
                aggregated = MACROMAPPER.stackToObjects(stack);
                GTSHelper.setValue(bucketized, currentBucketEnd, (Long)aggregated[1], (Long)aggregated[2], aggregated[3], false);
            }
        } else {
            if (!(aggregator instanceof WarpScriptBucketizerFunction)) {
                throw new WarpScriptException("Invalid bucketizer function.");
            }
            if (aggregator instanceof WarpScriptAggregatorOnListsFunction) {
                Object[] parms = new Object[8];
                parms[1] = new ArrayList();
                ((ArrayList)parms[1]).add(bucketized.getName());
                parms[2] = new ArrayList();
                ((ArrayList)parms[2]).add(labels);
                Object[] aggregated = null;
                while (i >= 0 && gts.ticks[i] > lastbucket - bucketspan * (long)bucketcount) {
                    int currentBucketEndPosition = i;
                    long currentBucketEnd = gts.ticks[i] + (lastbucket - gts.ticks[i]) % bucketspan;
                    while (i >= 0 && gts.ticks[i] > currentBucketEnd - bucketspan) {
                        --i;
                    }
                    int currentBucketStartPosition = i + 1;
                    int count = currentBucketEndPosition - currentBucketStartPosition + 1;
                    parms[0] = currentBucketEnd;
                    parms[3] = new COWList(gts.ticks, currentBucketStartPosition, count);
                    parms[4] = null != gts.locations ? new COWList(gts.locations, currentBucketStartPosition, count) : null;
                    parms[5] = null != gts.elevations ? new COWList(gts.elevations, currentBucketStartPosition, count) : null;
                    switch (gts.type) {
                        case LONG: {
                            parms[6] = new COWList(gts.longValues, currentBucketStartPosition, count);
                            break;
                        }
                        case DOUBLE: {
                            parms[6] = new COWList(gts.doubleValues, currentBucketStartPosition, count);
                            break;
                        }
                        case STRING: {
                            parms[6] = new COWList(gts.stringValues, currentBucketStartPosition, count);
                            break;
                        }
                        case BOOLEAN: {
                            parms[6] = new COWList(gts.booleanValues, currentBucketStartPosition, count);
                        }
                    }
                    ArrayList<Long> lastParms = new ArrayList<Long>(4);
                    lastParms.add(0L);
                    lastParms.add(-bucketspan);
                    lastParms.add(currentBucketEnd - bucketspan);
                    lastParms.add(currentBucketEnd);
                    parms[7] = lastParms;
                    aggregated = (Object[])((WarpScriptAggregatorOnListsFunction)aggregator).applyOnSubLists(parms);
                    if (null == aggregated[3]) continue;
                    GTSHelper.setValue(bucketized, currentBucketEnd, (Long)aggregated[1], (Long)aggregated[2], aggregated[3], false);
                }
            } else {
                Object[] parms = new Object[8];
                parms[1] = new String[1];
                ((String[])parms[1])[0] = bucketized.getName();
                parms[2] = new Map[1];
                ((Map[])parms[2])[0] = labels;
                Object[] aggregated = null;
                Double[] nanArray = new Double[]{Double.NaN};
                List<Double> nanList = Arrays.asList(nanArray);
                while (i >= 0 && gts.ticks[i] > lastbucket - bucketspan * (long)bucketcount) {
                    int currentBucketEndPosition = i;
                    long currentBucketEnd = gts.ticks[i] + (lastbucket - gts.ticks[i]) % bucketspan;
                    while (i >= 0 && gts.ticks[i] > currentBucketEnd - bucketspan) {
                        --i;
                    }
                    int currentBucketStartPosition = i + 1;
                    int count = currentBucketEndPosition - currentBucketStartPosition + 1;
                    parms[0] = currentBucketEnd;
                    parms[3] = Arrays.copyOfRange(gts.ticks, currentBucketStartPosition, currentBucketEndPosition + 1);
                    if (null != gts.locations) {
                        parms[4] = Arrays.copyOfRange(gts.locations, currentBucketStartPosition, currentBucketEndPosition + 1);
                    } else {
                        parms[4] = new long[count];
                        Arrays.fill((long[])parms[4], 91480763316633925L);
                    }
                    if (null != gts.elevations) {
                        parms[5] = Arrays.copyOfRange(gts.elevations, currentBucketStartPosition, currentBucketEndPosition + 1);
                    } else {
                        parms[5] = new long[count];
                        Arrays.fill((long[])parms[5], Long.MIN_VALUE);
                    }
                    parms[6] = new Object[count];
                    switch (gts.type) {
                        case LONG: {
                            int k;
                            for (k = 0; k < count; ++k) {
                                ((Object[])parms[6])[k] = gts.longValues[currentBucketStartPosition + k];
                            }
                            break;
                        }
                        case DOUBLE: {
                            int k;
                            for (k = 0; k < count; ++k) {
                                ((Object[])parms[6])[k] = gts.doubleValues[currentBucketStartPosition + k];
                            }
                            break;
                        }
                        case STRING: {
                            int k;
                            for (k = 0; k < count; ++k) {
                                ((Object[])parms[6])[k] = gts.stringValues[currentBucketStartPosition + k];
                            }
                            break;
                        }
                        case BOOLEAN: {
                            int k;
                            for (k = 0; k < count; ++k) {
                                ((Object[])parms[6])[k] = gts.booleanValues.get(currentBucketStartPosition + k);
                            }
                            break;
                        }
                    }
                    parms[7] = new long[]{0L, -bucketspan, currentBucketEnd - bucketspan, currentBucketEnd};
                    aggregated = (Object[])((WarpScriptBucketizerFunction)aggregator).apply(parms);
                    if (null == aggregated[3]) continue;
                    GTSHelper.setValue(bucketized, currentBucketEnd, (Long)aggregated[1], (Long)aggregated[2], aggregated[3], false);
                }
            }
        }
        GTSHelper.shrink(bucketized);
        bucketized.sorted = true;
        bucketized.reversed = true;
        return bucketized;
    }

    public static void unbucketize(GeoTimeSerie gts) {
        gts.bucketcount = 0;
        gts.bucketspan = 0L;
        gts.lastbucket = 0L;
    }

    public static GTSEncoder parse_regexp(GTSEncoder encoder, String str, Map<String, String> extraLabels) throws ParseException, IOException {
        long timestamp;
        Matcher matcher = MEASUREMENT_RE.matcher(str);
        if (!matcher.matches()) {
            throw new ParseException(str, 0);
        }
        String name = matcher.group(6);
        if (name.contains("%")) {
            try {
                name = URLDecoder.decode(name, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        Map<String, String> labels = GTSHelper.parseLabels(matcher.group(7));
        if (null != extraLabels) {
            labels.putAll(extraLabels);
        }
        long location = 91480763316633925L;
        long elevation = Long.MIN_VALUE;
        try {
            timestamp = null != matcher.group(1) ? Long.parseLong(matcher.group(1)) : TimeSource.getTime();
            if (null != matcher.group(2)) {
                location = GeoXPLib.toGeoXPPoint((double)Double.parseDouble(matcher.group(3)), (double)Double.parseDouble(matcher.group(4)));
            }
            if (null != matcher.group(5)) {
                elevation = Long.parseLong(matcher.group(5));
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("", 0);
        }
        String valuestr = matcher.group(8);
        Object value = GTSHelper.parseValue_regexp(valuestr);
        if (null == value) {
            throw new ParseException("Unable to parse value '" + valuestr + "'", 0);
        }
        if (null == encoder || !name.equals(encoder.getName()) || !labels.equals(encoder.getLabels())) {
            encoder = new GTSEncoder(0L);
            encoder.setName(name);
            encoder.setLabels(labels);
        }
        encoder.addValue(timestamp, location, elevation, value);
        return encoder;
    }

    public static GTSEncoder parseJSON(GTSEncoder encoder, String str, Map<String, String> extraLabels, Long now) throws IOException, ParseException {
        Object ots;
        Map o = (Map)JsonUtils.jsonToObject(str);
        String name = (String)o.get("c");
        Map labels = (Map)o.get("l");
        if (null != extraLabels) {
            labels.putAll(extraLabels);
            if (extraLabels.containsValue(null)) {
                Set<Map.Entry<String, String>> entries = extraLabels.entrySet();
                while (labels.containsValue(null)) {
                    for (Map.Entry<String, String> entry : entries) {
                        if (null != entry.getValue()) continue;
                        labels.remove(entry.getKey());
                    }
                }
            }
        }
        long ts = null != (ots = o.get("t")) ? ((Number)ots).longValue() : (null != now ? now : TimeSource.getTime());
        long location = 91480763316633925L;
        if (o.containsKey("lat") && o.containsKey("lon")) {
            double lat = (Double)o.get("lat");
            double lon = (Double)o.get("lon");
            location = GeoXPLib.toGeoXPPoint((double)lat, (double)lon);
        }
        long elevation = Long.MIN_VALUE;
        if (o.containsKey("elev")) {
            elevation = ((Number)o.get("elev")).longValue();
        }
        Object v = o.get("v");
        if (null == encoder || !name.equals(encoder.getName()) || !labels.equals(encoder.getLabels())) {
            encoder = new GTSEncoder(0L);
            encoder.setName(name);
            encoder.setLabels(labels);
        }
        if (v instanceof Long || v instanceof Integer || v instanceof Short || v instanceof Byte || v instanceof BigInteger) {
            encoder.addValue(ts, location, elevation, ((Number)v).longValue());
        } else if (v instanceof Double || v instanceof Float) {
            encoder.addValue(ts, location, elevation, ((Number)v).doubleValue());
        } else if (v instanceof BigDecimal) {
            encoder.addValue(ts, location, elevation, v);
        } else if (v instanceof Boolean || v instanceof String) {
            encoder.addValue(ts, location, elevation, v);
        } else {
            throw new ParseException("Invalid value.", 0);
        }
        return encoder;
    }

    private static GTSEncoder parse(GTSEncoder encoder, String str, Map<String, String> extraLabels) throws ParseException, IOException {
        return GTSHelper.parse(encoder, str, extraLabels, null);
    }

    public static GTSEncoder parse(GTSEncoder encoder, String str, Map<String, String> extraLabels, Long now) throws ParseException, IOException {
        return GTSHelper.parse(encoder, str, extraLabels, now, Long.MAX_VALUE, null);
    }

    public static GTSEncoder parse(GTSEncoder encoder, String str, Map<String, String> extraLabels, Long now, long maxValueSize) throws ParseException, IOException {
        return GTSHelper.parse(encoder, str, extraLabels, now, maxValueSize, null);
    }

    public static GTSEncoder parse(GTSEncoder encoder, String str, Map<String, String> extraLabels, Long now, long maxValueSize, AtomicBoolean parsedAttributes) throws ParseException, IOException {
        return GTSHelper.parse(encoder, str, extraLabels, now, maxValueSize, parsedAttributes, null, null, null, false);
    }

    public static GTSEncoder parse(GTSEncoder encoder, String str, Map<String, String> extraLabels, Long now, long maxValueSize, AtomicBoolean parsedAttributes, Long maxpast, Long maxfuture, AtomicLong ignoredCount, boolean deltaAttributes) throws ParseException, IOException {
        return GTSHelper.parse(encoder, str, extraLabels, now, maxValueSize, parsedAttributes, maxpast, maxfuture, ignoredCount, deltaAttributes, 0L);
    }

    public static GTSEncoder parse(GTSEncoder encoder, String str, Map<String, String> extraLabels, Long now, long maxValueSize, AtomicBoolean parsedAttributes, Long maxpast, Long maxfuture, AtomicLong ignoredCount, boolean deltaAttributes, long timeshift) throws ParseException, IOException {
        Object value;
        long timestamp;
        int idx = 0;
        int tsoffset = 0;
        if ('=' == str.charAt(0)) {
            if (null == encoder) {
                throw new ParseException("Invalid continuation.", 0);
            }
            tsoffset = 1;
        }
        if (-1 == (idx = str.indexOf(47, tsoffset))) {
            throw new ParseException("Missing timestamp separator.", tsoffset);
        }
        try {
            timestamp = tsoffset == idx ? (null != now ? now : TimeSource.getTime()) : ('T' == str.charAt(tsoffset) ? (null != now ? now : TimeSource.getTime()) + Long.parseLong(str.substring(1 + tsoffset, idx)) : Long.parseLong(str.substring(tsoffset, idx)));
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Invalid timestamp.", tsoffset);
        }
        boolean ignored = false;
        if (null != maxpast && (timestamp += timeshift) < maxpast) {
            if (null == ignoredCount) {
                throw new ParseException("Timestamp " + timestamp + " is too far in the past.", idx);
            }
            ignored = true;
        } else if (null != maxfuture && timestamp > maxfuture) {
            if (null == ignoredCount) {
                throw new ParseException("Timestamp " + timestamp + " is too far in the future.", idx);
            }
            ignored = true;
        }
        int idx2 = str.indexOf(47, ++idx);
        if (-1 == idx2) {
            throw new ParseException("Missing location/elevation separator.", idx);
        }
        long location = 91480763316633925L;
        if (idx != idx2) {
            String latlon = str.substring(idx, idx2);
            idx = idx2 + 1;
            idx2 = latlon.indexOf(58);
            try {
                if (-1 != idx2) {
                    location = GeoXPLib.toGeoXPPoint((double)Double.parseDouble(latlon.substring(0, idx2)), (double)Double.parseDouble(latlon.substring(idx2 + 1)));
                }
                location = Long.parseLong(latlon);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Invalid location: '" + latlon + "'.", idx - latlon.length() - 1);
            }
        } else {
            idx = idx2 + 1;
        }
        if (-1 == (idx2 = str.indexOf(32, idx))) {
            if (0 == tsoffset) {
                throw new ParseException("Missing GTS name, labels and value.", idx);
            }
            throw new ParseException("Missing value.", idx);
        }
        long elevation = Long.MIN_VALUE;
        if (idx != idx2) {
            try {
                elevation = Long.parseLong(str.substring(idx, idx2));
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Invalid elevation: '" + str.substring(idx, idx2) + "'.", idx);
            }
        }
        for (idx = idx2 + 1; idx < str.length() && str.charAt(idx) == ' '; ++idx) {
        }
        idx2 = tsoffset > 0 ? -1 : str.indexOf(123, idx);
        String name = null;
        Map<String, String> labels = null;
        Map<String, String> attributes = null;
        boolean reuseLabels = false;
        if (-1 == idx2) {
            if (idx >= str.length()) {
                throw new ParseException("Missing value", idx);
            }
            if (null == encoder) {
                throw new ParseException("Missing or invalid GTS name and labels.", idx);
            }
            name = encoder.getMetadata().getName();
            labels = encoder.getMetadata().getLabels();
            reuseLabels = true;
        } else {
            name = str.substring(idx, idx2);
            name = WarpURLDecoder.decode(name, StandardCharsets.UTF_8);
            idx = idx2 + 1;
            if (-1 == (idx2 = str.indexOf(125, idx))) {
                throw new ParseException("Missing end of labels '}'.", str.length() - 1);
            }
            try {
                labels = GTSHelper.parseLabels(null != extraLabels ? extraLabels.size() : 0, str.substring(idx, idx2));
            }
            catch (ParseException pe) {
                ParseException newpe = new ParseException("Invalid label definition.", pe.getErrorOffset() + idx);
                newpe.initCause(pe);
                throw newpe;
            }
            idx = idx2 + 1;
            if (idx < str.length() && str.charAt(idx) == '{') {
                int attrstart = ++idx;
                while (idx < str.length() && str.charAt(idx) != '}') {
                    ++idx;
                }
                if (null != parsedAttributes) {
                    if (idx >= str.length()) {
                        throw new ParseException("Missing end of attributes '}'.", str.length() - 1);
                    }
                    try {
                        attributes = GTSHelper.parseLabels(str.substring(attrstart, idx));
                    }
                    catch (ParseException pe) {
                        ParseException newpe = new ParseException("Invalid attribute definition.", pe.getErrorOffset() + idx);
                        newpe.initCause(pe);
                        throw newpe;
                    }
                    parsedAttributes.set(true);
                }
                ++idx;
            }
            while (idx < str.length() && str.charAt(idx) == ' ') {
                ++idx;
            }
            if (idx >= str.length()) {
                throw new ParseException("Missing value.", str.length() - 1);
            }
        }
        if (!reuseLabels && null != extraLabels) {
            labels.putAll(extraLabels);
            if (extraLabels.containsValue(null)) {
                Set<Map.Entry<String, String>> entries = extraLabels.entrySet();
                while (labels.containsValue(null)) {
                    for (Map.Entry<String, String> entry : entries) {
                        if (null != entry.getValue()) continue;
                        labels.remove(entry.getKey());
                    }
                }
            }
        }
        String valuestr = str.substring(idx);
        try {
            value = GTSHelper.parseValue(valuestr);
        }
        catch (ParseException pe) {
            ParseException newpe = new ParseException(pe.getMessage(), idx + pe.getErrorOffset());
            newpe.initCause(pe.getCause());
            throw newpe;
        }
        if (null == value) {
            throw new ParseException("Unable to parse value '" + valuestr + "'", idx);
        }
        if (value instanceof String && (long)value.toString().length() > maxValueSize || value instanceof byte[] && (long)((byte[])value).length > maxValueSize) {
            throw new ParseException("Value too large for GTS " + (null != encoder ? GTSHelper.buildSelector(encoder.getMetadata(), false) : ""), idx);
        }
        if (null == encoder || !name.equals(encoder.getName()) || !labels.equals(encoder.getMetadata().getLabels())) {
            encoder = new GTSEncoder(0L);
            encoder.setName(name);
            encoder.getMetadata().setLabels(labels);
        }
        if (null != attributes) {
            if (!deltaAttributes) {
                encoder.getMetadata().setAttributes(attributes);
            } else {
                if (0 == encoder.getMetadata().getAttributesSize()) {
                    encoder.getMetadata().setAttributes(new HashMap<String, String>());
                }
                for (Map.Entry attr : attributes.entrySet()) {
                    if ("".equals(attr.getValue())) {
                        encoder.getMetadata().getAttributes().remove(attr.getKey());
                        continue;
                    }
                    encoder.getMetadata().putToAttributes((String)attr.getKey(), (String)attr.getValue());
                }
            }
        }
        if (!ignored) {
            long pessimisticSize = encoder.getPessimisticSize();
            encoder.addValue(timestamp, location, elevation, value);
            if (Long.MAX_VALUE != maxValueSize && encoder.getPessimisticSize() - pessimisticSize > maxValueSize + 30L) {
                throw new ParseException("Value too large for GTS " + GTSHelper.buildSelector(encoder.getMetadata(), false), idx);
            }
        } else {
            ignoredCount.addAndGet(1L);
        }
        if (str.length() - 6 - valuestr.length() > MetadataUtils.SIZE_THRESHOLD && !MetadataUtils.validateMetadata(encoder.getMetadata())) {
            throw new ParseException("Invalid or too large metadata", 0);
        }
        return encoder;
    }

    public static GTSEncoder parse(GTSEncoder encoder, String str) throws ParseException, IOException {
        return GTSHelper.parse(encoder, str, null);
    }

    public static Object parseValue(String valuestr) throws ParseException {
        Object value;
        block57: {
            try {
                boolean likelylong;
                char firstChar = valuestr.charAt(0);
                if ('\'' == firstChar && valuestr.endsWith("'") || '\"' == firstChar && valuestr.endsWith("\"")) {
                    value = valuestr.substring(1, valuestr.length() - 1);
                    value = WarpURLDecoder.decode((String)value, StandardCharsets.UTF_8);
                    break block57;
                }
                if (!('t' != firstChar && 'T' != firstChar || 1 != valuestr.length() && !"true".equalsIgnoreCase(valuestr))) {
                    value = Boolean.TRUE;
                    break block57;
                }
                if (!('f' != firstChar && 'F' != firstChar || 1 != valuestr.length() && !"false".equalsIgnoreCase(valuestr))) {
                    value = Boolean.FALSE;
                    break block57;
                }
                if ('H' == firstChar && valuestr.startsWith("HH:")) {
                    double lon;
                    double lat;
                    int colon = valuestr.indexOf(58, 3);
                    if (-1 == colon) {
                        throw new ParseException("Invalid value for lat,lon conversion to HHCode.", 0);
                    }
                    try {
                        lat = Double.parseDouble(valuestr.substring(3, colon));
                    }
                    catch (NumberFormatException nfe) {
                        ParseException pe = new ParseException("Cannot parse latitude.", 3);
                        pe.initCause(nfe);
                        throw pe;
                    }
                    try {
                        lon = Double.parseDouble(valuestr.substring(colon + 1));
                    }
                    catch (NumberFormatException nfe) {
                        ParseException pe = new ParseException("Cannot parse longitude.", colon + 1);
                        pe.initCause(nfe);
                        throw pe;
                    }
                    value = GeoXPLib.toGeoXPPoint((double)lat, (double)lon);
                    break block57;
                }
                if ('Q' == firstChar && valuestr.startsWith("Q:")) {
                    double[] q = new double[4];
                    int idx = 2;
                    int qidx = 0;
                    while (qidx < q.length) {
                        int colon = valuestr.indexOf(58, idx);
                        if (-1 == colon) {
                            throw new ParseException("Invalid value for Quaternion, expected Q:w:x:y:z", 0);
                        }
                        try {
                            q[qidx++] = Double.parseDouble(valuestr.substring(idx, colon));
                            idx = colon + 1;
                            if (3 != qidx) continue;
                            q[qidx++] = Double.parseDouble(valuestr.substring(idx));
                        }
                        catch (NumberFormatException nfe) {
                            ParseException pe = new ParseException("Cannot parse quaternion component.", idx);
                            pe.initCause(nfe);
                            throw pe;
                        }
                    }
                    if (!(Double.isFinite(q[0]) && Double.isFinite(q[1]) && Double.isFinite(q[2]) && Double.isFinite(q[3]))) {
                        throw new ParseException("Quaternion values require finite elements.", 0);
                    }
                    value = TOQUATERNION.toQuaternion(q[0], q[1], q[2], q[3]);
                    break block57;
                }
                if ('[' == valuestr.charAt(0)) {
                    char c;
                    int idxValueEnd;
                    GTSEncoder encoder = new GTSEncoder();
                    int idxTokenStart = 1;
                    boolean comp = true;
                    if ('!' == valuestr.charAt(1)) {
                        comp = false;
                        idxTokenStart = 2;
                    }
                    int idxTokenSlash = 0;
                    for (idxValueEnd = valuestr.length() - 1; idxValueEnd >= idxTokenStart && ']' != (c = valuestr.charAt(idxValueEnd)); --idxValueEnd) {
                        if (' ' == c) {
                            continue;
                        }
                        throw new ParseException("Missing closing bracket.", 0);
                    }
                    if (idxValueEnd < idxTokenStart) {
                        throw new ParseException("Missing closing bracket.", 0);
                    }
                    while (idxTokenStart < idxValueEnd) {
                        int opening;
                        int idxTokenSemiCol;
                        Object val;
                        char lead;
                        int closing;
                        long ts;
                        int idxTokenEnd;
                        while (idxTokenStart < idxValueEnd && ' ' == valuestr.charAt(idxTokenStart)) {
                            ++idxTokenStart;
                        }
                        if (idxTokenStart >= idxValueEnd) break;
                        for (idxTokenEnd = idxTokenStart + 1; idxTokenEnd < idxValueEnd && ' ' != valuestr.charAt(idxTokenEnd); ++idxTokenEnd) {
                        }
                        for (idxTokenSlash = idxTokenStart + 1; idxTokenSlash < idxTokenEnd && '/' != valuestr.charAt(idxTokenSlash); ++idxTokenSlash) {
                        }
                        long location = 91480763316633925L;
                        long elevation = Long.MIN_VALUE;
                        if (idxTokenSlash == idxTokenEnd) {
                            ts = 0L;
                            if ('[' == valuestr.charAt(idxTokenStart)) {
                                int opening2 = 1;
                                for (closing = idxTokenStart + 1; closing < idxValueEnd && opening2 > 0; ++closing) {
                                    lead = valuestr.charAt(closing);
                                    if (']' == lead) {
                                        --opening2;
                                        continue;
                                    }
                                    if ('[' != lead) continue;
                                    ++opening2;
                                }
                                idxTokenEnd = closing;
                            }
                            try {
                                val = GTSHelper.parseValue(valuestr.substring(idxTokenStart, idxTokenEnd));
                            }
                            catch (ParseException pe) {
                                ParseException newpe = new ParseException(pe.getMessage(), idxTokenStart + pe.getErrorOffset());
                                newpe.initCause(pe.getCause());
                                throw newpe;
                            }
                            encoder.addValue(ts, location, elevation, val);
                            idxTokenStart = idxTokenEnd;
                            continue;
                        }
                        ts = Long.parseLong(valuestr.substring(idxTokenStart, idxTokenSlash));
                        idxTokenStart = ++idxTokenSlash;
                        while (idxTokenSlash < idxTokenEnd && '/' != valuestr.charAt(idxTokenSlash)) {
                            ++idxTokenSlash;
                        }
                        if (idxTokenSlash == idxTokenEnd) {
                            if ('[' == valuestr.charAt(idxTokenStart)) {
                                int opening3 = 1;
                                for (closing = idxTokenStart + 1; closing < idxValueEnd && opening3 > 0; ++closing) {
                                    lead = valuestr.charAt(closing);
                                    if (']' == lead) {
                                        --opening3;
                                        continue;
                                    }
                                    if ('[' != lead) continue;
                                    ++opening3;
                                }
                                idxTokenEnd = closing;
                            }
                            try {
                                val = GTSHelper.parseValue(valuestr.substring(idxTokenStart, idxTokenEnd));
                            }
                            catch (ParseException pe) {
                                ParseException newpe = new ParseException(pe.getMessage(), idxTokenStart + pe.getErrorOffset());
                                newpe.initCause(pe.getCause());
                                throw newpe;
                            }
                            encoder.addValue(ts, location, elevation, val);
                            idxTokenStart = idxTokenEnd;
                            continue;
                        }
                        for (idxTokenSemiCol = idxTokenStart; idxTokenSemiCol < idxTokenSlash && ':' != valuestr.charAt(idxTokenSemiCol); ++idxTokenSemiCol) {
                        }
                        if (idxTokenSemiCol == idxTokenSlash) {
                            if (idxTokenSemiCol > idxTokenStart) {
                                location = Long.parseLong(valuestr.substring(idxTokenStart, idxTokenSemiCol));
                            }
                        } else {
                            double lat = Double.parseDouble(valuestr.substring(idxTokenStart, idxTokenSemiCol));
                            double lon = Double.parseDouble(valuestr.substring(idxTokenSemiCol + 1, idxTokenSlash));
                            location = GeoXPLib.toGeoXPPoint((double)lat, (double)lon);
                        }
                        idxTokenStart = ++idxTokenSlash;
                        while (idxTokenSlash < idxTokenEnd && '/' != valuestr.charAt(idxTokenSlash)) {
                            ++idxTokenSlash;
                        }
                        if (idxTokenSlash == idxTokenEnd) {
                            if ('[' == valuestr.charAt(idxTokenStart)) {
                                int closing2;
                                opening = 1;
                                for (closing2 = idxTokenStart + 1; closing2 < idxValueEnd && opening > 0; ++closing2) {
                                    char lead2 = valuestr.charAt(closing2);
                                    if (']' == lead2) {
                                        --opening;
                                        continue;
                                    }
                                    if ('[' != lead2) continue;
                                    ++opening;
                                }
                                idxTokenEnd = closing2;
                            }
                            try {
                                val = GTSHelper.parseValue(valuestr.substring(idxTokenStart, idxTokenEnd));
                            }
                            catch (ParseException pe) {
                                ParseException newpe = new ParseException(pe.getMessage(), idxTokenStart + pe.getErrorOffset());
                                newpe.initCause(pe.getCause());
                                throw newpe;
                            }
                            encoder.addValue(ts, location, elevation, val);
                            idxTokenStart = idxTokenEnd;
                            continue;
                        }
                        if (idxTokenSlash > idxTokenStart) {
                            elevation = Long.parseLong(valuestr.substring(idxTokenStart, idxTokenSlash));
                        }
                        if ('[' == valuestr.charAt(idxTokenSlash + 1)) {
                            int closing3;
                            opening = 1;
                            for (closing3 = idxTokenSlash + 2; closing3 < idxValueEnd && opening > 0; ++closing3) {
                                char lead3 = valuestr.charAt(closing3);
                                if (']' == lead3) {
                                    --opening;
                                    continue;
                                }
                                if ('[' != lead3) continue;
                                ++opening;
                            }
                            idxTokenEnd = closing3;
                        }
                        try {
                            val = GTSHelper.parseValue(valuestr.substring(idxTokenSlash + 1, idxTokenEnd));
                        }
                        catch (ParseException pe) {
                            ParseException newpe = new ParseException(pe.getMessage(), idxTokenSlash + 1 + pe.getErrorOffset());
                            newpe.initCause(pe.getCause());
                            throw newpe;
                        }
                        encoder.addValue(ts, location, elevation, val);
                        idxTokenStart = idxTokenEnd + 1;
                    }
                    GTSWrapper wrapper = GTSWrapperHelper.fromGTSEncoderToGTSWrapper(encoder, comp, 100.0, Integer.MAX_VALUE, false);
                    TSerializer serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
                    byte[] ser = serializer.serialize((TBase)wrapper);
                    return ser;
                }
                value = 'b' == firstChar && valuestr.startsWith("b64:") ? (Object)Base64.decodeBase64((String)valuestr.substring(4)) : ('h' == firstChar && valuestr.startsWith("hex:") ? (Object)WarpHexDecoder.decode(valuestr.substring(4)) : (':' == firstChar ? ValueEncoder.parse(valuestr) : ((likelylong = UnsafeString.isLong(valuestr)) ? (Number)Long.parseLong(valuestr) : (Number)(valuestr.length() <= 15 && UnsafeString.mayBeDecimalDouble(valuestr) ? new BigDecimal(valuestr) : Double.valueOf(Double.parseDouble(valuestr))))));
            }
            catch (ParseException pe) {
                throw pe;
            }
            catch (Exception e) {
                ParseException pe = new ParseException("Cannot parse value.", 0);
                pe.initCause(e);
                throw pe;
            }
        }
        return value;
    }

    public static Object parseValue_regexp(String valuestr) throws ParseException {
        Object value;
        Matcher valuematcher = DOUBLE_VALUE_RE.matcher(valuestr);
        if (valuematcher.matches()) {
            value = valuematcher.group(1).length() < 10 && valuematcher.group(2).length() < 10 ? new BigDecimal(valuestr) : Double.valueOf(Double.parseDouble(valuestr));
        } else {
            valuematcher = LONG_VALUE_RE.matcher(valuestr);
            if (valuematcher.matches()) {
                value = Long.parseLong(valuestr);
            } else {
                valuematcher = STRING_VALUE_RE.matcher(valuestr);
                if (valuematcher.matches()) {
                    value = valuestr.substring(1, valuestr.length() - 1);
                } else {
                    valuematcher = BOOLEAN_VALUE_RE.matcher(valuestr);
                    if (valuematcher.matches()) {
                        value = 't' == valuestr.charAt(0) || 'T' == valuestr.charAt(0) ? Boolean.TRUE : Boolean.FALSE;
                    } else {
                        throw new ParseException(valuestr, 0);
                    }
                }
            }
        }
        return value;
    }

    public static Map<String, String> parseLabels(int initialCapacity, String str) throws ParseException {
        LinkedHashMap<String, String> selectors = GTSHelper.parseLabelsSelectors(str);
        HashMap<String, String> labels = new HashMap<String, String>(selectors.size() + initialCapacity);
        for (Map.Entry entry : selectors.entrySet()) {
            if ('=' != ((String)entry.getValue()).charAt(0)) {
                throw new ParseException((String)entry.getValue(), 0);
            }
            labels.put((String)entry.getKey(), ((String)entry.getValue()).substring(1));
        }
        return labels;
    }

    public static Map<String, String> parseLabels(String str) throws ParseException {
        return GTSHelper.parseLabels(0, str);
    }

    public static final long classId(byte[] key, String name) {
        long[] sipkey = SipHashInline.getKey(key);
        return GTSHelper.classId(sipkey, name);
    }

    public static final long classId(long[] key, String name) {
        return GTSHelper.classId(key[0], key[1], name);
    }

    public static final long classId(long k0, long k1, String name) {
        byte[] ba = name.getBytes(StandardCharsets.UTF_8);
        return SipHashInline.hash24_palindromic(k0, k1, ba, 0, ba.length);
    }

    public static final long gtsId(long[] key, long classId, long labelsId) {
        int i;
        byte[] buf = new byte[21];
        buf[0] = 71;
        buf[1] = 84;
        buf[2] = 83;
        buf[3] = 58;
        for (i = 0; i < 8; ++i) {
            buf[11 - i] = (byte)(classId & 0xFFL);
            classId >>>= 8;
        }
        buf[12] = 58;
        for (i = 0; i < 8; ++i) {
            buf[20 - i] = (byte)(labelsId & 0xFFL);
            labelsId >>>= 8;
        }
        return SipHashInline.hash24_palindromic(key[0], key[1], buf);
    }

    public static final long classId(byte[] key, GeoTimeSerie gts) {
        return GTSHelper.classId(key, gts.getName());
    }

    public static final long labelsId(byte[] key, Map<String, String> labels) {
        long[] sipkey = SipHashInline.getKey(key);
        return GTSHelper.labelsId(sipkey, labels);
    }

    public static final long labelsId(long[] sipkey, Map<String, String> labels) {
        return GTSHelper.labelsId(sipkey[0], sipkey[1], labels);
    }

    public static final long labelsId(long sipkey0, long sipkey1, Map<String, String> labels) {
        CharsetEncoder ce = StandardCharsets.UTF_8.newEncoder();
        int calen = 64;
        byte[] ba = new byte[(int)((double)ce.maxBytesPerChar() * (double)calen)];
        long[] hashes = new long[labels.size() * 2];
        int idx = 0;
        CharBuffer cb = CharBuffer.allocate(calen);
        ByteBuffer bb = ByteBuffer.allocate((int)((double)ce.maxBytesPerChar() * (double)calen));
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            String ekey = entry.getKey();
            String eval = entry.getValue();
            int klen = ekey.length();
            int vlen = eval.length();
            if (klen > calen || vlen > calen) {
                calen = Math.max(klen, vlen);
                cb = CharBuffer.allocate(calen);
                bb = ByteBuffer.allocate((int)((double)ce.maxBytesPerChar() * (double)calen));
            }
            ce.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
            cb.clear();
            cb.put(ekey);
            cb.flip();
            bb.clear();
            CoderResult res = ce.encode(cb, bb, true);
            bb.flip();
            hashes[idx] = SipHashInline.hash24_palindromic(sipkey0, sipkey1, bb.array(), 0, bb.limit());
            ce.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
            cb.clear();
            cb.put(eval);
            cb.flip();
            bb.clear();
            res = ce.encode(cb, bb, true);
            bb.flip();
            hashes[idx + 1] = SipHashInline.hash24_palindromic(sipkey0, sipkey1, bb.array(), 0, bb.limit());
            idx += 2;
        }
        for (int i = 0; i < labels.size() - 1; ++i) {
            int ii = i << 1;
            int iip = ii + 1;
            for (int j = i + 1; j < labels.size(); ++j) {
                long tmp;
                int jj = j << 1;
                int jjp = jj + 1;
                if (hashes[ii] > hashes[jj]) {
                    tmp = hashes[jj];
                    hashes[jj] = hashes[ii];
                    hashes[ii] = tmp;
                    tmp = hashes[jjp];
                    hashes[jjp] = hashes[iip];
                    hashes[iip] = tmp;
                    continue;
                }
                if (hashes[ii] != hashes[jj] || hashes[iip] <= hashes[jjp]) continue;
                tmp = hashes[jjp];
                hashes[jjp] = hashes[iip];
                hashes[iip] = tmp;
            }
        }
        byte[] buf = new byte[hashes.length * 8];
        idx = 0;
        for (long hash : hashes) {
            buf[idx++] = (byte)(hash >> 56 & 0xFFL);
            buf[idx++] = (byte)(hash >> 48 & 0xFFL);
            buf[idx++] = (byte)(hash >> 40 & 0xFFL);
            buf[idx++] = (byte)(hash >> 32 & 0xFFL);
            buf[idx++] = (byte)(hash >> 24 & 0xFFL);
            buf[idx++] = (byte)(hash >> 16 & 0xFFL);
            buf[idx++] = (byte)(hash >> 8 & 0xFFL);
            buf[idx++] = (byte)(hash & 0xFFL);
        }
        long id = SipHashInline.hash24_palindromic(sipkey0, sipkey1, buf, 0, buf.length);
        return id;
    }

    public static final long labelsId_slow(byte[] key, Map<String, String> labels) {
        long[] hashes = new long[labels.size() * 2];
        int idx = 0;
        long[] sipkey = SipHashInline.getKey(key);
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            hashes[idx] = SipHashInline.hash24_palindromic(sipkey[0], sipkey[1], entry.getKey().getBytes(StandardCharsets.UTF_8));
            hashes[idx + 1] = SipHashInline.hash24_palindromic(sipkey[0], sipkey[1], entry.getValue().getBytes(StandardCharsets.UTF_8));
            idx += 2;
        }
        for (int i = 0; i < labels.size() - 1; ++i) {
            for (int j = i + 1; j < labels.size(); ++j) {
                long tmp;
                if (hashes[i * 2] > hashes[j * 2]) {
                    tmp = hashes[j * 2];
                    hashes[j * 2] = hashes[i * 2];
                    hashes[i * 2] = tmp;
                    tmp = hashes[j * 2 + 1];
                    hashes[j * 2 + 1] = hashes[i * 2 + 1];
                    hashes[i * 2 + 1] = tmp;
                    continue;
                }
                if (hashes[i * 2] != hashes[j * 2] || hashes[i * 2 + 1] <= hashes[j * 2 + 1]) continue;
                tmp = hashes[j * 2 + 1];
                hashes[j * 2 + 1] = hashes[i * 2 + 1];
                hashes[i * 2 + 1] = tmp;
            }
        }
        byte[] buf = new byte[hashes.length * 8];
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.order(ByteOrder.BIG_ENDIAN);
        for (long hash : hashes) {
            bb.putLong(hash);
        }
        return SipHashInline.hash24_palindromic(sipkey[0], sipkey[1], buf, 0, buf.length);
    }

    public static final long labelsId(byte[] key, GeoTimeSerie gts) {
        return GTSHelper.labelsId(key, gts.getLabels());
    }

    public static byte[] unpackGTSId(BigInteger bi) {
        byte[] bytes = bi.toByteArray();
        if (bytes.length < 16) {
            byte[] tmp = new byte[16];
            if (bi.signum() < 0) {
                Arrays.fill(tmp, (byte)-1);
            }
            System.arraycopy(bytes, 0, tmp, tmp.length - bytes.length, bytes.length);
            return tmp;
        }
        return bytes;
    }

    public static byte[] unpackGTSId(String s) {
        byte[] bytes = new byte[16];
        if (8 != s.length()) {
            return bytes;
        }
        for (int i = 0; i < 8; ++i) {
            char c = s.charAt(i);
            bytes[i * 2] = (byte)(c >> 8 & 0xFF);
            bytes[1 + i * 2] = (byte)(c & 0xFF);
        }
        return bytes;
    }

    public static long[] unpackGTSIdLongs(String s) {
        long[] clslbls = new long[2];
        for (int i = 0; i < 4; ++i) {
            clslbls[0] = clslbls[0] << 16;
            clslbls[0] = clslbls[0] | (long)s.charAt(i) & 0xFFFFL & 0xFFFFL;
            clslbls[1] = clslbls[1] << 16;
            clslbls[1] = clslbls[1] | (long)s.charAt(i + 4) & 0xFFFFL & 0xFFFFL;
        }
        return clslbls;
    }

    public static String gtsIdToString(long classId, long labelsId) {
        return GTSHelper.gtsIdToString(classId, labelsId, true);
    }

    public static String gtsIdToString(long classId, long labelsId, boolean intern) {
        char[] c = new char[8];
        long x = classId;
        long y = labelsId;
        for (int i = 3; i >= 0; --i) {
            c[i] = (char)(x & 0xFFFFL);
            c[i + 4] = (char)(y & 0xFFFFL);
            x >>>= 16;
            y >>>= 16;
        }
        String s = new String(c);
        if (intern) {
            s = s.intern();
        }
        return s;
    }

    public static long[] stringToGTSId(String s) {
        long x = 0L;
        long y = 0L;
        for (int i = 0; i < 4; ++i) {
            x <<= 16;
            x |= (long)s.charAt(i) & 0xFFFFL;
            y <<= 16;
            y |= (long)s.charAt(i + 4) & 0xFFFFL;
        }
        long[] clslbls = new long[]{x, y};
        return clslbls;
    }

    public static void fillGTSIds(byte[] bytes, int offset, long classId, long labelsId) {
        bytes[offset++] = (byte)(classId >> 56 & 0xFFL);
        bytes[offset++] = (byte)(classId >> 48 & 0xFFL);
        bytes[offset++] = (byte)(classId >> 40 & 0xFFL);
        bytes[offset++] = (byte)(classId >> 32 & 0xFFL);
        bytes[offset++] = (byte)(classId >> 24 & 0xFFL);
        bytes[offset++] = (byte)(classId >> 16 & 0xFFL);
        bytes[offset++] = (byte)(classId >> 8 & 0xFFL);
        bytes[offset++] = (byte)(classId & 0xFFL);
        bytes[offset++] = (byte)(labelsId >> 56 & 0xFFL);
        bytes[offset++] = (byte)(labelsId >> 48 & 0xFFL);
        bytes[offset++] = (byte)(labelsId >> 40 & 0xFFL);
        bytes[offset++] = (byte)(labelsId >> 32 & 0xFFL);
        bytes[offset++] = (byte)(labelsId >> 24 & 0xFFL);
        bytes[offset++] = (byte)(labelsId >> 16 & 0xFFL);
        bytes[offset++] = (byte)(labelsId >> 8 & 0xFFL);
        bytes[offset] = (byte)(labelsId & 0xFFL);
    }

    public static final LinkedHashMap<String, String> parseLabelsSelectors(String selectors) throws ParseException {
        String[] tokens = UnsafeString.split(selectors, ',');
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(tokens.length);
        for (String token : tokens) {
            String[] subtokens;
            if ("".equals(token = token.trim())) continue;
            boolean exact = true;
            if (token.contains("=")) {
                exact = true;
                subtokens = UnsafeString.split(token, '=');
            } else if (token.contains("~")) {
                exact = false;
                subtokens = UnsafeString.split(token, '~');
            } else {
                throw new ParseException(token, 0);
            }
            String name = subtokens[0];
            String value = subtokens.length > 1 ? subtokens[1] : "";
            try {
                name = WarpURLDecoder.decode(name, StandardCharsets.UTF_8);
                value = WarpURLDecoder.decode(value, StandardCharsets.UTF_8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            result.put(name, (exact ? "=" : "~") + value);
        }
        return result;
    }

    public static Map<String, Pattern> patternsFromSelectors(String classLabelsSelectionString) throws ParseException {
        String classSelector = classLabelsSelectionString.replaceAll("\\{.*$", "");
        String labelsSelectorsString = classLabelsSelectionString.replaceAll("^.*\\{", "").replaceAll("\\}.*$", "");
        LinkedHashMap<String, String> labelsSelectors = GTSHelper.parseLabelsSelectors(labelsSelectorsString);
        HashMap<String, Pattern> patterns = new HashMap<String, Pattern>();
        try {
            classSelector = WarpURLDecoder.decode(classSelector, StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if ('=' == classSelector.charAt(0)) {
            patterns.put(null, Pattern.compile(Pattern.quote(classSelector.substring(1))));
        } else if ('~' == classSelector.charAt(0)) {
            patterns.put(null, Pattern.compile(classSelector.substring(1)));
        } else {
            patterns.put(null, Pattern.compile(Pattern.quote(classSelector)));
        }
        for (Map.Entry entry : labelsSelectors.entrySet()) {
            if ('=' == ((String)entry.getValue()).charAt(0)) {
                patterns.put((String)entry.getKey(), Pattern.compile(Pattern.quote(((String)entry.getValue()).substring(1))));
                continue;
            }
            patterns.put((String)entry.getKey(), Pattern.compile(((String)entry.getValue()).substring(1)));
        }
        return patterns;
    }

    public static Iterator<String> valueRepresentationIterator(final GeoTimeSerie gts) {
        return new Iterator<String>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < gts.values;
            }

            @Override
            public String next() {
                Object value = GeoTimeSerie.TYPE.LONG == gts.type ? Long.valueOf(gts.longValues[this.idx]) : (GeoTimeSerie.TYPE.DOUBLE == gts.type ? Double.valueOf(gts.doubleValues[this.idx]) : (GeoTimeSerie.TYPE.STRING == gts.type ? gts.stringValues[this.idx] : (GeoTimeSerie.TYPE.BOOLEAN == gts.type ? Boolean.valueOf(gts.booleanValues.get(this.idx)) : null)));
                String repr = GTSHelper.tickToString(gts.ticks[this.idx], null != gts.locations ? gts.locations[this.idx] : 91480763316633925L, null != gts.elevations ? gts.elevations[this.idx] : Long.MIN_VALUE, value);
                ++this.idx;
                return repr;
            }

            @Override
            public void remove() {
            }
        };
    }

    public static String tickToString(StringBuilder clslbls, long timestamp, long location, long elevation, Object value) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(timestamp);
            sb.append("/");
            if (91480763316633925L != location) {
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)location);
                sb.append(latlon[0]);
                sb.append(":");
                sb.append(latlon[1]);
            }
            sb.append("/");
            if (Long.MIN_VALUE != elevation) {
                sb.append(elevation);
            }
            sb.append(" ");
            if (null != clslbls && clslbls.length() > 0) {
                sb.append((CharSequence)clslbls);
                sb.append(" ");
            }
            GTSHelper.encodeValue(sb, value);
            return sb.toString();
        }
        catch (Exception e) {
            LOG.error("Error converting tick to String.", (Throwable)e);
            return null;
        }
    }

    public static String tickToString(long timestamp, long location, long elevation, Object value) {
        return GTSHelper.tickToString(null, timestamp, location, elevation, value);
    }

    public static void encodeValue(StringBuilder sb, Object value) {
        if (value instanceof Long || value instanceof Double) {
            sb.append(value);
        } else if (value instanceof BigDecimal) {
            sb.append(((BigDecimal)value).toPlainString());
            if (((BigDecimal)value).scale() <= 0) {
                sb.append(".0");
            }
        } else if (value instanceof Boolean) {
            sb.append(((Boolean)value).equals(Boolean.TRUE) ? "T" : "F");
        } else if (value instanceof String) {
            sb.append("'");
            try {
                String encoded = WarpURLEncoder.encode((String)value, StandardCharsets.UTF_8);
                sb.append(encoded);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            sb.append("'");
        } else if (value instanceof byte[]) {
            sb.append("b64:");
            sb.append(Base64.encodeBase64URLSafeString((byte[])((byte[])value)));
        }
    }

    public static void encodeName(StringBuilder sb, String name) {
        if (null == name) {
            return;
        }
        try {
            String encoded = WarpURLEncoder.encode(name, StandardCharsets.UTF_8);
            sb.append(encoded);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static GeoTimeSerie slowmerge(GeoTimeSerie base, GeoTimeSerie gts, boolean overwrite) {
        GeoTimeSerie.TYPE baseType = base.getType();
        GeoTimeSerie.TYPE gtsType = gts.getType();
        if (GeoTimeSerie.TYPE.UNDEFINED.equals((Object)baseType) || baseType.equals((Object)gtsType)) {
            for (int i = 0; i < gts.values; ++i) {
                GTSHelper.setValue(base, gts.ticks[i], null != gts.locations ? gts.locations[i] : 91480763316633925L, null != gts.elevations ? gts.elevations[i] : Long.MIN_VALUE, GTSHelper.valueAtIndex(gts, i), overwrite);
            }
        }
        return base;
    }

    public static GeoTimeSerie merge(GeoTimeSerie base, GeoTimeSerie gts) {
        GeoTimeSerie.TYPE baseType = base.getType();
        GeoTimeSerie.TYPE gtsType = gts.getType();
        if (GeoTimeSerie.TYPE.UNDEFINED.equals((Object)baseType) || baseType.equals((Object)gtsType)) {
            if (0 == gts.values) {
                return base;
            }
            if (null == base.ticks) {
                base.ticks = Arrays.copyOf(gts.ticks, gts.values);
            } else {
                if (base.ticks.length < base.values + gts.values) {
                    base.ticks = Arrays.copyOf(base.ticks, base.values + gts.values);
                }
                System.arraycopy(gts.ticks, 0, base.ticks, base.values, gts.values);
            }
            if (null == base.locations) {
                if (null != gts.locations) {
                    base.locations = new long[base.ticks.length];
                    Arrays.fill(base.locations, 91480763316633925L);
                    System.arraycopy(gts.locations, 0, base.locations, base.values, gts.values);
                }
            } else {
                if (base.locations.length < base.values + gts.values) {
                    base.locations = Arrays.copyOf(base.locations, base.values + gts.values);
                }
                if (null != gts.locations) {
                    System.arraycopy(gts.locations, 0, base.locations, base.values, gts.values);
                } else {
                    Arrays.fill(base.locations, base.values, base.values + gts.values, 91480763316633925L);
                }
            }
            if (null == base.elevations) {
                if (null != gts.elevations) {
                    base.elevations = new long[base.ticks.length];
                    Arrays.fill(base.elevations, Long.MIN_VALUE);
                    System.arraycopy(gts.elevations, 0, base.elevations, base.values, gts.values);
                }
            } else {
                if (base.elevations.length < base.values + gts.values) {
                    base.elevations = Arrays.copyOf(base.elevations, base.values + gts.values);
                }
                if (null != gts.elevations) {
                    System.arraycopy(gts.elevations, 0, base.elevations, base.values, gts.values);
                } else {
                    Arrays.fill(base.elevations, base.values, base.values + gts.values, Long.MIN_VALUE);
                }
            }
            switch (gtsType) {
                case LONG: {
                    base.type = GeoTimeSerie.TYPE.LONG;
                    if (null == base.longValues) {
                        base.longValues = Arrays.copyOf(gts.longValues, gts.values);
                        break;
                    }
                    if (base.longValues.length < base.values + gts.values) {
                        base.longValues = Arrays.copyOf(base.longValues, base.values + gts.values);
                    }
                    System.arraycopy(gts.longValues, 0, base.longValues, base.values, gts.values);
                    break;
                }
                case DOUBLE: {
                    base.type = GeoTimeSerie.TYPE.DOUBLE;
                    if (null == base.doubleValues) {
                        base.doubleValues = Arrays.copyOf(gts.doubleValues, gts.values);
                        break;
                    }
                    if (base.doubleValues.length < base.values + gts.values) {
                        base.doubleValues = Arrays.copyOf(base.doubleValues, base.values + gts.values);
                    }
                    System.arraycopy(gts.doubleValues, 0, base.doubleValues, base.values, gts.values);
                    break;
                }
                case STRING: {
                    base.type = GeoTimeSerie.TYPE.STRING;
                    if (null == base.stringValues) {
                        base.stringValues = Arrays.copyOf(gts.stringValues, gts.values);
                        break;
                    }
                    if (base.stringValues.length < base.values + gts.values) {
                        base.stringValues = Arrays.copyOf(base.stringValues, base.values + gts.values);
                    }
                    System.arraycopy(gts.stringValues, 0, base.stringValues, base.values, gts.values);
                    break;
                }
                case BOOLEAN: {
                    base.type = GeoTimeSerie.TYPE.BOOLEAN;
                    if (null == base.booleanValues) {
                        base.booleanValues = (BitSet)gts.booleanValues.clone();
                        break;
                    }
                    for (int i = 0; i < gts.values; ++i) {
                        base.booleanValues.set(base.values + i, gts.booleanValues.get(i));
                    }
                    break;
                }
            }
        } else {
            throw new RuntimeException("Merge cannot proceed with incompatible GTS types.");
        }
        if (0 == base.values) {
            base.sorted = gts.sorted;
            base.reversed = gts.reversed;
        } else {
            base.sorted = base.sorted && gts.sorted && base.reversed == gts.reversed ? (base.reversed ? base.ticks[base.values - 1] >= gts.ticks[0] : base.ticks[base.values - 1] <= gts.ticks[0]) : false;
        }
        base.values += gts.values;
        return base;
    }

    public static GeoTimeSerie mergeViaEncoders(List<GeoTimeSerie> series) throws IOException {
        GTSEncoder encoder = new GTSEncoder(0L);
        try {
            for (int i = 0; i < series.size(); ++i) {
                GeoTimeSerie gts = series.get(i);
                if (0 == i) {
                    encoder.setMetadata(gts.getMetadata());
                }
                encoder.encode(gts);
            }
        }
        catch (IOException ioe) {
            throw new IOException(ioe);
        }
        return encoder.getDecoder(true).decode();
    }

    public static GeoTimeSerie sortedMerge(GeoTimeSerie base, GeoTimeSerie gts) {
        if (0 == gts.values) {
            return base.clone();
        }
        GeoTimeSerie.TYPE baseType = base.getType();
        GeoTimeSerie.TYPE gtsType = gts.getType();
        if (!GeoTimeSerie.TYPE.UNDEFINED.equals((Object)baseType) && !baseType.equals((Object)gtsType)) {
            throw new RuntimeException("merge cannot proceed with incompatible GTS types.");
        }
        GeoTimeSerie merged = base.cloneEmpty();
        merged.type = gtsType;
        GTSHelper.sort(base);
        GTSHelper.sort(gts);
        merged.ticks = new long[base.values + gts.values];
        if (null != base.locations || null != gts.locations) {
            merged.locations = new long[merged.ticks.length];
        }
        if (null != base.elevations || null != gts.elevations) {
            merged.elevations = new long[merged.ticks.length];
        }
        if (GeoTimeSerie.TYPE.LONG == merged.type) {
            merged.longValues = new long[base.values + gts.values];
        } else if (GeoTimeSerie.TYPE.DOUBLE == merged.type) {
            merged.doubleValues = new double[base.values + gts.values];
        } else if (GeoTimeSerie.TYPE.STRING == merged.type) {
            merged.stringValues = new String[base.values + gts.values];
        } else {
            merged.booleanValues = new BitSet();
        }
        int baseIndex = 0;
        int gtsIndex = 0;
        int mergedIndex = 0;
        while (base.values > baseIndex && gts.values > gtsIndex) {
            if (base.ticks[baseIndex] < gts.ticks[gtsIndex]) {
                merged.ticks[mergedIndex] = base.ticks[baseIndex];
                if (null != merged.locations) {
                    long l = merged.locations[mergedIndex] = null == base.locations ? 91480763316633925L : base.locations[baseIndex];
                }
                if (null != merged.locations) {
                    long l = merged.locations[mergedIndex] = null == base.locations ? 91480763316633925L : base.locations[baseIndex];
                }
                if (GeoTimeSerie.TYPE.LONG == merged.type) {
                    merged.longValues[mergedIndex] = base.longValues[baseIndex];
                } else if (GeoTimeSerie.TYPE.DOUBLE == merged.type) {
                    merged.doubleValues[mergedIndex] = base.doubleValues[baseIndex];
                } else if (GeoTimeSerie.TYPE.STRING == merged.type) {
                    merged.stringValues[mergedIndex] = base.stringValues[baseIndex];
                } else {
                    merged.booleanValues.set(mergedIndex, base.booleanValues.get(baseIndex));
                }
                ++baseIndex;
            } else {
                if (base.ticks[baseIndex] == gts.ticks[gtsIndex]) {
                    ++baseIndex;
                }
                merged.ticks[mergedIndex] = gts.ticks[gtsIndex];
                if (null != merged.locations) {
                    long l = merged.locations[mergedIndex] = null == gts.locations ? 91480763316633925L : gts.locations[gtsIndex];
                }
                if (null != merged.locations) {
                    long l = merged.locations[mergedIndex] = null == gts.locations ? 91480763316633925L : gts.locations[gtsIndex];
                }
                if (GeoTimeSerie.TYPE.LONG == merged.type) {
                    merged.longValues[mergedIndex] = gts.longValues[gtsIndex];
                } else if (GeoTimeSerie.TYPE.DOUBLE == merged.type) {
                    merged.doubleValues[mergedIndex] = gts.doubleValues[gtsIndex];
                } else if (GeoTimeSerie.TYPE.STRING == merged.type) {
                    merged.stringValues[mergedIndex] = gts.stringValues[gtsIndex];
                } else {
                    merged.booleanValues.set(mergedIndex, gts.booleanValues.get(gtsIndex));
                }
                ++gtsIndex;
            }
            ++mergedIndex;
        }
        if (base.values > baseIndex) {
            int length = base.values - baseIndex;
            GTSHelper.copy0(base, baseIndex, merged, mergedIndex, length);
            mergedIndex += length;
        } else if (gts.values > gtsIndex) {
            int length = gts.values - gtsIndex;
            GTSHelper.copy0(gts, gtsIndex, merged, mergedIndex, length);
            mergedIndex += length;
        }
        merged.values = mergedIndex;
        merged.sorted = true;
        return merged;
    }

    public static GTSEncoder sortedMerge(List<Object> params, boolean reversed) throws WarpScriptException {
        final class GTSAndIndex {
            private GeoTimeSerie gts;
            private int idx;

            GTSAndIndex() {
            }
        }
        int i;
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        ArrayList<GTSEncoder> encoders = new ArrayList<GTSEncoder>();
        for (int i2 = 0; i2 < params.size(); ++i2) {
            if (params.get(i2) instanceof GeoTimeSerie) {
                if (GTSHelper.nvalues((GeoTimeSerie)params.get(i2)) > 1) {
                    if (!GTSHelper.isSorted((GeoTimeSerie)params.get(i2))) {
                        throw new WarpScriptException("GTS " + GTSHelper.buildSelector((GeoTimeSerie)params.get(i2), false) + " is not sorted.");
                    }
                    if (GTSHelper.isReversed((GeoTimeSerie)params.get(i2)) != reversed) {
                        throw new WarpScriptException("GTS " + GTSHelper.buildSelector((GeoTimeSerie)params.get(i2), false) + " is not sorted in the expected order.");
                    }
                }
                series.add((GeoTimeSerie)params.get(i2));
                continue;
            }
            if (params.get(i2) instanceof GTSEncoder) {
                encoders.add((GTSEncoder)params.get(i2));
                continue;
            }
            if (!(params.get(i2) instanceof List)) continue;
            for (Object o : (List)params.get(i2)) {
                if (o instanceof GeoTimeSerie) {
                    if (GTSHelper.nvalues((GeoTimeSerie)o) > 1) {
                        if (!GTSHelper.isSorted((GeoTimeSerie)o)) {
                            throw new WarpScriptException("GTS " + GTSHelper.buildSelector((GeoTimeSerie)o, false) + " is not sorted.");
                        }
                        if (GTSHelper.isReversed((GeoTimeSerie)o) != reversed) {
                            throw new WarpScriptException("GTS " + GTSHelper.buildSelector((GeoTimeSerie)o, false) + " is not sorted in the expected order.");
                        }
                    }
                    series.add((GeoTimeSerie)o);
                    continue;
                }
                if (o instanceof GTSEncoder) {
                    encoders.add((GTSEncoder)o);
                    continue;
                }
                throw new WarpScriptException("expects a list of Geo Time Series or encoders or of lists thereof.");
            }
        }
        int gtsidx = encoders.size();
        final boolean freversed = reversed;
        PriorityQueue<Object> decoders = new PriorityQueue<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                GTSAndIndex gtsi;
                Long ts1 = null;
                Long ts2 = null;
                if (o1 instanceof GTSDecoder) {
                    ts1 = ((GTSDecoder)o1).getTimestamp();
                } else {
                    gtsi = (GTSAndIndex)o1;
                    if (gtsi.idx < gtsi.gts.size()) {
                        ts1 = GTSHelper.tickAtIndex(gtsi.gts, gtsi.idx);
                    }
                }
                if (o2 instanceof GTSDecoder) {
                    ts2 = ((GTSDecoder)o2).getTimestamp();
                } else {
                    gtsi = (GTSAndIndex)o2;
                    if (gtsi.idx < gtsi.gts.size()) {
                        ts2 = GTSHelper.tickAtIndex(gtsi.gts, gtsi.idx);
                    }
                }
                if (null == ts1 && null == ts2) {
                    return 0;
                }
                if (null == ts1) {
                    if (freversed) {
                        return -1;
                    }
                    return 1;
                }
                if (null == ts2) {
                    if (freversed) {
                        return 1;
                    }
                    return -1;
                }
                if (!freversed) {
                    return Long.compare(ts1, ts2);
                }
                return Long.compare(ts2, ts1);
            }
        });
        for (i = 0; i < encoders.size(); ++i) {
            GTSDecoder decoder = ((GTSEncoder)encoders.get(i)).getDecoder(true);
            if (!decoder.next()) continue;
            decoders.add(decoder);
        }
        for (i = 0; i < series.size(); ++i) {
            if (0 == ((GeoTimeSerie)series.get(i)).size()) continue;
            GTSAndIndex gtsi = new GTSAndIndex();
            gtsi.gts = (GeoTimeSerie)series.get(i);
            gtsi.idx = 0;
            decoders.add(gtsi);
        }
        GTSEncoder merged = new GTSEncoder(0L);
        if (!encoders.isEmpty()) {
            merged.setMetadata(((GTSEncoder)encoders.get(0)).getMetadata());
        } else if (!series.isEmpty()) {
            merged.setMetadata(((GeoTimeSerie)series.get(0)).getMetadata());
        }
        try {
            while (!decoders.isEmpty()) {
                Object first = decoders.peek();
                Long ts = null;
                Long lastTs = null;
                if (first instanceof GTSDecoder) {
                    GTSDecoder decoder = (GTSDecoder)first;
                    lastTs = decoder.getTimestamp();
                } else {
                    GTSAndIndex gtsi = (GTSAndIndex)first;
                    if (gtsi.idx < gtsi.gts.size()) {
                        lastTs = GTSHelper.tickAtIndex(gtsi.gts, gtsi.idx);
                    }
                }
                if (null != lastTs) {
                    boolean done = false;
                    while (!decoders.isEmpty() && !done) {
                        Object elt = decoders.remove();
                        if (elt instanceof GTSDecoder) {
                            GTSDecoder decoder = (GTSDecoder)elt;
                            ts = decoder.getTimestamp();
                            if (!lastTs.equals(ts)) {
                                decoders.add(elt);
                                done = true;
                                continue;
                            }
                            boolean exhausted = false;
                            while (lastTs.equals(ts)) {
                                merged.addValue(ts, decoder.getLocation(), decoder.getElevation(), decoder.getBinaryValue());
                                if (decoder.next()) {
                                    ts = decoder.getTimestamp();
                                    if (reversed && ts > lastTs) {
                                        throw new WarpScriptException("ENCODER " + GTSHelper.buildSelector(decoder.getMetadata(), false) + " is not sorted in expected order.");
                                    }
                                    if (reversed || ts >= lastTs) continue;
                                    throw new WarpScriptException("ENCODER " + GTSHelper.buildSelector(decoder.getMetadata(), false) + " is not sorted in expected order.");
                                }
                                ts = null;
                                exhausted = true;
                            }
                            if (exhausted) continue;
                            decoders.add(decoder);
                            continue;
                        }
                        GTSAndIndex gtsi = (GTSAndIndex)elt;
                        ts = GTSHelper.tickAtIndex(gtsi.gts, gtsi.idx);
                        if (!lastTs.equals(ts)) {
                            decoders.add(elt);
                            done = true;
                            continue;
                        }
                        while (lastTs.equals(ts)) {
                            merged.addValue(ts, GTSHelper.locationAtIndex(gtsi.gts, gtsi.idx), GTSHelper.elevationAtIndex(gtsi.gts, gtsi.idx), GTSHelper.valueAtIndex(gtsi.gts, gtsi.idx));
                            gtsi.idx++;
                            if (gtsi.idx >= gtsi.gts.size()) break;
                            ts = GTSHelper.tickAtIndex(gtsi.gts, gtsi.idx);
                        }
                        if (gtsi.idx >= gtsi.gts.size()) continue;
                        decoders.add(gtsi);
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            throw new WarpScriptException("encountered an error while merging.");
        }
        return merged;
    }

    public static GeoTimeSerie fillprevious(GeoTimeSerie gts) {
        GeoTimeSerie filled = gts.clone();
        if (!GTSHelper.isBucketized(filled)) {
            return filled;
        }
        GTSHelper.sort(filled, false);
        int nticks = filled.values;
        if (0 != nticks) {
            long firsttick = filled.ticks[0];
            filled.setSizeHint(1 + (int)((filled.lastbucket - firsttick) / filled.bucketspan));
        }
        int idx = 0;
        int bucketidx = filled.bucketcount - 1;
        long bucketts = filled.lastbucket - (long)bucketidx * filled.bucketspan;
        Object prevValue = null;
        long prevLocation = 91480763316633925L;
        long prevElevation = Long.MIN_VALUE;
        long bucketoffset = filled.lastbucket % filled.bucketspan;
        while (bucketidx >= 0) {
            while (idx < nticks && bucketoffset != filled.ticks[idx] % filled.bucketspan) {
                ++idx;
            }
            if (idx >= nticks) break;
            while (bucketidx >= 0 && filled.ticks[idx] > bucketts) {
                if (null != prevValue) {
                    GTSHelper.setValue(filled, bucketts, prevLocation, prevElevation, prevValue, false);
                }
                bucketts = filled.lastbucket - (long)(--bucketidx) * filled.bucketspan;
            }
            bucketts = filled.lastbucket - (long)(--bucketidx) * filled.bucketspan;
            prevValue = GTSHelper.valueAtIndex(filled, idx);
            prevLocation = null != filled.locations ? filled.locations[idx] : 91480763316633925L;
            prevElevation = null != filled.elevations ? filled.elevations[idx] : Long.MIN_VALUE;
            ++idx;
        }
        while (bucketidx >= 0) {
            if (null != prevValue) {
                GTSHelper.setValue(filled, bucketts, prevLocation, prevElevation, prevValue, false);
            }
            bucketts = filled.lastbucket - (long)(--bucketidx) * filled.bucketspan;
        }
        return filled;
    }

    public static GeoTimeSerie fillnext(GeoTimeSerie gts) {
        GeoTimeSerie filled = gts.clone();
        if (!GTSHelper.isBucketized(filled)) {
            return filled;
        }
        GTSHelper.sort(filled, true);
        int nticks = filled.values;
        if (0 != nticks) {
            long lasttick = filled.ticks[0];
            filled.setSizeHint(1 + (int)((lasttick - (filled.lastbucket - (long)filled.bucketcount * filled.bucketspan)) / filled.bucketspan));
        }
        int idx = 0;
        int bucketidx = 0;
        long bucketts = filled.lastbucket - (long)bucketidx * filled.bucketspan;
        Object prevValue = null;
        long prevLocation = 91480763316633925L;
        long prevElevation = Long.MIN_VALUE;
        long bucketoffset = filled.lastbucket % filled.bucketspan;
        while (bucketidx < filled.bucketcount) {
            while (idx < nticks && bucketoffset != filled.ticks[idx] % filled.bucketspan) {
                ++idx;
            }
            if (idx >= nticks) break;
            while (bucketidx >= 0 && filled.ticks[idx] < bucketts) {
                if (null != prevValue) {
                    GTSHelper.setValue(filled, bucketts, prevLocation, prevElevation, prevValue, false);
                }
                bucketts = filled.lastbucket - (long)(++bucketidx) * filled.bucketspan;
            }
            bucketts = filled.lastbucket - (long)(++bucketidx) * filled.bucketspan;
            prevValue = GTSHelper.valueAtIndex(filled, idx);
            prevLocation = null != filled.locations ? filled.locations[idx] : 91480763316633925L;
            prevElevation = null != filled.elevations ? filled.elevations[idx] : Long.MIN_VALUE;
            ++idx;
        }
        while (bucketidx < filled.bucketcount) {
            if (null != prevValue) {
                GTSHelper.setValue(filled, bucketts, prevLocation, prevElevation, prevValue, false);
            }
            bucketts = filled.lastbucket - (long)(++bucketidx) * filled.bucketspan;
        }
        return filled;
    }

    public static GeoTimeSerie fillvalue(GeoTimeSerie gts, long location, long elevation, Object value) {
        GeoTimeSerie filled = gts.clone();
        if (!GTSHelper.isBucketized(filled) || null == value) {
            return filled;
        }
        filled.setSizeHint(filled.bucketcount);
        GTSHelper.sort(filled);
        int idx = 0;
        int nticks = filled.values;
        for (int bucket = filled.bucketcount - 1; bucket >= 0; --bucket) {
            long bucketts = filled.lastbucket - (long)bucket * filled.bucketspan;
            while (idx < nticks && filled.ticks[idx] > bucketts || idx >= nticks && bucket >= 0) {
                GTSHelper.setValue(filled, bucketts, location, elevation, value, false);
                bucketts = filled.lastbucket - (long)(--bucket) * filled.bucketspan;
            }
            ++idx;
        }
        return filled;
    }

    public static GeoTimeSerie fillticks(GeoTimeSerie gts, long location, long elevation, Object value, long[] ticks) {
        GeoTimeSerie filled = gts.clone();
        if (null == value || GTSHelper.isBucketized(filled)) {
            return filled;
        }
        long[] gticks = filled.values > 0 ? Arrays.copyOf(filled.ticks, filled.values) : new long[]{};
        Arrays.sort(gticks);
        Arrays.sort(ticks);
        int tickidx = 0;
        int nvalues = filled.values;
        for (int gtsidx = 0; gtsidx < nvalues; ++gtsidx) {
            long tick = gticks[gtsidx];
            while (tickidx < ticks.length && ticks[tickidx] < tick) {
                GTSHelper.setValue(filled, ticks[tickidx], location, elevation, value, false);
                ++tickidx;
            }
        }
        while (tickidx < ticks.length) {
            GTSHelper.setValue(filled, ticks[tickidx], location, elevation, value, false);
            ++tickidx;
        }
        return filled;
    }

    public static final List<GeoTimeSerie> fill(GeoTimeSerie gtsa, GeoTimeSerie gtsb, WarpScriptFillerFunction filler) throws WarpScriptException {
        GTSHelper.sort(gtsa, false);
        GTSHelper.sort(gtsb, false);
        GeoTimeSerie ga = gtsa.clone();
        GeoTimeSerie gb = gtsb.clone();
        int idxa = 0;
        int idxb = 0;
        Long curTickA = null;
        Long curTickB = null;
        String classA = ga.getName();
        String classB = gb.getName();
        Map<String, String> labelsA = Collections.unmodifiableMap(ga.getLabels());
        Map<String, String> labelsB = Collections.unmodifiableMap(gb.getLabels());
        Map<String, String> attrA = Collections.unmodifiableMap(ga.getMetadata().getAttributes());
        Map<String, String> attrB = Collections.unmodifiableMap(gb.getMetadata().getAttributes());
        int prewindow = filler.getPreWindow() >= 0 ? filler.getPreWindow() : 0;
        int postwindow = filler.getPostWindow() >= 0 ? filler.getPostWindow() : 0;
        Object[] meta = new Object[2];
        Object[][] prev = new Object[prewindow][];
        for (int i = 0; i < prewindow; ++i) {
            prev[i] = new Object[4];
        }
        Object[][] next = new Object[postwindow][];
        for (int i = 0; i < postwindow; ++i) {
            next[i] = new Object[4];
        }
        Object[] other = new Object[4];
        Object[][] params = new Object[2 + prewindow + postwindow][];
        while (idxa < gtsa.values || idxb < gtsb.values) {
            int i;
            int i2;
            curTickA = null;
            curTickB = null;
            if (idxa < gtsa.values) {
                curTickA = gtsa.ticks[idxa];
            }
            if (idxb < gtsb.values) {
                curTickB = gtsb.ticks[idxb];
            }
            if (null != curTickA && curTickA.equals(curTickB)) {
                if ((++idxa >= gtsa.values || curTickA != gtsa.ticks[idxa]) && (++idxb >= gtsb.values || curTickB != gtsb.ticks[idxb])) continue;
                throw new WarpScriptException("Cannot fill Geo Time Series with duplicate timestamps.");
            }
            for (i2 = 0; i2 < prewindow; ++i2) {
                prev[i2][0] = null;
                prev[i2][1] = null;
                prev[i2][2] = null;
                prev[i2][3] = null;
            }
            for (i2 = 0; i2 < postwindow; ++i2) {
                next[i2][0] = null;
                next[i2][1] = null;
                next[i2][2] = null;
                next[i2][3] = null;
            }
            Object otherValue = null;
            Long otherTick = null;
            Long otherLocation = null;
            Long otherElevation = null;
            Metadata ourMeta = new Metadata();
            Metadata otherMeta = new Metadata();
            String ourClass = null;
            Map<String, String> ourLabels = null;
            Map<String, String> ourAttr = null;
            String otherClass = null;
            Map<String, String> otherLabels = null;
            Map<String, String> otherAttr = null;
            GeoTimeSerie filled = null;
            if (curTickA == null || null != curTickB && curTickA > curTickB) {
                int ia;
                filled = ga;
                for (i = prewindow - 1; i >= 0 && (ia = idxa - prewindow + i) >= 0; --i) {
                    prev[i][0] = gtsa.ticks[ia];
                    prev[i][1] = GTSHelper.locationAtIndex(gtsa, ia);
                    prev[i][2] = GTSHelper.elevationAtIndex(gtsa, ia);
                    prev[i][3] = GTSHelper.valueAtIndex(gtsa, ia);
                }
                for (i = 0; i < postwindow && (ia = idxa + i) < gtsa.values; ++i) {
                    next[i][0] = gtsa.ticks[ia];
                    next[i][1] = GTSHelper.locationAtIndex(gtsa, ia);
                    next[i][2] = GTSHelper.elevationAtIndex(gtsa, ia);
                    next[i][3] = GTSHelper.valueAtIndex(gtsa, ia);
                }
                otherValue = GTSHelper.valueAtIndex(gtsb, idxb);
                otherTick = gtsb.ticks[idxb];
                otherLocation = GTSHelper.locationAtIndex(gtsb, idxb);
                otherElevation = GTSHelper.elevationAtIndex(gtsb, idxb);
                ourClass = classA;
                ourLabels = labelsA;
                ourAttr = attrA;
                otherClass = classB;
                otherLabels = labelsB;
                otherAttr = attrB;
                ++idxb;
            } else {
                int ib;
                int ib2;
                filled = gb;
                for (i = prewindow - 1; i >= 0 && (ib2 = idxb - prewindow + i) >= 0; --i) {
                    prev[i][0] = gtsb.ticks[ib2];
                    prev[i][1] = GTSHelper.locationAtIndex(gtsb, ib2);
                    prev[i][2] = GTSHelper.elevationAtIndex(gtsb, ib2);
                    prev[i][3] = GTSHelper.valueAtIndex(gtsb, ib2);
                }
                for (i = 0; i < postwindow && (ib = idxb + i) < gtsb.values; ++i) {
                    next[i][0] = gtsb.ticks[ib];
                    next[i][1] = GTSHelper.locationAtIndex(gtsb, ib);
                    next[i][2] = GTSHelper.elevationAtIndex(gtsb, ib);
                    next[i][3] = GTSHelper.valueAtIndex(gtsb, ib);
                }
                otherValue = GTSHelper.valueAtIndex(gtsa, idxa);
                otherTick = gtsa.ticks[idxa];
                otherLocation = GTSHelper.locationAtIndex(gtsa, idxa);
                otherElevation = GTSHelper.elevationAtIndex(gtsa, idxa);
                ourClass = classB;
                ourLabels = labelsB;
                ourAttr = attrB;
                otherClass = classA;
                otherLabels = labelsA;
                otherAttr = attrA;
                ++idxa;
            }
            other[0] = otherTick;
            other[1] = otherLocation;
            other[2] = otherElevation;
            other[3] = otherValue;
            ourMeta.setName(ourClass);
            ourMeta.setLabels(ourLabels);
            ourMeta.setAttributes(ourAttr);
            meta[0] = ourMeta;
            otherMeta.setName(otherClass);
            otherMeta.setLabels(otherLabels);
            otherMeta.setAttributes(otherAttr);
            meta[1] = otherMeta;
            params[0] = meta;
            for (i = 0; i < prewindow; ++i) {
                params[1 + i] = prev[i];
            }
            params[prewindow + 1] = other;
            for (i = 0; i < postwindow; ++i) {
                params[2 + prewindow + i] = next[i];
            }
            Object[] result = filler.apply((Object[])params);
            if (null == result[3]) continue;
            long tick = ((Number)result[0]).longValue();
            long location = ((Number)result[1]).longValue();
            long elevation = ((Number)result[2]).longValue();
            Object value = result[3];
            GTSHelper.setValue(filled, tick, location, elevation, value, false);
        }
        ArrayList<GeoTimeSerie> results = new ArrayList<GeoTimeSerie>();
        results.add(ga);
        results.add(gb);
        return results;
    }

    public static GeoTimeSerie compensateResets(GeoTimeSerie gts, boolean resethigher) {
        GeoTimeSerie filled = gts.clone();
        GeoTimeSerie.TYPE type = gts.getType();
        if (GeoTimeSerie.TYPE.LONG != type && GeoTimeSerie.TYPE.DOUBLE != type) {
            return filled;
        }
        GTSHelper.sort(filled);
        long lastl = GeoTimeSerie.TYPE.LONG == type ? filled.longValues[0] : 0L;
        long offsetl = 0L;
        double lastd = GeoTimeSerie.TYPE.DOUBLE == type ? filled.doubleValues[0] : 0.0;
        double offsetd = 0.0;
        for (int i = 1; i < filled.values; ++i) {
            if (GeoTimeSerie.TYPE.LONG == type) {
                long value = filled.longValues[i];
                if (!resethigher) {
                    if (value < lastl) {
                        offsetl += lastl;
                    }
                    lastl = value;
                } else {
                    if (value > lastl) {
                        offsetl += lastl;
                    }
                    lastl = value;
                }
                filled.longValues[i] = value + offsetl;
                continue;
            }
            double value = filled.doubleValues[i];
            if (!resethigher) {
                if (value < lastd) {
                    offsetd += lastd;
                }
                lastd = value;
            } else {
                if (value > lastd) {
                    offsetd += lastd;
                }
                lastd = value;
            }
            filled.doubleValues[i] = value + offsetd;
        }
        return filled;
    }

    public static boolean isBucketized(GeoTimeSerie gts) {
        return 0 != gts.bucketcount && 0L != gts.bucketspan && 0L != gts.lastbucket;
    }

    public static List<GeoTimeSerie> timesplit(GeoTimeSerie gts, long quietperiod, int minvalues, String labelname) {
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        if (0 == gts.values || gts.hasLabel(labelname)) {
            series.add(gts.clone());
            return series;
        }
        GTSHelper.sort(gts, false);
        long lasttick = gts.ticks[0];
        int idx = 0;
        int gtsid = 1;
        GeoTimeSerie serie = new GeoTimeSerie(gts.lastbucket, gts.bucketcount, gts.bucketspan, 4);
        serie.setName(gts.getName());
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.putAll(gts.getLabels());
        labels.put(labelname, Integer.toString(gtsid));
        serie.setLabels(labels);
        if (gts.getMetadata().getAttributesSize() > 0) {
            serie.getMetadata().setAttributes(new HashMap<String, String>(gts.getMetadata().getAttributes()));
        }
        while (idx < gts.values) {
            if (gts.ticks[idx] - lasttick >= quietperiod) {
                if (serie.values > 0 && serie.values >= minvalues) {
                    series.add(serie);
                }
                serie = new GeoTimeSerie(gts.lastbucket, gts.bucketcount, gts.bucketspan, 4);
                serie.setName(gts.getName());
                labels = new HashMap();
                labels.putAll(gts.getLabels());
                labels.put(labelname, Integer.toString(++gtsid));
                serie.setLabels(labels);
                if (gts.getMetadata().getAttributesSize() > 0) {
                    serie.getMetadata().setAttributes(new HashMap<String, String>(gts.getMetadata().getAttributes()));
                }
            }
            Object value = GTSHelper.valueAtIndex(gts, idx);
            GTSHelper.setValue(serie, gts.ticks[idx], null != gts.locations ? gts.locations[idx] : 91480763316633925L, null != gts.elevations ? gts.elevations[idx] : Long.MIN_VALUE, value, false);
            lasttick = gts.ticks[idx];
            ++idx;
        }
        if (serie.values > 0 && serie.values >= minvalues) {
            series.add(serie);
        }
        return series;
    }

    public static GeoTimeSerie crop(GeoTimeSerie gts) {
        if (!GTSHelper.isBucketized(gts)) {
            return gts.clone();
        }
        GTSHelper.sort(gts, false);
        long firstbucket = gts.lastbucket - (long)(gts.bucketcount - 1) * gts.bucketspan;
        GeoTimeSerie cropped = new GeoTimeSerie(4);
        cropped.setMetadata(new Metadata(gts.getMetadata()));
        for (int i = 0; i < gts.values; ++i) {
            if (gts.ticks[i] < firstbucket || gts.ticks[i] > gts.lastbucket || gts.ticks[i] % gts.bucketspan != gts.lastbucket % gts.bucketspan) continue;
            GTSHelper.setValue(cropped, gts.ticks[i], null != gts.locations ? gts.locations[i] : 91480763316633925L, null != gts.elevations ? gts.elevations[i] : Long.MIN_VALUE, GTSHelper.valueAtIndex(gts, i), false);
        }
        cropped.bucketspan = gts.bucketspan;
        cropped.lastbucket = cropped.ticks[cropped.values - 1];
        cropped.bucketcount = 1 + (int)((cropped.lastbucket - cropped.ticks[0]) / cropped.bucketspan);
        return cropped;
    }

    public static GeoTimeSerie timeshift(GeoTimeSerie gts, long delta) {
        GeoTimeSerie shifted = gts.clone();
        for (int i = 0; i < shifted.values; ++i) {
            shifted.ticks[i] = shifted.ticks[i] + delta;
        }
        if (GTSHelper.isBucketized(shifted)) {
            shifted.lastbucket += delta;
        }
        return shifted;
    }

    public static GeoTimeSerie tickindex(GeoTimeSerie gts) {
        GeoTimeSerie indexed = gts.clone();
        for (int i = 0; i < indexed.values; ++i) {
            indexed.ticks[i] = i;
        }
        indexed.bucketcount = 0;
        indexed.bucketspan = 0L;
        indexed.lastbucket = 0L;
        return indexed;
    }

    public static GTSEncoder tickindex(GTSEncoder encoder) throws IOException {
        long index = 0L;
        GTSDecoder decoder = encoder.getDecoder(true);
        GTSEncoder newencoder = new GTSEncoder(0L);
        while (decoder.next()) {
            newencoder.addValue(index++, decoder.getLocation(), decoder.getElevation(), decoder.getBinaryValue());
        }
        return newencoder;
    }

    public static void clear(GeoTimeSerie gts) {
        gts.values = 0;
        gts.type = GeoTimeSerie.TYPE.UNDEFINED;
        gts.booleanValues = null;
        gts.locations = null;
        gts.elevations = null;
        gts.ticks = null;
        gts.doubleValues = null;
        gts.longValues = null;
        gts.stringValues = null;
    }

    public static void reset(GeoTimeSerie gts) {
        gts.values = 0;
        gts.type = GeoTimeSerie.TYPE.UNDEFINED;
        GTSHelper.unbucketize(gts);
    }

    public static List<GeoTimeSerie> map(GeoTimeSerie gts, WarpScriptMapperFunction mapper, long prewindow, long postwindow, long occurrences, boolean reversed, int step, boolean overrideTick) throws WarpScriptException {
        return GTSHelper.map(gts, mapper, prewindow, postwindow, occurrences, reversed, step, overrideTick, null);
    }

    public static List<GeoTimeSerie> map(GeoTimeSerie gts, Object mapper, long prewindow, long postwindow, long occurrences, boolean reversed, int step, boolean overrideTick, WarpScriptStack stack) throws WarpScriptException {
        return GTSHelper.map(gts, mapper, prewindow, postwindow, occurrences, reversed, step, overrideTick, stack, null);
    }

    public static List<GeoTimeSerie> map(GeoTimeSerie gts, Object mapper, long prewindow, long postwindow, long occurrences, boolean reversed, int step, boolean overrideTick, WarpScriptStack stack, List<Long> outputTicks) throws WarpScriptException {
        return GTSHelper.map(gts, mapper, prewindow, postwindow, occurrences, reversed, step, overrideTick, stack, outputTicks, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<GeoTimeSerie> map(GeoTimeSerie gts, Object mapper, long prewindow, long postwindow, long occurrences, boolean reversed, int step, boolean overrideTick, WarpScriptStack stack, List<Long> outputTicks, boolean dedup) throws WarpScriptException {
        int nticks;
        if (step <= 0) {
            step = 1;
        }
        if (prewindow > Integer.MAX_VALUE) {
            prewindow = Integer.MAX_VALUE;
        }
        if (postwindow > Integer.MAX_VALUE) {
            postwindow = Integer.MAX_VALUE;
        }
        if (occurrences > Integer.MAX_VALUE) {
            occurrences = Integer.MAX_VALUE;
        }
        ArrayList<GeoTimeSerie> results = new ArrayList<GeoTimeSerie>();
        GeoTimeSerie mapped = gts.clone();
        if (0 == mapped.values && !GTSHelper.isBucketized(mapped)) {
            results.add(mapped);
            return results;
        }
        GTSHelper.sort(mapped, reversed);
        boolean isBucketized = GTSHelper.isBucketized(gts);
        long[] ticks = isBucketized ? null : Arrays.copyOf(mapped.ticks, gts.values);
        GTSHelper.clear(mapped);
        int idx = 0;
        int rightIdx = 0;
        int leftIdx = 0;
        int n = nticks = isBucketized ? mapped.bucketcount : ticks.length;
        if (null != outputTicks) {
            nticks = outputTicks.size();
        }
        Map<String, String> labels = gts.getLabels();
        long tick = 0L;
        GeoTimeSerie subgts = null;
        boolean hasOccurrences = 0L != occurrences;
        TreeMap<String, GeoTimeSerie> multipleMapped = new TreeMap<String, GeoTimeSerie>();
        boolean hasSingleResult = true;
        long lastTick = 0L;
        long numbOfMappedDupTick = 0L;
        while (!(idx >= nticks || hasOccurrences && 0L == occurrences)) {
            void var37_29;
            if (null == outputTicks) {
                tick = reversed ? (isBucketized ? mapped.lastbucket - (long)idx * mapped.bucketspan : ticks[idx]) : (isBucketized ? mapped.lastbucket - (long)(mapped.bucketcount - 1 - idx) * mapped.bucketspan : ticks[idx]);
            } else {
                tick = outputTicks.get(idx);
                if (!isBucketized) {
                    if (reversed) {
                        while (leftIdx < ticks.length && ticks[leftIdx] > tick) {
                            ++leftIdx;
                        }
                    } else {
                        while (rightIdx < ticks.length && ticks[rightIdx] < tick) {
                            ++rightIdx;
                        }
                    }
                }
            }
            if (0 != idx && lastTick == tick) {
                if (dedup) {
                    idx += step;
                    continue;
                }
                ++numbOfMappedDupTick;
            } else {
                numbOfMappedDupTick = 0L;
            }
            lastTick = tick;
            long start = tick;
            long stop = tick;
            if (prewindow < 0L) {
                start = tick + prewindow;
            } else if (prewindow > 0L) {
                if (isBucketized) {
                    start = prewindow <= (long)mapped.bucketcount ? tick - prewindow * mapped.bucketspan : Long.MIN_VALUE;
                } else if (null == outputTicks) {
                    start = reversed ? ((long)idx + prewindow < (long)ticks.length ? ticks[idx + (int)prewindow] : Long.MIN_VALUE) : ((long)idx - prewindow >= 0L ? ticks[idx - (int)prewindow] : Long.MIN_VALUE);
                } else if (reversed) {
                    start = leftIdx < ticks.length && ticks[leftIdx] == tick ? ((long)leftIdx + prewindow < (long)ticks.length ? ticks[leftIdx + (int)prewindow] : Long.MIN_VALUE) : ((long)(leftIdx - 1) + prewindow < (long)ticks.length ? ticks[leftIdx - 1 + (int)prewindow] : Long.MIN_VALUE);
                } else {
                    long l = start = (long)rightIdx - prewindow >= 0L ? ticks[rightIdx - (int)prewindow] : Long.MIN_VALUE;
                }
            }
            if (postwindow < 0L) {
                stop = tick - postwindow;
            } else if (postwindow > 0L) {
                stop = isBucketized ? (postwindow <= (long)mapped.bucketcount ? tick + postwindow * mapped.bucketspan : Long.MAX_VALUE) : (null == outputTicks ? (reversed ? ((long)idx - postwindow >= 0L ? ticks[idx - (int)postwindow] : Long.MAX_VALUE) : ((long)idx + postwindow < (long)ticks.length ? ticks[idx + (int)postwindow] : Long.MAX_VALUE)) : (reversed ? ((long)leftIdx - postwindow >= 0L ? ticks[leftIdx - (int)postwindow] : Long.MAX_VALUE) : (rightIdx < ticks.length && tick == ticks[rightIdx] ? ((long)rightIdx + postwindow < (long)ticks.length ? ticks[rightIdx + (int)postwindow] : Long.MAX_VALUE) : ((long)(rightIdx - 1) + postwindow < (long)ticks.length ? ticks[rightIdx - 1 + (int)postwindow] : Long.MAX_VALUE))));
            }
            subgts = GTSHelper.subSerie(gts, start, stop, false, false, subgts);
            Object var37_30 = null;
            if (null != stack) {
                if (!(mapper instanceof WarpScriptStack.Macro)) throw new WarpScriptException("Invalid mapper function.");
                subgts.safeSetMetadata(mapped.getMetadata());
                stack.push(subgts);
                stack.exec((WarpScriptStack.Macro)mapper);
                Object res = stack.peek();
                if (res instanceof List) {
                    stack.drop();
                    Object[] objectArray = MACROMAPPER.listToObjects((List)res);
                } else if (res instanceof Map) {
                    stack.drop();
                    for (Map.Entry keyAndValue : ((Map)res).entrySet()) {
                        Object[] ores2 = MACROMAPPER.listToObjects((List)keyAndValue.getValue());
                        ((Map)res).put(keyAndValue.getKey(), ores2);
                    }
                    Object object = res;
                } else {
                    Object[] objectArray = MACROMAPPER.stackToObjects(stack);
                }
            } else {
                void var39_53;
                void var39_52;
                void var39_43;
                void var39_42;
                void var39_41;
                if (!(mapper instanceof WarpScriptMapperFunction)) {
                    throw new WarpScriptException("Expected a mapper function.");
                }
                Object[] parms = new Object[8];
                int n2 = 0;
                parms[n2] = tick;
                parms[++var39_40] = new String[subgts.values];
                Arrays.fill((Object[])parms[++var39_41 - true], gts.getName());
                parms[var39_41] = new Map[subgts.values];
                Arrays.fill((Object[])parms[++var39_42 - true], labels);
                ++var39_43;
                parms[var39_42] = subgts.values > 0 ? Arrays.copyOf(subgts.ticks, subgts.values) : new long[]{};
                if (null != subgts.locations) {
                    void var39_44;
                    ++var39_44;
                    parms[var39_43] = subgts.values > 0 ? Arrays.copyOf(subgts.locations, subgts.values) : new long[]{};
                } else if (subgts.values > 0) {
                    void var39_45;
                    parms[var39_43] = new long[subgts.values];
                    Arrays.fill((long[])parms[++var39_45 - true], 91480763316633925L);
                } else {
                    void var39_46;
                    ++var39_46;
                    parms[var39_43] = new long[0];
                }
                if (null != subgts.elevations) {
                    void var39_48;
                    ++var39_48;
                    parms[var39_47] = subgts.values > 0 ? Arrays.copyOf(subgts.elevations, subgts.values) : new long[]{};
                } else if (subgts.values > 0) {
                    void var39_49;
                    parms[var39_47] = new long[subgts.values];
                    Arrays.fill((long[])parms[++var39_49 - true], Long.MIN_VALUE);
                } else {
                    void var39_50;
                    ++var39_50;
                    parms[var39_47] = new long[0];
                }
                ++var39_52;
                parms[var39_51] = new Object[subgts.values];
                int tickidx = -1;
                for (int j = 0; j < subgts.values; ++j) {
                    ((Object[])parms[6])[j] = GTSHelper.valueAtIndex(subgts, j);
                    if (-1 != tickidx && !reversed || tick != GTSHelper.tickAtIndex(subgts, j)) continue;
                    tickidx = j;
                }
                tickidx = reversed ? (int)((long)tickidx - numbOfMappedDupTick) : (int)((long)tickidx + numbOfMappedDupTick);
                ++var39_53;
                parms[var39_52] = new long[]{prewindow, postwindow, start, stop, tickidx};
                Object object = ((WarpScriptMapperFunction)mapper).apply(parms);
            }
            if (var37_29 instanceof Map) {
                hasSingleResult = false;
                for (Map.Entry entry : ((Map)var37_29).entrySet()) {
                    Object[] result;
                    GeoTimeSerie mgts = (GeoTimeSerie)multipleMapped.get(entry.getKey().toString());
                    if (null == mgts) {
                        mgts = mapped.cloneEmpty();
                        if (null != outputTicks) {
                            GTSHelper.unbucketize(mgts);
                        }
                        mgts.setName(entry.getKey().toString());
                        multipleMapped.put(entry.getKey().toString(), mgts);
                    }
                    if (null == (result = (Object[])entry.getValue())[3]) continue;
                    GTSHelper.setValue(mgts, overrideTick ? (Long)result[0] : tick, (Long)result[1], (Long)result[2], result[3], false);
                }
            } else {
                Object[] result;
                Object[] objectArray = result = var37_29 instanceof List ? ((List)var37_29).toArray() : (Object[])var37_29;
                if (null != result[3]) {
                    GTSHelper.setValue(mapped, overrideTick ? (Long)result[0] : tick, (Long)result[1], (Long)result[2], result[3], false);
                }
            }
            idx += step;
            --occurrences;
        }
        if (hasSingleResult) {
            if (null != outputTicks) {
                GTSHelper.unbucketize(mapped);
            }
            results.add(mapped);
        }
        if (multipleMapped.isEmpty()) return results;
        results.addAll(multipleMapped.values());
        return results;
    }

    public static List<GeoTimeSerie> map(GeoTimeSerie gts, WarpScriptMapperFunction mapper, long prewindow, long postwindow, long occurrences, boolean reversed) throws WarpScriptException {
        return GTSHelper.map(gts, mapper, prewindow, postwindow, occurrences, reversed, 1, false);
    }

    public static List<GeoTimeSerie> map(GeoTimeSerie gts, WarpScriptMapperFunction mapper, long prewindow, long postwindow) throws WarpScriptException {
        return GTSHelper.map(gts, mapper, prewindow, postwindow, 0L, false);
    }

    public static GeoTimeSerie relabel(GeoTimeSerie gts, Map<String, String> newlabels) {
        Map<String, String> labels = GTSHelper.relabel(gts.getMetadata(), newlabels);
        gts.getMetadata().setLabels(labels);
        return gts;
    }

    public static GTSEncoder relabel(GTSEncoder encoder, Map<String, String> newlabels) {
        Map<String, String> labels = GTSHelper.relabel(encoder.getMetadata(), newlabels);
        encoder.getMetadata().setLabels(labels);
        return encoder;
    }

    private static Map<String, String> relabel(Metadata metadata, Map<String, String> newlabels) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (!newlabels.containsKey(null)) {
            labels.putAll(metadata.getLabels());
        }
        for (Map.Entry<String, String> nameAndValue : newlabels.entrySet()) {
            String name = nameAndValue.getKey();
            String value = nameAndValue.getValue();
            if (null == value || "".equals(value)) {
                labels.remove(name);
                continue;
            }
            if (null == name) continue;
            labels.put(name, value);
        }
        return labels;
    }

    public static GeoTimeSerie rename(GeoTimeSerie gts, String name) {
        String newname = null;
        newname = name.startsWith("+") ? gts.getName() + name.substring(1) : name;
        gts.setName(newname);
        gts.setRenamed(true);
        return gts;
    }

    public static Map<Map<String, String>, List<GeoTimeSerie>> partition(Collection<GeoTimeSerie> series, Collection<String> bylabels) {
        HashMap classes = new HashMap();
        HashMap labelsbyclass = new HashMap();
        for (GeoTimeSerie gts : series) {
            HashMap<String, String> eqcls = new HashMap<String, String>();
            if (null == bylabels) {
                eqcls.putAll(gts.getMetadata().getLabels());
            } else {
                for (String label : bylabels) {
                    if (!gts.hasLabel(label)) continue;
                    eqcls.put(label, gts.getLabel(label));
                }
            }
            if (!classes.containsKey(eqcls)) {
                classes.put(eqcls, new ArrayList());
                ((List)classes.get(eqcls)).add(gts);
                labelsbyclass.put(eqcls, new HashMap());
                ((Map)labelsbyclass.get(eqcls)).putAll(gts.getLabels());
                continue;
            }
            ((List)classes.get(eqcls)).add(gts);
            ArrayList<String> labelstoremove = new ArrayList<String>();
            Map<String, String> gtsLabels = gts.getMetadata().getLabels();
            for (Map.Entry labelAndValue : ((Map)labelsbyclass.get(eqcls)).entrySet()) {
                String label = (String)labelAndValue.getKey();
                if (((String)labelAndValue.getValue()).equals(gtsLabels.get(label))) continue;
                labelstoremove.add(label);
            }
            for (String label : labelstoremove) {
                ((Map)labelsbyclass.get(eqcls)).remove(label);
            }
        }
        HashMap<Map<String, String>, List<GeoTimeSerie>> partition = new HashMap<Map<String, String>, List<GeoTimeSerie>>(classes.size());
        for (Map.Entry keyAndValue : classes.entrySet()) {
            partition.put((Map<String, String>)labelsbyclass.get(keyAndValue.getKey()), (List<GeoTimeSerie>)keyAndValue.getValue());
        }
        return partition;
    }

    public static Map<String, String> commonAttributes(List<GeoTimeSerie> lgts) {
        HashMap<String, String> commonAttributes = new HashMap<String, String>();
        for (int i = 0; i < lgts.size(); ++i) {
            Map<String, String> attributes = lgts.get(i).getMetadata().getAttributes();
            if (null == attributes || attributes.isEmpty()) {
                commonAttributes.clear();
                break;
            }
            if (0 == i) {
                commonAttributes.putAll(attributes);
                continue;
            }
            commonAttributes.entrySet().retainAll(attributes.entrySet());
            if (commonAttributes.isEmpty()) break;
        }
        return commonAttributes;
    }

    public static long firsttick(GeoTimeSerie gts) {
        if (GTSHelper.isBucketized(gts)) {
            return gts.lastbucket - (long)(gts.bucketcount - 1) * gts.bucketspan;
        }
        long firsttick = Long.MAX_VALUE;
        if (gts.sorted && gts.values > 0) {
            firsttick = !gts.reversed ? gts.ticks[0] : gts.ticks[gts.values - 1];
        } else {
            for (int i = 0; i < gts.values; ++i) {
                if (gts.ticks[i] >= firsttick) continue;
                firsttick = gts.ticks[i];
            }
        }
        return firsttick;
    }

    public static long lasttick(GeoTimeSerie gts) {
        if (GTSHelper.isBucketized(gts)) {
            return gts.lastbucket;
        }
        long lasttick = Long.MIN_VALUE;
        if (gts.sorted && gts.values > 0) {
            lasttick = !gts.reversed ? gts.ticks[gts.values - 1] : gts.ticks[0];
        } else {
            for (int i = 0; i < gts.values; ++i) {
                if (gts.ticks[i] <= lasttick) continue;
                lasttick = gts.ticks[i];
            }
        }
        return lasttick;
    }

    public static int nticks(GeoTimeSerie gts) {
        if (GTSHelper.isBucketized(gts)) {
            return gts.bucketcount;
        }
        return gts.values;
    }

    public static int nvalues(GeoTimeSerie gts) {
        return gts.values;
    }

    public static boolean isSorted(GeoTimeSerie gts) {
        return gts.sorted;
    }

    public static boolean isReversed(GeoTimeSerie gts) {
        return gts.reversed;
    }

    public static Object max(GeoTimeSerie gts) throws WarpScriptException {
        Object[] parms = new Object[8];
        int i = 0;
        parms[i++] = 0L;
        parms[i++] = null;
        parms[i++] = null;
        parms[i++] = Arrays.copyOf(gts.ticks, gts.values);
        if (null != gts.locations) {
            parms[i++] = Arrays.copyOf(gts.locations, gts.values);
        } else {
            parms[i++] = new long[gts.values];
            Arrays.fill((long[])parms[i - 1], 91480763316633925L);
        }
        if (null != gts.elevations) {
            parms[i++] = Arrays.copyOf(gts.elevations, gts.values);
        } else {
            parms[i++] = new long[gts.values];
            Arrays.fill((long[])parms[i - 1], Long.MIN_VALUE);
        }
        parms[i++] = new Object[gts.values];
        parms[i++] = null;
        for (int j = 0; j < gts.values; ++j) {
            ((Object[])parms[6])[j] = GTSHelper.valueAtIndex(gts, j);
        }
        Object[] result = (Object[])((WarpScriptAggregatorFunction)WarpScriptLib.getFunction("mapper.max")).apply(parms);
        return result[3];
    }

    public static Object min(GeoTimeSerie gts) throws WarpScriptException {
        Object[] parms = new Object[8];
        int i = 0;
        parms[i++] = 0L;
        parms[i++] = null;
        parms[i++] = null;
        parms[i++] = Arrays.copyOf(gts.ticks, gts.values);
        if (null != gts.locations) {
            parms[i++] = Arrays.copyOf(gts.locations, gts.values);
        } else {
            parms[i++] = new long[gts.values];
            Arrays.fill((long[])parms[i - 1], 91480763316633925L);
        }
        if (null != gts.elevations) {
            parms[i++] = Arrays.copyOf(gts.elevations, gts.values);
        } else {
            parms[i++] = new long[gts.values];
            Arrays.fill((long[])parms[i - 1], Long.MIN_VALUE);
        }
        parms[i++] = new Object[gts.values];
        parms[i++] = null;
        for (int j = 0; j < gts.values; ++j) {
            ((Object[])parms[6])[j] = GTSHelper.valueAtIndex(gts, j);
        }
        Object[] result = (Object[])((WarpScriptAggregatorFunction)WarpScriptLib.getFunction("mapper.min")).apply(parms);
        return result[3];
    }

    public static Object lowest(GeoTimeSerie gts) throws WarpScriptException {
        Object[] parms = new Object[6];
        int i = 0;
        parms[i++] = 0L;
        parms[i++] = 0L;
        parms[i++] = Arrays.copyOf(gts.ticks, gts.values);
        if (null != gts.locations) {
            parms[i++] = Arrays.copyOf(gts.locations, gts.values);
        } else {
            parms[i++] = new long[gts.values];
            Arrays.fill((long[])parms[i - 1], 91480763316633925L);
        }
        if (null != gts.elevations) {
            parms[i++] = Arrays.copyOf(gts.elevations, gts.values);
        } else {
            parms[i++] = new long[gts.values];
            Arrays.fill((long[])parms[i - 1], Long.MIN_VALUE);
        }
        parms[i++] = new Object[gts.values];
        for (int j = 0; j < gts.values; ++j) {
            ((Object[])parms[5])[j] = GTSHelper.valueAtIndex(gts, j);
        }
        Object[] result = (Object[])((WarpScriptAggregatorFunction)WarpScriptLib.getFunction("mapper.lowest")).apply(parms);
        return result[3];
    }

    public static Object highest(GeoTimeSerie gts) throws WarpScriptException {
        Object[] parms = new Object[6];
        int i = 0;
        parms[i++] = 0L;
        parms[i++] = 0L;
        parms[i++] = Arrays.copyOf(gts.ticks, gts.values);
        if (null != gts.locations) {
            parms[i++] = Arrays.copyOf(gts.locations, gts.values);
        } else {
            parms[i++] = new long[gts.values];
            Arrays.fill((long[])parms[i - 1], 91480763316633925L);
        }
        if (null != gts.elevations) {
            parms[i++] = Arrays.copyOf(gts.elevations, gts.values);
        } else {
            parms[i++] = new long[gts.values];
            Arrays.fill((long[])parms[i - 1], Long.MIN_VALUE);
        }
        parms[i++] = new Object[gts.values];
        for (int j = 0; j < gts.values; ++j) {
            ((Object[])parms[5])[j] = GTSHelper.valueAtIndex(gts, j);
        }
        Object[] result = (Object[])((WarpScriptAggregatorFunction)WarpScriptLib.getFunction("mapper.highest")).apply(parms);
        return result[3];
    }

    public static long[] longValues(GeoTimeSerie gts) throws WarpScriptException {
        if (GeoTimeSerie.TYPE.LONG != gts.type) {
            throw new WarpScriptException("Invalid type, expected LONG.");
        }
        return Arrays.copyOfRange(gts.longValues, 0, gts.values);
    }

    public static double[] doubleValues(GeoTimeSerie gts) throws WarpScriptException {
        if (GeoTimeSerie.TYPE.DOUBLE != gts.type) {
            throw new WarpScriptException("Invalid type, expected DOUBLE.");
        }
        return Arrays.copyOfRange(gts.doubleValues, 0, gts.values);
    }

    public static BitSet booleanValues(GeoTimeSerie gts) throws WarpScriptException {
        if (GeoTimeSerie.TYPE.BOOLEAN != gts.type) {
            throw new WarpScriptException("Invalid type, expected BOOLEAN.");
        }
        return gts.booleanValues.get(0, gts.values);
    }

    public static String[] stringValues(GeoTimeSerie gts) throws WarpScriptException {
        if (GeoTimeSerie.TYPE.STRING != gts.type) {
            throw new WarpScriptException("Invalid type, expected STRING.");
        }
        return Arrays.copyOfRange(gts.stringValues, 0, gts.values);
    }

    public static GeoTimeSerie dedup(GeoTimeSerie gts) {
        GeoTimeSerie clone = gts.clone();
        if (clone.values < 2) {
            return clone;
        }
        long[] ticks = Arrays.copyOf(clone.ticks, clone.values);
        Arrays.sort(ticks);
        HashMap<Long, AtomicInteger> duplicates = new HashMap<Long, AtomicInteger>();
        int idx = 0;
        int idx2 = 1;
        while (idx2 < clone.values) {
            while (idx2 < clone.values && ticks[idx] == ticks[idx2]) {
                ++idx2;
            }
            if (idx2 - idx > 1) {
                duplicates.put(ticks[idx], new AtomicInteger(idx2 - idx));
            }
            idx = idx2++;
        }
        if (0 == duplicates.size()) {
            return clone;
        }
        idx = 0;
        int offset = 0;
        while (idx + offset < clone.values) {
            while (duplicates.containsKey(clone.ticks[idx + offset]) && ((AtomicInteger)duplicates.get(clone.ticks[idx + offset])).decrementAndGet() > 0) {
                ++offset;
            }
            if (offset > 0) {
                clone.ticks[idx] = clone.ticks[idx + offset];
                if (null != clone.locations) {
                    clone.locations[idx] = clone.locations[idx + offset];
                }
                if (null != clone.elevations) {
                    clone.elevations[idx] = clone.elevations[idx + offset];
                }
                switch (clone.type) {
                    case LONG: {
                        clone.longValues[idx] = clone.longValues[idx + offset];
                        break;
                    }
                    case DOUBLE: {
                        clone.doubleValues[idx] = clone.doubleValues[idx + offset];
                        break;
                    }
                    case STRING: {
                        clone.stringValues[idx] = clone.stringValues[idx + offset];
                        break;
                    }
                    case BOOLEAN: {
                        clone.booleanValues.set(idx, clone.booleanValues.get(idx + offset));
                    }
                }
            }
            ++idx;
        }
        clone.values -= offset;
        if (offset > 1000) {
            GTSHelper.shrink(clone);
        }
        return clone;
    }

    public static GeoTimeSerie onlybuckets(GeoTimeSerie gts) {
        GeoTimeSerie clone = gts.clone();
        if (!GTSHelper.isBucketized(gts)) {
            return clone;
        }
        boolean setLocations = gts.locations != null;
        boolean setElevations = gts.elevations != null;
        int i = 0;
        while (i < clone.values) {
            long q = (gts.lastbucket - gts.ticks[i]) / gts.bucketspan;
            long r = (gts.lastbucket - gts.ticks[i]) % gts.bucketspan;
            if (0L == r && q >= 0L && q < (long)gts.bucketcount) {
                ++i;
                continue;
            }
            q = (gts.lastbucket - gts.ticks[clone.values - 1]) / gts.bucketspan;
            r = (gts.lastbucket - gts.ticks[clone.values - 1]) % gts.bucketspan;
            while (clone.values - 1 > i && (0L != r || q < 0L || q >= (long)gts.bucketcount)) {
                --clone.values;
                q = (gts.lastbucket - gts.ticks[clone.values - 1]) / gts.bucketspan;
                r = (gts.lastbucket - gts.ticks[clone.values - 1]) % gts.bucketspan;
            }
            if (clone.values - 1 == i) {
                --clone.values;
                continue;
            }
            clone.ticks[i] = clone.ticks[clone.values - 1];
            if (setLocations) {
                clone.locations[i] = clone.locations[clone.values - 1];
            }
            if (setElevations) {
                clone.elevations[i] = clone.elevations[clone.values - 1];
            }
            switch (clone.type) {
                case LONG: {
                    clone.longValues[i] = clone.longValues[clone.values - 1];
                    break;
                }
                case DOUBLE: {
                    clone.doubleValues[i] = clone.doubleValues[clone.values - 1];
                    break;
                }
                case STRING: {
                    clone.stringValues[i] = clone.stringValues[clone.values - 1];
                    break;
                }
                case BOOLEAN: {
                    clone.booleanValues.set(i, clone.booleanValues.get(clone.values - 1));
                }
            }
            --clone.values;
            ++i;
        }
        if (gts.values - clone.values > 1000) {
            GTSHelper.shrink(clone);
        }
        return clone;
    }

    @SafeVarargs
    public static List<GeoTimeSerie> partitionAndApply(Object function, WarpScriptStack stack, WarpScriptStack.Macro validator, Collection<String> bylabels, List<GeoTimeSerie> ... series) throws WarpScriptException {
        Map<Map<String, String>, List<GeoTimeSerie>> unflattened = GTSHelper.partitionAndApplyUnflattened(function, stack, validator, bylabels, series);
        ArrayList<GeoTimeSerie> results = new ArrayList<GeoTimeSerie>();
        for (List<GeoTimeSerie> l : unflattened.values()) {
            results.addAll(l);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public static Map<Map<String, String>, List<GeoTimeSerie>> partitionAndApplyUnflattened(Object function, WarpScriptStack stack, WarpScriptStack.Macro validator, Collection<String> bylabels, List<GeoTimeSerie> ... series) throws WarpScriptException {
        LinkedHashSet<GeoTimeSerie> allgts = new LinkedHashSet<GeoTimeSerie>(series.length);
        boolean hasNonSingleton = false;
        for (List<GeoTimeSerie> serie : series) {
            if (serie.size() <= 1) continue;
            hasNonSingleton = true;
            allgts.addAll(serie);
        }
        if (!hasNonSingleton) {
            allgts.addAll(series[0]);
        }
        Map<Map<String, String>, List<GeoTimeSerie>> partition = GTSHelper.partition(allgts, bylabels);
        LinkedHashMap results = new LinkedHashMap();
        long idx = 0L;
        for (int i = 0; i < series.length; ++i) {
            for (GeoTimeSerie gts : series[i]) {
                gts.getMetadata().setClassId(idx++);
                gts.getMetadata().setLabelsId(0L);
            }
            Collections.sort(series[i], GTSIdComparator.COMPARATOR);
        }
        try {
            for (Map.Entry<Map<String, String>, List<GeoTimeSerie>> partitionlabelsAndGtss : partition.entrySet()) {
                Map<String, String> commonlabels = Collections.unmodifiableMap(partitionlabelsAndGtss.getKey());
                ArrayList<GeoTimeSerie> result = new ArrayList<GeoTimeSerie>();
                List[] subseries = new List[series.length];
                for (int i = 0; i < series.length; ++i) {
                    subseries[i] = new ArrayList();
                    if (1 == series[i].size()) {
                        subseries[i].add(series[i].iterator().next());
                        continue;
                    }
                    for (GeoTimeSerie serie : partitionlabelsAndGtss.getValue()) {
                        if (Collections.binarySearch(series[i], serie, GTSIdComparator.COMPARATOR) < 0) continue;
                        subseries[i].add(serie);
                    }
                }
                if (function instanceof WarpScriptFilterFunction) {
                    List<GeoTimeSerie> filtered = ((WarpScriptFilterFunction)function).filter(commonlabels, subseries);
                    if (null != filtered) {
                        result.addAll(filtered);
                    }
                } else if (function instanceof WarpScriptNAryFunction) {
                    boolean proceed = true;
                    if (null != stack && null != validator) {
                        stack.push(Arrays.asList(subseries));
                        stack.push(commonlabels);
                        stack.exec(validator);
                        if (!Boolean.TRUE.equals(stack.pop())) {
                            proceed = false;
                        }
                    }
                    if (proceed) {
                        result.add(GTSHelper.applyNAryFunction((WarpScriptNAryFunction)function, commonlabels, subseries));
                    }
                } else {
                    throw new WarpScriptException("Invalid function to apply.");
                }
                results.put(commonlabels, result);
            }
            LinkedHashMap linkedHashMap = results;
            return linkedHashMap;
        }
        finally {
            for (int i = 0; i < series.length; ++i) {
                for (GeoTimeSerie gts : series[i]) {
                    gts.getMetadata().unsetClassId();
                    gts.getMetadata().unsetLabelsId();
                }
            }
        }
    }

    @SafeVarargs
    public static GeoTimeSerie applyNAryFunction(WarpScriptNAryFunction function, Map<String, String> commonlabels, List<GeoTimeSerie> ... subseries) throws WarpScriptException {
        commonlabels = Collections.unmodifiableMap(commonlabels);
        long lastbucket = 0L;
        long firstbucket = Long.MAX_VALUE;
        long bucketspan = 0L;
        int bucketcount = 0;
        boolean done = false;
        for (List<GeoTimeSerie> subserie : subseries) {
            for (GeoTimeSerie serie : subserie) {
                if (!GTSHelper.isBucketized(serie) && bucketspan > 0L) {
                    done = true;
                    break;
                }
                if (!GTSHelper.isBucketized(serie)) continue;
                if (bucketspan > 0L && serie.bucketspan != bucketspan) {
                    done = true;
                    break;
                }
                if (0L == bucketspan) {
                    bucketspan = serie.bucketspan;
                    lastbucket = serie.lastbucket;
                }
                if (serie.lastbucket % bucketspan != lastbucket % bucketspan) {
                    done = true;
                    break;
                }
                lastbucket = Math.max(serie.lastbucket, lastbucket);
                firstbucket = Math.min(firstbucket, serie.lastbucket - (long)serie.bucketcount * bucketspan);
            }
            if (done) break;
        }
        if (done || 0L == bucketspan) {
            bucketspan = 0L;
            lastbucket = 0L;
            bucketcount = 0;
        } else {
            bucketcount = (int)((lastbucket - firstbucket) / bucketspan);
        }
        GeoTimeSerie gts = new GeoTimeSerie(lastbucket, bucketcount, bucketspan, 16);
        gts.setName("");
        gts.setLabels(commonlabels);
        int[][] idx = new int[subseries.length][];
        int nseries = 0;
        Map[][] partlabels = new Map[subseries.length][];
        for (int i = 0; i < subseries.length; ++i) {
            idx[i] = new int[subseries[i].size()];
            partlabels[i] = new Map[subseries[i].size()];
            for (int j = 0; j < subseries[i].size(); ++j) {
                partlabels[i][j] = subseries[i].get(j).getLabels();
                GTSHelper.sort(subseries[i].get(j));
                gts.setName(subseries[i].get(j).getName());
                ++nseries;
            }
        }
        long[] ticks = new long[nseries];
        String[] names = new String[nseries];
        Map[] labels = new Map[nseries + 1];
        long[] locations = new long[nseries];
        long[] elevations = new long[nseries];
        Object[] values = new Object[nseries];
        int[] collections = new int[nseries + 1];
        collections[nseries] = subseries.length;
        Object[] params = new Object[8];
        while (true) {
            long smallest = Long.MAX_VALUE;
            for (int i = 0; i < subseries.length; ++i) {
                for (int j = 0; j < idx[i].length; ++j) {
                    GeoTimeSerie serie = subseries[i].get(j);
                    if (idx[i][j] >= serie.values || serie.ticks[idx[i][j]] >= smallest) continue;
                    smallest = serie.ticks[idx[i][j]];
                }
            }
            if (Long.MAX_VALUE == smallest) break;
            int k = 0;
            for (int i = 0; i < subseries.length; ++i) {
                for (int j = 0; j < idx[i].length; ++j) {
                    GeoTimeSerie serie = subseries[i].get(j);
                    names[k] = serie.getName();
                    labels[k] = partlabels[i][j];
                    ticks[k] = i;
                    if (idx[i][j] < serie.values && smallest == serie.ticks[idx[i][j]]) {
                        locations[k] = null != serie.locations ? serie.locations[idx[i][j]] : 91480763316633925L;
                        elevations[k] = null != serie.elevations ? serie.elevations[idx[i][j]] : Long.MIN_VALUE;
                        values[k] = GTSHelper.valueAtIndex(serie, idx[i][j]);
                        int[] nArray = idx[i];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                    } else {
                        locations[k] = 91480763316633925L;
                        elevations[k] = Long.MIN_VALUE;
                        values[k] = null;
                    }
                    collections[k] = i;
                    ++k;
                }
            }
            labels[k] = commonlabels;
            params[0] = smallest;
            params[1] = names;
            params[2] = labels;
            params[3] = ticks;
            params[4] = locations;
            params[5] = elevations;
            params[6] = values;
            params[7] = collections;
            Object[] result = (Object[])function.apply(params);
            if (null == result[3]) continue;
            GTSHelper.setValue(gts, smallest, (Long)result[1], (Long)result[2], result[3], false);
        }
        return gts;
    }

    @Deprecated
    public static List<GeoTimeSerie> apply(WarpScriptBinaryOp op, Collection<GeoTimeSerie> op1, Collection<GeoTimeSerie> op2, Collection<String> bylabels) throws WarpScriptException {
        ArrayList<GeoTimeSerie> allgts = new ArrayList<GeoTimeSerie>();
        allgts.addAll(op1);
        allgts.addAll(op2);
        boolean oneToMany = false;
        if (1 == op1.size() || 1 == op2.size()) {
            oneToMany = true;
        }
        Map<Map<String, String>, List<GeoTimeSerie>> partition = null;
        if (!oneToMany) {
            partition = GTSHelper.partition(allgts, bylabels);
        } else {
            Map<String, String> labels;
            partition = new HashMap<Map<String, String>, List<GeoTimeSerie>>();
            if (1 == op1.size()) {
                for (GeoTimeSerie geoTimeSerie : op2) {
                    labels = geoTimeSerie.getLabels();
                    if (!partition.containsKey(labels)) {
                        partition.put(labels, new ArrayList());
                        partition.get(labels).add(op1.iterator().next());
                    }
                    partition.get(labels).add(geoTimeSerie);
                }
            } else {
                for (GeoTimeSerie geoTimeSerie : op1) {
                    labels = geoTimeSerie.getLabels();
                    if (!partition.containsKey(labels)) {
                        partition.put(labels, new ArrayList());
                        partition.get(labels).add(op2.iterator().next());
                    }
                    partition.get(labels).add(geoTimeSerie);
                }
            }
        }
        if (!oneToMany) {
            for (List list : partition.values()) {
                if (2 != list.size()) {
                    throw new WarpScriptException("Unable to partition operands coherently.");
                }
                if (op1.contains(list.get(0)) && op2.contains(list.get(1)) || op2.contains(list.get(0)) && op1.contains(list.get(1))) continue;
                throw new WarpScriptException("Unable to partition operands coherently.");
            }
        }
        ArrayList<GeoTimeSerie> results = new ArrayList<GeoTimeSerie>();
        if (!oneToMany) {
            for (Map.Entry<Map<String, String>, List<GeoTimeSerie>> entry : partition.entrySet()) {
                List<GeoTimeSerie> series = entry.getValue();
                Map<String, String> commonlabels = Collections.unmodifiableMap(entry.getKey());
                GeoTimeSerie x = op1.contains(series.get(0)) ? series.get(0) : series.get(1);
                GeoTimeSerie y = op2.contains(series.get(1)) ? series.get(1) : series.get(0);
                results.add(GTSHelper.applyBinOp(op, x.getName(), commonlabels, x, y));
            }
        } else {
            for (Map.Entry<Map<String, String>, List<GeoTimeSerie>> entry : partition.entrySet()) {
                List<GeoTimeSerie> series = entry.getValue();
                Map<String, String> commonlabels = Collections.unmodifiableMap(entry.getKey());
                GeoTimeSerie x = series.get(0);
                for (int i = 1; i < series.size(); ++i) {
                    GeoTimeSerie y = series.get(i);
                    if (op1.size() == 1) {
                        results.add(GTSHelper.applyBinOp(op, y.getName(), commonlabels, x, y));
                        continue;
                    }
                    results.add(GTSHelper.applyBinOp(op, y.getName(), commonlabels, y, x));
                }
            }
        }
        return results;
    }

    private static GeoTimeSerie applyBinOp(WarpScriptBinaryOp op, String name, Map<String, String> labels, GeoTimeSerie x, GeoTimeSerie y) {
        long lastbucket = 0L;
        long bucketspan = 0L;
        int bucketcount = 0;
        if (GTSHelper.isBucketized(x) && GTSHelper.isBucketized(y) && x.bucketspan == y.bucketspan && x.lastbucket % x.bucketspan == y.lastbucket % y.bucketspan) {
            lastbucket = Math.max(x.lastbucket, y.lastbucket);
            bucketspan = x.bucketspan;
            long firstbucket = Math.min(x.lastbucket - (long)x.bucketcount * bucketspan, y.lastbucket - (long)y.bucketcount * bucketspan);
            bucketcount = (int)((lastbucket - firstbucket) / bucketspan);
        }
        GeoTimeSerie gts = new GeoTimeSerie(lastbucket, bucketcount, bucketspan, 16);
        gts.setName(name);
        gts.setLabels(labels);
        GTSHelper.sort(x);
        GTSHelper.sort(y);
        int xidx = 0;
        int yidx = 0;
        Object[] params = new Object[7];
        params[1] = new String[2];
        params[2] = new Map[3];
        params[3] = new long[2];
        params[4] = new long[2];
        params[5] = new long[2];
        params[6] = new Object[2];
        Map<String, String> xlabels = Collections.unmodifiableMap(x.getLabels());
        Map<String, String> ylabels = Collections.unmodifiableMap(y.getLabels());
        labels = Collections.unmodifiableMap(labels);
        while (xidx < x.values || yidx < y.values) {
            long elevation;
            long location;
            Object value;
            Object[] result;
            Object yelt;
            Object xelt;
            long tick;
            while (yidx < y.values && x.ticks[xidx] >= y.ticks[yidx]) {
                tick = y.ticks[yidx];
                xelt = x.ticks[xidx] == y.ticks[yidx] ? GTSHelper.valueAtIndex(x, xidx) : null;
                yelt = GTSHelper.valueAtIndex(y, yidx);
                params[0] = tick;
                ((String[])params[1])[0] = x.getName();
                ((Map[])params[2])[0] = xlabels;
                ((long[])params[3])[0] = tick;
                if (null == xelt) {
                    ((long[])params[4])[0] = 91480763316633925L;
                    ((long[])params[5])[0] = Long.MIN_VALUE;
                } else {
                    ((long[])params[4])[0] = GTSHelper.locationAtIndex(x, xidx);
                    ((long[])params[5])[0] = GTSHelper.elevationAtIndex(x, xidx);
                }
                ((Object[])params[6])[0] = xelt;
                ((String[])params[1])[1] = y.getName();
                ((Map[])params[2])[1] = ylabels;
                ((long[])params[3])[1] = tick;
                ((long[])params[4])[1] = GTSHelper.locationAtIndex(y, yidx);
                ((long[])params[5])[1] = GTSHelper.elevationAtIndex(y, yidx);
                ((Object[])params[6])[1] = yelt;
                ((Map[])params[2])[2] = labels;
                result = (Object[])op.apply(params);
                if (null != result && null != (value = result[3])) {
                    location = (Long)result[1];
                    elevation = (Long)result[2];
                    GTSHelper.setValue(gts, tick, location, elevation, value, false);
                }
                ++yidx;
            }
            ++xidx;
            while (xidx < x.values && (x.ticks[xidx] < y.ticks[yidx] || yidx >= y.values)) {
                tick = x.ticks[xidx];
                xelt = GTSHelper.valueAtIndex(x, xidx);
                yelt = null;
                params[0] = tick;
                ((String[])params[1])[0] = x.getName();
                ((Map[])params[2])[0] = xlabels;
                ((long[])params[3])[0] = tick;
                if (null == xelt) {
                    ((long[])params[4])[0] = 91480763316633925L;
                    ((long[])params[5])[0] = Long.MIN_VALUE;
                } else {
                    ((long[])params[4])[0] = GTSHelper.locationAtIndex(x, xidx);
                    ((long[])params[5])[0] = GTSHelper.elevationAtIndex(x, xidx);
                }
                ((Object[])params[6])[0] = xelt;
                ((String[])params[1])[1] = y.getName();
                ((Map[])params[2])[1] = ylabels;
                ((long[])params[3])[1] = tick;
                ((long[])params[4])[1] = 91480763316633925L;
                ((long[])params[5])[1] = Long.MIN_VALUE;
                ((Object[])params[6])[1] = yelt;
                ((Map[])params[2])[2] = labels;
                result = (Object[])op.apply(params);
                if (null != result && null != (value = result[3])) {
                    location = (Long)result[1];
                    elevation = (Long)result[2];
                    GTSHelper.setValue(gts, tick, location, elevation, value, false);
                }
                ++xidx;
            }
        }
        return gts;
    }

    public static List<GeoTimeSerie> reduce(WarpScriptReducerFunction reducer, Collection<GeoTimeSerie> series, Collection<String> bylabels) throws WarpScriptException {
        return GTSHelper.reduce(reducer, series, bylabels, false);
    }

    public static List<GeoTimeSerie> reduce(WarpScriptReducerFunction reducer, Collection<GeoTimeSerie> series, Collection<String> bylabels, boolean overrideTick) throws WarpScriptException {
        Map<Map<String, String>, List<GeoTimeSerie>> unflattened = GTSHelper.reduceUnflattened(reducer, series, bylabels, overrideTick);
        ArrayList<GeoTimeSerie> results = new ArrayList<GeoTimeSerie>();
        for (List<GeoTimeSerie> l : unflattened.values()) {
            results.addAll(l);
        }
        return results;
    }

    public static Map<Map<String, String>, List<GeoTimeSerie>> reduceUnflattened(WarpScriptReducerFunction reducer, Collection<GeoTimeSerie> series, Collection<String> bylabels) throws WarpScriptException {
        return GTSHelper.reduceUnflattened(reducer, series, bylabels, false);
    }

    public static Map<Map<String, String>, List<GeoTimeSerie>> reduceUnflattened(WarpScriptReducerFunction reducer, Collection<GeoTimeSerie> series, Collection<String> bylabels, boolean overrideTick) throws WarpScriptException {
        Map<Map<String, String>, List<GeoTimeSerie>> partitions = GTSHelper.partition(series, bylabels);
        LinkedHashMap<Map<String, String>, List<GeoTimeSerie>> results = new LinkedHashMap<Map<String, String>, List<GeoTimeSerie>>();
        for (Map.Entry<Map<String, String>, List<GeoTimeSerie>> partitionLabelsAndGtss : partitions.entrySet()) {
            boolean singleGTSResult = false;
            Map<String, String> partitionLabels = partitionLabelsAndGtss.getKey();
            List<GeoTimeSerie> partitionSeries = partitionLabelsAndGtss.getValue();
            Map[] partlabels = new Map[partitionSeries.size() + 1];
            for (int i = 0; i < partitionSeries.size(); ++i) {
                partlabels[i] = partitionSeries.get(i).getLabels();
            }
            partlabels[partitionSeries.size()] = Collections.unmodifiableMap(partitionLabelsAndGtss.getKey());
            long lastbucket = Long.MIN_VALUE;
            long startbucket = Long.MAX_VALUE;
            long bucketspan = 0L;
            for (GeoTimeSerie gts : partitionSeries) {
                if (!GTSHelper.isBucketized(gts)) {
                    bucketspan = 0L;
                    break;
                }
                if (0L == bucketspan) {
                    bucketspan = gts.bucketspan;
                } else if (bucketspan != gts.bucketspan) {
                    bucketspan = 0L;
                    break;
                }
                if (Long.MIN_VALUE == lastbucket) {
                    lastbucket = gts.lastbucket;
                }
                if (lastbucket % bucketspan != gts.lastbucket % gts.bucketspan) {
                    bucketspan = 0L;
                    break;
                }
                if (gts.lastbucket > lastbucket) {
                    lastbucket = gts.lastbucket;
                }
                if (gts.lastbucket - (long)gts.bucketcount * gts.bucketspan >= startbucket) continue;
                startbucket = gts.lastbucket - (long)gts.bucketcount * gts.bucketspan;
            }
            int bucketcount = 0;
            if (0L != bucketspan) {
                bucketcount = (int)((lastbucket - startbucket) / bucketspan);
            }
            GeoTimeSerie result = 0L != bucketspan ? new GeoTimeSerie(lastbucket, bucketcount, bucketspan, 0) : new GeoTimeSerie();
            result.setName("");
            result.setLabels(partitionLabels);
            result.getMetadata().setAttributes(GTSHelper.commonAttributes(partitionSeries));
            String resultName = null;
            for (GeoTimeSerie gts : partitionSeries) {
                GTSHelper.sort(gts, false);
                if (null == resultName) {
                    resultName = gts.getName();
                    continue;
                }
                if (resultName.equals(gts.getName())) continue;
                resultName = "";
            }
            result.setName(resultName);
            TreeMap<String, GeoTimeSerie> multipleResults = new TreeMap<String, GeoTimeSerie>();
            int[] idx = new int[partitionSeries.size()];
            long[] ticks = new long[idx.length];
            String[] names = new String[idx.length];
            Map[] lbls = Arrays.copyOf(partlabels, partlabels.length);
            long[] locations = new long[idx.length];
            long[] elevations = new long[idx.length];
            Object[] values = new Object[idx.length];
            Object[] params = new Object[7];
            block4: while (true) {
                Object gts;
                int i;
                long smallest = Long.MAX_VALUE;
                for (i = 0; i < idx.length; ++i) {
                    gts = partitionSeries.get(i);
                    if (idx[i] >= ((GeoTimeSerie)gts).values || ((GeoTimeSerie)gts).ticks[idx[i]] >= smallest) continue;
                    smallest = ((GeoTimeSerie)gts).ticks[idx[i]];
                }
                if (Long.MAX_VALUE == smallest) break;
                for (i = 0; i < idx.length; ++i) {
                    gts = partitionSeries.get(i);
                    if (idx[i] < ((GeoTimeSerie)gts).values && smallest == ((GeoTimeSerie)gts).ticks[idx[i]]) {
                        ticks[i] = smallest;
                        names[i] = ((GeoTimeSerie)gts).getName();
                        locations[i] = null != ((GeoTimeSerie)gts).locations ? ((GeoTimeSerie)gts).locations[idx[i]] : 91480763316633925L;
                        elevations[i] = null != ((GeoTimeSerie)gts).elevations ? ((GeoTimeSerie)gts).elevations[idx[i]] : Long.MIN_VALUE;
                        values[i] = GTSHelper.valueAtIndex((GeoTimeSerie)gts, idx[i]);
                        int n = i;
                        idx[n] = idx[n] + 1;
                        continue;
                    }
                    ticks[i] = Long.MIN_VALUE;
                    names[i] = ((GeoTimeSerie)gts).getName();
                    locations[i] = 91480763316633925L;
                    elevations[i] = Long.MIN_VALUE;
                    values[i] = null;
                }
                params[0] = smallest;
                params[1] = names;
                params[2] = lbls;
                params[3] = ticks;
                params[4] = locations;
                params[5] = elevations;
                params[6] = values;
                Object reducerResult = reducer.apply(params);
                if (reducerResult instanceof Map) {
                    gts = ((Map)reducerResult).entrySet().iterator();
                    while (true) {
                        Object[] reduced;
                        if (!gts.hasNext()) continue block4;
                        Map.Entry entry = (Map.Entry)gts.next();
                        GeoTimeSerie gts2 = (GeoTimeSerie)multipleResults.get(entry.getKey().toString());
                        if (null == gts2) {
                            gts2 = 0L != bucketspan ? new GeoTimeSerie(lastbucket, bucketcount, bucketspan, 0) : new GeoTimeSerie();
                            gts2.setName(entry.getKey().toString());
                            gts2.setLabels(partitionLabels);
                            multipleResults.put(entry.getKey().toString(), gts2);
                        }
                        if (null == (reduced = (Object[])entry.getValue())[3]) continue;
                        GTSHelper.setValue(gts2, overrideTick ? (Long)reduced[0] : smallest, (Long)reduced[1], (Long)reduced[2], reduced[3], false);
                    }
                }
                Object[] reduced = (Object[])reducerResult;
                singleGTSResult = true;
                if (null == reduced[3]) continue;
                GTSHelper.setValue(result, overrideTick ? (Long)reduced[0] : smallest, (Long)reduced[1], (Long)reduced[2], reduced[3], false);
            }
            if (!results.containsKey(partitionLabels)) {
                results.put(partitionLabels, new ArrayList());
            }
            if (singleGTSResult) {
                ((List)results.get(partitionLabels)).add(result);
            }
            if (multipleResults.isEmpty()) continue;
            ((List)results.get(partitionLabels)).addAll(multipleResults.values());
        }
        return results;
    }

    public static Object getLastValue(GeoTimeSerie gts) {
        if (0 == gts.values) {
            return null;
        }
        if (GTSHelper.isBucketized(gts)) {
            for (int i = 0; i < gts.values; ++i) {
                if (gts.lastbucket != gts.ticks[i]) continue;
                return GTSHelper.valueAtIndex(gts, i);
            }
            return null;
        }
        long ts = Long.MIN_VALUE;
        int idx = -1;
        for (int i = 0; i < gts.values; ++i) {
            if (gts.ticks[i] <= ts) continue;
            ts = gts.ticks[i];
            idx = i;
        }
        if (-1 != idx) {
            return GTSHelper.valueAtIndex(gts, idx);
        }
        return null;
    }

    public static int[] sortIndices(final long[] values, final boolean reversed) {
        Integer[] indices = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            indices[i] = i;
        }
        Arrays.sort(indices, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (values[o1] < values[o2]) {
                    return reversed ? 1 : -1;
                }
                if (values[o1] == values[o2]) {
                    return 0;
                }
                return reversed ? -1 : 1;
            }
        });
        int[] sorted = new int[indices.length];
        for (int i = 0; i < sorted.length; ++i) {
            sorted[i] = indices[i];
        }
        return sorted;
    }

    public static GeoTimeSerie.TYPE getValueType(Object value) {
        if (value instanceof Long) {
            return GeoTimeSerie.TYPE.LONG;
        }
        if (value instanceof Double) {
            return GeoTimeSerie.TYPE.DOUBLE;
        }
        if (value instanceof String) {
            return GeoTimeSerie.TYPE.STRING;
        }
        if (value instanceof Boolean) {
            return GeoTimeSerie.TYPE.BOOLEAN;
        }
        return GeoTimeSerie.TYPE.UNDEFINED;
    }

    public static void shrink(GeoTimeSerie gts) {
        GTSHelper.shrink(gts, 1.0);
    }

    public static void shrink(GeoTimeSerie gts, double ratio) {
        if (0 == gts.values) {
            gts.ticks = null;
            gts.locations = null;
            gts.elevations = null;
            gts.longValues = null;
            gts.doubleValues = null;
            gts.stringValues = null;
            gts.booleanValues = null;
            return;
        }
        if ((double)gts.ticks.length / (double)gts.values <= ratio) {
            return;
        }
        if (gts.ticks.length > gts.values) {
            gts.ticks = Arrays.copyOf(gts.ticks, gts.values);
        }
        if (null != gts.locations && gts.locations.length > gts.values) {
            gts.locations = Arrays.copyOf(gts.locations, gts.values);
        }
        if (null != gts.elevations && gts.elevations.length > gts.values) {
            gts.elevations = Arrays.copyOf(gts.elevations, gts.values);
        }
        switch (gts.type) {
            case UNDEFINED: {
                gts.longValues = null;
                gts.doubleValues = null;
                gts.stringValues = null;
                gts.booleanValues = null;
                break;
            }
            case LONG: {
                gts.longValues = null != gts.longValues && gts.longValues.length > gts.values ? Arrays.copyOf(gts.longValues, gts.values) : gts.longValues;
                gts.doubleValues = null;
                gts.stringValues = null;
                gts.booleanValues = null;
                break;
            }
            case DOUBLE: {
                gts.longValues = null;
                gts.doubleValues = null != gts.doubleValues && gts.doubleValues.length > gts.values ? Arrays.copyOf(gts.doubleValues, gts.values) : gts.doubleValues;
                gts.stringValues = null;
                gts.booleanValues = null;
                break;
            }
            case STRING: {
                gts.longValues = null;
                gts.doubleValues = null;
                gts.stringValues = null != gts.stringValues && gts.stringValues.length > gts.values ? Arrays.copyOf(gts.stringValues, gts.values) : gts.stringValues;
                gts.booleanValues = null;
                break;
            }
            case BOOLEAN: {
                gts.longValues = null;
                gts.doubleValues = null;
                gts.stringValues = null;
                if (null == gts.booleanValues || gts.booleanValues.size() <= gts.values) break;
                gts.booleanValues = gts.booleanValues.get(0, gts.values);
            }
        }
    }

    public static GeoTimeSerie compact(GeoTimeSerie gts, boolean preserveRanges) {
        GeoTimeSerie clone = gts.clone();
        GTSHelper.sort(clone);
        if (2 >= clone.values) {
            return clone;
        }
        int idx = 0;
        int offset = 0;
        int compactIdx = 1;
        while (idx < clone.values - 1) {
            while (idx + 1 + offset < clone.values - 1 && GTSHelper.locationAtIndex(clone, idx + 1 + offset) == GTSHelper.locationAtIndex(clone, idx) && GTSHelper.elevationAtIndex(clone, idx + 1 + offset) == GTSHelper.elevationAtIndex(clone, idx) && GTSHelper.valueAtIndex(clone, idx + 1 + offset).equals(GTSHelper.valueAtIndex(clone, idx))) {
                ++offset;
            }
            boolean last = false;
            if (preserveRanges && idx + 1 + offset == clone.values - 1 && GTSHelper.locationAtIndex(clone, clone.values - 1) == GTSHelper.locationAtIndex(clone, idx) && GTSHelper.elevationAtIndex(clone, clone.values - 1) == GTSHelper.elevationAtIndex(clone, idx) && GTSHelper.valueAtIndex(clone, clone.values - 1).equals(GTSHelper.valueAtIndex(clone, idx))) {
                ++offset;
                last = true;
            }
            if (preserveRanges && offset > 0) {
                clone.ticks[compactIdx] = clone.ticks[idx + offset];
                if (null != clone.locations) {
                    clone.locations[compactIdx] = clone.locations[idx + offset];
                }
                if (null != clone.elevations) {
                    clone.elevations[compactIdx] = clone.elevations[idx + offset];
                }
                switch (clone.type) {
                    case LONG: {
                        clone.longValues[compactIdx] = clone.longValues[idx + offset];
                        break;
                    }
                    case DOUBLE: {
                        clone.doubleValues[compactIdx] = clone.doubleValues[idx + offset];
                        break;
                    }
                    case BOOLEAN: {
                        clone.booleanValues.set(compactIdx, clone.booleanValues.get(idx + offset));
                        break;
                    }
                    case STRING: {
                        clone.stringValues[compactIdx] = clone.stringValues[idx + offset];
                    }
                }
                if (!last) {
                    ++compactIdx;
                }
            }
            if (idx + offset + 1 < clone.values) {
                clone.ticks[compactIdx] = clone.ticks[idx + offset + 1];
                if (null != clone.locations) {
                    clone.locations[compactIdx] = clone.locations[idx + offset + 1];
                }
                if (null != clone.elevations) {
                    clone.elevations[compactIdx] = clone.elevations[idx + offset + 1];
                }
                switch (clone.type) {
                    case LONG: {
                        clone.longValues[compactIdx] = clone.longValues[idx + offset + 1];
                        break;
                    }
                    case DOUBLE: {
                        clone.doubleValues[compactIdx] = clone.doubleValues[idx + offset + 1];
                        break;
                    }
                    case BOOLEAN: {
                        clone.booleanValues.set(compactIdx, clone.booleanValues.get(idx + offset + 1));
                        break;
                    }
                    case STRING: {
                        clone.stringValues[compactIdx] = clone.stringValues[idx + offset + 1];
                    }
                }
            }
            idx = idx + offset + 1;
            ++compactIdx;
            offset = 0;
        }
        clone.values = compactIdx;
        GTSHelper.shrink(clone);
        return clone;
    }

    public static GeoTimeSerie normalize(GeoTimeSerie gts) {
        int i;
        if (GeoTimeSerie.TYPE.DOUBLE != gts.getType() && GeoTimeSerie.TYPE.LONG != gts.getType() || 0 == gts.values) {
            return gts.clone();
        }
        double dmin = Double.POSITIVE_INFINITY;
        double dmax = Double.NEGATIVE_INFINITY;
        long lmin = Long.MAX_VALUE;
        long lmax = Long.MIN_VALUE;
        if (GeoTimeSerie.TYPE.LONG == gts.getType()) {
            for (i = 0; i < gts.values; ++i) {
                long value = ((Number)GTSHelper.valueAtIndex(gts, i)).longValue();
                if (value > lmax) {
                    lmax = value;
                }
                if (value >= lmin) continue;
                lmin = value;
            }
        } else {
            for (i = 0; i < gts.values; ++i) {
                double value = ((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue();
                if (value > dmax) {
                    dmax = value;
                }
                if (!(value < dmin)) continue;
                dmin = value;
            }
        }
        boolean constant = false;
        if (lmin == lmax || dmin == dmax) {
            constant = true;
        }
        GeoTimeSerie normalized = new GeoTimeSerie(gts.lastbucket, gts.bucketcount, gts.bucketspan, gts.values);
        normalized.setMetadata(new Metadata(gts.getMetadata()));
        for (int i2 = 0; i2 < gts.values; ++i2) {
            Double value = constant ? Double.valueOf(1.0) : (GeoTimeSerie.TYPE.LONG == gts.getType() ? Double.valueOf((double)(((Number)GTSHelper.valueAtIndex(gts, i2)).longValue() - lmin) / (double)(lmax - lmin)) : Double.valueOf((((Number)GTSHelper.valueAtIndex(gts, i2)).doubleValue() - dmin) / (dmax - dmin)));
            GTSHelper.setValue(normalized, gts.ticks[i2], GTSHelper.locationAtIndex(gts, i2), GTSHelper.elevationAtIndex(gts, i2), value, false);
        }
        return normalized;
    }

    public static GeoTimeSerie isonormalize(GeoTimeSerie gts) {
        int i;
        if (GeoTimeSerie.TYPE.DOUBLE != gts.getType() && GeoTimeSerie.TYPE.LONG != gts.getType() || 0 == gts.values) {
            return gts.clone();
        }
        double sum = 0.0;
        double dmin = Double.POSITIVE_INFINITY;
        double dmax = Double.NEGATIVE_INFINITY;
        long lmin = Long.MAX_VALUE;
        long lmax = Long.MIN_VALUE;
        if (GeoTimeSerie.TYPE.LONG == gts.getType()) {
            for (i = 0; i < gts.values; ++i) {
                long value = ((Number)GTSHelper.valueAtIndex(gts, i)).longValue();
                if (value > lmax) {
                    lmax = value;
                }
                if (value < lmin) {
                    lmin = value;
                }
                sum += (double)value;
            }
        } else {
            for (i = 0; i < gts.values; ++i) {
                double value = ((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue();
                if (value > dmax) {
                    dmax = value;
                }
                if (value < dmin) {
                    dmin = value;
                }
                sum += value;
            }
        }
        boolean constant = false;
        if (lmin == lmax || dmin == dmax) {
            constant = true;
        }
        GeoTimeSerie isonormalized = new GeoTimeSerie(gts.lastbucket, gts.bucketcount, gts.bucketspan, gts.values);
        isonormalized.setMetadata(new Metadata(gts.getMetadata()));
        double mean = sum / (double)gts.values;
        for (int i2 = 0; i2 < gts.values; ++i2) {
            Double value = constant ? Double.valueOf(1.0) : (GeoTimeSerie.TYPE.LONG == gts.getType() ? Double.valueOf(((double)((Number)GTSHelper.valueAtIndex(gts, i2)).longValue() - mean) / (double)(lmax - lmin)) : Double.valueOf((((Number)GTSHelper.valueAtIndex(gts, i2)).doubleValue() - mean) / (dmax - dmin)));
            GTSHelper.setValue(isonormalized, gts.ticks[i2], GTSHelper.locationAtIndex(gts, i2), GTSHelper.elevationAtIndex(gts, i2), value, false);
        }
        return isonormalized;
    }

    public static GeoTimeSerie standardize(GeoTimeSerie gts) {
        if (GeoTimeSerie.TYPE.DOUBLE != gts.getType() && GeoTimeSerie.TYPE.LONG != gts.getType() || 0 == gts.values) {
            return gts.clone();
        }
        double sum = 0.0;
        double sumsq = 0.0;
        for (int i = 0; i < gts.values; ++i) {
            double value = ((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue();
            sum += value;
            sumsq += value * value;
        }
        double mean = sum / (double)gts.values;
        double variance = sumsq / (double)gts.values - sum * sum / ((double)gts.values * (double)gts.values);
        if (gts.values > 1) {
            variance = variance * (double)gts.values / ((double)gts.values - 1.0);
        }
        double sd = Math.sqrt(variance);
        return GTSHelper.standardize(gts, mean, sd);
    }

    public static GeoTimeSerie standardize(GeoTimeSerie gts, double mean, double sd) {
        GeoTimeSerie standardized = new GeoTimeSerie(gts.lastbucket, gts.bucketcount, gts.bucketspan, gts.values);
        standardized.setMetadata(new Metadata(gts.getMetadata()));
        for (int i = 0; i < gts.values; ++i) {
            double value = ((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue();
            value -= mean;
            if (0.0 != sd) {
                value /= sd;
            }
            GTSHelper.setValue(standardized, gts.ticks[i], null != gts.locations ? gts.locations[i] : 91480763316633925L, null != gts.elevations ? gts.elevations[i] : Long.MIN_VALUE, value, false);
        }
        return standardized;
    }

    public static GeoTimeSerie bSAX(GeoTimeSerie gts, int alphabetSize, int wordLen, int windowLen, boolean standardizePAA) throws WarpScriptException {
        if (!GTSHelper.isBucketized(gts) || GeoTimeSerie.TYPE.DOUBLE != gts.type && GeoTimeSerie.TYPE.LONG != gts.type) {
            throw new WarpScriptException("Function can only be applied to numeric, bucketized, filled Geo Time Series.");
        }
        if (windowLen % wordLen != 0) {
            throw new WarpScriptException("Wordlen MUST divide windowlen.");
        }
        int levels = 0;
        if (0 == alphabetSize) {
            throw new WarpScriptException("Alphabet size MUST be a power of two.");
        }
        while (0 == (alphabetSize & 1)) {
            ++levels;
            alphabetSize >>>= 1;
        }
        if (1 != alphabetSize) {
            throw new WarpScriptException("Alphabet size MUST be a power of two.");
        }
        if (levels < 1 || levels > 16) {
            throw new WarpScriptException("Alphabet size MUST be a power of two between 2 and 2^16");
        }
        int paaLen = windowLen / wordLen;
        GTSHelper.sort(gts);
        GeoTimeSerie saxGTS = new GeoTimeSerie(gts.lastbucket, gts.bucketcount, gts.bucketspan, gts.values);
        saxGTS.setMetadata(gts.getMetadata());
        int[] symbols = new int[wordLen];
        double[] paaSum = new double[wordLen];
        for (int i = 0; i < gts.values - windowLen + 1; ++i) {
            double sum = 0.0;
            double sumsq = 0.0;
            for (int w = 0; w < wordLen; ++w) {
                paaSum[w] = 0.0;
                for (int k = 0; k < paaLen; ++k) {
                    int n = w;
                    paaSum[n] = paaSum[n] + (GeoTimeSerie.TYPE.LONG == gts.type ? (double)gts.longValues[i + w * paaLen + k] : gts.doubleValues[i + w * paaLen + k]);
                }
                if (!standardizePAA) continue;
                double mean = paaSum[w] / (double)paaLen;
                sum += mean;
                sumsq += mean * mean;
            }
            double mu = 0.0;
            double variance = 0.0;
            double sigma = 0.0;
            if (standardizePAA) {
                mu = sum / (double)wordLen;
                variance = sumsq / (double)wordLen - sum * sum / ((double)wordLen * (double)wordLen);
                if (wordLen > 1) {
                    variance = variance * (double)wordLen / ((double)wordLen - 1.0);
                }
                sigma = Math.sqrt(variance);
            }
            for (int w = 0; w < wordLen; ++w) {
                symbols[w] = standardizePAA ? SAXUtils.SAX(levels, sigma != 0.0 ? (paaSum[w] / (double)paaLen - mu) / sigma : paaSum[w] / (double)paaLen - mu) : SAXUtils.SAX(levels, paaSum[w] / (double)paaLen);
            }
            String word = new String(OrderPreservingBase64.encode(SAXUtils.bSAX(levels, symbols)), StandardCharsets.US_ASCII);
            GTSHelper.setValue(saxGTS, gts.ticks[i], word);
        }
        return saxGTS;
    }

    public static GeoTimeSerie singleExponentialSmoothing(GeoTimeSerie gts, double alpha) throws WarpScriptException {
        if (alpha <= 0.0 || alpha >= 1.0) {
            throw new WarpScriptException("The smoothing factor must be in 0 < alpha < 1.");
        }
        if (GeoTimeSerie.TYPE.LONG != gts.type && GeoTimeSerie.TYPE.DOUBLE != gts.type) {
            throw new WarpScriptException("Can only perform exponential smoothing on numeric Geo Time Series.");
        }
        if (gts.values < 2) {
            throw new WarpScriptException("Can only perform exponential smoothing on Geo Time Series containing at least two values.");
        }
        GeoTimeSerie s = new GeoTimeSerie(gts.lastbucket, gts.bucketcount, gts.bucketspan, gts.values);
        s.setMetadata(new Metadata(gts.getMetadata()));
        GTSHelper.sort(gts);
        double smoothed = ((Number)GTSHelper.valueAtIndex(gts, 0)).doubleValue();
        double oneminusalpha = 1.0 - alpha;
        GTSHelper.setValue(s, gts.ticks[0], null != gts.locations ? gts.locations[0] : 91480763316633925L, null != gts.elevations ? gts.elevations[0] : Long.MIN_VALUE, smoothed, false);
        for (int i = 1; i < gts.values; ++i) {
            smoothed = alpha * ((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue() + oneminusalpha * smoothed;
            GTSHelper.setValue(s, gts.ticks[i], null != gts.locations ? gts.locations[i] : 91480763316633925L, null != gts.elevations ? gts.elevations[i] : Long.MIN_VALUE, smoothed, false);
        }
        return s;
    }

    public static List<GeoTimeSerie> doubleExponentialSmoothing(GeoTimeSerie gts, double alpha, double beta) throws WarpScriptException {
        if (alpha <= 0.0 || alpha >= 1.0) {
            throw new WarpScriptException("The data smoothing factor must be in 0 < alpha < 1.");
        }
        if (beta <= 0.0 || beta >= 1.0) {
            throw new WarpScriptException("The trend smoothing factor must be in 0 < beta < 1.");
        }
        if (GeoTimeSerie.TYPE.LONG != gts.type && GeoTimeSerie.TYPE.DOUBLE != gts.type) {
            throw new WarpScriptException("Can only perform exponential smoothing on numeric Geo Time Series.");
        }
        if (gts.values < 2) {
            throw new WarpScriptException("Can only perform exponential smoothing on Geo Time Series containing at least two values.");
        }
        ArrayList<GeoTimeSerie> result = new ArrayList<GeoTimeSerie>();
        GeoTimeSerie s = new GeoTimeSerie(gts.lastbucket, gts.bucketcount, gts.bucketspan, gts.values);
        s.setMetadata(new Metadata(gts.getMetadata()));
        GeoTimeSerie b = s.clone();
        GTSHelper.sort(gts);
        double smoothed = ((Number)GTSHelper.valueAtIndex(gts, 1)).doubleValue();
        double bestestimate = smoothed - ((Number)GTSHelper.valueAtIndex(gts, 0)).doubleValue();
        double oneminusalpha = 1.0 - alpha;
        double oneminusbeta = 1.0 - beta;
        GTSHelper.setValue(s, gts.ticks[1], null != gts.locations ? gts.locations[1] : 91480763316633925L, null != gts.elevations ? gts.elevations[1] : Long.MIN_VALUE, smoothed, false);
        GTSHelper.setValue(b, gts.ticks[1], null != gts.locations ? gts.locations[1] : 91480763316633925L, null != gts.elevations ? gts.elevations[1] : Long.MIN_VALUE, bestestimate, false);
        for (int i = 2; i < gts.values; ++i) {
            double newsmoothed = alpha * ((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue() + oneminusalpha * (smoothed + bestestimate);
            bestestimate = beta * (newsmoothed - smoothed) + oneminusbeta * bestestimate;
            smoothed = newsmoothed;
            GTSHelper.setValue(s, gts.ticks[i], null != gts.locations ? gts.locations[i] : 91480763316633925L, null != gts.elevations ? gts.elevations[i] : Long.MIN_VALUE, smoothed, false);
            GTSHelper.setValue(b, gts.ticks[i], null != gts.locations ? gts.locations[i] : 91480763316633925L, null != gts.elevations ? gts.elevations[i] : Long.MIN_VALUE, bestestimate, false);
        }
        result.add(s);
        result.add(b);
        return result;
    }

    public static Map<Object, Long> valueHistogram(GeoTimeSerie gts) {
        LinkedHashMap<Object, Long> occurrences = new LinkedHashMap<Object, Long>();
        for (int i = 0; i < gts.values; ++i) {
            Object value = GTSHelper.valueAtIndex(gts, i);
            if (!occurrences.containsKey(value)) {
                occurrences.put(value, 1L);
                continue;
            }
            occurrences.put(value, 1L + (Long)occurrences.get(value));
        }
        if (GTSHelper.isBucketized(gts) && gts.bucketcount != gts.values) {
            occurrences.put(null, Long.valueOf(gts.bucketcount - gts.values));
        }
        return occurrences;
    }

    public static Map<Object, Long> valueHistogram(GTSEncoder encoder) {
        HashMap<Object, Long> occurrences = new HashMap<Object, Long>();
        GTSDecoder decoder = encoder.getDecoder();
        while (decoder.next()) {
            Object value = decoder.getValue();
            if (!occurrences.containsKey(value)) {
                occurrences.put(value, 1L);
                continue;
            }
            occurrences.put(value, 1L + (Long)occurrences.get(value));
        }
        return occurrences;
    }

    public static GeoTimeSerie detect(GeoTimeSerie gts, int alphabetSize, int wordLen, int windowLen, Collection<String> patterns, boolean standardizePAA) throws WarpScriptException {
        GeoTimeSerie gtsPatterns = GTSHelper.bSAX(gts, alphabetSize, wordLen, windowLen, standardizePAA);
        GTSHelper.sort(gtsPatterns);
        GeoTimeSerie detected = new GeoTimeSerie(gts.lastbucket, gts.bucketcount, gts.bucketspan, 16);
        detected.setMetadata(gts.getMetadata());
        int lastidx = -1;
        for (int i = 0; i < gtsPatterns.values; ++i) {
            if (!patterns.contains(gtsPatterns.stringValues[i])) continue;
            for (int j = 0; j < windowLen; ++j) {
                if (i + j <= lastidx) continue;
                lastidx = i + j;
                GTSHelper.setValue(detected, GTSHelper.tickAtIndex(gts, lastidx), GTSHelper.locationAtIndex(gts, lastidx), GTSHelper.elevationAtIndex(gts, lastidx), GTSHelper.valueAtIndex(gts, lastidx), false);
            }
        }
        return detected;
    }

    public static int getBucketCount(GeoTimeSerie gts) {
        return gts.bucketcount;
    }

    public static long getBucketSpan(GeoTimeSerie gts) {
        return gts.bucketspan;
    }

    public static long getLastBucket(GeoTimeSerie gts) {
        return gts.lastbucket;
    }

    public static void setBucketCount(GeoTimeSerie gts, int bucketcount) {
        gts.bucketcount = bucketcount;
    }

    public static void setBucketSpan(GeoTimeSerie gts, long bucketspan) {
        gts.bucketspan = bucketspan;
    }

    public static void setLastBucket(GeoTimeSerie gts, long lastbucket) {
        gts.lastbucket = lastbucket;
    }

    public static void metadataToString(StringBuilder sb, String name, Map<String, String> labels, boolean expose) {
        GTSHelper.encodeName(sb, name);
        GTSHelper.labelsToString(sb, labels, expose);
    }

    public static void labelsToString(StringBuilder sb, Map<String, String> labels, boolean expose) {
        sb.append("{");
        boolean first = true;
        if (null != labels) {
            for (Map.Entry<String, String> entry : labels.entrySet()) {
                if (!expose && !Constants.EXPOSE_OWNER_PRODUCER && (".producer".equals(entry.getKey()) || ".owner".equals(entry.getKey()))) continue;
                if (!first) {
                    sb.append(",");
                }
                GTSHelper.encodeName(sb, entry.getKey());
                sb.append("=");
                GTSHelper.encodeName(sb, entry.getValue());
                first = false;
            }
        }
        sb.append("}");
    }

    public static String buildSelector(GeoTimeSerie gts, boolean forSearch) {
        return GTSHelper.buildSelector(gts.getMetadata(), forSearch);
    }

    public static String buildSelector(Metadata metadata, boolean forSearch) {
        StringBuilder sb = new StringBuilder();
        String name = metadata.getName();
        if (null != name) {
            char nameFirstChar;
            if (name.length() > 0 && ('=' == (nameFirstChar = name.charAt(0)) || '~' == nameFirstChar)) {
                sb.append("=");
            }
            GTSHelper.encodeName(sb, name);
        }
        sb.append("{");
        if (metadata.getLabelsSize() > 0) {
            TreeMap<String, String> labels = new TreeMap<String, String>(metadata.getLabels());
            boolean first = true;
            for (Map.Entry<String, String> entry : labels.entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                GTSHelper.encodeName(sb, entry.getKey());
                if (forSearch && Constants.ABSENT_LABEL_SUPPORT && "".equals(entry.getValue())) {
                    sb.append("~$");
                } else {
                    sb.append("=");
                    GTSHelper.encodeName(sb, entry.getValue());
                }
                first = false;
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public static GeoTimeSerie timeclip(GeoTimeSerie gts, long start, long end) {
        if (gts.sorted) {
            return GTSHelper.subSerie(gts, start, end, false);
        }
        GeoTimeSerie clipped = gts.cloneEmpty();
        for (int idx = 0; idx < gts.values; ++idx) {
            long ts = GTSHelper.tickAtIndex(gts, idx);
            if (ts < start || ts > end) continue;
            GTSHelper.setValue(clipped, ts, GTSHelper.locationAtIndex(gts, idx), GTSHelper.elevationAtIndex(gts, idx), GTSHelper.valueAtIndex(gts, idx), false);
        }
        return clipped;
    }

    public static GTSEncoder timeclip(GTSEncoder encoder, long start, long end) {
        GTSEncoder clipped = new GTSEncoder(0L);
        clipped.setMetadata(encoder.getMetadata());
        GTSDecoder decoder = encoder.getUnsafeDecoder(false);
        while (decoder.next()) {
            long timestamp = decoder.getTimestamp();
            if (timestamp < start || timestamp > end) continue;
            try {
                clipped.addValue(timestamp, decoder.getLocation(), decoder.getElevation(), decoder.getBinaryValue());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return clipped;
    }

    public static GeoTimeSerie integrate(GeoTimeSerie gts, double initialValue) {
        GeoTimeSerie integrated = gts.cloneEmpty();
        GTSHelper.sort(gts);
        double value = initialValue;
        GTSHelper.setValue(integrated, GTSHelper.tickAtIndex(gts, 0), GTSHelper.locationAtIndex(gts, 0), GTSHelper.elevationAtIndex(gts, 0), value, false);
        for (int i = 1; i < gts.values; ++i) {
            double deltaT = (double)(gts.ticks[i] - gts.ticks[i - 1]) / (double)Constants.TIME_UNITS_PER_S;
            double rateOfChange = ((Number)GTSHelper.valueAtIndex(gts, i - 1)).doubleValue();
            GTSHelper.setValue(integrated, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), value += rateOfChange * deltaT, false);
        }
        return integrated;
    }

    public static GeoTimeSerie shrinkTo(GeoTimeSerie gts, int newsize) {
        if (newsize >= 0 && newsize < gts.values) {
            gts.values = newsize;
        }
        return gts;
    }

    public static GTSEncoder shrinkTo(GTSEncoder encoder, int newsize) throws IOException {
        GTSEncoder enc = null;
        if (0 == newsize) {
            return encoder.cloneEmpty();
        }
        if (newsize > 0) {
            enc = encoder.cloneEmpty();
            GTSDecoder decoder = encoder.getDecoder(true);
            for (int count = 0; count < newsize && decoder.next(); ++count) {
                enc.addValue(decoder.getTimestamp(), decoder.getLocation(), decoder.getElevation(), decoder.getBinaryValue());
            }
            return enc;
        }
        return encoder;
    }

    public static List<GeoTimeSerie> chunk(GeoTimeSerie gts, long lastchunk, long chunkwidth, long chunkcount, String chunklabel, boolean keepempty) throws WarpScriptException {
        return GTSHelper.chunk(gts, lastchunk, chunkwidth, chunkcount, chunklabel, keepempty, 0L);
    }

    public static List<GeoTimeSerie> chunk(GeoTimeSerie gts, long lastchunk, long chunkwidth, long chunkcount, String chunklabel, boolean keepempty, long overlap) throws WarpScriptException {
        long lasttick;
        if (overlap < 0L || overlap > chunkwidth) {
            throw new WarpScriptException("Overlap cannot exceed chunk width.");
        }
        Metadata metadata = gts.getMetadata();
        if (metadata.getLabels().containsKey(chunklabel)) {
            throw new WarpScriptException("Cannot operate on Geo Time Series which already have a label named '" + chunklabel + "'");
        }
        TreeMap<Long, GeoTimeSerie> chunks = new TreeMap<Long, GeoTimeSerie>();
        boolean bucketized = GTSHelper.isBucketized(gts);
        if (bucketized) {
            if (gts.bucketspan > chunkwidth) {
                throw new WarpScriptException("Cannot operate on Geo Time Series with a bucketspan greater than the chunk width.");
            }
        } else if (0 == gts.values && 0L == lastchunk) {
            return new ArrayList<GeoTimeSerie>();
        }
        boolean zeroChunkCount = false;
        if (0L == chunkcount) {
            chunkcount = Integer.MAX_VALUE;
            zeroChunkCount = true;
        }
        GTSHelper.sort(gts, true);
        int idx = 0;
        long bucketspan = gts.bucketspan;
        int bucketcount = gts.bucketcount;
        long lastbucket = gts.lastbucket;
        if (0L == lastchunk) {
            if (GTSHelper.isBucketized(gts)) {
                lastchunk = lastbucket;
            } else {
                lastchunk = gts.ticks[0];
                if (0L != lastchunk % chunkwidth) {
                    lastchunk = lastchunk - lastchunk % chunkwidth + chunkwidth;
                }
            }
        }
        if (!keepempty && lastchunk > (lasttick = GTSHelper.lasttick(gts))) {
            if (!zeroChunkCount) {
                chunkcount -= (lastchunk - lasttick) / chunkwidth;
            }
            lastchunk -= chunkwidth * ((lastchunk - lasttick) / chunkwidth);
        }
        if (overlap > 0L) {
            chunkcount += 2L;
            lastchunk += chunkwidth;
        }
        int hint = (int)(chunkcount > 0L ? (long)gts.values / chunkcount : 0L);
        int overlaphint = (int)(overlap > 0L ? (long)gts.values / overlap : 0L);
        if (hint > 0) {
            hint += 2 * overlaphint;
        }
        for (long i = 0L; !(i >= chunkcount || idx >= gts.values && zeroChunkCount); ++i) {
            long chunkend = lastchunk - i * chunkwidth;
            long chunkstart = chunkend - chunkwidth + 1L;
            GeoTimeSerie chunkgts = new GeoTimeSerie(lastbucket, bucketcount, bucketspan, hint);
            if (bucketized) {
                if (lastbucket < chunkstart || chunkend <= lastbucket - (long)bucketcount * bucketspan) {
                    if (!keepempty && overlap <= 0L) continue;
                    chunkgts.setMetadata(metadata);
                    chunkgts.getMetadata().putToLabels(chunklabel, Long.toString(chunkend));
                    chunks.put(chunkend, chunkgts);
                    continue;
                }
                if (0L == chunkwidth % bucketspan) {
                    chunkgts.bucketspan = bucketspan;
                    chunkgts.lastbucket = chunkend;
                    chunkgts.bucketcount = (int)((chunkend - chunkstart + 1L) / bucketspan);
                } else {
                    chunkgts.bucketspan = 0L;
                    chunkgts.lastbucket = 0L;
                    chunkgts.bucketspan = 0L;
                }
            }
            while (idx < gts.values && gts.ticks[idx] > chunkend) {
                ++idx;
            }
            if (idx >= gts.values) {
                if (0 == chunkgts.values && !keepempty && overlap <= 0L) continue;
                chunkgts.setMetadata(metadata);
                chunkgts.getMetadata().putToLabels(chunklabel, Long.toString(chunkend));
                chunks.put(chunkend, chunkgts);
                continue;
            }
            if (gts.ticks[idx] < chunkstart) {
                if (0 == chunkgts.values && !keepempty && overlap <= 0L) continue;
                chunkgts.setMetadata(metadata);
                chunkgts.getMetadata().putToLabels(chunklabel, Long.toString(chunkend));
                chunks.put(chunkend, chunkgts);
                continue;
            }
            while (idx < gts.values && gts.ticks[idx] >= chunkstart) {
                GTSHelper.setValue(chunkgts, GTSHelper.tickAtIndex(gts, idx), GTSHelper.locationAtIndex(gts, idx), GTSHelper.elevationAtIndex(gts, idx), GTSHelper.valueAtIndex(gts, idx), false);
                ++idx;
            }
            if (0 != chunkgts.values || keepempty || overlap > 0L) {
                chunkgts.setMetadata(metadata);
                chunkgts.getMetadata().putToLabels(chunklabel, Long.toString(chunkend));
                chunks.put(chunkend, chunkgts);
            }
            if (0 == chunkgts.values || chunkgts.ticks.length - chunkgts.values > 2 * overlaphint) {
                GTSHelper.shrink(chunkgts);
            }
            if (chunkgts.values > hint) {
                hint = chunkgts.values + 2 * overlaphint;
                continue;
            }
            if (chunkgts.values >= hint) continue;
            hint = (hint + chunkgts.values) / 2 + 2 * overlaphint;
        }
        if (overlap > 0L) {
            int i;
            ArrayList allchunks = new ArrayList(chunks.entrySet());
            int[] currentSizes = new int[allchunks.size()];
            for (i = 0; i < currentSizes.length; ++i) {
                currentSizes[i] = ((GeoTimeSerie)((Map.Entry)allchunks.get((int)i)).getValue()).values;
            }
            for (i = 0; i < allchunks.size(); ++i) {
                long timestamp;
                int j;
                GeoTimeSerie current = (GeoTimeSerie)((Map.Entry)allchunks.get(i)).getValue();
                long lowerBound = (Long)((Map.Entry)allchunks.get(i)).getKey() - chunkwidth + 1L - overlap;
                long upperBound = (Long)((Map.Entry)allchunks.get(i)).getKey() + overlap;
                if (i > 0) {
                    GeoTimeSerie prev = (GeoTimeSerie)((Map.Entry)allchunks.get(i - 1)).getValue();
                    for (j = 0; j < currentSizes[i - 1] && (timestamp = GTSHelper.tickAtIndex(prev, j)) >= lowerBound; ++j) {
                        GTSHelper.setValue(current, timestamp, GTSHelper.locationAtIndex(prev, j), GTSHelper.elevationAtIndex(prev, j), GTSHelper.valueAtIndex(prev, j), false);
                    }
                }
                if (i >= allchunks.size() - 1) continue;
                GeoTimeSerie next = (GeoTimeSerie)((Map.Entry)allchunks.get(i + 1)).getValue();
                for (j = currentSizes[i + 1] - 1; j >= 0 && (timestamp = GTSHelper.tickAtIndex(next, j)) <= upperBound; --j) {
                    GTSHelper.setValue(current, timestamp, GTSHelper.locationAtIndex(next, j), GTSHelper.elevationAtIndex(next, j), GTSHelper.valueAtIndex(next, j), false);
                }
            }
            chunks.remove(lastchunk);
            chunks.remove(lastchunk - (chunkcount - 1L) * chunkwidth);
        }
        ArrayList<GeoTimeSerie> result = new ArrayList<GeoTimeSerie>();
        for (GeoTimeSerie g : chunks.values()) {
            if (!keepempty && 0 == g.values) continue;
            if (g.values > 0 && (double)(g.ticks.length - g.values) > (double)g.values * 0.1) {
                GTSHelper.shrink(g);
            }
            result.add(g);
        }
        return result;
    }

    public static List<GTSEncoder> chunk(GTSEncoder encoder, long lastchunk, long chunkwidth, long chunkcount, String chunklabel, boolean keepempty, long overlap) throws WarpScriptException {
        if (overlap < 0L || overlap > chunkwidth) {
            throw new WarpScriptException("Overlap cannot exceed chunk width.");
        }
        Metadata metadata = encoder.getMetadata();
        if (metadata.getLabels().containsKey(chunklabel)) {
            throw new WarpScriptException("Cannot operate on encoders which already have a label named '" + chunklabel + "'");
        }
        HashMap<Long, GTSEncoder> chunks = new HashMap<Long, GTSEncoder>();
        if (0L == encoder.getCount() && 0 == encoder.size() && 0L == lastchunk) {
            return new ArrayList<GTSEncoder>();
        }
        boolean zeroChunkCount = false;
        if (0L == chunkcount) {
            chunkcount = Integer.MAX_VALUE;
            zeroChunkCount = true;
        }
        GTSDecoder decoder = encoder.getUnsafeDecoder(false);
        long oldestChunk = Long.MAX_VALUE;
        long newestChunk = Long.MIN_VALUE;
        try {
            while (decoder.next()) {
                long timestamp = decoder.getTimestamp();
                long chunkid = 0L;
                long delta = timestamp - lastchunk;
                if (delta < 0L) {
                    if (0L != -delta % chunkwidth) {
                        delta += -delta % chunkwidth;
                    }
                    chunkid = lastchunk + delta;
                } else if (delta > 0L) {
                    if (0L != delta % chunkwidth) {
                        delta = delta - delta % chunkwidth + chunkwidth;
                    }
                    chunkid = lastchunk + delta;
                } else {
                    chunkid = lastchunk;
                }
                GTSEncoder chunkencoder = (GTSEncoder)chunks.get(chunkid);
                if (null == chunkencoder) {
                    chunkencoder = new GTSEncoder(0L);
                    chunkencoder.setMetadata(encoder.getMetadata());
                    chunkencoder.getMetadata().putToLabels(chunklabel, Long.toString(chunkid));
                    chunks.put(chunkid, chunkencoder);
                }
                chunkencoder.addValue(timestamp, decoder.getLocation(), decoder.getElevation(), decoder.getValue());
                if (overlap > 0L) {
                    if (timestamp >= chunkid + 1L - overlap) {
                        chunkencoder = (GTSEncoder)chunks.get(chunkid + chunkwidth);
                        if (null == chunkencoder) {
                            chunkencoder = new GTSEncoder(0L);
                            chunkencoder.setMetadata(encoder.getMetadata());
                            chunkencoder.getMetadata().putToLabels(chunklabel, Long.toString(chunkid + chunkwidth));
                            chunks.put(chunkid + chunkwidth, chunkencoder);
                            newestChunk = Math.max(newestChunk, chunkid + chunkwidth);
                        }
                        chunkencoder.addValue(timestamp, decoder.getLocation(), decoder.getElevation(), decoder.getValue());
                    }
                    if (timestamp <= chunkid - chunkwidth + overlap) {
                        chunkencoder = (GTSEncoder)chunks.get(chunkid - chunkwidth);
                        if (null == chunkencoder) {
                            chunkencoder = new GTSEncoder(0L);
                            chunkencoder.setMetadata(encoder.getMetadata());
                            chunkencoder.getMetadata().putToLabels(chunklabel, Long.toString(chunkid - chunkwidth));
                            chunks.put(chunkid - chunkwidth, chunkencoder);
                            oldestChunk = Math.min(oldestChunk, chunkid - chunkwidth);
                        }
                        chunkencoder.addValue(timestamp, decoder.getLocation(), decoder.getElevation(), decoder.getValue());
                    }
                }
                oldestChunk = Math.min(oldestChunk, chunkid);
                newestChunk = Math.max(newestChunk, chunkid);
            }
        }
        catch (IOException ioe) {
            throw new WarpScriptException("Encountered an error while creating chunks.", ioe);
        }
        ArrayList<GTSEncoder> encoders = new ArrayList<GTSEncoder>();
        CapacityExtractorOutputStream extractor = new CapacityExtractorOutputStream();
        long firstchunkid = oldestChunk;
        if (!zeroChunkCount) {
            firstchunkid = lastchunk - (chunkcount - 1L) * chunkwidth;
        }
        long lastchunkid = lastchunk;
        if (0L == lastchunk) {
            lastchunkid = newestChunk;
        }
        if (!keepempty && lastchunkid > newestChunk) {
            if (!zeroChunkCount) {
                chunkcount -= (lastchunkid - newestChunk) / chunkwidth;
            }
            lastchunkid = newestChunk;
        }
        for (long chunkid = lastchunkid; chunkid >= firstchunkid && (zeroChunkCount || (lastchunkid - chunkid) / chunkwidth < chunkcount); chunkid -= chunkwidth) {
            GTSEncoder enc = (GTSEncoder)chunks.get(chunkid);
            if (null == enc) {
                if (!keepempty) continue;
                enc = new GTSEncoder();
                enc.setMetadata(encoder.getMetadata());
                enc.getMetadata().putToLabels(chunklabel, Long.toString(chunkid));
            } else {
                try {
                    enc.writeTo(extractor);
                    if ((double)extractor.getCapacity() > 1.1 * (double)enc.size()) {
                        enc.resize(enc.size());
                    }
                }
                catch (IOException ioe) {
                    throw new WarpScriptException("Encountered an error while optimizing chunks.", ioe);
                }
            }
            encoders.add(enc);
        }
        Collections.reverse(encoders);
        return encoders;
    }

    public static GeoTimeSerie fuse(Collection<GeoTimeSerie> chunks) throws WarpScriptException {
        if (!chunks.isEmpty()) {
            GeoTimeSerie.TYPE type = null;
            int size = 0;
            for (GeoTimeSerie chunk : chunks) {
                if (null == type) {
                    if (GeoTimeSerie.TYPE.UNDEFINED == chunk.type) continue;
                    type = chunk.type;
                    continue;
                }
                if (0 != chunk.values && type != chunk.type) {
                    throw new WarpScriptException("Inconsistent types for chunks to fuse.");
                }
                size += chunk.values;
            }
            long lastbucket = Long.MIN_VALUE;
            long bucketspan = 0L;
            long firstbucket = Long.MAX_VALUE;
            for (GeoTimeSerie chunk : chunks) {
                if (!GTSHelper.isBucketized(chunk)) {
                    bucketspan = 0L;
                    break;
                }
                if (0L == bucketspan) {
                    bucketspan = chunk.bucketspan;
                    lastbucket = chunk.lastbucket;
                    firstbucket = lastbucket - bucketspan * (long)(chunk.bucketcount - 1);
                    continue;
                }
                if (bucketspan != chunk.bucketspan) {
                    bucketspan = 0L;
                    break;
                }
                if (lastbucket % bucketspan != chunk.lastbucket % bucketspan) {
                    bucketspan = 0L;
                    break;
                }
                if (chunk.lastbucket > lastbucket) {
                    lastbucket = chunk.lastbucket;
                }
                if (chunk.lastbucket - (long)(chunk.bucketcount - 1) * chunk.bucketspan >= firstbucket) continue;
                firstbucket = chunk.lastbucket - (long)(chunk.bucketcount - 1) * chunk.bucketspan;
            }
            int bucketcount = 0;
            if (0L == bucketspan) {
                lastbucket = 0L;
            } else {
                bucketcount = (int)(1L + (lastbucket - firstbucket) / bucketspan);
            }
            GeoTimeSerie fused = new GeoTimeSerie(lastbucket, bucketcount, bucketspan, size);
            String classname = null;
            boolean hasClass = false;
            HashMap<String, String> labels = null;
            for (GeoTimeSerie chunk : chunks) {
                if (null == classname) {
                    classname = chunk.getMetadata().getName();
                    hasClass = true;
                } else if (!classname.equals(chunk.getMetadata().getName())) {
                    hasClass = false;
                }
                Map<String, String> chunklabels = chunk.getMetadata().getLabels();
                if (null == labels) {
                    labels = new HashMap<String, String>();
                    labels.putAll(chunklabels);
                } else {
                    for (Map.Entry<String, String> entry : chunklabels.entrySet()) {
                        if (entry.getValue().equals(labels.get(entry.getKey()))) continue;
                        labels.remove(entry.getKey());
                    }
                }
                for (int i = 0; i < chunk.values; ++i) {
                    GTSHelper.setValue(fused, GTSHelper.tickAtIndex(chunk, i), GTSHelper.locationAtIndex(chunk, i), GTSHelper.elevationAtIndex(chunk, i), GTSHelper.valueAtIndex(chunk, i), false);
                }
            }
            if (hasClass) {
                fused.setName(classname);
            }
            fused.setLabels(labels);
            return fused;
        }
        return new GeoTimeSerie();
    }

    public static GeoTimeSerie timescale(GeoTimeSerie gts, double scale) throws WarpScriptException {
        if (GTSHelper.isBucketized(gts)) {
            throw new WarpScriptException("Cannot apply timescale on a bucketized GTS. Unbucketize it first.");
        }
        GeoTimeSerie scaled = gts.clone();
        for (int i = 0; i < scaled.values; ++i) {
            scaled.ticks[i] = (long)((double)scaled.ticks[i] * scale);
        }
        if (scaled.sorted && scale < 0.0) {
            scaled.reversed = !scaled.reversed;
        }
        return scaled;
    }

    public static boolean isNormal(GeoTimeSerie gts, int buckets, double pcterror, boolean bessel) {
        if (0 == gts.values) {
            return true;
        }
        if (GeoTimeSerie.TYPE.DOUBLE != gts.type && GeoTimeSerie.TYPE.LONG != gts.type) {
            return false;
        }
        double[] musigma = GTSHelper.musigma(gts, bessel);
        double mu = musigma[0];
        double sigma = musigma[1];
        if (0.0 == sigma) {
            return false;
        }
        double[] bounds = SAXUtils.getBounds(buckets);
        int[] counts = new int[bounds.length + 1];
        for (int i = 0; i < gts.values; ++i) {
            double v = (((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue() - mu) / sigma;
            int insertion = Arrays.binarySearch(bounds, v);
            if (insertion >= 0) {
                int n = insertion;
                counts[n] = counts[n] + 1;
                continue;
            }
            int n = -(1 + insertion);
            counts[n] = counts[n] + 1;
        }
        double mean = (double)gts.values / (double)counts.length;
        for (int count : counts) {
            if (!(Math.abs(1.0 - (double)count / mean) > pcterror)) continue;
            return false;
        }
        return true;
    }

    public static double[] musigma(GeoTimeSerie gts, boolean bessel) {
        int i;
        double sum = 0.0;
        double sumsq = 0.0;
        double[] musigma = new double[2];
        if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
            for (i = 0; i < gts.values; ++i) {
                sum += gts.doubleValues[i];
                sumsq += gts.doubleValues[i] * gts.doubleValues[i];
            }
        } else {
            for (i = 0; i < gts.values; ++i) {
                double v = gts.longValues[i];
                sum += v;
                sumsq += v * v;
            }
        }
        musigma[0] = sum / (double)gts.values;
        double variance = sumsq / (double)gts.values - sum * sum / ((double)gts.values * (double)gts.values);
        if (bessel && gts.values > 1) {
            variance = variance * (double)gts.values / ((double)gts.values - 1.0);
        }
        musigma[1] = Math.sqrt(variance);
        return musigma;
    }

    public static GeoTimeSerie quantize(GeoTimeSerie gts, double[] bounds, Object[] values) throws WarpScriptException {
        if (GeoTimeSerie.TYPE.DOUBLE != gts.type && GeoTimeSerie.TYPE.LONG != gts.type) {
            throw new WarpScriptException("Can only quantify numeric Geo Time Series.");
        }
        GeoTimeSerie quantified = gts.cloneEmpty();
        for (int i = 0; i < gts.values; ++i) {
            double v = ((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue();
            int insertion = Arrays.binarySearch(bounds, v);
            if (null == values) {
                if (insertion >= 0) {
                    GTSHelper.setValue(quantified, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), insertion, false);
                    continue;
                }
                GTSHelper.setValue(quantified, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), -(1 + insertion), false);
                continue;
            }
            if (insertion >= 0) {
                GTSHelper.setValue(quantified, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), values[insertion], false);
                continue;
            }
            GTSHelper.setValue(quantified, GTSHelper.tickAtIndex(gts, i), GTSHelper.locationAtIndex(gts, i), GTSHelper.elevationAtIndex(gts, i), values[-(1 + insertion)], false);
        }
        return quantified;
    }

    public static long[] getTicks(GeoTimeSerie gts) {
        return Arrays.copyOf(gts.ticks, gts.values);
    }

    public static long[] getLocations(GeoTimeSerie gts) {
        if (null != gts.locations) {
            return Arrays.copyOf(gts.locations, gts.values);
        }
        long[] locations = new long[gts.values];
        Arrays.fill(locations, 91480763316633925L);
        return locations;
    }

    public static long[] getOriginalLocations(GeoTimeSerie gts) {
        return gts.locations;
    }

    public static long[] getOriginalElevations(GeoTimeSerie gts) {
        return gts.elevations;
    }

    public static long[] getElevations(GeoTimeSerie gts) {
        if (null != gts.elevations) {
            return Arrays.copyOf(gts.elevations, gts.values);
        }
        long[] elevations = new long[gts.values];
        Arrays.fill(elevations, Long.MIN_VALUE);
        return elevations;
    }

    public static double[] getValuesAsDouble(GeoTimeSerie gts) throws WarpScriptException {
        if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
            return Arrays.copyOf(gts.doubleValues, gts.values);
        }
        if (GeoTimeSerie.TYPE.LONG == gts.type) {
            double[] values = new double[gts.values];
            for (int i = 0; i < gts.values; ++i) {
                values[i] = gts.longValues[i];
            }
            return values;
        }
        throw new WarpScriptException("Invalid Geo Time Series type.");
    }

    public static void internalizeStrings(Metadata meta) {
        String value;
        String key;
        String name = meta.getName();
        if (null != name) {
            meta.setName(name.intern());
        }
        if (meta.getLabelsSize() > 0) {
            HashMap<String, String> newlabels = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : meta.getLabels().entrySet()) {
                key = entry.getKey().intern();
                value = entry.getValue().intern();
                newlabels.put(key, value);
            }
            meta.setLabels(newlabels);
        }
        if (meta.getAttributesSize() > 0) {
            HashMap<String, String> newattributes = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : meta.getAttributes().entrySet()) {
                key = entry.getKey().intern();
                value = entry.getValue().intern();
                newattributes.put(key, value);
            }
            meta.setAttributes(newattributes);
        }
    }

    public static double pointwise_lowess(GeoTimeSerie gts, int idx, long tick, int q, int p, double[] weights, double[] rho, double[] beta, boolean reversed) throws WarpScriptException {
        if (null != weights && q > weights.length || null != rho && gts.values > rho.length || null != beta && p + 1 > beta.length) {
            throw new WarpScriptException("Incoherent array lengths as input of pointwise_lowess");
        }
        int i = idx;
        int j = idx - 1;
        if (reversed) {
            ++i;
            ++j;
        }
        for (int count = 0; count < q; ++count) {
            long idist = Long.MAX_VALUE;
            long jdist = Long.MAX_VALUE;
            if (i < gts.values) {
                idist = Math.abs(GTSHelper.tickAtIndex(gts, i) - tick);
            }
            if (j >= 0) {
                jdist = Math.abs(GTSHelper.tickAtIndex(gts, j) - tick);
            }
            if (Long.MAX_VALUE == idist && Long.MAX_VALUE == jdist) break;
            if (idist < jdist) {
                ++i;
                continue;
            }
            --j;
        }
        double maxdist = Math.max(j < -1 ? 0.0 : (double)Math.abs(GTSHelper.tickAtIndex(gts, j + 1) - tick), i <= 0 ? 0.0 : (double)Math.abs(GTSHelper.tickAtIndex(gts, i - 1) - tick));
        if (q > gts.values) {
            maxdist = maxdist * (double)q / (double)gts.values;
        }
        if (null == weights) {
            weights = new double[q];
        } else {
            Arrays.fill(weights, 0.0);
        }
        int widx = 0;
        double wsum = 0.0;
        for (int k = j + 1; k < i; ++k) {
            if (0.0 == maxdist) {
                weights[widx] = 1.0;
            } else {
                double u = (double)Math.abs(gts.ticks[k] - tick) / maxdist;
                if (u >= 1.0) {
                    weights[widx] = 0.0;
                } else {
                    weights[widx] = 1.0 - u * u * u;
                    double rho_ = 1.0;
                    if (null != rho) {
                        rho_ = 0.0 != rho[k] ? rho[k] : 1.0E-6;
                    }
                    weights[widx] = rho_ * weights[widx] * weights[widx] * weights[widx];
                }
            }
            wsum += weights[widx];
            ++widx;
        }
        if (null == beta) {
            beta = new double[p + 1];
        }
        if (1 == p) {
            widx = 0;
            double ctick = 0.0;
            double cvalue = 0.0;
            for (int k = j + 1; k < i; ++k) {
                ctick += weights[widx] * (double)gts.ticks[k];
                cvalue += weights[widx] * ((Number)GTSHelper.valueAtIndex(gts, k)).doubleValue();
                ++widx;
            }
            ctick /= wsum;
            cvalue /= wsum;
            double covar = 0.0;
            double var = 0.0;
            widx = 0;
            for (int k = j + 1; k < i; ++k) {
                covar += weights[widx] * ((double)gts.ticks[k] - ctick) * (((Number)GTSHelper.valueAtIndex(gts, k)).doubleValue() - cvalue);
                var += weights[widx] * ((double)gts.ticks[k] - ctick) * ((double)gts.ticks[k] - ctick);
                ++widx;
            }
            beta[1] = 0.0 == (var /= wsum) ? 0.0 : (covar /= wsum) / var;
            beta[0] = cvalue - ctick * beta[1];
        } else {
            ArrayList<WeightedObservedPoint> observations = new ArrayList<WeightedObservedPoint>();
            widx = 0;
            for (int k = j + 1; k < i; ++k) {
                WeightedObservedPoint point = new WeightedObservedPoint(weights[widx], (double)gts.ticks[k], ((Number)GTSHelper.valueAtIndex(gts, k)).doubleValue());
                observations.add(point);
                ++widx;
            }
            PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)p);
            beta = fitter.fit(observations);
            observations.clear();
        }
        double estimated = beta[0];
        double tmp = 1.0;
        for (int u = 1; u < p + 1; ++u) {
            estimated += (tmp *= (double)tick) * beta[u];
        }
        return estimated;
    }

    public static double pointwise_lowess(GeoTimeSerie gts, int idx, long tick, int q, int p, double[] weights, double[] rho, double[] beta) throws WarpScriptException {
        return GTSHelper.pointwise_lowess(gts, idx, tick, q, p, weights, rho, beta, false);
    }

    public static GeoTimeSerie rlowess(GeoTimeSerie gts, int q, int r, long d, int p, double[] weights, double[] rho, boolean inplace) throws WarpScriptException {
        boolean hasElevations;
        double[] residual;
        int nvalues;
        if (GeoTimeSerie.TYPE.DOUBLE != gts.type && GeoTimeSerie.TYPE.LONG != gts.type) {
            throw new WarpScriptException("Can only smooth numeric Geo Time Series.");
        }
        if (q < 1) {
            throw new WarpScriptException("Bandwidth parameter must be greater than 0");
        }
        if (r < 0) {
            throw new WarpScriptException("Robustness parameter must be greater or equal to 0");
        }
        if (d < 0L) {
            throw new WarpScriptException("Delta parameter must be greater or equal to 0");
        }
        if (p < 1) {
            throw new WarpScriptException("Degree of polynomial fit must be greater than 0");
        }
        if (p > 9) {
            throw new WarpScriptException("Degree of polynomial fit should remain small (lower than 10)");
        }
        GTSHelper.sort(gts, false);
        if (gts.bucketcount - gts.values > 500000) {
            throw new WarpScriptException("More than 500000 missing values");
        }
        long previous = -1L;
        for (int t = 0; t < gts.values; ++t) {
            long current = gts.ticks[t];
            if (previous == current) {
                throw new WarpScriptException("Can't be applied on GTS with duplicate ticks");
            }
            previous = current;
        }
        int size = GTSHelper.isBucketized(gts) ? gts.bucketcount : gts.values;
        int sizehint = Math.max(gts.sizehint, Math.round(1.1f * (float)size));
        double[] transient_smoothed = new double[sizehint];
        int n = nvalues = q < size ? q : size;
        if (null == weights) {
            weights = new double[nvalues];
        } else if (weights.length < nvalues) {
            throw new WarpScriptException("in rlowess weights array too small");
        }
        if (r > 0) {
            if (null == rho) {
                rho = new double[gts.values];
                Arrays.fill(rho, 1.0);
            } else if (rho.length < nvalues) {
                throw new WarpScriptException("in rlowess rho array too small");
            }
            residual = new double[gts.values];
        } else {
            residual = null;
        }
        double[] beta = new double[p + 1];
        for (int r_iter = 0; r_iter < r + 1; ++r_iter) {
            Iterator<Long> iter = GTSHelper.tickIterator(gts, false);
            Iterator<Long> iter_follower = 0.0 == (double)d ? null : GTSHelper.tickIterator(gts, false);
            int idx = 0;
            int ridx = 0;
            int ridx_last = 0;
            long last = d * -1L - 1L;
            int idx_last = 0;
            long last_skipped = 0L;
            boolean skip = false;
            boolean resolved = false;
            long tick = 0L;
            while (iter.hasNext() || resolved) {
                if (!resolved) {
                    tick = iter.next();
                } else {
                    resolved = false;
                }
                if (iter.hasNext() && tick - last <= d) {
                    last_skipped = tick;
                    skip = true;
                    ++ridx;
                    continue;
                }
                if (!skip) {
                    while (idx < gts.values - 1 && tick > GTSHelper.tickAtIndex(gts, idx)) {
                        ++idx;
                    }
                    transient_smoothed[ridx] = GTSHelper.pointwise_lowess(gts, idx, tick, nvalues, p, weights, rho, beta);
                    if (r_iter < r && tick == GTSHelper.tickAtIndex(gts, idx)) {
                        residual[idx] = Math.abs(((Number)GTSHelper.valueAtIndex(gts, idx)).doubleValue() - transient_smoothed[ridx]);
                    }
                    if (null != iter_follower) {
                        iter_follower.next();
                        last = tick;
                        idx_last = idx;
                        ridx_last = ridx;
                    }
                    ++ridx;
                    continue;
                }
                if (!iter.hasNext() && tick - last <= d) {
                    last_skipped = tick;
                    ++ridx;
                }
                while (idx < gts.values - 1 && last_skipped > GTSHelper.tickAtIndex(gts, idx)) {
                    ++idx;
                }
                transient_smoothed[ridx - 1] = GTSHelper.pointwise_lowess(gts, idx, last_skipped, nvalues, p, weights, rho, beta);
                if (r_iter < r && last_skipped == GTSHelper.tickAtIndex(gts, idx)) {
                    residual[idx] = Math.abs(((Number)GTSHelper.valueAtIndex(gts, idx)).doubleValue() - transient_smoothed[ridx - 1]);
                }
                double denom = last_skipped - last;
                long skipped = iter_follower.next();
                int ridx_s = ridx_last + 1;
                while (last_skipped > skipped) {
                    int sidx;
                    double alpha = (double)(skipped - last) / denom;
                    transient_smoothed[ridx_s] = alpha * transient_smoothed[ridx - 1] + (1.0 - alpha) * transient_smoothed[ridx_last];
                    if (r_iter < r && 0 < (sidx = Arrays.binarySearch(gts.ticks, idx_last, idx, skipped))) {
                        residual[sidx] = Math.abs(((Number)GTSHelper.valueAtIndex(gts, sidx)).doubleValue() - transient_smoothed[ridx_s]);
                    }
                    skipped = iter_follower.next();
                    ++ridx_s;
                }
                if (!iter.hasNext() && tick - last <= d) continue;
                skip = false;
                resolved = true;
                last = last_skipped;
                idx_last = idx;
                ridx_last = ridx - 1;
            }
            if (r_iter >= r) continue;
            double[] sorted = rho;
            sorted = Arrays.copyOf(residual, gts.values);
            Arrays.sort(sorted);
            double median = gts.values % 2 == 0 ? (sorted[gts.values / 2] + sorted[gts.values / 2 - 1]) / 2.0 : sorted[gts.values / 2];
            double h = 6.0 * median;
            for (int k = 0; k < gts.values; ++k) {
                if (0.0 == h) {
                    rho[k] = 1.0;
                    continue;
                }
                double u = residual[k] / h;
                if (u >= 1.0) {
                    rho[k] = 0.0;
                    continue;
                }
                rho[k] = 1.0 - u * u;
                rho[k] = rho[k] * rho[k];
            }
        }
        boolean hasLocations = null != gts.locations;
        boolean bl = hasElevations = null != gts.elevations;
        if (!GTSHelper.isBucketized(gts) || gts.values == gts.bucketcount && gts.lastbucket == gts.ticks[gts.values - 1] && gts.lastbucket - gts.bucketspan * (long)(gts.bucketcount - 1) == gts.ticks[0]) {
            if (inplace) {
                if (GeoTimeSerie.TYPE.LONG == gts.type) {
                    gts.longValues = null;
                    gts.type = GeoTimeSerie.TYPE.DOUBLE;
                }
                gts.doubleValues = transient_smoothed;
                return gts;
            }
            GeoTimeSerie smoothed = gts.cloneEmpty(sizehint);
            try {
                smoothed.reset(Arrays.copyOf(gts.ticks, sizehint), hasLocations ? Arrays.copyOf(gts.locations, sizehint) : null, hasElevations ? Arrays.copyOf(gts.elevations, sizehint) : null, transient_smoothed, size);
            }
            catch (IOException ioe) {
                throw new WarpScriptException("IOException in reset method.", ioe);
            }
            return smoothed;
        }
        if (inplace) {
            if (hasLocations && gts.locations.length != sizehint) {
                gts.locations = Arrays.copyOf(gts.locations, sizehint);
            }
            if (hasElevations && gts.elevations.length != sizehint) {
                gts.elevations = Arrays.copyOf(gts.elevations, sizehint);
            }
            if (gts.ticks.length != sizehint) {
                gts.ticks = Arrays.copyOf(gts.ticks, sizehint);
            }
            if (hasLocations || hasElevations) {
                Iterator<Long> iter = GTSHelper.tickIterator(gts, true);
                int idx = gts.values - 1;
                int idx_new = gts.bucketcount;
                while (iter.hasNext()) {
                    long tick = iter.next();
                    --idx_new;
                    while (idx > 0 && tick < gts.ticks[idx]) {
                        --idx;
                    }
                    if (hasLocations) {
                        long l = gts.locations[idx_new] = tick == gts.ticks[idx] ? gts.locations[idx] : 91480763316633925L;
                    }
                    if (hasElevations) {
                        gts.elevations[idx_new] = tick == gts.ticks[idx] ? gts.locations[idx] : Long.MIN_VALUE;
                    }
                    gts.ticks[idx_new] = tick;
                }
            }
            if (GeoTimeSerie.TYPE.LONG == gts.type) {
                gts.longValues = null;
                gts.type = GeoTimeSerie.TYPE.DOUBLE;
            }
            gts.doubleValues = transient_smoothed;
            gts.values = size;
            return gts;
        }
        GeoTimeSerie smoothed = gts.cloneEmpty(sizehint);
        long[] ticks = new long[sizehint];
        int idx = 0;
        Iterator<Long> iter = GTSHelper.tickIterator(gts, false);
        while (iter.hasNext()) {
            ticks[idx] = iter.next();
            ++idx;
        }
        int v = 0;
        long[] locations = null;
        if (hasLocations) {
            locations = new long[sizehint];
            for (int u = 0; u < size; ++u) {
                locations[u] = (v = Arrays.binarySearch(gts.ticks, v, gts.values, smoothed.ticks[u])) < 0 ? 91480763316633925L : gts.locations[v];
            }
        }
        v = 0;
        long[] elevations = null;
        if (hasElevations) {
            elevations = new long[sizehint];
            for (int u = 0; u < size; ++u) {
                elevations[u] = (v = Arrays.binarySearch(gts.ticks, v, gts.values, smoothed.ticks[u])) < 0 ? Long.MIN_VALUE : gts.elevations[v];
            }
        }
        try {
            smoothed.reset(ticks, locations, elevations, transient_smoothed, size);
        }
        catch (IOException ioe) {
            throw new WarpScriptException("IOException in reset method.", ioe);
        }
        return smoothed;
    }

    public static GeoTimeSerie rlowess(GeoTimeSerie gts, int q, int r, long d, int p) throws WarpScriptException {
        return GTSHelper.rlowess(gts, q, r, d, p, null, null, false);
    }

    public static void lowess_stl(GeoTimeSerie fromGTS, GeoTimeSerie toGTS, int neighbours, int degree, int jump, double[] weights, double[] rho) throws WarpScriptException {
        block10: {
            int j;
            block9: {
                if (!GTSHelper.isBucketized(fromGTS)) {
                    throw new WarpScriptException("lowess_stl method works with bucketized gts only");
                }
                if (fromGTS == toGTS) {
                    throw new WarpScriptException("in lowess_stl method, fromGTS and toGTS can't be the same object. Please consider using rlowess method instead");
                }
                GTSHelper.sort(fromGTS);
                if (neighbours >= 0) break block9;
                double mean = GTSHelper.musigma(fromGTS, false)[0];
                for (int j2 = 0; j2 < fromGTS.bucketcount; ++j2) {
                    long tick = fromGTS.lastbucket - (long)j2 * fromGTS.bucketspan;
                    GTSHelper.setValue(toGTS, tick, 91480763316633925L, Long.MIN_VALUE, mean, true);
                }
                break block10;
            }
            int idx = fromGTS.values - 1;
            int rest = (fromGTS.bucketcount - 1) % (jump + 1);
            for (j = 0; j <= (fromGTS.bucketcount - 1) / (jump + 1); ++j) {
                long tick = fromGTS.lastbucket - (long)(j * (jump + 1) + rest) * fromGTS.bucketspan;
                while (idx > -1 && tick < GTSHelper.tickAtIndex(fromGTS, idx)) {
                    --idx;
                }
                double estimated = GTSHelper.pointwise_lowess(fromGTS, idx, tick, neighbours, degree, weights, rho, null, true);
                GTSHelper.setValue(toGTS, tick, 91480763316633925L, Long.MIN_VALUE, estimated, true);
            }
            for (j = 0; j < (fromGTS.bucketcount - 1) / (jump + 1); ++j) {
                int right = j * (jump + 1) + rest;
                int left = (j + 1) * (jump + 1) + rest;
                double denom = left - right;
                long righttick = fromGTS.lastbucket - (long)right * fromGTS.bucketspan;
                long lefttick = fromGTS.lastbucket - (long)left * fromGTS.bucketspan;
                for (int r = 1; r < jump + 1; ++r) {
                    int middle = r + j * (jump + 1) + rest;
                    long tick = fromGTS.lastbucket - (long)middle * fromGTS.bucketspan;
                    double alpha = (double)(middle - right) / denom;
                    double interpolated = alpha * ((Number)GTSHelper.valueAtTick(toGTS, lefttick)).doubleValue() + (1.0 - alpha) * ((Number)GTSHelper.valueAtTick(toGTS, righttick)).doubleValue();
                    GTSHelper.setValue(toGTS, tick, 91480763316633925L, Long.MIN_VALUE, interpolated, true);
                }
            }
            if (0 == rest) break block10;
            for (idx = fromGTS.values - 1; idx > -1 && fromGTS.lastbucket < GTSHelper.tickAtIndex(fromGTS, idx); --idx) {
            }
            double estimated = GTSHelper.pointwise_lowess(fromGTS, idx, fromGTS.lastbucket, neighbours, degree, weights, rho, null, true);
            GTSHelper.setValue(toGTS, fromGTS.lastbucket, 91480763316633925L, Long.MIN_VALUE, estimated, true);
            int right = 0;
            int left = rest;
            double denom = left - right;
            long lefttick = fromGTS.lastbucket - (long)left * fromGTS.bucketspan;
            for (int r = 1; r < rest; ++r) {
                long tick = fromGTS.lastbucket - (long)r * fromGTS.bucketspan;
                double alpha = (double)(r - right) / denom;
                double interpolated = alpha * ((Number)GTSHelper.valueAtTick(toGTS, lefttick)).doubleValue() + (1.0 - alpha) * estimated;
                GTSHelper.setValue(toGTS, tick, 91480763316633925L, Long.MIN_VALUE, interpolated, true);
            }
        }
    }

    public static List<GeoTimeSerie> stl(GeoTimeSerie gts, int buckets_per_period, int inner, int outer, int neighbour_s, int degree_s, int jump_s, int neighbour_l, int degree_l, int jump_l, int neighbour_t, int degree_t, int jump_t, int neighbour_p, int degree_p, int jump_p) throws WarpScriptException {
        int u;
        if (GeoTimeSerie.TYPE.DOUBLE != gts.type && GeoTimeSerie.TYPE.LONG != gts.type) {
            throw new WarpScriptException("Can only be applied on numeric Geo Time Series.");
        }
        if (!GTSHelper.isBucketized(gts)) {
            throw new WarpScriptException("Can only be applied on bucketized Geo Time Series");
        }
        GTSHelper.sort(gts, false);
        int nonnull = gts.values;
        int size = gts.bucketcount;
        if (size - nonnull > 500000) {
            throw new WarpScriptException("More than 500000 missing values");
        }
        int sizehint = size + 2 * buckets_per_period;
        GeoTimeSerie seasonal = gts.cloneEmpty(sizehint);
        try {
            seasonal.reset(Arrays.copyOf(gts.ticks, sizehint), null, null, new double[sizehint], nonnull);
        }
        catch (IOException ioe) {
            throw new WarpScriptException("IOException in reset method.", ioe);
        }
        GeoTimeSerie trend = gts.cloneEmpty(sizehint);
        try {
            trend.reset(Arrays.copyOf(gts.ticks, sizehint), null, null, new double[sizehint], nonnull);
        }
        catch (IOException ioe) {
            throw new WarpScriptException("IOException in reset method.", ioe);
        }
        GeoTimeSerie lowpassed = trend;
        double[] rho = new double[nonnull];
        Arrays.fill(rho, 1.0);
        double[] residual = rho;
        int nei = Math.max(Math.max(neighbour_s, neighbour_l), neighbour_t);
        double[] weights = new double[nei];
        for (int s = 0; s < outer + 1; ++s) {
            int idx_t;
            for (int k = 0; k < inner; ++k) {
                int r;
                int r2;
                idx_t = 0;
                for (int idx = 0; idx < nonnull; ++idx) {
                    idx_t = Arrays.binarySearch(trend.ticks, idx_t, trend.size(), gts.ticks[idx]);
                    seasonal.doubleValues[idx] = ((Number)GTSHelper.valueAtIndex(gts, idx)).doubleValue() - trend.doubleValues[idx_t];
                }
                GeoTimeSerie subCycle = null;
                GeoTimeSerie subRho = null;
                for (int c = 0; c < buckets_per_period; ++c) {
                    subCycle = GTSHelper.subCycleSerie(seasonal, seasonal.lastbucket - (long)c * seasonal.bucketspan, buckets_per_period, true, subCycle);
                    subCycle.lastbucket += subCycle.bucketspan;
                    subCycle.bucketcount += 2;
                    if (s > 0) {
                        double[] tmp = seasonal.doubleValues;
                        int tmp_size = seasonal.values;
                        seasonal.doubleValues = rho;
                        seasonal.values = rho.length;
                        subRho = GTSHelper.subCycleSerie(seasonal, seasonal.lastbucket - (long)c * seasonal.bucketspan, buckets_per_period, true, subRho);
                        seasonal.doubleValues = tmp;
                        seasonal.values = tmp_size;
                    }
                    if (subCycle.values <= 0) continue;
                    GTSHelper.lowess_stl(subCycle, seasonal, neighbour_s, degree_s, jump_s, weights, s > 0 ? subRho.doubleValues : rho);
                }
                seasonal.lastbucket += seasonal.bucketspan * (long)buckets_per_period;
                seasonal.bucketcount += 2 * buckets_per_period;
                GTSHelper.sort(seasonal);
                long firstbucket = GTSHelper.firsttick(seasonal);
                double sum = 0.0;
                int count = 0;
                for (r2 = 0; r2 < buckets_per_period; ++r2) {
                    Object val = GTSHelper.valueAtTick(seasonal, firstbucket + (long)r2 * seasonal.bucketspan);
                    if (null == val) continue;
                    ++count;
                    sum += ((Double)val).doubleValue();
                }
                if (0 == count) {
                    throw new WarpScriptException("STL found no value in its step 3.0, is GTS empty?");
                }
                lowpassed.doubleValues[0] = sum / (double)count;
                for (r2 = 1; r2 < seasonal.bucketcount - buckets_per_period + 1; ++r2) {
                    Object firstVal = GTSHelper.valueAtTick(seasonal, firstbucket + (long)(r2 - 1) * seasonal.bucketspan);
                    Object nextVal = GTSHelper.valueAtTick(seasonal, firstbucket + (long)(r2 + buckets_per_period - 1) * seasonal.bucketspan);
                    if (null == firstVal) {
                        if (null == nextVal) {
                            lowpassed.doubleValues[r2] = lowpassed.doubleValues[r2 - 1];
                            continue;
                        }
                        lowpassed.doubleValues[r2] = (sum += ((Double)nextVal).doubleValue()) / (double)(++count);
                        continue;
                    }
                    if (null == nextVal) {
                        if (0 == --count) {
                            throw new WarpScriptException("STL found no value in its step 3.1, is GTS empty?");
                        }
                        sum -= ((Double)firstVal).doubleValue();
                    } else {
                        sum += (Double)nextVal - (Double)firstVal;
                    }
                    lowpassed.doubleValues[r2] = sum / (double)count;
                }
                sum = 0.0;
                for (r2 = 0; r2 < buckets_per_period; ++r2) {
                    sum += lowpassed.doubleValues[r2];
                }
                double tmp = lowpassed.doubleValues[0];
                lowpassed.doubleValues[0] = sum / (double)buckets_per_period;
                for (r = 1; r <= seasonal.bucketcount - 2 * buckets_per_period + 1; ++r) {
                    tmp = lowpassed.doubleValues[r];
                    lowpassed.doubleValues[r] = (sum += lowpassed.doubleValues[r + buckets_per_period - 1] - tmp) / (double)buckets_per_period;
                }
                r = 0;
                while (r < seasonal.bucketcount - 2 * buckets_per_period) {
                    int n = r;
                    lowpassed.doubleValues[n] = lowpassed.doubleValues[n] + (lowpassed.doubleValues[r + 1] + lowpassed.doubleValues[r + 2]);
                    int n2 = r++;
                    lowpassed.doubleValues[n2] = lowpassed.doubleValues[n2] / 3.0;
                }
                lowpassed.bucketcount = seasonal.bucketcount - 2 * buckets_per_period;
                lowpassed.lastbucket = seasonal.lastbucket - (long)buckets_per_period * seasonal.bucketspan;
                lowpassed.values = lowpassed.bucketcount;
                for (int i = 0; i < lowpassed.bucketcount; ++i) {
                    lowpassed.ticks[i] = lowpassed.lastbucket - (long)(lowpassed.bucketcount - 1 - i) * lowpassed.bucketspan;
                }
                lowpassed = GTSHelper.rlowess(lowpassed, neighbour_l, 0, (long)(jump_l + 1) * lowpassed.bucketspan, degree_l, weights, null, true);
                seasonal.lastbucket -= seasonal.bucketspan * (long)buckets_per_period;
                seasonal.bucketcount -= 2 * buckets_per_period;
                if (seasonal.bucketcount != lowpassed.values) {
                    throw new WarpScriptException("stl impl error #1: " + seasonal.values + " vs " + lowpassed.values);
                }
                int id = 0;
                for (int r3 = 0; r3 < seasonal.bucketcount; ++r3) {
                    Object val = GTSHelper.valueAtTick(seasonal, firstbucket + (long)(r3 + buckets_per_period) * seasonal.bucketspan);
                    if (null == val) continue;
                    seasonal.doubleValues[id] = (Double)val - lowpassed.doubleValues[r3];
                    seasonal.ticks[id] = lowpassed.ticks[r3];
                    ++id;
                }
                seasonal.values = id;
                int idx_s = 0;
                for (int idx = 0; idx < nonnull; ++idx) {
                    idx_s = Arrays.binarySearch(seasonal.ticks, idx_s, seasonal.values, gts.ticks[idx]);
                    trend.doubleValues[idx] = ((Number)GTSHelper.valueAtIndex(gts, idx)).doubleValue() - seasonal.doubleValues[idx_s];
                }
                trend.values = nonnull;
                trend.lastbucket = gts.lastbucket;
                trend.bucketspan = gts.bucketspan;
                trend.bucketcount = size;
                trend = GTSHelper.rlowess(trend, neighbour_t, 0, (long)(jump_t + 1) * trend.bucketspan, degree_t, weights, rho, true);
            }
            if (s >= outer) continue;
            int idx_s = 0;
            idx_t = 0;
            int id = 0;
            for (int idx = 0; idx < nonnull; ++idx) {
                if ((idx_s = Arrays.binarySearch(seasonal.ticks, idx_s, seasonal.size(), gts.ticks[idx])) < 0) continue;
                idx_t = idx_s;
                residual[id++] = Math.abs(((Number)GTSHelper.valueAtIndex(gts, idx)).doubleValue() - seasonal.doubleValues[idx_s] - trend.doubleValues[idx_t]);
            }
            double[] sorted = Arrays.copyOf(residual, gts.values);
            Arrays.sort(sorted);
            double median = gts.values % 2 == 0 ? (sorted[gts.values / 2] + sorted[gts.values / 2 - 1]) / 2.0 : sorted[gts.values / 2];
            double h = 6.0 * median;
            for (int k = 0; k < gts.values; ++k) {
                if (0.0 == h) {
                    rho[k] = 1.0;
                    continue;
                }
                double u2 = residual[k] / h;
                if (u2 >= 1.0) {
                    rho[k] = 0.0;
                    continue;
                }
                rho[k] = 1.0 - u2 * u2;
                rho[k] = rho[k] * rho[k];
            }
        }
        if (neighbour_p > 0) {
            seasonal = GTSHelper.rlowess(seasonal, neighbour_p, 0, (long)(jump_p + 1) * seasonal.bucketspan, degree_p);
        }
        int v = 0;
        if (null != gts.locations) {
            for (u = 0; u < size; ++u) {
                v = Arrays.binarySearch(gts.ticks, v, nonnull, seasonal.ticks[u]);
                seasonal.locations[u] = v < 0 ? 91480763316633925L : gts.locations[v];
                trend.locations[u] = seasonal.locations[u];
            }
        } else {
            seasonal.locations = null;
            trend.locations = null;
        }
        v = 0;
        if (null != gts.elevations) {
            for (u = 0; u < size; ++u) {
                v = Arrays.binarySearch(gts.ticks, v, nonnull, seasonal.ticks[u]);
                seasonal.elevations[u] = v < 0 ? Long.MIN_VALUE : gts.elevations[v];
                trend.elevations[u] = seasonal.elevations[u];
            }
        } else {
            seasonal.elevations = null;
            trend.elevations = null;
        }
        String prefix = null == gts.getName() || 0 == gts.getName().length() ? "" : gts.getName() + "_";
        seasonal.setName(prefix + "seasonal");
        trend.setName(prefix + "trend");
        ArrayList<GeoTimeSerie> output = new ArrayList<GeoTimeSerie>();
        output.add(seasonal);
        output.add(trend);
        return output;
    }

    public static void copy(GeoTimeSerie src, int srcPos, GeoTimeSerie dest, int destPos, int length) {
        if (!GeoTimeSerie.TYPE.UNDEFINED.equals((Object)dest.type) && !dest.type.equals((Object)src.type)) {
            throw new RuntimeException("Combine cannot proceed with incompatible GTS types.");
        }
        dest.type = src.type;
        int destMinLength = destPos + length;
        if (null == dest.ticks) {
            dest.ticks = new long[destMinLength];
            if (GeoTimeSerie.TYPE.LONG == dest.type) {
                dest.longValues = new long[destMinLength];
            } else if (GeoTimeSerie.TYPE.DOUBLE == dest.type) {
                dest.doubleValues = new double[destMinLength];
            } else if (GeoTimeSerie.TYPE.STRING == dest.type) {
                dest.stringValues = new String[destMinLength];
            } else {
                dest.booleanValues = new BitSet();
            }
        } else if (dest.ticks.length < destMinLength) {
            dest.ticks = Arrays.copyOf(dest.ticks, destMinLength);
            if (GeoTimeSerie.TYPE.LONG == dest.type) {
                dest.longValues = Arrays.copyOf(dest.longValues, destMinLength);
            } else if (GeoTimeSerie.TYPE.DOUBLE == dest.type) {
                dest.doubleValues = Arrays.copyOf(dest.doubleValues, destMinLength);
            } else if (GeoTimeSerie.TYPE.STRING == dest.type) {
                dest.stringValues = Arrays.copyOf(dest.stringValues, destMinLength);
            }
        }
        if (null != dest.locations || null != src.locations) {
            if (null == dest.locations) {
                dest.locations = new long[destMinLength];
                Arrays.fill(dest.locations, 91480763316633925L);
            } else if (dest.locations.length < destMinLength) {
                dest.locations = Arrays.copyOf(dest.locations, destMinLength);
                Arrays.fill(dest.locations, dest.values, dest.values + destMinLength, 91480763316633925L);
            }
        }
        if (null != dest.elevations || null != src.elevations) {
            if (null == dest.elevations) {
                dest.elevations = new long[destMinLength];
                Arrays.fill(dest.elevations, Long.MIN_VALUE);
            } else if (dest.elevations.length < destMinLength) {
                dest.elevations = Arrays.copyOf(dest.elevations, destMinLength);
                Arrays.fill(dest.elevations, dest.values, dest.values + destMinLength, Long.MIN_VALUE);
            }
        }
        GTSHelper.copy0(src, srcPos, dest, destPos, length);
        dest.values = Math.max(dest.values, destMinLength);
    }

    private static void copy0(GeoTimeSerie src, int srcPos, GeoTimeSerie dest, int destPos, int length) {
        System.arraycopy(src.ticks, srcPos, dest.ticks, destPos, length);
        if (null != src.locations) {
            System.arraycopy(src.locations, srcPos, dest.locations, destPos, length);
        }
        if (null != src.elevations) {
            System.arraycopy(src.elevations, srcPos, dest.elevations, destPos, length);
        }
        if (GeoTimeSerie.TYPE.LONG == dest.type) {
            System.arraycopy(src.longValues, srcPos, dest.longValues, destPos, length);
        } else if (GeoTimeSerie.TYPE.DOUBLE == dest.type) {
            System.arraycopy(src.doubleValues, srcPos, dest.doubleValues, destPos, length);
        } else if (GeoTimeSerie.TYPE.STRING == dest.type) {
            System.arraycopy(src.stringValues, srcPos, dest.stringValues, destPos, length);
        } else {
            for (int i = 0; i < length; ++i) {
                dest.booleanValues.set(destPos + i, src.booleanValues.get(srcPos + i));
            }
        }
    }

    public static void copyGeo(GeoTimeSerie from, GeoTimeSerie to) {
        GTSHelper.sort(from, false);
        GTSHelper.sort(to, false);
        int fromidx = 0;
        int toidx = 0;
        while (toidx < to.values && fromidx < from.values) {
            long fromtick = GTSHelper.tickAtIndex(from, fromidx);
            long totick = GTSHelper.tickAtIndex(to, toidx);
            while (fromidx < from.values && fromtick < totick) {
                fromtick = GTSHelper.tickAtIndex(from, ++fromidx);
            }
            if (fromidx >= from.values) break;
            while (toidx < to.values && totick < fromtick) {
                totick = GTSHelper.tickAtIndex(to, ++toidx);
            }
            if (toidx >= to.values) break;
            if (totick != fromtick) continue;
            long location = GTSHelper.locationAtIndex(from, fromidx);
            long elevation = GTSHelper.elevationAtIndex(from, fromidx);
            GTSHelper.setLocationAtIndex(to, toidx, location);
            GTSHelper.setElevationAtIndex(to, toidx, elevation);
            ++fromidx;
        }
    }

    public static int[] getFirstLastTicks(long[] ticks) {
        long firsttick = Long.MAX_VALUE;
        long lasttick = Long.MIN_VALUE;
        int firstidx = -1;
        int lastidx = -1;
        for (int i = 0; i < ticks.length; ++i) {
            if (ticks[i] < firsttick) {
                firstidx = i;
                firsttick = ticks[i];
            }
            if (ticks[i] <= lasttick) continue;
            lastidx = i;
            lasttick = ticks[i];
        }
        return new int[]{firstidx, lastidx};
    }

    public static boolean geowithin(GeoXPLib.GeoXPShape shape, GeoTimeSerie gts) {
        boolean hasLocations = false;
        for (int i = 0; i < gts.values; ++i) {
            long location = GTSHelper.locationAtIndex(gts, i);
            if (91480763316633925L == location) continue;
            hasLocations = true;
            if (GeoXPLib.isGeoXPPointInGeoXPShape((long)location, (GeoXPLib.GeoXPShape)shape)) continue;
            return false;
        }
        return hasLocations;
    }

    public static boolean geointersects(GeoXPLib.GeoXPShape shape, GeoTimeSerie gts) {
        for (int i = 0; i < gts.values; ++i) {
            long location = GTSHelper.locationAtIndex(gts, i);
            if (91480763316633925L == location || !GeoXPLib.isGeoXPPointInGeoXPShape((long)location, (GeoXPLib.GeoXPShape)shape)) continue;
            return true;
        }
        return false;
    }

    public static List<GeoTimeSerie> commonTicks(List<GeoTimeSerie> series) {
        if (1 == series.size()) {
            GeoTimeSerie serie = series.get(0).clone();
            ArrayList<GeoTimeSerie> result = new ArrayList<GeoTimeSerie>();
            result.add(serie);
            return result;
        }
        for (GeoTimeSerie serie : series) {
            GTSHelper.sort(serie);
        }
        int[] idx = new int[series.size()];
        int minticks = Integer.MAX_VALUE;
        int leader = -1;
        for (int i = 0; i < series.size(); ++i) {
            if (series.get((int)i).values >= minticks) continue;
            leader = i;
            minticks = series.get((int)i).values;
        }
        GeoTimeSerie leadergts = series.get(leader);
        ArrayList<GeoTimeSerie> result = new ArrayList<GeoTimeSerie>();
        for (GeoTimeSerie gts : series) {
            result.add(gts.cloneEmpty(gts.values / 2));
        }
        if (0 == minticks) {
            return result;
        }
        while (true) {
            GeoTimeSerie serie;
            int i;
            long target = leadergts.ticks[idx[leader]];
            boolean match = true;
            for (i = 0; i < series.size(); ++i) {
                if (i == leader) continue;
                serie = series.get(i);
                while (idx[i] < serie.values && serie.ticks[idx[i]] < target) {
                    int n = i;
                    idx[n] = idx[n] + 1;
                }
                if (idx[i] >= serie.values) {
                    return result;
                }
                if (serie.ticks[idx[i]] <= target) continue;
                while (idx[leader] < leadergts.values && leadergts.ticks[idx[leader]] < serie.ticks[idx[i]]) {
                    int n = leader;
                    idx[n] = idx[n] + 1;
                }
                if (idx[leader] >= leadergts.values) {
                    return result;
                }
                match = false;
                break;
            }
            if (!match) continue;
            for (i = 0; i < series.size(); ++i) {
                int tidx;
                serie = series.get(i);
                for (tidx = idx[i]; tidx < serie.values && target == serie.ticks[tidx]; ++tidx) {
                    GTSHelper.setValue((GeoTimeSerie)result.get(i), GTSHelper.tickAtIndex(serie, tidx), GTSHelper.locationAtIndex(serie, tidx), GTSHelper.elevationAtIndex(serie, tidx), GTSHelper.valueAtIndex(serie, tidx), false);
                }
                if (tidx < serie.values) {
                    // empty if block
                }
                idx[i] = --tidx;
            }
            int n = leader;
            idx[n] = idx[n] + 1;
            if (idx[leader] >= leadergts.values) break;
        }
        return result;
    }

    public static List<Number> bbox(GeoTimeSerie gts) {
        double maxlat = -90.0;
        double minlat = 90.0;
        double minlon = 180.0;
        double maxlon = -180.0;
        ArrayList<Number> bbox = new ArrayList<Number>();
        if (null == gts.locations) {
            bbox.add(-90.0);
            bbox.add(-180.0);
            bbox.add(90.0);
            bbox.add(180.0);
            return bbox;
        }
        for (int i = 0; i < gts.values; ++i) {
            if (91480763316633925L == gts.locations[i]) continue;
            double[] latlon = GeoXPLib.fromGeoXPPoint((long)gts.locations[i]);
            if (latlon[0] < minlat) {
                minlat = latlon[0];
            }
            if (latlon[0] > maxlat) {
                maxlat = latlon[0];
            }
            if (latlon[1] < minlon) {
                minlon = latlon[1];
            }
            if (!(latlon[1] > maxlon)) continue;
            maxlon = latlon[1];
        }
        bbox.add(minlat);
        bbox.add(minlon);
        bbox.add(maxlat);
        bbox.add(maxlon);
        return bbox;
    }

    public static GeoTimeSerie cprob(GeoTimeSerie gts, String separator) throws WarpScriptException {
        HashMap<Object, AtomicInteger> histogram = new HashMap<Object, AtomicInteger>();
        GeoTimeSerie prob = gts.cloneEmpty();
        if (null == separator) {
            int i;
            long total = 0L;
            for (i = 0; i < gts.values; ++i) {
                Object value = GTSHelper.valueAtIndex(gts, i);
                AtomicInteger count = (AtomicInteger)histogram.get(value);
                if (null == count) {
                    count = new AtomicInteger(0);
                    histogram.put(value, count);
                }
                count.addAndGet(1);
                ++total;
            }
            for (i = 0; i < gts.values; ++i) {
                long timestamp = GTSHelper.tickAtIndex(gts, i);
                long geoxppoint = GTSHelper.locationAtIndex(gts, i);
                long elevation = GTSHelper.elevationAtIndex(gts, i);
                Object value = GTSHelper.valueAtIndex(gts, i);
                double p = ((AtomicInteger)histogram.get(value)).doubleValue() / (double)total;
                GTSHelper.setValue(prob, timestamp, geoxppoint, elevation, p, false);
            }
            return prob;
        }
        GTSHelper.valueSort(gts);
        int idx = 0;
        while (idx < gts.values) {
            String event;
            int subidx;
            Object val = GTSHelper.valueAtIndex(gts, idx);
            if (!(val instanceof String)) {
                throw new WarpScriptException("Can only compute conditional probabilities for String Geo Time Series.");
            }
            int lastsep = val.toString().lastIndexOf(separator);
            if (-1 == lastsep) {
                throw new WarpScriptException("Separator not found, unable to isolate given events.");
            }
            String given = val.toString().substring(0, lastsep);
            histogram.clear();
            long total = 0L;
            for (subidx = idx; subidx < gts.values; ++subidx) {
                val = GTSHelper.valueAtIndex(gts, subidx);
                lastsep = val.toString().lastIndexOf(separator);
                if (-1 == lastsep) {
                    throw new WarpScriptException("Separator not found, unable to isolate given events.");
                }
                String givenEvents = val.toString().substring(0, lastsep);
                if (!givenEvents.equals(given)) break;
                event = val.toString().substring(lastsep + separator.length()).trim();
                AtomicInteger count = (AtomicInteger)histogram.get(event);
                if (null == count) {
                    count = new AtomicInteger(0);
                    histogram.put(event, count);
                }
                count.addAndGet(1);
                ++total;
            }
            for (int i = idx; i < subidx; ++i) {
                val = GTSHelper.valueAtIndex(gts, i);
                lastsep = val.toString().lastIndexOf(separator);
                event = val.toString().substring(lastsep + separator.length());
                long timestamp = GTSHelper.tickAtIndex(gts, i);
                long location = GTSHelper.locationAtIndex(gts, i);
                long elevation = GTSHelper.elevationAtIndex(gts, i);
                double p = ((AtomicInteger)histogram.get(event)).doubleValue() / (double)total;
                GTSHelper.setValue(prob, timestamp, location, elevation, p, false);
            }
            idx = subidx;
        }
        return prob;
    }

    public static GeoTimeSerie prob(GeoTimeSerie gts) {
        Map<Object, Long> histogram = GTSHelper.valueHistogram(gts);
        GeoTimeSerie prob = gts.cloneEmpty(gts.values);
        for (int i = 0; i < gts.values; ++i) {
            long timestamp = GTSHelper.tickAtIndex(gts, i);
            long geoxppoint = GTSHelper.locationAtIndex(gts, i);
            long elevation = GTSHelper.elevationAtIndex(gts, i);
            Object value = GTSHelper.valueAtIndex(gts, i);
            GTSHelper.setValue(prob, timestamp, geoxppoint, elevation, histogram.get(value).doubleValue() / (double)gts.values, false);
        }
        return prob;
    }

    public static GeoTimeSerie lttb(GeoTimeSerie gts, int threshold, boolean timebased) throws WarpScriptException {
        int i;
        if (gts.values <= threshold - 2) {
            return gts;
        }
        if (GeoTimeSerie.TYPE.STRING == gts.type || GeoTimeSerie.TYPE.BOOLEAN == gts.type) {
            return gts;
        }
        if (threshold < 3) {
            throw new WarpScriptException("Threshold MUST be >= 3.");
        }
        double bucketsize = (double)gts.values / (double)(threshold - 1);
        GTSHelper.sort(gts);
        long timebucket = (long)Math.ceil((double)(gts.ticks[gts.values - 1] - gts.ticks[0] - 2L) / (double)(threshold - 2));
        long firsttick = gts.ticks[0];
        ArrayList<Integer> buckets = null;
        if (timebased) {
            buckets = new ArrayList<Integer>();
            long lowerts = firsttick + 1L;
            buckets.add(0);
            long lastbucket = 0L;
            for (i = 1; i < gts.values - 1; ++i) {
                long bucket = 1L + (gts.ticks[i] - lowerts) / timebucket;
                if (bucket == lastbucket) continue;
                buckets.add(i - 1);
                buckets.add(i);
                lastbucket = bucket;
            }
            buckets.add(gts.values - 2);
            buckets.add(gts.values - 1);
            buckets.add(gts.values - 1);
            threshold = buckets.size() / 2;
        }
        GeoTimeSerie sampled = gts.cloneEmpty(threshold);
        GTSHelper.setValue(sampled, GTSHelper.tickAtIndex(gts, 0), GTSHelper.locationAtIndex(gts, 0), GTSHelper.elevationAtIndex(gts, 0), GTSHelper.valueAtIndex(gts, 0), false);
        int refidx = 0;
        int firstinrange = 1;
        int lastinrange = -1;
        for (i = 0; i < threshold - 2; ++i) {
            if (timebased) {
                firstinrange = (Integer)buckets.get(2 * (i + 2));
                lastinrange = (Integer)buckets.get(2 * (i + 2) + 1) + 1;
            } else {
                firstinrange = 1 + (int)Math.floor((double)(i + 1) * bucketsize);
                lastinrange = 1 + (int)Math.floor((double)(i + 2) * bucketsize);
                if (firstinrange >= gts.values) {
                    firstinrange = gts.values - 1;
                }
                if (lastinrange >= gts.values) {
                    lastinrange = gts.values - 1;
                }
            }
            double ticksum = 0.0;
            double valuesum = 0.0;
            for (int j = firstinrange; j < lastinrange; ++j) {
                ticksum += (double)gts.ticks[j];
                valuesum += ((Number)GTSHelper.valueAtIndex(gts, j)).doubleValue();
            }
            double tickavg = ticksum / (double)(lastinrange - firstinrange + 1);
            double valueavg = valuesum / (double)(lastinrange - firstinrange + 1);
            double maxarea = -1.0;
            double refvalue = ((Number)GTSHelper.valueAtIndex(gts, refidx)).doubleValue();
            double reftick = gts.ticks[refidx];
            int nextref = -1;
            if (timebased) {
                firstinrange = (Integer)buckets.get(2 * (i + 1));
                lastinrange = (Integer)buckets.get(2 * (i + 1) + 1) + 1;
            } else {
                firstinrange = 1 + (int)Math.floor((double)i * bucketsize);
                lastinrange = 1 + (int)Math.floor((double)(i + 1) * bucketsize);
                if (firstinrange >= gts.values - 1) {
                    firstinrange = gts.values - 2;
                }
                if (lastinrange >= gts.values - 1) {
                    lastinrange = gts.values - 1;
                }
            }
            for (int j = firstinrange; j < lastinrange; ++j) {
                double tick = gts.ticks[j];
                double value = ((Number)GTSHelper.valueAtIndex(gts, j)).doubleValue();
                double area = 0.5 * Math.abs((reftick - tickavg) * (value - refvalue) - (reftick - tick) * (valueavg - refvalue));
                if (!(area > maxarea)) continue;
                maxarea = area;
                nextref = j;
            }
            GTSHelper.setValue(sampled, GTSHelper.tickAtIndex(gts, nextref), GTSHelper.locationAtIndex(gts, nextref), GTSHelper.elevationAtIndex(gts, nextref), GTSHelper.valueAtIndex(gts, nextref), false);
        }
        GTSHelper.setValue(sampled, GTSHelper.tickAtIndex(gts, gts.values - 1), GTSHelper.locationAtIndex(gts, gts.values - 1), GTSHelper.elevationAtIndex(gts, gts.values - 1), GTSHelper.valueAtIndex(gts, gts.values - 1), false);
        return sampled;
    }

    public static void dump(GTSEncoder encoder, PrintWriter pw) {
        boolean first;
        StringBuilder sb = new StringBuilder(" ");
        Metadata meta = encoder.getMetadata();
        GTSHelper.encodeName(sb, meta.getName());
        if (meta.getLabelsSize() > 0) {
            sb.append("{");
            first = true;
            for (Map.Entry<String, String> entry : meta.getLabels().entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                GTSHelper.encodeName(sb, entry.getKey());
                sb.append("=");
                GTSHelper.encodeName(sb, entry.getValue());
                first = false;
            }
            sb.append("}");
        } else {
            sb.append("{}");
        }
        if (meta.getAttributesSize() > 0) {
            sb.append("{");
            first = true;
            for (Map.Entry<String, String> entry : meta.getAttributes().entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                GTSHelper.encodeName(sb, entry.getKey());
                sb.append("=");
                GTSHelper.encodeName(sb, entry.getValue());
                first = false;
            }
            sb.append("}");
        } else {
            sb.append("{}");
        }
        sb.append(" ");
        String clslbs = sb.toString();
        GTSDecoder decoder = encoder.getUnsafeDecoder(false);
        boolean first2 = true;
        while (decoder.next()) {
            if (!first2) {
                pw.print("=");
            }
            pw.print(decoder.getTimestamp());
            pw.print("/");
            long location = decoder.getLocation();
            if (91480763316633925L != location) {
                double[] latlon = GeoXPLib.fromGeoXPPoint((long)location);
                pw.print(latlon[0]);
                pw.print(":");
                pw.print(latlon[1]);
            }
            pw.print("/");
            long elevation = decoder.getElevation();
            if (Long.MIN_VALUE != elevation) {
                pw.print(elevation);
            }
            if (first2) {
                pw.print(clslbs);
            } else {
                pw.print(" ");
            }
            sb.setLength(0);
            GTSHelper.encodeValue(sb, decoder.getBinaryValue());
            pw.print(sb.toString());
            pw.print("\r\n");
            first2 = false;
        }
    }

    public static double standardizedMoment(int moment, GeoTimeSerie gts, boolean bessel) throws WarpScriptException {
        int i;
        double sum = 0.0;
        double sumsq = 0.0;
        int n = gts.values;
        if (GeoTimeSerie.TYPE.LONG == gts.type) {
            for (i = 0; i < n; ++i) {
                sum += (double)gts.longValues[i];
                sumsq += (double)(gts.longValues[i] * gts.longValues[i]);
            }
        } else if (GeoTimeSerie.TYPE.DOUBLE == gts.type) {
            for (i = 0; i < n; ++i) {
                sum += gts.doubleValues[i];
                sumsq += gts.doubleValues[i] * gts.doubleValues[i];
            }
        } else {
            throw new WarpScriptException("Non numeric Geo Time Series.");
        }
        double mean = sum / (double)n;
        double variance = sumsq / (double)n - sum * sum / ((double)n * (double)n);
        if (n > 1 && bessel) {
            variance = variance * (double)n / ((double)n - 1.0);
        }
        double sd = Math.sqrt(variance);
        double momentValue = 0.0;
        if (GeoTimeSerie.TYPE.LONG == gts.type) {
            for (int i2 = 0; i2 < n; ++i2) {
                momentValue += Math.pow(((double)gts.longValues[i2] - mean) / sd, moment);
            }
        } else {
            for (int i3 = 0; i3 < n; ++i3) {
                momentValue += Math.pow((gts.doubleValues[i3] - mean) / sd, moment);
            }
        }
        return momentValue /= (double)n;
    }

    public static double kurtosis(GeoTimeSerie gts, boolean bessel) throws WarpScriptException {
        return GTSHelper.standardizedMoment(4, gts, bessel);
    }

    public static double skewness(GeoTimeSerie gts, boolean bessel) throws WarpScriptException {
        return GTSHelper.standardizedMoment(3, gts, bessel);
    }

    public static void booleanNot(GeoTimeSerie gts) throws WarpScriptException {
        if (GeoTimeSerie.TYPE.BOOLEAN != gts.getType()) {
            throw new WarpScriptException("Non boolean Geo Time Series.");
        }
        gts.booleanValues.flip(0, gts.values);
    }

    public static enum BinarySearchTickChoice {
        ARBITRARY,
        FIRST,
        LAST;

    }
}

