/*
 * Decompiled with CFR 0.152.
 */
package io.warp10;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;

public class WrapperList
extends AbstractList<Object> {
    private final Object[] array;

    public WrapperList(Object[] array) {
        if (null == array) {
            throw new IllegalArgumentException("The wrapped array cannot be null");
        }
        this.array = array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public Object[] toArray() {
        return this.array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            return Arrays.copyOf(this.array, size, a.getClass());
        }
        System.arraycopy(this.array, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public Object get(int index) {
        return this.array[index];
    }

    @Override
    public Object set(int index, Object element) {
        Object oldValue = this.array[index];
        this.array[index] = element;
        return oldValue;
    }

    @Override
    public int indexOf(Object o) {
        Object[] a = this.array;
        if (o == null) {
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (!o.equals(a[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Spliterator<Object> spliterator() {
        return Spliterators.spliterator(this.array, 16);
    }

    @Override
    public Iterator<Object> iterator() {
        return new ArrayItr(this.array);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WrapperList)) {
            return false;
        }
        return ((WrapperList)o).array == this.array;
    }

    public static class ArrayItr
    implements Iterator<Object> {
        private int cursor;
        private final Object[] a;

        ArrayItr(Object[] a) {
            this.a = a;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.a.length;
        }

        @Override
        public Object next() {
            int i = this.cursor;
            if (i >= this.a.length) {
                throw new NoSuchElementException();
            }
            this.cursor = i + 1;
            return this.a[i];
        }
    }
}

