/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class MapperDateTime
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction {
    private final DateTimeZone dtz;

    public MapperDateTime(String name, Object timezone) throws WarpScriptException {
        super(name);
        if (timezone instanceof String) {
            this.dtz = DateTimeZone.forID((String)timezone.toString());
        } else if (timezone instanceof Number) {
            this.dtz = DateTimeZone.forOffsetMillis((int)((Number)timezone).intValue());
        } else {
            throw new WarpScriptException(this.getName() + " expects a STRING timezone or a NUMBER millisecond offset.");
        }
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == values.length) {
            return new Object[]{0L, 91480763316633925L, Long.MIN_VALUE, null};
        }
        if (1 != values.length) {
            throw new WarpScriptException(this.getName() + " can only be applied to a single value.");
        }
        long location = locations[0];
        long elevation = elevations[0];
        DateTime dt = new DateTime(tick / Constants.TIME_UNITS_PER_MS, this.dtz);
        return new Object[]{tick, location, elevation, this.getDateTimeInfo(dt, tick)};
    }

    public abstract Object getDateTimeInfo(DateTime var1, long var2);

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.dtz.getID()));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }
}

