/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions.shape;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.FLATTEN;
import java.util.ArrayList;
import java.util.List;

public class RESHAPE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final FLATTEN FLATTEN = new FLATTEN("FLATTEN");

    public RESHAPE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a shape (a list of dimensions).");
        }
        List shape = (List)top;
        long ncells = 1L;
        for (Object o : shape) {
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects dimensions to be LONGs.");
            }
            long dim = ((Number)o).longValue();
            if (dim > 0L) {
                ncells *= dim;
                continue;
            }
            throw new WarpScriptException(this.getName() + " dimension cannot be negative or null.");
        }
        top = stack.peek();
        if (!(top instanceof List)) {
            stack.pop();
            throw new WarpScriptException(this.getName() + " operates on a list.");
        }
        FLATTEN.apply(stack);
        ArrayList elts = (ArrayList)stack.pop();
        if ((long)elts.size() != ncells) {
            throw new WarpScriptException(this.getName() + " expected " + ncells + " elements, but found " + elts.size());
        }
        for (int k = shape.size() - 1; k >= 1; --k) {
            int dim = ((Number)shape.get(k)).intValue();
            ArrayList ll = elts;
            int size = elts.size() / dim;
            if (0 == size) {
                throw new WarpScriptException(this.getName() + " invalid shape, cannot create " + dim + " elements from " + elts.size());
            }
            elts = new ArrayList(size);
            for (int idx = 0; idx < ll.size(); idx += dim) {
                elts.add(ll.subList(idx, idx + dim));
            }
        }
        stack.push(elts);
        return stack;
    }
}

